"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultiCCAPIWrapper_exports = {};
__export(MultiCCAPIWrapper_exports, {
  createMultiCCAPIWrapper: () => createMultiCCAPIWrapper
});
module.exports = __toCommonJS(MultiCCAPIWrapper_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
function createMultiCCAPIWrapper(apiInstances) {
  if (apiInstances.length === 0) {
    throw new import_core.ZWaveError("At least one CC API instance must be provided", import_core.ZWaveErrorCodes.Argument_Invalid);
  } else if (apiInstances.some((a) => a.ccId !== apiInstances[0].ccId)) {
    throw new import_core.ZWaveError("All CC API instances must be for the same CC", import_core.ZWaveErrorCodes.Argument_Invalid);
  }
  const withOptions = /* @__PURE__ */ __name((options) => createMultiCCAPIWrapper(
    // Create a new wrapper where each instance has the options applied
    apiInstances.map((a) => a.withOptions(options))
  ), "withOptions");
  const withTXReport = /* @__PURE__ */ __name(() => createMultiCCAPIWrapper(apiInstances.map((a) => a.withTXReport())), "withTXReport");
  const version = apiInstances[0].version;
  const ccId = apiInstances[0].ccId;
  const isSupported = /* @__PURE__ */ __name(() => apiInstances[0].isSupported(), "isSupported");
  const isSetValueOptimistic = /* @__PURE__ */ __name((valueId) => apiInstances[0].isSetValueOptimistic(valueId), "isSetValueOptimistic");
  const supportsCommand = /* @__PURE__ */ __name((cmd) => apiInstances[0].supportsCommand(cmd), "supportsCommand");
  const setValue = apiInstances[0].setValue ? async (...args) => {
    const tasks = apiInstances.map((a) => a.setValue.call(a, ...args));
    const results = await Promise.all(tasks);
    return (0, import_core.mergeSupervisionResults)(results);
  } : void 0;
  const getNode = /* @__PURE__ */ __name(() => void 0, "getNode");
  const tryGetNode = /* @__PURE__ */ __name(() => void 0, "tryGetNode");
  return new Proxy({}, {
    get(target, prop) {
      if (process.env.NODE_ENV === "test" && typeof prop === "string" && (prop === "$$typeof" || prop === "constructor" || prop.includes("@@__IMMUTABLE"))) {
        return void 0;
      }
      switch (prop) {
        case "ccId":
          return ccId;
        case "version":
          return version;
        case "isSupported":
          return isSupported;
        case "getNode":
          return getNode;
        case "tryGetNode":
          return tryGetNode;
        case "isSetValueOptimistic":
          return isSetValueOptimistic;
        case "supportsCommand":
          return supportsCommand;
        case "withOptions":
          return withOptions;
        case "withTXReport":
          return withTXReport;
        case "pollValue":
          return void 0;
        case "setValue":
          return setValue;
        default:
          return async (...args) => {
            const tasks = apiInstances.map((a) => (
              // This may throw when a non-existing method is accessed, but that is desired here
              a[prop].call(a, ...args)
            ));
            const responses = await Promise.all(tasks);
            const results = responses.map((r) => {
              if (r instanceof import_cc.SupervisionCCReport) {
                return r.toSupervisionResult();
              }
              return void 0;
            });
            return (0, import_core.mergeSupervisionResults)(results);
          };
      }
    }
  });
}
__name(createMultiCCAPIWrapper, "createMultiCCAPIWrapper");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createMultiCCAPIWrapper
});
//# sourceMappingURL=MultiCCAPIWrapper.js.map
