"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to2, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to2, key) && key !== except)
        __defProp(to2, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to2;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NodeReadyMachine_exports = {};
__export(NodeReadyMachine_exports, {
  createNodeReadyMachine: () => createNodeReadyMachine
});
module.exports = __toCommonJS(NodeReadyMachine_exports);
var import_core = require("@zwave-js/core");
function to(state) {
  return { newState: state };
}
__name(to, "to");
function createNodeReadyMachine() {
  const initialState = {
    value: "notReady",
    maybeDead: true
  };
  const READY = { value: "ready", done: true };
  const transitions = /* @__PURE__ */ __name((state) => (input) => {
    switch (state.value) {
      case "notReady": {
        switch (input.value) {
          case "NOT_DEAD":
            return to({ ...state, maybeDead: false });
          case "MAYBE_DEAD":
            return to({ ...state, maybeDead: true });
          case "RESTART_FROM_CACHE":
            if (state.maybeDead) {
              return to({ value: "readyIfNotDead" });
            } else {
              return to(READY);
            }
          case "INTERVIEW_DONE":
            return to(READY);
        }
        break;
      }
      case "readyIfNotDead": {
        if (input.value === "NOT_DEAD")
          return to(READY);
        break;
      }
    }
  }, "transitions");
  return new import_core.StateMachine(initialState, transitions);
}
__name(createNodeReadyMachine, "createNodeReadyMachine");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createNodeReadyMachine
});
//# sourceMappingURL=NodeReadyMachine.js.map
