"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CapabilityValues_exports = {};
__export(CapabilityValues_exports, {
  NodeCapabilityValuesMixin: () => NodeCapabilityValuesMixin
});
module.exports = __toCommonJS(CapabilityValues_exports);
var import_cc = require("@zwave-js/cc");
var import_Values = require("./40_Values.js");
class NodeCapabilityValuesMixin extends import_Values.NodeValuesMixin {
  static {
    __name(this, "NodeCapabilityValuesMixin");
  }
  get manufacturerId() {
    return this.getValue(import_cc.ManufacturerSpecificCCValues.manufacturerId.id);
  }
  get productId() {
    return this.getValue(import_cc.ManufacturerSpecificCCValues.productId.id);
  }
  get productType() {
    return this.getValue(import_cc.ManufacturerSpecificCCValues.productType.id);
  }
  get firmwareVersion() {
    const firmware0Version = this.getValue(import_cc.VersionCCValues.firmwareVersions.id)?.[0];
    const applicationVersion = this.getValue(import_cc.VersionCCValues.applicationVersion.id);
    let ret = firmware0Version;
    if (applicationVersion) {
      if (!ret || applicationVersion.startsWith(`${ret}.`)) {
        ret = applicationVersion;
      }
    }
    if (ret && this.isControllerNode) {
      const sdkVersion = this.sdkVersion;
      if (sdkVersion && sdkVersion.startsWith(`${ret}.`)) {
        return sdkVersion;
      }
    }
    return ret;
  }
  get hardwareVersion() {
    return this.getValue(import_cc.VersionCCValues.hardwareVersion.id);
  }
  get sdkVersion() {
    return this.getValue(import_cc.VersionCCValues.sdkVersion.id);
  }
  get zwavePlusVersion() {
    return this.getValue(import_cc.ZWavePlusCCValues.zwavePlusVersion.id);
  }
  get zwavePlusNodeType() {
    return this.getValue(import_cc.ZWavePlusCCValues.nodeType.id);
  }
  get zwavePlusRoleType() {
    return this.getValue(import_cc.ZWavePlusCCValues.roleType.id);
  }
  get supportsWakeUpOnDemand() {
    return this.getValue(import_cc.WakeUpCCValues.wakeUpOnDemandSupported.id);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeCapabilityValuesMixin
});
//# sourceMappingURL=41_CapabilityValues.js.map
