"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultiChannel_exports = {};
__export(MultiChannel_exports, {
  MultiChannelCCBehaviors: () => MultiChannelCCBehaviors,
  MultiChannelCCHooks: () => MultiChannelCCHooks
});
module.exports = __toCommonJS(MultiChannel_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
const encapsulateMultiChannelCC = {
  transformIncomingCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MultiChannelCCCommandEncapsulation) {
      const inner = receivedCC.encapsulated;
      inner.endpointIndex = receivedCC.destination;
      return inner;
    } else if (receivedCC instanceof import_cc.MultiChannelCCV1CommandEncapsulation) {
      const inner = receivedCC.encapsulated;
      inner.endpointIndex = receivedCC.endpointIndex;
      return inner;
    }
    return receivedCC;
  },
  transformResponse(controller, self, receivedCC, response) {
    if (response.action === "sendCC" && receivedCC instanceof import_cc.CommandClass && receivedCC.isEncapsulatedWith(import_core.CommandClasses["Multi Channel"]) && !response.cc.isEncapsulatedWith(import_core.CommandClasses["Multi Channel"])) {
      const multiChannelEncap = receivedCC.getEncapsulatingCC(import_core.CommandClasses["Multi Channel"]);
      if (!multiChannelEncap)
        return response;
      if (multiChannelEncap instanceof import_cc.MultiChannelCCV1CommandEncapsulation) {
        response.cc = new import_cc.MultiChannelCCV1CommandEncapsulation({
          nodeId: response.cc.nodeId,
          endpointIndex: multiChannelEncap.endpointIndex,
          encapsulated: response.cc
        });
      } else if (multiChannelEncap instanceof import_cc.MultiChannelCCCommandEncapsulation) {
        const destination = multiChannelEncap.endpointIndex;
        const source = multiChannelEncap.destination;
        response.cc = new import_cc.MultiChannelCCCommandEncapsulation({
          nodeId: response.cc.nodeId,
          endpointIndex: source,
          encapsulated: response.cc,
          destination
        });
      }
    }
    return response;
  }
};
const respondToMultiChannelCCEndPointGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MultiChannelCCEndPointGet) {
      const cc = new import_cc.MultiChannelCCEndPointReport({
        nodeId: controller.ownNodeId,
        countIsDynamic: false,
        identicalCapabilities: false,
        individualCount: self.endpoints.size
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMultiChannelCCEndPointFind = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MultiChannelCCEndPointFind) {
      const request = receivedCC;
      const cc = new import_cc.MultiChannelCCEndPointFindReport({
        nodeId: controller.ownNodeId,
        genericClass: request.genericClass,
        specificClass: request.specificClass,
        foundEndpoints: [...self.endpoints.keys()],
        reportsToFollow: 0
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMultiChannelCCCapabilityGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MultiChannelCCCapabilityGet) {
      const endpoint = self.endpoints.get(receivedCC.requestedEndpoint);
      const cc = new import_cc.MultiChannelCCCapabilityReport({
        nodeId: controller.ownNodeId,
        endpointIndex: endpoint.index,
        genericDeviceClass: endpoint?.capabilities.genericDeviceClass ?? self.capabilities.genericDeviceClass,
        specificDeviceClass: endpoint?.capabilities.specificDeviceClass ?? self.capabilities.specificDeviceClass,
        isDynamic: false,
        wasRemoved: false,
        supportedCCs: [...endpoint.implementedCCs.keys()].filter((ccId) => ccId !== import_core.CommandClasses.Basic)
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMultiChannelCCV1Get = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MultiChannelCCV1Get) {
      const requestedCC = receivedCC.requestedCC;
      const supportedEndpointIndizes = [...self.endpoints.values()].filter((ep) => {
        const info = ep.implementedCCs.get(requestedCC);
        return info && info.version > 0 && info.isSupported;
      }).map((ep) => ep.index);
      const endpointCount = Math.max(0, ...supportedEndpointIndizes);
      const cc = new import_cc.MultiChannelCCV1Report({
        nodeId: self.id,
        requestedCC,
        endpointCount
      });
      return { action: "sendCC", cc };
    }
  }
};
const MultiChannelCCHooks = [
  encapsulateMultiChannelCC
];
const MultiChannelCCBehaviors = [
  respondToMultiChannelCCEndPointGet,
  respondToMultiChannelCCEndPointFind,
  respondToMultiChannelCCCapabilityGet,
  respondToMultiChannelCCV1Get
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MultiChannelCCBehaviors,
  MultiChannelCCHooks
});
//# sourceMappingURL=MultiChannel.js.map
