export var SecurityBootstrapFailure;
(function (SecurityBootstrapFailure) {
    /** Security bootstrapping was canceled by the user */
    SecurityBootstrapFailure[SecurityBootstrapFailure["UserCanceled"] = 0] = "UserCanceled";
    /** The required security keys were not configured in the driver */
    SecurityBootstrapFailure[SecurityBootstrapFailure["NoKeysConfigured"] = 1] = "NoKeysConfigured";
    /** No Security S2 user callbacks (or provisioning info) were provided to grant security classes and/or validate the DSK. */
    SecurityBootstrapFailure[SecurityBootstrapFailure["S2NoUserCallbacks"] = 2] = "S2NoUserCallbacks";
    /** An expected message was not received within the corresponding timeout */
    SecurityBootstrapFailure[SecurityBootstrapFailure["Timeout"] = 3] = "Timeout";
    /** There was no possible match in encryption parameters between the controller and the node */
    SecurityBootstrapFailure[SecurityBootstrapFailure["ParameterMismatch"] = 4] = "ParameterMismatch";
    /** Security bootstrapping was canceled by the included node */
    SecurityBootstrapFailure[SecurityBootstrapFailure["NodeCanceled"] = 5] = "NodeCanceled";
    /** The PIN was incorrect, so the included node could not decode the key exchange commands */
    SecurityBootstrapFailure[SecurityBootstrapFailure["S2IncorrectPIN"] = 6] = "S2IncorrectPIN";
    /** There was a mismatch in security keys between the controller and the node */
    SecurityBootstrapFailure[SecurityBootstrapFailure["S2WrongSecurityLevel"] = 7] = "S2WrongSecurityLevel";
    /** The node has been bootstrapped using S0 in an S2-capable network */
    SecurityBootstrapFailure[SecurityBootstrapFailure["S0Downgrade"] = 8] = "S0Downgrade";
    /** Some other unspecified error happened */
    SecurityBootstrapFailure[SecurityBootstrapFailure["Unknown"] = 9] = "Unknown";
})(SecurityBootstrapFailure || (SecurityBootstrapFailure = {}));
export var InclusionStrategy;
(function (InclusionStrategy) {
    /**
     * Always uses Security S2 if supported, otherwise uses Security S0 for certain devices which don't work without encryption and uses no encryption otherwise.
     *
     * Issues a warning if Security S0 or S2 is supported, but the secure bootstrapping fails.
     *
     * **This is the recommended** strategy and should be used unless there is a good reason not to.
     */
    InclusionStrategy[InclusionStrategy["Default"] = 0] = "Default";
    /**
     * Include using SmartStart (requires Security S2).
     *
     * **Note:** This will be used internally and cannot be used by applications
     */
    InclusionStrategy[InclusionStrategy["SmartStart"] = 1] = "SmartStart";
    /**
     * Don't use encryption, even if supported.
     *
     * **Not recommended**, because S2 should be used where possible.
     */
    InclusionStrategy[InclusionStrategy["Insecure"] = 2] = "Insecure";
    /**
     * Use Security S0, even if a higher security mode is supported.
     *
     * Issues a warning if Security S0 is not supported or the secure bootstrapping fails.
     *
     * **Not recommended** because S0 should be used sparingly and S2 preferred wherever possible.
     */
    InclusionStrategy[InclusionStrategy["Security_S0"] = 3] = "Security_S0";
    /**
     * Use Security S2 and issue a warning if it is not supported or the secure bootstrapping fails.
     *
     * **Not recommended** because the *Default* strategy is more versatile and user-friendly.
     */
    InclusionStrategy[InclusionStrategy["Security_S2"] = 4] = "Security_S2";
})(InclusionStrategy || (InclusionStrategy = {}));
export var ExclusionStrategy;
(function (ExclusionStrategy) {
    /** Exclude the node, keep the provisioning entry untouched */
    ExclusionStrategy[ExclusionStrategy["ExcludeOnly"] = 0] = "ExcludeOnly";
    /** Disable the node's Smart Start provisioning entry, but do not remove it */
    ExclusionStrategy[ExclusionStrategy["DisableProvisioningEntry"] = 1] = "DisableProvisioningEntry";
    /** Remove the node from the Smart Start provisioning list  */
    ExclusionStrategy[ExclusionStrategy["Unprovision"] = 2] = "Unprovision";
})(ExclusionStrategy || (ExclusionStrategy = {}));
export var ProvisioningEntryStatus;
(function (ProvisioningEntryStatus) {
    ProvisioningEntryStatus[ProvisioningEntryStatus["Active"] = 0] = "Active";
    ProvisioningEntryStatus[ProvisioningEntryStatus["Inactive"] = 1] = "Inactive";
})(ProvisioningEntryStatus || (ProvisioningEntryStatus = {}));
export var InclusionState;
(function (InclusionState) {
    /** The controller isn't doing anything regarding inclusion. */
    InclusionState[InclusionState["Idle"] = 0] = "Idle";
    /** The controller is waiting for a node to be included. */
    InclusionState[InclusionState["Including"] = 1] = "Including";
    /** The controller is waiting for a node to be excluded. */
    InclusionState[InclusionState["Excluding"] = 2] = "Excluding";
    /** The controller is busy including or excluding a node. */
    InclusionState[InclusionState["Busy"] = 3] = "Busy";
    /** The controller listening for SmartStart nodes to announce themselves. */
    InclusionState[InclusionState["SmartStart"] = 4] = "SmartStart";
})(InclusionState || (InclusionState = {}));
/** Additional information why a node was removed from the network */
export var RemoveNodeReason;
(function (RemoveNodeReason) {
    /** The node was excluded by the user or an inclusion controller */
    RemoveNodeReason[RemoveNodeReason["Excluded"] = 0] = "Excluded";
    /** The node was excluded by an inclusion controller */
    RemoveNodeReason[RemoveNodeReason["ProxyExcluded"] = 1] = "ProxyExcluded";
    /** The node was removed using the "remove failed node" feature */
    RemoveNodeReason[RemoveNodeReason["RemoveFailed"] = 2] = "RemoveFailed";
    /** The node was replaced using the "replace failed node" feature */
    RemoveNodeReason[RemoveNodeReason["Replaced"] = 3] = "Replaced";
    /** The node was replaced by an inclusion controller */
    RemoveNodeReason[RemoveNodeReason["ProxyReplaced"] = 4] = "ProxyReplaced";
    /** The node was reset locally and was auto-removed */
    RemoveNodeReason[RemoveNodeReason["Reset"] = 5] = "Reset";
    /** SmartStart inclusion failed, and the node was auto-removed as a result. */
    RemoveNodeReason[RemoveNodeReason["SmartStartFailed"] = 6] = "SmartStartFailed";
})(RemoveNodeReason || (RemoveNodeReason = {}));
export var JoinNetworkStrategy;
(function (JoinNetworkStrategy) {
    JoinNetworkStrategy[JoinNetworkStrategy["Default"] = 0] = "Default";
    // TODO: Implement
    // SmartStart,
    // These require modifying the NIF prior to joining
    // Security_S2,
    // Security_S0,
    // Insecure,
})(JoinNetworkStrategy || (JoinNetworkStrategy = {}));
export var JoinNetworkResult;
(function (JoinNetworkResult) {
    /** The process to join the network was started successfully */
    JoinNetworkResult[JoinNetworkResult["OK"] = 0] = "OK";
    /** Another join/leave process is already in progress. */
    JoinNetworkResult[JoinNetworkResult["Error_Busy"] = 1] = "Error_Busy";
    /** Joining another network is not permitted due to the controller's network role */
    JoinNetworkResult[JoinNetworkResult["Error_NotPermitted"] = 2] = "Error_NotPermitted";
    /** There was an unknown error while joining the network */
    JoinNetworkResult[JoinNetworkResult["Error_Failed"] = 3] = "Error_Failed";
})(JoinNetworkResult || (JoinNetworkResult = {}));
export var LeaveNetworkResult;
(function (LeaveNetworkResult) {
    /** The process to leave the network was started successfully */
    LeaveNetworkResult[LeaveNetworkResult["OK"] = 0] = "OK";
    /** Another join/leave process is already in progress. */
    LeaveNetworkResult[LeaveNetworkResult["Error_Busy"] = 1] = "Error_Busy";
    /** Leaving the network is not permitted due to the controller's network role */
    LeaveNetworkResult[LeaveNetworkResult["Error_NotPermitted"] = 2] = "Error_NotPermitted";
    /** There was an unknown error while leaving the network */
    LeaveNetworkResult[LeaveNetworkResult["Error_Failed"] = 3] = "Error_Failed";
})(LeaveNetworkResult || (LeaveNetworkResult = {}));
// | {
// 	strategy: JoinNetworkStrategy.Security_S2;
// 	requested: InclusionGrant;
// 	/**
// 	 * Allows overriding the user callbacks for this attempt at joining a network.
// 	 * If not given, the join network user callbacks of the driver options will be used.
// 	 */
// 	userCallbacks?: JoinNetworkUserCallbacks;
// };
//# sourceMappingURL=Inclusion.js.map