import { AssociationGroupInfoProfile, DeviceResetLocallyCommand, } from "@zwave-js/cc";
import { CommandClasses, EncapsulationFlags, } from "@zwave-js/core";
export async function handleAGINameGet(ctx, node, command) {
    if (command.groupId !== 1) {
        // We only "support" the lifeline group
        return;
    }
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    // We are being queried, so the device may actually not support the CC, just control it.
    // Using the commandClasses property would throw in that case
    const api = endpoint
        .createAPI(CommandClasses["Association Group Information"], false)
        .withOptions({
        // Answer with the same encapsulation as asked, but omit
        // Supervision as it shouldn't be used for Get-Report flows
        encapsulationFlags: command.encapsulationFlags
            & ~EncapsulationFlags.Supervision,
    });
    await api.reportGroupName(1, "Lifeline");
}
export async function handleAGIInfoGet(ctx, node, command) {
    if (!command.listMode && command.groupId !== 1) {
        // We only "support" the lifeline group
        return;
    }
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    // We are being queried, so the device may actually not support the CC, just control it.
    // Using the commandClasses property would throw in that case
    const api = endpoint
        .createAPI(CommandClasses["Association Group Information"], false)
        .withOptions({
        // Answer with the same encapsulation as asked, but omit
        // Supervision as it shouldn't be used for Get-Report flows
        encapsulationFlags: command.encapsulationFlags
            & ~EncapsulationFlags.Supervision,
    });
    await api.reportGroupInfo({
        isListMode: command.listMode ?? false,
        hasDynamicInfo: false,
        groups: [
            {
                groupId: 1,
                eventCode: 0, // ignored anyways
                profile: AssociationGroupInfoProfile["General: Lifeline"],
                mode: 0, // ignored anyways
            },
        ],
    });
}
export async function handleAGICommandListGet(ctx, node, command) {
    if (command.groupId !== 1) {
        // We only "support" the lifeline group
        return;
    }
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    // We are being queried, so the device may actually not support the CC, just control it.
    // Using the commandClasses property would throw in that case
    const api = endpoint
        .createAPI(CommandClasses["Association Group Information"], false)
        .withOptions({
        // Answer with the same encapsulation as asked, but omit
        // Supervision as it shouldn't be used for Get-Report flows
        encapsulationFlags: command.encapsulationFlags
            & ~EncapsulationFlags.Supervision,
    });
    await api.reportCommands(command.groupId, new Map([
        [
            CommandClasses["Device Reset Locally"],
            [DeviceResetLocallyCommand.Notification],
        ],
    ]));
}
export async function handleAssociationSupportedGroupingsGet(ctx, node, command) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    // We are being queried, so the device may actually not support the CC, just control it.
    // Using the commandClasses property would throw in that case
    const api = endpoint
        .createAPI(CommandClasses.Association, false)
        .withOptions({
        // Answer with the same encapsulation as asked, but omit
        // Supervision as it shouldn't be used for Get-Report flows
        encapsulationFlags: command.encapsulationFlags
            & ~EncapsulationFlags.Supervision,
    });
    // We only "support" the lifeline group
    await api.reportGroupCount(1);
}
//# sourceMappingURL=AssociationGroupInformationCC.js.map