import { CommandClasses, EncapsulationFlags, ZWaveLibraryTypes, } from "@zwave-js/core";
import semverParse from "semver/functions/parse.js";
import { libVersion } from "../../driver/Driver.js";
export async function handleVersionGet(ctx, controller, node, command, vendorInfo) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    // We are being queried, so the device may actually not support the CC, just control it.
    // Using the commandClasses property would throw in that case
    const api = endpoint
        .createAPI(CommandClasses.Version, false)
        .withOptions({
        // Answer with the same encapsulation as asked, but omit
        // Supervision as it shouldn't be used for Get-Report flows
        encapsulationFlags: command.encapsulationFlags
            & ~EncapsulationFlags.Supervision,
    });
    const firmwareVersion1 = semverParse(libVersion, { loose: true });
    await api.sendReport({
        libraryType: ZWaveLibraryTypes["Static Controller"],
        protocolVersion: controller.protocolVersion,
        firmwareVersions: [
            // Firmware 0 is the Z-Wave chip firmware
            controller.firmwareVersion,
            // Firmware 1 is Z-Wave JS itself
            `${firmwareVersion1.major}.${firmwareVersion1.minor}.${firmwareVersion1.patch}`,
        ],
        hardwareVersion: vendorInfo?.hardwareVersion,
    });
}
export async function handleVersionCommandClassGet(ctx, node, command, reportVersion) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    // We are being queried, so the device may actually not support the CC, just control it.
    // Using the commandClasses property would throw in that case
    const api = endpoint
        .createAPI(CommandClasses.Version, false)
        .withOptions({
        // Answer with the same encapsulation as asked, but omit
        // Supervision as it shouldn't be used for Get-Report flows
        encapsulationFlags: command.encapsulationFlags
            & ~EncapsulationFlags.Supervision,
    });
    await api.reportCCVersion(command.requestedCC, reportVersion);
}
export async function handleVersionCapabilitiesGet(ctx, node, command) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    // We are being queried, so the device may actually not support the CC, just control it.
    // Using the commandClasses property would throw in that case
    const api = endpoint
        .createAPI(CommandClasses.Version, false)
        .withOptions({
        // Answer with the same encapsulation as asked, but omit
        // Supervision as it shouldn't be used for Get-Report flows
        encapsulationFlags: command.encapsulationFlags
            & ~EncapsulationFlags.Supervision,
    });
    await api.reportCapabilities();
}
//# sourceMappingURL=VersionCC.js.map