import { NodeStatus, StateMachine } from "@zwave-js/core";
import type { NodeNetworkRole } from "./mixins/01_NetworkRole.js";
export type NodeStatusState = {
    value: "unknown" | "dead" | "alive" | "asleep" | "awake";
};
export type NodeStatusMachineInput = {
    value: "DEAD" | "ALIVE" | "ASLEEP" | "AWAKE";
};
export type NodeStatusMachine = StateMachine<NodeStatusState, NodeStatusMachineInput>;
export declare function nodeStatusMachineStateToNodeStatus(state: NodeStatusState["value"]): NodeStatus;
export declare function createNodeStatusMachine(node: NodeNetworkRole): NodeStatusMachine;
//# sourceMappingURL=NodeStatusMachine.d.ts.map