import { type CommandClasses, InterviewStage } from "@zwave-js/core";
import type { Driver } from "../../driver/Driver.js";
import type { DeviceClass } from "../DeviceClass.js";
import { type NodeReadyMachineInput } from "../NodeReadyMachine.js";
import { type NodeStatusMachineInput } from "../NodeStatusMachine.js";
import { NodeStatus } from "../_Types.js";
import { NodeEventsMixin } from "./10_Events.js";
export interface NodeWithStatus {
    /**
     * Which status the node is believed to be in
     */
    status: NodeStatus;
    /**
     * Whether the node is ready to be used
     */
    ready: boolean;
    /**
     * Which interview stage was last completed
     */
    interviewStage: InterviewStage;
}
export declare abstract class NodeStatusMixin extends NodeEventsMixin implements NodeWithStatus {
    constructor(nodeId: number, driver: Driver, index: number, deviceClass?: DeviceClass, supportedCCs?: CommandClasses[]);
    private statusMachine;
    private _status;
    /**
     * Which status the node is believed to be in
     */
    get status(): NodeStatus;
    protected restartStatusMachine(): void;
    protected updateStatusMachine(input: NodeStatusMachineInput): void;
    private onStatusChange;
    private readyMachine;
    private _ready;
    protected restartReadyMachine(): void;
    protected updateReadyMachine(input: NodeReadyMachineInput): void;
    private onReadyChange;
    /**
     * Whether the node is ready to be used
     */
    get ready(): boolean;
    protected set ready(ready: boolean);
    get interviewStage(): InterviewStage;
    set interviewStage(value: InterviewStage);
}
//# sourceMappingURL=20_Status.d.ts.map