import { type GetAllEndpoints, type GetEndpoint, type MaybeNotKnown } from "@zwave-js/core";
import { Endpoint } from "../Endpoint.js";
import { NodeCapabilityValuesMixin } from "./41_CapabilityValues.js";
/** Defines functionality of Z-Wave nodes related to accessing endpoints and their capabilities */
export interface Endpoints {
    /** Whether the endpoint count is dynamic */
    readonly endpointCountIsDynamic: MaybeNotKnown<boolean>;
    /** Whether all endpoints have identical capabilities */
    readonly endpointsHaveIdenticalCapabilities: MaybeNotKnown<boolean>;
    /** The number of individual endpoints */
    readonly individualEndpointCount: MaybeNotKnown<number>;
    /** The number of aggregated endpoints */
    readonly aggregatedEndpointCount: MaybeNotKnown<number>;
    /** Returns the current endpoint count of this node.
     *
     * If you want to enumerate the existing endpoints, use `getEndpointIndizes` instead.
     * Some devices are known to contradict themselves.
     */
    getEndpointCount(): number;
    /** Returns indizes of all endpoints on the node. */
    getEndpointIndizes(): number[];
    /** Returns an endpoint of this node with the given index. 0 returns the node itself. */
    getEndpoint(index: 0): Endpoint;
    getEndpoint(index: number): Endpoint | undefined;
    /** Returns an endpoint of this node with the given index. Throws if the endpoint does not exist. */
    getEndpointOrThrow(index: number): Endpoint;
    /** Returns a list of all endpoints of this node, including the root endpoint (index 0) */
    getAllEndpoints(): Endpoint[];
}
export declare abstract class EndpointsMixin extends NodeCapabilityValuesMixin implements Endpoints, GetEndpoint<Endpoint>, GetAllEndpoints<Endpoint> {
    get endpointCountIsDynamic(): MaybeNotKnown<boolean>;
    get endpointsHaveIdenticalCapabilities(): MaybeNotKnown<boolean>;
    get individualEndpointCount(): MaybeNotKnown<number>;
    get aggregatedEndpointCount(): MaybeNotKnown<number>;
    /** Returns the device class of an endpoint. Falls back to the node's device class if the information is not known. */
    private getEndpointDeviceClass;
    private getEndpointCCs;
    /**
     * Returns the current endpoint count of this node.
     *
     * If you want to enumerate the existing endpoints, use `getEndpointIndizes` instead.
     * Some devices are known to contradict themselves.
     */
    getEndpointCount(): number;
    /**
     * Returns indizes of all endpoints on the node.
     */
    getEndpointIndizes(): number[];
    /** Whether the Multi Channel CC has been interviewed and all endpoint information is known */
    private get isMultiChannelInterviewComplete();
    /** Cache for this node's endpoint instances */
    protected _endpointInstances: Map<number, Endpoint>;
    /**
     * Returns an endpoint of this node with the given index. 0 returns the node itself.
     */
    getEndpoint(index: 0): Endpoint;
    getEndpoint(index: number): Endpoint | undefined;
    getEndpointOrThrow(index: number): Endpoint;
    /** Returns a list of all endpoints of this node, including the root endpoint (index 0) */
    getAllEndpoints(): Endpoint[];
}
//# sourceMappingURL=50_Endpoints.d.ts.map