import { NotificationCCEventSupportedGet, NotificationCCEventSupportedReport, NotificationCCSupportedGet, NotificationCCSupportedReport, } from "@zwave-js/cc/NotificationCC";
import { CommandClasses } from "@zwave-js/core";
const defaultCapabilities = {
    supportsV1Alarm: false,
    notificationTypesAndEvents: {}, // none
};
const respondToNotificationSupportedGet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof NotificationCCSupportedGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(CommandClasses.Notification, receivedCC.endpointIndex),
            };
            const cc = new NotificationCCSupportedReport({
                nodeId: controller.ownNodeId,
                supportsV1Alarm: capabilities.supportsV1Alarm,
                supportedNotificationTypes: Object.keys(capabilities.notificationTypesAndEvents).map((t) => parseInt(t)),
            });
            return { action: "sendCC", cc };
        }
    },
};
const respondToNotificationEventSupportedGet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof NotificationCCEventSupportedGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(CommandClasses.Notification, receivedCC.endpointIndex),
            };
            if (receivedCC.notificationType
                in capabilities.notificationTypesAndEvents) {
                const cc = new NotificationCCEventSupportedReport({
                    nodeId: controller.ownNodeId,
                    notificationType: receivedCC.notificationType,
                    supportedEvents: capabilities.notificationTypesAndEvents[receivedCC.notificationType],
                });
                return { action: "sendCC", cc };
            }
            return { action: "stop" };
        }
    },
};
export const NotificationCCBehaviors = [
    respondToNotificationSupportedGet,
    respondToNotificationEventSupportedGet,
];
//# sourceMappingURL=Notification.js.map