"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAndUpdateShas = void 0;
var fs = __importStar(require("fs"));
var path = __importStar(require("path"));
var log_1 = require("./log");
function parseAndUpdateShas(inputFile) {
    // Read the input file containing new SHAs
    if (!fs.existsSync(inputFile)) {
        throw (0, log_1.wasReported)("Input file ".concat(inputFile, " does not exist"));
    }
    var input = fs.readFileSync(inputFile, 'utf8');
    var lines = input.split('\n').map(function (l) { return l.trim(); }).filter(Boolean);
    // Read existing shas.txt
    var shasPath = path.join(process.cwd(), 'shas.txt');
    var shasTxt = '';
    try {
        shasTxt = fs.readFileSync(shasPath, 'utf8');
    }
    catch (e) {
        log_1.log.info('shas.txt not found, creating new one');
        shasTxt = '';
    }
    var shasArr = shasTxt.split('\n');
    var _loop_1 = function (line) {
        var _a = line.split(/\s+/), sha = _a[0], patchName = _a[1];
        if (!sha || !patchName) {
            log_1.log.warn("Skipping invalid line: ".concat(line));
            return "continue";
        }
        // Extract major, os, arch. E.g.: node-v22.20.0-win-x64
        var match = patchName.match(/^node-v(\d+)\.[^ ]*-(.+)-(.+)$/);
        if (!match) {
            log_1.log.warn("Skipping line with invalid patch name format: ".concat(line));
            return "continue";
        }
        var major = match[1];
        var os = match[2];
        var arch = match[3];
        // Regex for matching line in shas.txt
        var re = new RegExp("^\\S+\\s+node-v".concat(major, "\\.([0-9.]+){2}-").concat(os, "-").concat(arch, "$"));
        var found = false;
        shasArr = shasArr.map(function (l) {
            if (re.test(l)) {
                found = true;
                log_1.log.info("Updating: ".concat(l, " -> ").concat(sha, "  ").concat(patchName));
                return "".concat(sha, "  ").concat(patchName);
            }
            return l;
        });
        if (!found) {
            log_1.log.info("Adding new entry: ".concat(sha, "  ").concat(patchName));
            shasArr.push("".concat(sha, "  ").concat(patchName));
        }
    };
    // Process each line from input
    for (var _i = 0, lines_1 = lines; _i < lines_1.length; _i++) {
        var line = lines_1[_i];
        _loop_1(line);
    }
    // Write updated shas.txt
    var filteredShas = shasArr.filter(Boolean);
    var updatedContent = filteredShas.length > 0 ? "".concat(filteredShas.join('\n'), "\n") : '';
    fs.writeFileSync(shasPath, updatedContent);
    log_1.log.info("Successfully updated ".concat(shasPath));
}
exports.parseAndUpdateShas = parseAndUpdateShas;
// Main execution
if (require.main === module) {
    var args = process.argv.slice(2);
    if (args.length !== 1) {
        log_1.log.error('Usage: parse-update-shas.ts <input-file>');
        log_1.log.error('  input-file: Path to file containing SHA lines in format "<sha> <patch-name>"');
        process.exit(1);
    }
    var inputFile = args[0];
    try {
        parseAndUpdateShas(inputFile);
    }
    catch (error) {
        if (error instanceof Error && !('wasReported' in error)) {
            log_1.log.error(error);
        }
        process.exit(1);
    }
}
//# sourceMappingURL=parse-update-shas.js.map