"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AssociationCC_exports = {};
__export(AssociationCC_exports, {
  AssociationCC: () => AssociationCC,
  AssociationCCAPI: () => AssociationCCAPI,
  AssociationCCGet: () => AssociationCCGet,
  AssociationCCRemove: () => AssociationCCRemove,
  AssociationCCReport: () => AssociationCCReport,
  AssociationCCSet: () => AssociationCCSet,
  AssociationCCSpecificGroupGet: () => AssociationCCSpecificGroupGet,
  AssociationCCSpecificGroupReport: () => AssociationCCSpecificGroupReport,
  AssociationCCSupportedGroupingsGet: () => AssociationCCSupportedGroupingsGet,
  AssociationCCSupportedGroupingsReport: () => AssociationCCSupportedGroupingsReport,
  AssociationCCValues: () => import_CCValues_generated.AssociationCCValues
});
module.exports = __toCommonJS(AssociationCC_exports);
var __validateArgs = __toESM(require("./AssociationCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_arrays = require("alcalzone-shared/arrays");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var ccUtils = __toESM(require("../lib/utils.js"), 1);
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_AssociationCCAPI_reportGroupCount, validateArgs_AssociationCCAPI_getGroup, validateArgs_AssociationCCAPI_sendReport, validateArgs_AssociationCCAPI_addNodeIds, validateArgs_AssociationCCAPI_removeNodeIds, validateArgs_AssociationCCAPI_removeNodeIdsFromAllGroups, validateArgs_AssociationCCAPI_getSpecificGroup, validateArgs_AssociationCCAPI_reportSpecificGroup } = __validateArgs;
let AssociationCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Association)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _reportGroupCount_decorators;
  let _getGroup_decorators;
  let _sendReport_decorators;
  let _addNodeIds_decorators;
  let _removeNodeIds_decorators;
  let _removeNodeIdsFromAllGroups_decorators;
  let _getSpecificGroup_decorators;
  let _reportSpecificGroup_decorators;
  var AssociationCCAPI2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _reportGroupCount_decorators = [validateArgs_AssociationCCAPI_reportGroupCount()];
      _getGroup_decorators = [validateArgs_AssociationCCAPI_getGroup()];
      _sendReport_decorators = [validateArgs_AssociationCCAPI_sendReport()];
      _addNodeIds_decorators = [validateArgs_AssociationCCAPI_addNodeIds()];
      _removeNodeIds_decorators = [validateArgs_AssociationCCAPI_removeNodeIds()];
      _removeNodeIdsFromAllGroups_decorators = [validateArgs_AssociationCCAPI_removeNodeIdsFromAllGroups()];
      _getSpecificGroup_decorators = [validateArgs_AssociationCCAPI_getSpecificGroup()];
      _reportSpecificGroup_decorators = [validateArgs_AssociationCCAPI_reportSpecificGroup()];
      __esDecorate(this, null, _reportGroupCount_decorators, { kind: "method", name: "reportGroupCount", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportGroupCount" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportGroupCount, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getGroup_decorators, { kind: "method", name: "getGroup", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getGroup" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getGroup, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _sendReport_decorators, { kind: "method", name: "sendReport", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendReport" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendReport, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _addNodeIds_decorators, { kind: "method", name: "addNodeIds", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "addNodeIds" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.addNodeIds, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _removeNodeIds_decorators, { kind: "method", name: "removeNodeIds", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "removeNodeIds" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.removeNodeIds, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _removeNodeIdsFromAllGroups_decorators, { kind: "method", name: "removeNodeIdsFromAllGroups", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "removeNodeIdsFromAllGroups" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.removeNodeIdsFromAllGroups, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getSpecificGroup_decorators, { kind: "method", name: "getSpecificGroup", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getSpecificGroup" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getSpecificGroup, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportSpecificGroup_decorators, { kind: "method", name: "reportSpecificGroup", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportSpecificGroup" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportSpecificGroup, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.AssociationCommand.Get:
        case import_Types.AssociationCommand.Set:
        case import_Types.AssociationCommand.Report:
        case import_Types.AssociationCommand.Remove:
        case import_Types.AssociationCommand.SupportedGroupingsGet:
        case import_Types.AssociationCommand.SupportedGroupingsReport:
          return true;
        case import_Types.AssociationCommand.SpecificGroupGet:
        case import_Types.AssociationCommand.SpecificGroupReport:
          return this.version >= 2;
      }
      return super.supportsCommand(cmd);
    }
    /**
     * Returns the number of association groups a node supports.
     * Association groups are consecutive, starting at 1.
     */
    async getGroupCount() {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.SupportedGroupingsGet);
      const cc = new AssociationCCSupportedGroupingsGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response)
        return response.groupCount;
    }
    async reportGroupCount(groupCount) {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.SupportedGroupingsReport);
      const cc = new AssociationCCSupportedGroupingsReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupCount
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Returns information about an association group.
     */
    async getGroup(groupId) {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.Get);
      const cc = new AssociationCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return {
          maxNodes: response.maxNodes,
          nodeIds: response.nodeIds
        };
      }
    }
    async sendReport(options) {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.Report);
      const cc = new AssociationCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Adds new nodes to an association group
     */
    async addNodeIds(groupId, ...nodeIds) {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.Set);
      const cc = new AssociationCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupId,
        nodeIds
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Removes nodes from an association group
     */
    async removeNodeIds(options) {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.Remove);
      if (!options.groupId) {
        if (this.version === 1) {
          throw new import_core.ZWaveError(`Node ${this.endpoint.nodeId} only supports AssociationCC V1 which requires the group Id to be set`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      } else if (options.groupId < 0) {
        throw new import_core.ZWaveError("The group id must be positive!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const cc = new AssociationCCRemove({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Removes nodes from all association groups
     */
    async removeNodeIdsFromAllGroups(nodeIds) {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.Remove);
      if (this.version >= 2) {
        return this.removeNodeIds({ nodeIds, groupId: 0 });
      } else {
        const groupCount = this.tryGetValueDB()?.getValue(import_CCValues_generated.AssociationCCValues.groupCount.endpoint(this.endpoint.index)) ?? 0;
        for (let groupId = 1; groupId <= groupCount; groupId++) {
          await this.removeNodeIds({ nodeIds, groupId });
        }
      }
    }
    /**
     * Request the association group that represents the most recently detected button press
     */
    async getSpecificGroup() {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.SpecificGroupGet);
      const cc = new AssociationCCSpecificGroupGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.group;
    }
    /**
     * Report the association group that represents the most recently detected button press
     */
    async reportSpecificGroup(group) {
      this.assertSupportsCommand(import_Types.AssociationCommand, import_Types.AssociationCommand.SpecificGroupReport);
      const cc = new AssociationCCSpecificGroupReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        group
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return AssociationCCAPI2 = _classThis;
})();
let AssociationCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Association), (0, import_CommandClassDecorators.implementedVersion)(4), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.AssociationCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var AssociationCC2 = class extends _classSuper {
    static {
      __name(this, "AssociationCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    determineRequiredCCInterviews() {
      return [
        ...super.determineRequiredCCInterviews(),
        import_core.CommandClasses["Z-Wave Plus Info"],
        // We need information about endpoints to correctly configure the lifeline associations
        import_core.CommandClasses["Multi Channel"]
      ];
    }
    /**
     * Returns the number of association groups reported by the node/endpoint.
     * This only works AFTER the interview process
     */
    static getGroupCountCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.AssociationCCValues.groupCount.endpoint(endpoint.index)) || 0;
    }
    /**
     * Returns the number of nodes an association group supports.
     * This only works AFTER the interview process
     */
    static getMaxNodesCached(ctx, endpoint, groupId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.AssociationCCValues.maxNodes(groupId).endpoint(endpoint.index)) ?? ctx.getDeviceConfig?.(endpoint.nodeId)?.getAssociationConfigForEndpoint(endpoint.index, groupId)?.maxNodes ?? 0;
    }
    /**
     * Returns all the destinations of all association groups reported by the node/endpoint.
     * This only works AFTER the interview process
     */
    static getAllDestinationsCached(ctx, endpoint) {
      const ret = /* @__PURE__ */ new Map();
      const groupCount = this.getGroupCountCached(ctx, endpoint);
      const valueDB = ctx.getValueDB(endpoint.nodeId);
      for (let i = 1; i <= groupCount; i++) {
        const nodes = valueDB.getValue(import_CCValues_generated.AssociationCCValues.nodeIds(i).endpoint(endpoint.index)) ?? [];
        ret.set(
          i,
          // Filter out duplicates
          (0, import_arrays.distinct)(nodes).map((nodeId) => ({ nodeId }))
        );
      }
      return ret;
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Association, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying number of association groups...",
        direction: "outbound"
      });
      const groupCount = await api.getGroupCount();
      if (groupCount != void 0) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `supports ${groupCount} association groups`,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying association groups timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      await this.refreshValues(ctx);
      if (endpoint.supportsCC(import_core.CommandClasses["Multi Channel Association"])) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `${this.constructor.name}: delaying configuration of lifeline associations until after Multi Channel Association interview...`,
          direction: "none"
        });
        this.setInterviewComplete(ctx, true);
        return;
      }
      await ccUtils.configureLifelineAssociations(ctx, endpoint);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Association, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const groupCount = AssociationCC2.getGroupCountCached(ctx, endpoint);
      for (let groupId = 1; groupId <= groupCount; groupId++) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying association group #${groupId}...`,
          direction: "outbound"
        });
        const group = await api.getGroup(groupId);
        if (group != void 0) {
          const logMessage = `received information for association group #${groupId}:
maximum # of nodes: ${group.maxNodes}
currently assigned nodes: ${group.nodeIds.map(String).join(", ")}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
    }
  };
  return AssociationCC2 = _classThis;
})();
let AssociationCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationCC;
  var AssociationCCSet2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.groupId < 1) {
        throw new import_core.ZWaveError("The group id must be positive!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      if (options.nodeIds.some((n) => n < 1 || n > import_core.MAX_NODES)) {
        throw new import_core.ZWaveError(`All node IDs must be between 1 and ${import_core.MAX_NODES}!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.groupId = options.groupId;
      this.nodeIds = options.nodeIds;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const groupId = raw.payload[0];
      const nodeIds = [...raw.payload.subarray(1)];
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId,
        nodeIds
      });
    }
    groupId;
    nodeIds;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.groupId, ...this.nodeIds]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "group id": this.groupId || "all groups",
        "node ids": this.nodeIds.length ? this.nodeIds.join(", ") : "all nodes"
      };
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return AssociationCCSet2 = _classThis;
})();
let AssociationCCRemove = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationCommand.Remove), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationCC;
  var AssociationCCRemove2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCRemove");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCRemove2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupId = options.groupId;
      this.nodeIds = options.nodeIds;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      let groupId;
      if (raw.payload[0] !== 0) {
        groupId = raw.payload[0];
      }
      const nodeIds = [...raw.payload.subarray(1)];
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId,
        nodeIds
      });
    }
    groupId;
    nodeIds;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.groupId || 0,
        ...this.nodeIds || []
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "group id": this.groupId || "all groups",
        "node ids": this.nodeIds && this.nodeIds.length ? this.nodeIds.join(", ") : "all nodes"
      };
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return AssociationCCRemove2 = _classThis;
})();
let AssociationCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("maxNodes", import_CCValues_generated.AssociationCCValues.maxNodes, (self) => [self.groupId]), (0, import_CommandClassDecorators.ccValueProperty)("nodeIds", import_CCValues_generated.AssociationCCValues.nodeIds, (self) => [self.groupId])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationCC;
  var AssociationCCReport2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupId = options.groupId;
      this.maxNodes = options.maxNodes;
      this.nodeIds = options.nodeIds;
      this.reportsToFollow = options.reportsToFollow;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const groupId = raw.payload[0];
      const maxNodes = raw.payload[1];
      const reportsToFollow = raw.payload[2];
      const nodeIds = [...raw.payload.subarray(3)];
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId,
        maxNodes,
        reportsToFollow,
        nodeIds
      });
    }
    groupId;
    maxNodes;
    nodeIds;
    reportsToFollow;
    getPartialCCSessionId() {
      return { groupId: this.groupId };
    }
    expectMoreMessages() {
      return this.reportsToFollow > 0;
    }
    mergePartialCCs(partials, _ctx) {
      this.nodeIds = [...partials, this].map((report) => report.nodeIds).reduce((prev, cur) => prev.concat(...cur), []);
      return Promise.resolve();
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.groupId,
        this.maxNodes,
        this.reportsToFollow,
        ...this.nodeIds
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "group id": this.groupId,
          "max # of nodes": this.maxNodes,
          "node IDs": this.nodeIds.join(", "),
          "reports to follow": this.reportsToFollow
        }
      };
    }
  };
  return AssociationCCReport2 = _classThis;
})();
let AssociationCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(AssociationCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationCC;
  var AssociationCCGet2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.groupId < 1) {
        throw new import_core.ZWaveError("The group id must be positive!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.groupId = options.groupId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const groupId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId
      });
    }
    groupId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.groupId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "group id": this.groupId }
      };
    }
  };
  return AssociationCCGet2 = _classThis;
})();
let AssociationCCSupportedGroupingsReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationCommand.SupportedGroupingsReport), (0, import_CommandClassDecorators.ccValueProperty)("groupCount", import_CCValues_generated.AssociationCCValues.groupCount)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationCC;
  var AssociationCCSupportedGroupingsReport2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCSupportedGroupingsReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCSupportedGroupingsReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupCount = options.groupCount;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const groupCount = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        groupCount
      });
    }
    groupCount;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.groupCount]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "group count": this.groupCount }
      };
    }
  };
  return AssociationCCSupportedGroupingsReport2 = _classThis;
})();
let AssociationCCSupportedGroupingsGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationCommand.SupportedGroupingsGet), (0, import_CommandClassDecorators.expectedCCResponse)(AssociationCCSupportedGroupingsReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationCC;
  var AssociationCCSupportedGroupingsGet2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCSupportedGroupingsGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCSupportedGroupingsGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return AssociationCCSupportedGroupingsGet2 = _classThis;
})();
let AssociationCCSpecificGroupReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationCommand.SpecificGroupReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationCC;
  var AssociationCCSpecificGroupReport2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCSpecificGroupReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCSpecificGroupReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.group = options.group;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const group = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        group
      });
    }
    group;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.group]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { group: this.group }
      };
    }
  };
  return AssociationCCSpecificGroupReport2 = _classThis;
})();
let AssociationCCSpecificGroupGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationCommand.SpecificGroupGet), (0, import_CommandClassDecorators.expectedCCResponse)(AssociationCCSpecificGroupReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationCC;
  var AssociationCCSpecificGroupGet2 = class extends _classSuper {
    static {
      __name(this, "AssociationCCSpecificGroupGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationCCSpecificGroupGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return AssociationCCSpecificGroupGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AssociationCC,
  AssociationCCAPI,
  AssociationCCGet,
  AssociationCCRemove,
  AssociationCCReport,
  AssociationCCSet,
  AssociationCCSpecificGroupGet,
  AssociationCCSpecificGroupReport,
  AssociationCCSupportedGroupingsGet,
  AssociationCCSupportedGroupingsReport,
  AssociationCCValues
});
//# sourceMappingURL=AssociationCC.js.map
