"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AssociationGroupInfoCC_exports = {};
__export(AssociationGroupInfoCC_exports, {
  AssociationGroupInfoCC: () => AssociationGroupInfoCC,
  AssociationGroupInfoCCAPI: () => AssociationGroupInfoCCAPI,
  AssociationGroupInfoCCCommandListGet: () => AssociationGroupInfoCCCommandListGet,
  AssociationGroupInfoCCCommandListReport: () => AssociationGroupInfoCCCommandListReport,
  AssociationGroupInfoCCInfoGet: () => AssociationGroupInfoCCInfoGet,
  AssociationGroupInfoCCInfoReport: () => AssociationGroupInfoCCInfoReport,
  AssociationGroupInfoCCNameGet: () => AssociationGroupInfoCCNameGet,
  AssociationGroupInfoCCNameReport: () => AssociationGroupInfoCCNameReport,
  AssociationGroupInfoCCValues: () => import_CCValues_generated.AssociationGroupInfoCCValues
});
module.exports = __toCommonJS(AssociationGroupInfoCC_exports);
var __validateArgs = __toESM(require("./AssociationGroupInfoCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_AssociationCC = require("./AssociationCC.js");
var import_MultiChannelAssociationCC = require("./MultiChannelAssociationCC.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_AssociationGroupInfoCCAPI_getGroupName, validateArgs_AssociationGroupInfoCCAPI_reportGroupName, validateArgs_AssociationGroupInfoCCAPI_getGroupInfo, validateArgs_AssociationGroupInfoCCAPI_reportGroupInfo, validateArgs_AssociationGroupInfoCCAPI_getCommands, validateArgs_AssociationGroupInfoCCAPI_reportCommands } = __validateArgs;
let AssociationGroupInfoCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Association Group Information"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _getGroupName_decorators;
  let _reportGroupName_decorators;
  let _getGroupInfo_decorators;
  let _reportGroupInfo_decorators;
  let _getCommands_decorators;
  let _reportCommands_decorators;
  var AssociationGroupInfoCCAPI2 = class extends _classSuper {
    static {
      __name(this, "AssociationGroupInfoCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _getGroupName_decorators = [validateArgs_AssociationGroupInfoCCAPI_getGroupName()];
      _reportGroupName_decorators = [validateArgs_AssociationGroupInfoCCAPI_reportGroupName()];
      _getGroupInfo_decorators = [validateArgs_AssociationGroupInfoCCAPI_getGroupInfo()];
      _reportGroupInfo_decorators = [validateArgs_AssociationGroupInfoCCAPI_reportGroupInfo()];
      _getCommands_decorators = [validateArgs_AssociationGroupInfoCCAPI_getCommands()];
      _reportCommands_decorators = [validateArgs_AssociationGroupInfoCCAPI_reportCommands()];
      __esDecorate(this, null, _getGroupName_decorators, { kind: "method", name: "getGroupName", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getGroupName" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getGroupName, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportGroupName_decorators, { kind: "method", name: "reportGroupName", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportGroupName" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportGroupName, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getGroupInfo_decorators, { kind: "method", name: "getGroupInfo", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getGroupInfo" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getGroupInfo, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportGroupInfo_decorators, { kind: "method", name: "reportGroupInfo", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportGroupInfo" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportGroupInfo, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getCommands_decorators, { kind: "method", name: "getCommands", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getCommands" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getCommands, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportCommands_decorators, { kind: "method", name: "reportCommands", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportCommands" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportCommands, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationGroupInfoCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.AssociationGroupInfoCommand.NameGet:
        case import_Types.AssociationGroupInfoCommand.NameReport:
        case import_Types.AssociationGroupInfoCommand.InfoGet:
        case import_Types.AssociationGroupInfoCommand.InfoReport:
        case import_Types.AssociationGroupInfoCommand.CommandListGet:
        case import_Types.AssociationGroupInfoCommand.CommandListReport:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    async getGroupName(groupId) {
      this.assertSupportsCommand(import_Types.AssociationGroupInfoCommand, import_Types.AssociationGroupInfoCommand.NameGet);
      const cc = new AssociationGroupInfoCCNameGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response)
        return response.name;
    }
    async reportGroupName(groupId, name) {
      this.assertSupportsCommand(import_Types.AssociationGroupInfoCommand, import_Types.AssociationGroupInfoCommand.NameReport);
      const cc = new AssociationGroupInfoCCNameReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupId,
        name
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async getGroupInfo(groupId, refreshCache = false) {
      this.assertSupportsCommand(import_Types.AssociationGroupInfoCommand, import_Types.AssociationGroupInfoCommand.InfoGet);
      const cc = new AssociationGroupInfoCCInfoGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupId,
        refreshCache
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response && response.groups.length > 0) {
        const { groupId: _, ...info } = response.groups[0];
        return {
          hasDynamicInfo: response.hasDynamicInfo,
          ...info
        };
      }
    }
    async reportGroupInfo(options) {
      this.assertSupportsCommand(import_Types.AssociationGroupInfoCommand, import_Types.AssociationGroupInfoCommand.InfoReport);
      const cc = new AssociationGroupInfoCCInfoReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async getCommands(groupId, allowCache = true) {
      this.assertSupportsCommand(import_Types.AssociationGroupInfoCommand, import_Types.AssociationGroupInfoCommand.CommandListGet);
      const cc = new AssociationGroupInfoCCCommandListGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupId,
        allowCache
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response)
        return response.commands;
    }
    async reportCommands(groupId, commands) {
      this.assertSupportsCommand(import_Types.AssociationGroupInfoCommand, import_Types.AssociationGroupInfoCommand.CommandListReport);
      const cc = new AssociationGroupInfoCCCommandListReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupId,
        commands
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return AssociationGroupInfoCCAPI2 = _classThis;
})();
let AssociationGroupInfoCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Association Group Information"]), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.AssociationGroupInfoCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var AssociationGroupInfoCC2 = class extends _classSuper {
    static {
      __name(this, "AssociationGroupInfoCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationGroupInfoCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    determineRequiredCCInterviews() {
      return [
        ...super.determineRequiredCCInterviews(),
        import_core.CommandClasses.Association,
        import_core.CommandClasses["Multi Channel Association"]
      ];
    }
    /** Returns the name of an association group */
    static getGroupNameCached(ctx, endpoint, groupId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.AssociationGroupInfoCCValues.groupName(groupId).endpoint(endpoint.index));
    }
    /** Returns the association profile for an association group */
    static getGroupProfileCached(ctx, endpoint, groupId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.AssociationGroupInfoCCValues.groupInfo(groupId).endpoint(endpoint.index))?.profile;
    }
    /** Returns the dictionary of all commands issued by the given association group */
    static getIssuedCommandsCached(ctx, endpoint, groupId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.AssociationGroupInfoCCValues.commands(groupId).endpoint(endpoint.index));
    }
    static findGroupsForIssuedCommand(ctx, endpoint, ccId, command) {
      const ret = [];
      const associationGroupCount = this.getAssociationGroupCountCached(ctx, endpoint);
      for (let groupId = 1; groupId <= associationGroupCount; groupId++) {
        const issuedCommands = this.getIssuedCommandsCached(ctx, endpoint, groupId);
        if (!issuedCommands)
          continue;
        if (issuedCommands.has(ccId) && issuedCommands.get(ccId).includes(command)) {
          ret.push(groupId);
          continue;
        }
      }
      return ret;
    }
    static getAssociationGroupCountCached(ctx, endpoint) {
      return (
        // First query the Multi Channel Association CC
        // And fall back to 0
        endpoint.supportsCC(import_core.CommandClasses["Multi Channel Association"]) && import_MultiChannelAssociationCC.MultiChannelAssociationCC.getGroupCountCached(ctx, endpoint) || endpoint.supportsCC(import_core.CommandClasses.Association) && import_AssociationCC.AssociationCC.getGroupCountCached(ctx, endpoint) || 0
      );
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Association Group Information"], ctx, endpoint).withOptions({ priority: import_core.MessagePriority.NodeQuery });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      const associationGroupCount = AssociationGroupInfoCC2.getAssociationGroupCountCached(ctx, endpoint);
      for (let groupId = 1; groupId <= associationGroupCount; groupId++) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `Association group #${groupId}: Querying name...`,
          direction: "outbound"
        });
        const name = await api.getGroupName(groupId);
        if (name) {
          const logMessage = `Association group #${groupId} has name "${name}"`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `Association group #${groupId}: Querying command list...`,
          direction: "outbound"
        });
        await api.getCommands(groupId);
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Association Group Information"], ctx, endpoint).withOptions({ priority: import_core.MessagePriority.NodeQuery });
      const associationGroupCount = AssociationGroupInfoCC2.getAssociationGroupCountCached(ctx, endpoint);
      const hasDynamicInfo = this.getValue(ctx, import_CCValues_generated.AssociationGroupInfoCCValues.hasDynamicInfo);
      for (let groupId = 1; groupId <= associationGroupCount; groupId++) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `Association group #${groupId}: Querying info...`,
          direction: "outbound"
        });
        const info = await api.getGroupInfo(groupId, !!hasDynamicInfo);
        if (info) {
          const logMessage = `Received info for association group #${groupId}:
info is dynamic: ${info.hasDynamicInfo}
profile:         ${(0, import_shared.getEnumMemberName)(import_Types.AssociationGroupInfoProfile, info.profile)}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
    }
  };
  return AssociationGroupInfoCC2 = _classThis;
})();
let AssociationGroupInfoCCNameReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationGroupInfoCommand.NameReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationGroupInfoCC;
  var AssociationGroupInfoCCNameReport2 = class extends _classSuper {
    static {
      __name(this, "AssociationGroupInfoCCNameReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationGroupInfoCCNameReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupId = options.groupId;
      this.name = options.name;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const groupId = raw.payload[0];
      const nameLength = raw.payload[1];
      (0, import_core.validatePayload)(raw.payload.length >= 2 + nameLength);
      const name = (0, import_shared.cpp2js)(raw.payload.subarray(2, 2 + nameLength).toString("utf8"));
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId,
        name
      });
    }
    groupId;
    name;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const valueDB = this.getValueDB(ctx);
      valueDB.setValue(import_CCValues_generated.AssociationGroupInfoCCValues.groupName(this.groupId).endpoint(this.endpointIndex), this.name);
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.groupId, this.name.length]),
        import_shared.Bytes.from(this.name, "utf8")
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "group id": this.groupId,
          name: this.name
        }
      };
    }
  };
  return AssociationGroupInfoCCNameReport2 = _classThis;
})();
let AssociationGroupInfoCCNameGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationGroupInfoCommand.NameGet), (0, import_CommandClassDecorators.expectedCCResponse)(AssociationGroupInfoCCNameReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationGroupInfoCC;
  var AssociationGroupInfoCCNameGet2 = class extends _classSuper {
    static {
      __name(this, "AssociationGroupInfoCCNameGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationGroupInfoCCNameGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupId = options.groupId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const groupId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId
      });
    }
    groupId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.groupId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "group id": this.groupId }
      };
    }
  };
  return AssociationGroupInfoCCNameGet2 = _classThis;
})();
let AssociationGroupInfoCCInfoReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationGroupInfoCommand.InfoReport), (0, import_CommandClassDecorators.ccValueProperty)("hasDynamicInfo", import_CCValues_generated.AssociationGroupInfoCCValues.hasDynamicInfo)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationGroupInfoCC;
  var AssociationGroupInfoCCInfoReport2 = class extends _classSuper {
    static {
      __name(this, "AssociationGroupInfoCCInfoReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationGroupInfoCCInfoReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.isListMode = options.isListMode;
      this.hasDynamicInfo = options.hasDynamicInfo;
      this.groups = options.groups;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const isListMode = !!(raw.payload[0] & 128);
      const hasDynamicInfo = !!(raw.payload[0] & 64);
      const groupCount = raw.payload[0] & 63;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + groupCount * 7);
      const groups = [];
      for (let i = 0; i < groupCount; i++) {
        const offset = 1 + i * 7;
        const groupBytes = raw.payload.subarray(offset, offset + 7);
        const groupId = groupBytes[0];
        const mode = 0;
        const profile = groupBytes.readUInt16BE(2);
        const eventCode = 0;
        groups.push({ groupId, mode, profile, eventCode });
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        isListMode,
        hasDynamicInfo,
        groups
      });
    }
    isListMode;
    hasDynamicInfo;
    groups;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      for (const group of this.groups) {
        const { groupId, mode, profile, eventCode } = group;
        this.setValue(ctx, import_CCValues_generated.AssociationGroupInfoCCValues.groupInfo(groupId), {
          mode,
          profile,
          eventCode
        });
      }
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.alloc(1 + this.groups.length * 7, 0);
      this.payload[0] = (this.isListMode ? 128 : 0) | (this.hasDynamicInfo ? 64 : 0) | this.groups.length & 63;
      for (let i = 0; i < this.groups.length; i++) {
        const offset = 1 + i * 7;
        this.payload[offset] = this.groups[i].groupId;
        this.payload.writeUInt16BE(this.groups[i].profile, offset + 2);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "is list mode": this.isListMode,
          "has dynamic info": this.hasDynamicInfo,
          groups: `${this.groups.map((g) => `
\xB7 Group #${g.groupId}
  mode:       ${g.mode}
  profile:    ${g.profile}
  event code: ${g.eventCode}`).join("")}`
        }
      };
    }
  };
  return AssociationGroupInfoCCInfoReport2 = _classThis;
})();
let AssociationGroupInfoCCInfoGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationGroupInfoCommand.InfoGet), (0, import_CommandClassDecorators.expectedCCResponse)(AssociationGroupInfoCCInfoReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationGroupInfoCC;
  var AssociationGroupInfoCCInfoGet2 = class extends _classSuper {
    static {
      __name(this, "AssociationGroupInfoCCInfoGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationGroupInfoCCInfoGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.refreshCache = options.refreshCache;
      if ("listMode" in options)
        this.listMode = options.listMode;
      if ("groupId" in options)
        this.groupId = options.groupId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const optionByte = raw.payload[0];
      const refreshCache = !!(optionByte & 128);
      const listMode = !!(optionByte & 64);
      let groupId;
      if (!listMode) {
        groupId = raw.payload[1];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        refreshCache,
        listMode,
        groupId
      });
    }
    refreshCache;
    listMode;
    groupId;
    serialize(ctx) {
      const isListMode = this.listMode === true;
      const optionByte = (this.refreshCache ? 128 : 0) | (isListMode ? 64 : 0);
      this.payload = import_shared.Bytes.from([
        optionByte,
        isListMode ? 0 : this.groupId
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {};
      if (this.groupId != void 0) {
        message["group id"] = this.groupId;
      }
      if (this.listMode != void 0) {
        message["list mode"] = this.listMode;
      }
      message["refresh cache"] = this.refreshCache;
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return AssociationGroupInfoCCInfoGet2 = _classThis;
})();
let AssociationGroupInfoCCCommandListReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationGroupInfoCommand.CommandListReport), (0, import_CommandClassDecorators.ccValueProperty)("commands", import_CCValues_generated.AssociationGroupInfoCCValues.commands, (self) => [self.groupId])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationGroupInfoCC;
  var AssociationGroupInfoCCCommandListReport2 = class extends _classSuper {
    static {
      __name(this, "AssociationGroupInfoCCCommandListReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationGroupInfoCCCommandListReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupId = options.groupId;
      this.commands = options.commands;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const groupId = raw.payload[0];
      const listLength = raw.payload[1];
      (0, import_core.validatePayload)(raw.payload.length >= 2 + listLength);
      const listBytes = raw.payload.subarray(2, 2 + listLength);
      let offset = 0;
      const commands = /* @__PURE__ */ new Map();
      while (offset < listLength) {
        const { ccId, bytesRead } = (0, import_core.parseCCId)(listBytes, offset);
        const command = listBytes[offset + bytesRead];
        if (!commands.has(ccId))
          commands.set(ccId, []);
        commands.get(ccId).push(command);
        offset += bytesRead + 1;
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId,
        commands
      });
    }
    groupId;
    commands;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(2 + this.commands.size * 3);
      this.payload[0] = this.groupId;
      let offset = 2;
      for (const [ccId, commands] of this.commands) {
        for (const command of commands) {
          offset += (0, import_core.encodeCCId)(ccId, this.payload, offset);
          this.payload[offset] = command;
          offset++;
        }
      }
      this.payload[1] = offset - 2;
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "group id": this.groupId,
          commands: `${[...this.commands].map(([cc, cmds]) => {
            return `
\xB7 ${(0, import_core.getCCName)(cc)}: ${cmds.map((cmd) => (0, import_shared.num2hex)(cmd)).join(", ")}`;
          }).join("")}`
        }
      };
    }
  };
  return AssociationGroupInfoCCCommandListReport2 = _classThis;
})();
let AssociationGroupInfoCCCommandListGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AssociationGroupInfoCommand.CommandListGet), (0, import_CommandClassDecorators.expectedCCResponse)(AssociationGroupInfoCCCommandListReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssociationGroupInfoCC;
  var AssociationGroupInfoCCCommandListGet2 = class extends _classSuper {
    static {
      __name(this, "AssociationGroupInfoCCCommandListGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssociationGroupInfoCCCommandListGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.allowCache = options.allowCache;
      this.groupId = options.groupId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const allowCache = !!(raw.payload[0] & 128);
      const groupId = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        allowCache,
        groupId
      });
    }
    allowCache;
    groupId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.allowCache ? 128 : 0,
        this.groupId
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "group id": this.groupId,
          "allow cache": this.allowCache
        }
      };
    }
  };
  return AssociationGroupInfoCCCommandListGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AssociationGroupInfoCC,
  AssociationGroupInfoCCAPI,
  AssociationGroupInfoCCCommandListGet,
  AssociationGroupInfoCCCommandListReport,
  AssociationGroupInfoCCInfoGet,
  AssociationGroupInfoCCInfoReport,
  AssociationGroupInfoCCNameGet,
  AssociationGroupInfoCCNameReport,
  AssociationGroupInfoCCValues
});
//# sourceMappingURL=AssociationGroupInfoCC.js.map
