"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var FirmwareUpdateMetaDataCC_exports = {};
__export(FirmwareUpdateMetaDataCC_exports, {
  FirmwareUpdateMetaDataCC: () => FirmwareUpdateMetaDataCC,
  FirmwareUpdateMetaDataCCAPI: () => FirmwareUpdateMetaDataCCAPI,
  FirmwareUpdateMetaDataCCActivationReport: () => FirmwareUpdateMetaDataCCActivationReport,
  FirmwareUpdateMetaDataCCActivationSet: () => FirmwareUpdateMetaDataCCActivationSet,
  FirmwareUpdateMetaDataCCGet: () => FirmwareUpdateMetaDataCCGet,
  FirmwareUpdateMetaDataCCMetaDataGet: () => FirmwareUpdateMetaDataCCMetaDataGet,
  FirmwareUpdateMetaDataCCMetaDataReport: () => FirmwareUpdateMetaDataCCMetaDataReport,
  FirmwareUpdateMetaDataCCPrepareGet: () => FirmwareUpdateMetaDataCCPrepareGet,
  FirmwareUpdateMetaDataCCPrepareReport: () => FirmwareUpdateMetaDataCCPrepareReport,
  FirmwareUpdateMetaDataCCReport: () => FirmwareUpdateMetaDataCCReport,
  FirmwareUpdateMetaDataCCRequestGet: () => FirmwareUpdateMetaDataCCRequestGet,
  FirmwareUpdateMetaDataCCRequestReport: () => FirmwareUpdateMetaDataCCRequestReport,
  FirmwareUpdateMetaDataCCStatusReport: () => FirmwareUpdateMetaDataCCStatusReport,
  FirmwareUpdateMetaDataCCValues: () => import_CCValues_generated.FirmwareUpdateMetaDataCCValues
});
module.exports = __toCommonJS(FirmwareUpdateMetaDataCC_exports);
var __validateArgs = __toESM(require("./FirmwareUpdateMetaDataCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_FirmwareUpdateMetaDataCCAPI_reportMetaData, validateArgs_FirmwareUpdateMetaDataCCAPI_requestUpdate, validateArgs_FirmwareUpdateMetaDataCCAPI_respondToUpdateRequest, validateArgs_FirmwareUpdateMetaDataCCAPI_respondToDownloadRequest, validateArgs_FirmwareUpdateMetaDataCCAPI_sendFirmwareFragment, validateArgs_FirmwareUpdateMetaDataCCAPI_activateFirmware } = __validateArgs;
let FirmwareUpdateMetaDataCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Firmware Update Meta Data"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _reportMetaData_decorators;
  let _requestUpdate_decorators;
  let _respondToUpdateRequest_decorators;
  let _respondToDownloadRequest_decorators;
  let _sendFirmwareFragment_decorators;
  let _activateFirmware_decorators;
  var FirmwareUpdateMetaDataCCAPI2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _reportMetaData_decorators = [validateArgs_FirmwareUpdateMetaDataCCAPI_reportMetaData()];
      _requestUpdate_decorators = [validateArgs_FirmwareUpdateMetaDataCCAPI_requestUpdate()];
      _respondToUpdateRequest_decorators = [validateArgs_FirmwareUpdateMetaDataCCAPI_respondToUpdateRequest()];
      _respondToDownloadRequest_decorators = [validateArgs_FirmwareUpdateMetaDataCCAPI_respondToDownloadRequest()];
      _sendFirmwareFragment_decorators = [validateArgs_FirmwareUpdateMetaDataCCAPI_sendFirmwareFragment()];
      _activateFirmware_decorators = [validateArgs_FirmwareUpdateMetaDataCCAPI_activateFirmware()];
      __esDecorate(this, null, _reportMetaData_decorators, { kind: "method", name: "reportMetaData", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportMetaData" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportMetaData, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _requestUpdate_decorators, { kind: "method", name: "requestUpdate", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "requestUpdate" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.requestUpdate, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _respondToUpdateRequest_decorators, { kind: "method", name: "respondToUpdateRequest", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "respondToUpdateRequest" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.respondToUpdateRequest, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _respondToDownloadRequest_decorators, { kind: "method", name: "respondToDownloadRequest", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "respondToDownloadRequest" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.respondToDownloadRequest, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _sendFirmwareFragment_decorators, { kind: "method", name: "sendFirmwareFragment", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendFirmwareFragment" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendFirmwareFragment, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _activateFirmware_decorators, { kind: "method", name: "activateFirmware", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "activateFirmware" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.activateFirmware, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.FirmwareUpdateMetaDataCommand.MetaDataGet:
        case import_Types.FirmwareUpdateMetaDataCommand.MetaDataReport:
        case import_Types.FirmwareUpdateMetaDataCommand.RequestGet:
        case import_Types.FirmwareUpdateMetaDataCommand.RequestReport:
        case import_Types.FirmwareUpdateMetaDataCommand.Report:
        case import_Types.FirmwareUpdateMetaDataCommand.StatusReport:
          return true;
        case import_Types.FirmwareUpdateMetaDataCommand.ActivationSet:
          return this.version >= 4 && (this.version < 7 || this.tryGetValueDB()?.getValue(import_CCValues_generated.FirmwareUpdateMetaDataCCValues.supportsActivation.endpoint(this.endpoint.index)) === true);
        case import_Types.FirmwareUpdateMetaDataCommand.PrepareGet:
        case import_Types.FirmwareUpdateMetaDataCommand.PrepareReport:
          return this.version >= 5;
      }
      return super.supportsCommand(cmd);
    }
    /**
     * Requests information about the current firmware on the device
     */
    async getMetaData() {
      this.assertSupportsCommand(import_Types.FirmwareUpdateMetaDataCommand, import_Types.FirmwareUpdateMetaDataCommand.MetaDataGet);
      const cc = new FirmwareUpdateMetaDataCCMetaDataGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "manufacturerId",
          "firmwareId",
          "checksum",
          "firmwareUpgradable",
          "maxFragmentSize",
          "additionalFirmwareIDs",
          "hardwareVersion",
          "continuesToFunction",
          "supportsActivation",
          "supportsResuming",
          "supportsNonSecureTransfer"
        ]);
      }
    }
    async reportMetaData(options) {
      this.assertSupportsCommand(import_Types.FirmwareUpdateMetaDataCommand, import_Types.FirmwareUpdateMetaDataCommand.Report);
      const cc = new FirmwareUpdateMetaDataCCMetaDataReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Requests the device to start the firmware update process and waits for a response.
     * This response may time out on some devices, in which case the caller of this method
     * should wait manually.
     */
    requestUpdate(options) {
      this.assertSupportsCommand(import_Types.FirmwareUpdateMetaDataCommand, import_Types.FirmwareUpdateMetaDataCommand.RequestGet);
      const cc = new FirmwareUpdateMetaDataCCRequestGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Responds to a firmware update request
     */
    async respondToUpdateRequest(options) {
      this.assertSupportsCommand(import_Types.FirmwareUpdateMetaDataCommand, import_Types.FirmwareUpdateMetaDataCommand.RequestReport);
      const cc = new FirmwareUpdateMetaDataCCRequestReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, {
        ...this.commandOptions,
        // Do not wait for Nonce Reports
        s2VerifyDelivery: false
      });
    }
    /**
     * Responds to a firmware download request
     */
    async respondToDownloadRequest(options) {
      this.assertSupportsCommand(import_Types.FirmwareUpdateMetaDataCommand, import_Types.FirmwareUpdateMetaDataCommand.PrepareReport);
      const cc = new FirmwareUpdateMetaDataCCPrepareReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, {
        ...this.commandOptions,
        // Do not wait for Nonce Reports
        s2VerifyDelivery: false
      });
    }
    /**
     * Sends a fragment of the new firmware to the device
     */
    async sendFirmwareFragment(fragmentNumber, isLastFragment, data) {
      this.assertSupportsCommand(import_Types.FirmwareUpdateMetaDataCommand, import_Types.FirmwareUpdateMetaDataCommand.Report);
      const cc = new FirmwareUpdateMetaDataCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        reportNumber: fragmentNumber,
        isLast: isLastFragment,
        firmwareData: data
      });
      await this.host.sendCommand(cc, {
        ...this.commandOptions,
        // Do not wait for Nonce Reports
        s2VerifyDelivery: false
      });
    }
    /** Activates a previously transferred firmware image */
    async activateFirmware(options) {
      this.assertSupportsCommand(import_Types.FirmwareUpdateMetaDataCommand, import_Types.FirmwareUpdateMetaDataCommand.ActivationSet);
      const cc = new FirmwareUpdateMetaDataCCActivationSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.activationStatus;
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return FirmwareUpdateMetaDataCCAPI2 = _classThis;
})();
let FirmwareUpdateMetaDataCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Firmware Update Meta Data"]), (0, import_CommandClassDecorators.implementedVersion)(8), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.FirmwareUpdateMetaDataCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var FirmwareUpdateMetaDataCC2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    skipEndpointInterview() {
      return true;
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Firmware Update Meta Data"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "Querying firmware update capabilities...",
        direction: "outbound"
      });
      const caps = await api.getMetaData();
      if (caps) {
        let logMessage = `Received firmware update capabilities:`;
        if (caps.firmwareUpgradable) {
          logMessage += `
  firmware targets:             ${[0, ...caps.additionalFirmwareIDs].join(", ")}
  continues to function:        ${caps.continuesToFunction}
  supports activation:          ${caps.supportsActivation}`;
          if (caps.supportsResuming != void 0) {
            logMessage += `
  supports resuming:            ${caps.supportsResuming}`;
          }
          if (caps.supportsNonSecureTransfer != void 0) {
            logMessage += `
  supports non-secure transfer: ${caps.supportsNonSecureTransfer}`;
          }
        } else {
          logMessage += `
firmware upgradeable: false`;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Firmware update capability query timed out",
          direction: "inbound"
        });
      }
      this.setInterviewComplete(ctx, true);
    }
  };
  return FirmwareUpdateMetaDataCC2 = _classThis;
})();
let FirmwareUpdateMetaDataCCMetaDataReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.MetaDataReport), (0, import_CommandClassDecorators.ccValueProperty)("firmwareUpgradable", import_CCValues_generated.FirmwareUpdateMetaDataCCValues.firmwareUpgradable), (0, import_CommandClassDecorators.ccValueProperty)("additionalFirmwareIDs", import_CCValues_generated.FirmwareUpdateMetaDataCCValues.additionalFirmwareIDs), (0, import_CommandClassDecorators.ccValueProperty)("continuesToFunction", import_CCValues_generated.FirmwareUpdateMetaDataCCValues.continuesToFunction), (0, import_CommandClassDecorators.ccValueProperty)("supportsActivation", import_CCValues_generated.FirmwareUpdateMetaDataCCValues.supportsActivation), (0, import_CommandClassDecorators.ccValueProperty)("supportsResuming", import_CCValues_generated.FirmwareUpdateMetaDataCCValues.supportsResuming), (0, import_CommandClassDecorators.ccValueProperty)("supportsNonSecureTransfer", import_CCValues_generated.FirmwareUpdateMetaDataCCValues.supportsNonSecureTransfer)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCMetaDataReport2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCMetaDataReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCMetaDataReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.manufacturerId = options.manufacturerId;
      this.firmwareId = options.firmwareId ?? 0;
      this.checksum = options.checksum ?? 0;
      this.firmwareUpgradable = options.firmwareUpgradable;
      this.maxFragmentSize = options.maxFragmentSize;
      this.additionalFirmwareIDs = options.additionalFirmwareIDs ?? [];
      this.hardwareVersion = options.hardwareVersion;
      this.continuesToFunction = options.continuesToFunction;
      this.supportsActivation = options.supportsActivation;
      this.supportsResuming = options.supportsResuming;
      this.supportsNonSecureTransfer = options.supportsNonSecureTransfer;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 6);
      const manufacturerId = raw.payload.readUInt16BE(0);
      const firmwareId = raw.payload.readUInt16BE(2);
      const checksum = raw.payload.readUInt16BE(4);
      const firmwareUpgradable = raw.payload[6] === 255 || raw.payload[6] == void 0;
      let maxFragmentSize;
      let additionalFirmwareIDs;
      let hardwareVersion;
      let continuesToFunction;
      let supportsActivation;
      let supportsResuming;
      let supportsNonSecureTransfer;
      if (raw.payload.length >= 10) {
        maxFragmentSize = raw.payload.readUInt16BE(8);
        const numAdditionalFirmwares = raw.payload[7];
        additionalFirmwareIDs = [];
        (0, import_core.validatePayload)(raw.payload.length >= 10 + 2 * numAdditionalFirmwares);
        for (let i = 0; i < numAdditionalFirmwares; i++) {
          additionalFirmwareIDs.push(raw.payload.readUInt16BE(10 + 2 * i));
        }
        let offset = 10 + 2 * numAdditionalFirmwares;
        if (raw.payload.length >= offset + 1) {
          hardwareVersion = raw.payload[offset];
          offset++;
          if (raw.payload.length >= offset + 1) {
            const capabilities = raw.payload[offset];
            offset++;
            continuesToFunction = !!(capabilities & 1);
            supportsActivation = !!(capabilities & 2);
            supportsResuming = !!(capabilities & 8);
            supportsNonSecureTransfer = !!(capabilities & 4);
          }
        }
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        manufacturerId,
        firmwareId,
        checksum,
        firmwareUpgradable,
        maxFragmentSize,
        additionalFirmwareIDs,
        hardwareVersion,
        continuesToFunction,
        supportsActivation,
        supportsResuming,
        supportsNonSecureTransfer
      });
    }
    manufacturerId;
    firmwareId;
    checksum;
    firmwareUpgradable;
    maxFragmentSize;
    additionalFirmwareIDs = [];
    hardwareVersion;
    continuesToFunction;
    supportsActivation;
    supportsResuming;
    supportsNonSecureTransfer;
    serialize(ctx) {
      this.payload = import_shared.Bytes.alloc(12 + 2 * this.additionalFirmwareIDs.length);
      this.payload.writeUInt16BE(this.manufacturerId, 0);
      this.payload.writeUInt16BE(this.firmwareId, 2);
      this.payload.writeUInt16BE(this.checksum, 4);
      this.payload[6] = this.firmwareUpgradable ? 255 : 0;
      this.payload[7] = this.additionalFirmwareIDs.length;
      this.payload.writeUInt16BE(this.maxFragmentSize ?? 255, 8);
      let offset = 10;
      for (const id of this.additionalFirmwareIDs) {
        this.payload.writeUInt16BE(id, offset);
        offset += 2;
      }
      this.payload[offset++] = this.hardwareVersion ?? 255;
      this.payload[offset++] = (this.continuesToFunction ? 1 : 0) | (this.supportsActivation ? 2 : 0) | (this.supportsNonSecureTransfer ? 4 : 0) | (this.supportsResuming ? 8 : 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "manufacturer id": this.manufacturerId,
        "firmware id": this.firmwareId,
        checksum: this.checksum,
        "firmware upgradable": this.firmwareUpgradable
      };
      if (this.maxFragmentSize != void 0) {
        message["max fragment size"] = this.maxFragmentSize;
      }
      if (this.additionalFirmwareIDs.length) {
        message["additional firmware IDs"] = JSON.stringify(this.additionalFirmwareIDs);
      }
      if (this.hardwareVersion != void 0) {
        message["hardware version"] = this.hardwareVersion;
      }
      if (this.continuesToFunction != void 0) {
        message["continues to function"] = this.continuesToFunction;
      }
      if (this.supportsActivation != void 0) {
        message["supports activation"] = this.supportsActivation;
      }
      if (this.supportsResuming != void 0) {
        message["supports resuming"] = this.supportsResuming;
      }
      if (this.supportsNonSecureTransfer != void 0) {
        message["supports non-secure transfer"] = this.supportsNonSecureTransfer;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return FirmwareUpdateMetaDataCCMetaDataReport2 = _classThis;
})();
let FirmwareUpdateMetaDataCCMetaDataGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.MetaDataGet), (0, import_CommandClassDecorators.expectedCCResponse)(FirmwareUpdateMetaDataCCMetaDataReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCMetaDataGet2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCMetaDataGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCMetaDataGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return FirmwareUpdateMetaDataCCMetaDataGet2 = _classThis;
})();
let FirmwareUpdateMetaDataCCRequestReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.RequestReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCRequestReport2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCRequestReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCRequestReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.status = options.status;
      this.resume = options.resume;
      this.nonSecureTransfer = options.nonSecureTransfer;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const status = raw.payload[0];
      let resume;
      let nonSecureTransfer;
      if (raw.payload.length >= 2) {
        resume = !!(raw.payload[1] & 4);
        nonSecureTransfer = !!(raw.payload[1] & 2);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        status,
        resume,
        nonSecureTransfer
      });
    }
    status;
    resume;
    nonSecureTransfer;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.status,
        (this.resume ? 4 : 0) | (this.nonSecureTransfer ? 2 : 0)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        status: (0, import_shared.getEnumMemberName)(import_Types.FirmwareUpdateRequestStatus, this.status)
      };
      if (this.resume != void 0) {
        message.resume = this.resume;
      }
      if (this.nonSecureTransfer != void 0) {
        message["non-secure transfer"] = this.nonSecureTransfer;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return FirmwareUpdateMetaDataCCRequestReport2 = _classThis;
})();
let FirmwareUpdateMetaDataCCRequestGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.RequestGet), (0, import_CommandClassDecorators.expectedCCResponse)(FirmwareUpdateMetaDataCCRequestReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCRequestGet2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCRequestGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCRequestGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.manufacturerId = options.manufacturerId;
      this.firmwareId = options.firmwareId;
      this.checksum = options.checksum;
      if ("firmwareTarget" in options) {
        this.firmwareTarget = options.firmwareTarget;
        this.fragmentSize = options.fragmentSize;
        this.activation = options.activation ?? false;
        this.hardwareVersion = options.hardwareVersion;
        this.resume = options.resume;
        this.nonSecureTransfer = options.nonSecureTransfer;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 6);
      const manufacturerId = raw.payload.readUInt16BE(0);
      const firmwareId = raw.payload.readUInt16BE(2);
      const checksum = raw.payload.readUInt16BE(4);
      if (raw.payload.length < 9) {
        return new this({
          nodeId: ctx.sourceNodeId,
          manufacturerId,
          firmwareId,
          checksum
        });
      }
      const firmwareTarget = raw.payload[6];
      const fragmentSize = raw.payload.readUInt16BE(7);
      let resume;
      let nonSecureTransfer;
      let activation;
      if (raw.payload.length >= 10) {
        activation = !!(raw.payload[9] & 1);
        nonSecureTransfer = !!(raw.payload[9] & 2);
        resume = !!(raw.payload[9] & 4);
      }
      let hardwareVersion;
      if (raw.payload.length >= 11) {
        hardwareVersion = raw.payload[10];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        manufacturerId,
        firmwareId,
        checksum,
        firmwareTarget,
        fragmentSize,
        activation,
        hardwareVersion,
        resume,
        nonSecureTransfer
      });
    }
    manufacturerId;
    firmwareId;
    checksum;
    firmwareTarget;
    fragmentSize;
    activation;
    hardwareVersion;
    resume;
    nonSecureTransfer;
    serialize(ctx) {
      this.payload = import_shared.Bytes.alloc(10, 0);
      this.payload.writeUInt16BE(this.manufacturerId, 0);
      this.payload.writeUInt16BE(this.firmwareId, 2);
      this.payload.writeUInt16BE(this.checksum, 4);
      this.payload[6] = this.firmwareTarget ?? 0;
      this.payload.writeUInt16BE(this.fragmentSize ?? 32, 7);
      this.payload[9] = (this.activation ? 1 : 0) | (this.nonSecureTransfer ? 2 : 0) | (this.resume ? 4 : 0);
      if (this.hardwareVersion != void 0) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          [this.hardwareVersion]
        ]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "manufacturer id": (0, import_shared.num2hex)(this.manufacturerId),
        "firmware id": (0, import_shared.num2hex)(this.firmwareId),
        checksum: (0, import_shared.num2hex)(this.checksum)
      };
      if (this.firmwareTarget != void 0) {
        message["firmware target"] = this.firmwareTarget;
      }
      if (this.fragmentSize != void 0) {
        message["fragment size"] = this.fragmentSize;
      }
      if (this.activation != void 0) {
        message.activation = this.activation;
      }
      if (this.resume != void 0) {
        message.resume = this.resume;
      }
      if (this.nonSecureTransfer != void 0) {
        message["non-secure transfer"] = this.nonSecureTransfer;
      }
      if (this.hardwareVersion != void 0) {
        message["hardware version"] = this.hardwareVersion;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return FirmwareUpdateMetaDataCCRequestGet2 = _classThis;
})();
let FirmwareUpdateMetaDataCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.Get)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCGet2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.numReports = options.numReports;
      this.reportNumber = options.reportNumber;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const numReports = raw.payload[0];
      const reportNumber = raw.payload.readUInt16BE(1) & 32767;
      return new this({
        nodeId: ctx.sourceNodeId,
        numReports,
        reportNumber
      });
    }
    numReports;
    reportNumber;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(3);
      this.payload[0] = this.numReports;
      this.payload.writeUInt16BE(this.reportNumber & 32767, 1);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "total # of reports": this.numReports,
          "report number": this.reportNumber
        }
      };
    }
  };
  return FirmwareUpdateMetaDataCCGet2 = _classThis;
})();
let FirmwareUpdateMetaDataCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCReport2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.reportNumber = options.reportNumber;
      this.firmwareData = options.firmwareData;
      this.isLast = options.isLast;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    isLast;
    reportNumber;
    firmwareData;
    serialize(ctx) {
      const commandBuffer = import_shared.Bytes.concat([
        new import_shared.Bytes(2),
        // placeholder for report number
        this.firmwareData
      ]);
      commandBuffer.writeUInt16BE(this.reportNumber & 32767 | (this.isLast ? 32768 : 0), 0);
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (ccVersion >= 2) {
        let crc = (0, import_core.CRC16_CCITT)(import_shared.Bytes.from([this.ccId, this.ccCommand]));
        crc = (0, import_core.CRC16_CCITT)(commandBuffer, crc);
        this.payload = import_shared.Bytes.concat([
          commandBuffer,
          new import_shared.Bytes(2)
        ]);
        this.payload.writeUInt16BE(crc, this.payload.length - 2);
      } else {
        this.payload = commandBuffer;
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "report #": this.reportNumber,
          "is last": this.isLast
        }
      };
    }
  };
  return FirmwareUpdateMetaDataCCReport2 = _classThis;
})();
let FirmwareUpdateMetaDataCCStatusReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.StatusReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCStatusReport2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCStatusReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCStatusReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.status = options.status;
      this.waitTime = options.waitTime;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const status = raw.payload[0];
      let waitTime;
      if (raw.payload.length >= 3) {
        waitTime = raw.payload.readUInt16BE(1);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        status,
        waitTime
      });
    }
    status;
    /** The wait time in seconds before the node becomes available for communication after the update */
    waitTime;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(3);
      this.payload[0] = this.status;
      this.payload.writeUInt16BE(this.waitTime ?? 0, 1);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        status: (0, import_shared.getEnumMemberName)(import_Types.FirmwareUpdateStatus, this.status)
      };
      if (this.waitTime != void 0) {
        message["wait time"] = `${this.waitTime} seconds`;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return FirmwareUpdateMetaDataCCStatusReport2 = _classThis;
})();
let FirmwareUpdateMetaDataCCActivationReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.ActivationReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCActivationReport2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCActivationReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCActivationReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.manufacturerId = options.manufacturerId;
      this.firmwareId = options.firmwareId;
      this.checksum = options.checksum;
      this.firmwareTarget = options.firmwareTarget;
      this.activationStatus = options.activationStatus;
      this.hardwareVersion = options.hardwareVersion;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 8);
      const manufacturerId = raw.payload.readUInt16BE(0);
      const firmwareId = raw.payload.readUInt16BE(2);
      const checksum = raw.payload.readUInt16BE(4);
      const firmwareTarget = raw.payload[6];
      const activationStatus = raw.payload[7];
      let hardwareVersion;
      if (raw.payload.length >= 9) {
        hardwareVersion = raw.payload[8];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        manufacturerId,
        firmwareId,
        checksum,
        firmwareTarget,
        activationStatus,
        hardwareVersion
      });
    }
    manufacturerId;
    firmwareId;
    checksum;
    firmwareTarget;
    activationStatus;
    hardwareVersion;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(8);
      this.payload.writeUInt16BE(this.manufacturerId, 0);
      this.payload.writeUInt16BE(this.firmwareId, 2);
      this.payload.writeUInt16BE(this.checksum, 4);
      this.payload[6] = this.firmwareTarget;
      this.payload[7] = this.activationStatus;
      if (this.hardwareVersion != void 0) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          [this.hardwareVersion]
        ]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "manufacturer id": (0, import_shared.num2hex)(this.manufacturerId),
        "firmware id": (0, import_shared.num2hex)(this.firmwareId),
        checksum: (0, import_shared.num2hex)(this.checksum),
        "firmware target": this.firmwareTarget,
        "activation status": (0, import_shared.getEnumMemberName)(import_Types.FirmwareUpdateActivationStatus, this.activationStatus)
      };
      if (this.hardwareVersion != void 0) {
        message.hardwareVersion = this.hardwareVersion;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return FirmwareUpdateMetaDataCCActivationReport2 = _classThis;
})();
let FirmwareUpdateMetaDataCCActivationSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.ActivationSet), (0, import_CommandClassDecorators.expectedCCResponse)(FirmwareUpdateMetaDataCCActivationReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCActivationSet2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCActivationSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCActivationSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.manufacturerId = options.manufacturerId;
      this.firmwareId = options.firmwareId;
      this.checksum = options.checksum;
      this.firmwareTarget = options.firmwareTarget;
      this.hardwareVersion = options.hardwareVersion;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 7);
      const manufacturerId = raw.payload.readUInt16BE(0);
      const firmwareId = raw.payload.readUInt16BE(2);
      const checksum = raw.payload.readUInt16BE(4);
      const firmwareTarget = raw.payload[6];
      let hardwareVersion;
      if (raw.payload.length >= 8) {
        hardwareVersion = raw.payload[7];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        manufacturerId,
        firmwareId,
        checksum,
        firmwareTarget,
        hardwareVersion
      });
    }
    manufacturerId;
    firmwareId;
    checksum;
    firmwareTarget;
    hardwareVersion;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(7);
      this.payload.writeUInt16BE(this.manufacturerId, 0);
      this.payload.writeUInt16BE(this.firmwareId, 2);
      this.payload.writeUInt16BE(this.checksum, 4);
      this.payload[6] = this.firmwareTarget;
      if (this.hardwareVersion != void 0) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          [this.hardwareVersion]
        ]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "manufacturer id": (0, import_shared.num2hex)(this.manufacturerId),
        "firmware id": (0, import_shared.num2hex)(this.firmwareId),
        checksum: (0, import_shared.num2hex)(this.checksum),
        "firmware target": this.firmwareTarget
      };
      if (this.hardwareVersion != void 0) {
        message["hardware version"] = this.hardwareVersion;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return FirmwareUpdateMetaDataCCActivationSet2 = _classThis;
})();
let FirmwareUpdateMetaDataCCPrepareReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.PrepareReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCPrepareReport2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCPrepareReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCPrepareReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.status = options.status;
      this.checksum = options.checksum;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const status = raw.payload[0];
      const checksum = raw.payload.readUInt16BE(1);
      return new this({
        nodeId: ctx.sourceNodeId,
        status,
        checksum
      });
    }
    status;
    checksum;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(3);
      this.payload[0] = this.status;
      this.payload.writeUInt16BE(this.checksum, 1);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          status: (0, import_shared.getEnumMemberName)(import_Types.FirmwareDownloadStatus, this.status),
          checksum: (0, import_shared.num2hex)(this.checksum)
        }
      };
    }
  };
  return FirmwareUpdateMetaDataCCPrepareReport2 = _classThis;
})();
let FirmwareUpdateMetaDataCCPrepareGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.FirmwareUpdateMetaDataCommand.PrepareGet), (0, import_CommandClassDecorators.expectedCCResponse)(FirmwareUpdateMetaDataCCPrepareReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateMetaDataCC;
  var FirmwareUpdateMetaDataCCPrepareGet2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateMetaDataCCPrepareGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateMetaDataCCPrepareGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.manufacturerId = options.manufacturerId;
      this.firmwareId = options.firmwareId;
      this.firmwareTarget = options.firmwareTarget;
      this.fragmentSize = options.fragmentSize;
      this.hardwareVersion = options.hardwareVersion;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 8);
      const manufacturerId = raw.payload.readUInt16BE(0);
      const firmwareId = raw.payload.readUInt16BE(2);
      const firmwareTarget = raw.payload[4];
      const fragmentSize = raw.payload.readUInt16BE(5);
      const hardwareVersion = raw.payload[7];
      return new this({
        nodeId: ctx.sourceNodeId,
        manufacturerId,
        firmwareId,
        firmwareTarget,
        fragmentSize,
        hardwareVersion
      });
    }
    manufacturerId;
    firmwareId;
    firmwareTarget;
    fragmentSize;
    hardwareVersion;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(8);
      this.payload.writeUInt16BE(this.manufacturerId, 0);
      this.payload.writeUInt16BE(this.firmwareId, 2);
      this.payload[4] = this.firmwareTarget;
      this.payload.writeUInt16BE(this.fragmentSize, 5);
      this.payload[7] = this.hardwareVersion;
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "manufacturer id": (0, import_shared.num2hex)(this.manufacturerId),
          "firmware id": (0, import_shared.num2hex)(this.firmwareId),
          "firmware target": this.firmwareTarget,
          "fragment size": this.fragmentSize,
          "hardware version": this.hardwareVersion
        }
      };
    }
  };
  return FirmwareUpdateMetaDataCCPrepareGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  FirmwareUpdateMetaDataCC,
  FirmwareUpdateMetaDataCCAPI,
  FirmwareUpdateMetaDataCCActivationReport,
  FirmwareUpdateMetaDataCCActivationSet,
  FirmwareUpdateMetaDataCCGet,
  FirmwareUpdateMetaDataCCMetaDataGet,
  FirmwareUpdateMetaDataCCMetaDataReport,
  FirmwareUpdateMetaDataCCPrepareGet,
  FirmwareUpdateMetaDataCCPrepareReport,
  FirmwareUpdateMetaDataCCReport,
  FirmwareUpdateMetaDataCCRequestGet,
  FirmwareUpdateMetaDataCCRequestReport,
  FirmwareUpdateMetaDataCCStatusReport,
  FirmwareUpdateMetaDataCCValues
});
//# sourceMappingURL=FirmwareUpdateMetaDataCC.js.map
