"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultiChannelAssociationCC_exports = {};
__export(MultiChannelAssociationCC_exports, {
  MultiChannelAssociationCC: () => MultiChannelAssociationCC,
  MultiChannelAssociationCCAPI: () => MultiChannelAssociationCCAPI,
  MultiChannelAssociationCCGet: () => MultiChannelAssociationCCGet,
  MultiChannelAssociationCCRemove: () => MultiChannelAssociationCCRemove,
  MultiChannelAssociationCCReport: () => MultiChannelAssociationCCReport,
  MultiChannelAssociationCCSet: () => MultiChannelAssociationCCSet,
  MultiChannelAssociationCCSupportedGroupingsGet: () => MultiChannelAssociationCCSupportedGroupingsGet,
  MultiChannelAssociationCCSupportedGroupingsReport: () => MultiChannelAssociationCCSupportedGroupingsReport,
  MultiChannelAssociationCCValues: () => import_CCValues_generated.MultiChannelAssociationCCValues
});
module.exports = __toCommonJS(MultiChannelAssociationCC_exports);
var __validateArgs = __toESM(require("./MultiChannelAssociationCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var ccUtils = __toESM(require("../lib/utils.js"), 1);
var import_AssociationCC = require("./AssociationCC.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_MultiChannelAssociationCCAPI_reportGroupCount, validateArgs_MultiChannelAssociationCCAPI_getGroup, validateArgs_MultiChannelAssociationCCAPI_sendReport, validateArgs_MultiChannelAssociationCCAPI_addDestinations, validateArgs_MultiChannelAssociationCCAPI_removeDestinations } = __validateArgs;
function endpointAddressesToString(endpoints) {
  return endpoints.map(({ nodeId, endpoint }) => {
    if (typeof endpoint === "number") {
      return `${nodeId}:${endpoint}`;
    } else {
      return `${nodeId}:[${endpoint.map(String).join(", ")}]`;
    }
  }).join(", ");
}
__name(endpointAddressesToString, "endpointAddressesToString");
const MULTI_CHANNEL_ASSOCIATION_MARKER = 0;
function serializeMultiChannelAssociationDestination(nodeIds, endpoints) {
  const nodeAddressBytes = nodeIds.length;
  const endpointAddressBytes = endpoints.length * 2;
  const payload = new import_shared.Bytes(
    // node addresses
    nodeAddressBytes + (endpointAddressBytes > 0 ? 1 : 0) + endpointAddressBytes
  );
  for (let i = 0; i < nodeIds.length; i++) {
    payload[i] = nodeIds[i];
  }
  if (endpointAddressBytes > 0) {
    let offset = nodeIds.length;
    payload[offset] = MULTI_CHANNEL_ASSOCIATION_MARKER;
    offset += 1;
    for (let i = 0; i < endpoints.length; i++) {
      const endpoint = endpoints[i];
      const destination = typeof endpoint.endpoint === "number" ? endpoint.endpoint & 127 : (0, import_core.encodeBitMask)(endpoint.endpoint, 7)[0] | 128;
      payload[offset + 2 * i] = endpoint.nodeId;
      payload[offset + 2 * i + 1] = destination;
    }
  }
  return payload;
}
__name(serializeMultiChannelAssociationDestination, "serializeMultiChannelAssociationDestination");
function deserializeMultiChannelAssociationDestination(data) {
  const nodeIds = [];
  let endpointOffset = data.length;
  for (let i = 0; i < data.length; i++) {
    if (data[i] === MULTI_CHANNEL_ASSOCIATION_MARKER) {
      endpointOffset = i + 1;
      break;
    }
    nodeIds.push(data[i]);
  }
  const endpoints = [];
  for (let i = endpointOffset; i < data.length; i += 2) {
    const nodeId = data[i];
    const isBitMask = !!(data[i + 1] & 128);
    const destination = data[i + 1] & 127;
    const endpoint = isBitMask ? (0, import_core.parseBitMask)(import_shared.Bytes.from([destination])) : destination;
    endpoints.push({ nodeId, endpoint });
  }
  return { nodeIds, endpoints };
}
__name(deserializeMultiChannelAssociationDestination, "deserializeMultiChannelAssociationDestination");
let MultiChannelAssociationCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Multi Channel Association"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _reportGroupCount_decorators;
  let _getGroup_decorators;
  let _sendReport_decorators;
  let _addDestinations_decorators;
  let _removeDestinations_decorators;
  var MultiChannelAssociationCCAPI2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelAssociationCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _reportGroupCount_decorators = [validateArgs_MultiChannelAssociationCCAPI_reportGroupCount()];
      _getGroup_decorators = [validateArgs_MultiChannelAssociationCCAPI_getGroup()];
      _sendReport_decorators = [validateArgs_MultiChannelAssociationCCAPI_sendReport()];
      _addDestinations_decorators = [validateArgs_MultiChannelAssociationCCAPI_addDestinations()];
      _removeDestinations_decorators = [validateArgs_MultiChannelAssociationCCAPI_removeDestinations()];
      __esDecorate(this, null, _reportGroupCount_decorators, { kind: "method", name: "reportGroupCount", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportGroupCount" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportGroupCount, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getGroup_decorators, { kind: "method", name: "getGroup", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getGroup" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getGroup, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _sendReport_decorators, { kind: "method", name: "sendReport", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendReport" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendReport, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _addDestinations_decorators, { kind: "method", name: "addDestinations", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "addDestinations" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.addDestinations, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _removeDestinations_decorators, { kind: "method", name: "removeDestinations", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "removeDestinations" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.removeDestinations, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelAssociationCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.MultiChannelAssociationCommand.Get:
        case import_Types.MultiChannelAssociationCommand.Set:
        case import_Types.MultiChannelAssociationCommand.Report:
        case import_Types.MultiChannelAssociationCommand.Remove:
        case import_Types.MultiChannelAssociationCommand.SupportedGroupingsGet:
        case import_Types.MultiChannelAssociationCommand.SupportedGroupingsReport:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    /**
     * Returns the number of association groups a node supports.
     * Association groups are consecutive, starting at 1.
     */
    async getGroupCount() {
      this.assertSupportsCommand(import_Types.MultiChannelAssociationCommand, import_Types.MultiChannelAssociationCommand.SupportedGroupingsGet);
      const cc = new MultiChannelAssociationCCSupportedGroupingsGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.groupCount;
    }
    async reportGroupCount(groupCount) {
      this.assertSupportsCommand(import_Types.MultiChannelAssociationCommand, import_Types.MultiChannelAssociationCommand.SupportedGroupingsReport);
      const cc = new MultiChannelAssociationCCSupportedGroupingsReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupCount
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Returns information about an association group.
     */
    async getGroup(groupId) {
      this.assertSupportsCommand(import_Types.MultiChannelAssociationCommand, import_Types.MultiChannelAssociationCommand.Get);
      const cc = new MultiChannelAssociationCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        groupId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["maxNodes", "nodeIds", "endpoints"]);
      }
    }
    async sendReport(options) {
      this.assertSupportsCommand(import_Types.MultiChannelAssociationCommand, import_Types.MultiChannelAssociationCommand.Report);
      const cc = new MultiChannelAssociationCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Adds new nodes or endpoints to an association group
     */
    async addDestinations(options) {
      this.assertSupportsCommand(import_Types.MultiChannelAssociationCommand, import_Types.MultiChannelAssociationCommand.Set);
      const cc = new MultiChannelAssociationCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Removes nodes or endpoints from an association group
     */
    async removeDestinations(options) {
      this.assertSupportsCommand(import_Types.MultiChannelAssociationCommand, import_Types.MultiChannelAssociationCommand.Remove);
      if (!options.groupId && this.version === 1) {
        const currentDestinations = MultiChannelAssociationCC.getAllDestinationsCached(this.host, this.endpoint);
        for (const [group, destinations] of currentDestinations) {
          const cc = new MultiChannelAssociationCCRemove({
            nodeId: this.endpoint.nodeId,
            endpointIndex: this.endpoint.index,
            groupId: group,
            nodeIds: destinations.filter((d) => d.endpoint != void 0).map((d) => d.nodeId),
            endpoints: destinations.filter((d) => d.endpoint != void 0)
          });
          await this.host.sendCommand(cc, this.commandOptions);
        }
      } else if (options.groupId && options.groupId < 0) {
        throw new import_core.ZWaveError("The group id must not be negative!", import_core.ZWaveErrorCodes.Argument_Invalid);
      } else {
        const cc = new MultiChannelAssociationCCRemove({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          ...options
        });
        return this.host.sendCommand(cc, this.commandOptions);
      }
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return MultiChannelAssociationCCAPI2 = _classThis;
})();
let MultiChannelAssociationCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Multi Channel Association"]), (0, import_CommandClassDecorators.implementedVersion)(5), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.MultiChannelAssociationCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var MultiChannelAssociationCC2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelAssociationCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelAssociationCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    determineRequiredCCInterviews() {
      return [
        ...super.determineRequiredCCInterviews(),
        import_core.CommandClasses["Z-Wave Plus Info"],
        // We need information about endpoints to correctly configure the lifeline associations
        import_core.CommandClasses["Multi Channel"],
        // AssociationCC will short-circuit if this CC is supported
        import_core.CommandClasses.Association
      ];
    }
    /**
     * Returns the number of association groups reported by the node/endpoint.
     * This only works AFTER the interview process
     */
    static getGroupCountCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.MultiChannelAssociationCCValues.groupCount.endpoint(endpoint.index)) || 0;
    }
    /**
     * Returns the number of nodes an association group supports.
     * This only works AFTER the interview process
     */
    static getMaxNodesCached(ctx, endpoint, groupId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.MultiChannelAssociationCCValues.maxNodes(groupId).endpoint(endpoint.index)) ?? 0;
    }
    /**
     * Returns all the destinations of all association groups reported by the node/endpoint.
     * This only works AFTER the interview process
     */
    static getAllDestinationsCached(ctx, endpoint) {
      const ret = /* @__PURE__ */ new Map();
      const groupCount = this.getGroupCountCached(ctx, endpoint);
      const valueDB = ctx.getValueDB(endpoint.nodeId);
      for (let i = 1; i <= groupCount; i++) {
        const groupDestinations = [];
        const nodes = valueDB.getValue(import_CCValues_generated.MultiChannelAssociationCCValues.nodeIds(i).endpoint(endpoint.index)) ?? [];
        groupDestinations.push(...nodes.map((nodeId) => ({ nodeId })));
        const endpoints = valueDB.getValue(import_CCValues_generated.MultiChannelAssociationCCValues.endpoints(i).endpoint(endpoint.index)) ?? [];
        for (const ep of endpoints) {
          if (typeof ep.endpoint === "number") {
            groupDestinations.push({
              nodeId: ep.nodeId,
              endpoint: ep.endpoint
            });
          } else {
            groupDestinations.push(...ep.endpoint.map((e) => ({
              nodeId: ep.nodeId,
              endpoint: e
            })));
          }
        }
        ret.set(
          i,
          // Filter out duplicates
          groupDestinations.filter((addr, index) => index === groupDestinations.findIndex(({ nodeId, endpoint: endpoint2 }) => nodeId === addr.nodeId && endpoint2 === addr.endpoint))
        );
      }
      return ret;
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const mcAPI = import_API.CCAPI.create(import_core.CommandClasses["Multi Channel Association"], ctx, endpoint);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying number of multi channel association groups...",
        direction: "outbound"
      });
      const mcGroupCount = await mcAPI.getGroupCount();
      if (mcGroupCount != void 0) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `supports ${mcGroupCount} multi channel association groups`,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying multi channel association groups timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      await this.refreshValues(ctx);
      await ccUtils.configureLifelineAssociations(ctx, endpoint);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const mcAPI = import_API.CCAPI.create(import_core.CommandClasses["Multi Channel Association"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const assocAPI = import_API.CCAPI.create(import_core.CommandClasses.Association, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const mcGroupCount = this.getValue(ctx, import_CCValues_generated.MultiChannelAssociationCCValues.groupCount) ?? 0;
      const assocGroupCount = this.getValue(ctx, import_AssociationCC.AssociationCCValues.groupCount) || mcGroupCount;
      for (let groupId = 1; groupId <= mcGroupCount; groupId++) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying multi channel association group #${groupId}...`,
          direction: "outbound"
        });
        const group = await mcAPI.getGroup(groupId);
        if (!group)
          continue;
        const logMessage = `received information for multi channel association group #${groupId}:
maximum # of nodes:           ${group.maxNodes}
currently assigned nodes:     ${group.nodeIds.map(String).join(", ")}
currently assigned endpoints: ${group.endpoints.map(({ nodeId, endpoint: endpoint2 }) => {
          if (typeof endpoint2 === "number") {
            return `${nodeId}:${endpoint2}`;
          } else {
            return `${nodeId}:[${endpoint2.map(String).join(", ")}]`;
          }
        }).join("")}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
      if (assocAPI.isSupported() && assocGroupCount > mcGroupCount) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying additional non-multi-channel association groups...`,
          direction: "outbound"
        });
        for (let groupId = mcGroupCount + 1; groupId <= assocGroupCount; groupId++) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `querying association group #${groupId}...`,
            direction: "outbound"
          });
          const group = await assocAPI.getGroup(groupId);
          if (!group)
            continue;
          const logMessage = `received information for association group #${groupId}:
maximum # of nodes:           ${group.maxNodes}
currently assigned nodes:     ${group.nodeIds.map(String).join(", ")}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
    }
  };
  return MultiChannelAssociationCC2 = _classThis;
})();
let MultiChannelAssociationCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelAssociationCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelAssociationCC;
  var MultiChannelAssociationCCSet2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelAssociationCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelAssociationCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.groupId < 1) {
        throw new import_core.ZWaveError("The group id must be positive!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.groupId = options.groupId;
      this.nodeIds = "nodeIds" in options && options.nodeIds || [];
      if (this.nodeIds.some((n) => n < 1 || n > import_core.MAX_NODES)) {
        throw new import_core.ZWaveError(`All node IDs must be between 1 and ${import_core.MAX_NODES}!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.endpoints = "endpoints" in options && options.endpoints || [];
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const groupId = raw.payload[0];
      const { nodeIds, endpoints } = deserializeMultiChannelAssociationDestination(raw.payload.subarray(1));
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId,
        nodeIds,
        endpoints
      });
    }
    groupId;
    nodeIds;
    endpoints;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.groupId]),
        serializeMultiChannelAssociationDestination(this.nodeIds, this.endpoints)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "group id": this.groupId,
          "node ids": this.nodeIds.join(", "),
          endpoints: endpointAddressesToString(this.endpoints)
        }
      };
    }
  };
  return MultiChannelAssociationCCSet2 = _classThis;
})();
let MultiChannelAssociationCCRemove = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelAssociationCommand.Remove), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelAssociationCC;
  var MultiChannelAssociationCCRemove2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelAssociationCCRemove");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelAssociationCCRemove2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupId = options.groupId;
      this.nodeIds = options.nodeIds;
      this.endpoints = options.endpoints;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const groupId = raw.payload[0];
      const { nodeIds, endpoints } = deserializeMultiChannelAssociationDestination(raw.payload.subarray(1));
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId,
        nodeIds,
        endpoints
      });
    }
    groupId;
    nodeIds;
    endpoints;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.groupId || 0]),
        serializeMultiChannelAssociationDestination(this.nodeIds || [], this.endpoints || [])
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "group id": this.groupId || "(all groups)"
      };
      if (this.nodeIds) {
        message["node ids"] = this.nodeIds.join(", ");
      }
      if (this.endpoints) {
        message.endpoints = endpointAddressesToString(this.endpoints);
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return MultiChannelAssociationCCRemove2 = _classThis;
})();
let MultiChannelAssociationCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelAssociationCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("maxNodes", import_CCValues_generated.MultiChannelAssociationCCValues.maxNodes, (self) => [self.groupId]), (0, import_CommandClassDecorators.ccValueProperty)("nodeIds", import_CCValues_generated.MultiChannelAssociationCCValues.nodeIds, (self) => [self.groupId]), (0, import_CommandClassDecorators.ccValueProperty)("endpoints", import_CCValues_generated.MultiChannelAssociationCCValues.endpoints, (self) => [self.groupId])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelAssociationCC;
  var MultiChannelAssociationCCReport2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelAssociationCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelAssociationCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupId = options.groupId;
      this.maxNodes = options.maxNodes;
      this.nodeIds = options.nodeIds;
      this.endpoints = options.endpoints;
      this.reportsToFollow = options.reportsToFollow;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const groupId = raw.payload[0];
      const maxNodes = raw.payload[1];
      const reportsToFollow = raw.payload[2];
      const { nodeIds, endpoints } = deserializeMultiChannelAssociationDestination(raw.payload.subarray(3));
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId,
        maxNodes,
        nodeIds,
        endpoints,
        reportsToFollow
      });
    }
    groupId;
    maxNodes;
    nodeIds;
    endpoints;
    reportsToFollow;
    getPartialCCSessionId() {
      return { groupId: this.groupId };
    }
    expectMoreMessages() {
      return this.reportsToFollow > 0;
    }
    mergePartialCCs(partials, _ctx) {
      this.nodeIds = [...partials, this].map((report) => [...report.nodeIds]).reduce((prev, cur) => prev.concat(...cur), []);
      this.endpoints = [...partials, this].map((report) => [...report.endpoints]).reduce((prev, cur) => prev.concat(...cur), []);
      return Promise.resolve();
    }
    serialize(ctx) {
      const destinations = serializeMultiChannelAssociationDestination(this.nodeIds, this.endpoints);
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([
          this.groupId,
          this.maxNodes,
          this.reportsToFollow
        ]),
        destinations
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "group id": this.groupId,
          "maximum # of nodes": this.maxNodes,
          "node ids": this.nodeIds.join(", "),
          endpoints: endpointAddressesToString(this.endpoints)
        }
      };
    }
  };
  return MultiChannelAssociationCCReport2 = _classThis;
})();
let MultiChannelAssociationCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelAssociationCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(MultiChannelAssociationCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelAssociationCC;
  var MultiChannelAssociationCCGet2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelAssociationCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelAssociationCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.groupId < 1) {
        throw new import_core.ZWaveError("The group id must be positive!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.groupId = options.groupId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const groupId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        groupId
      });
    }
    groupId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.groupId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "group id": this.groupId }
      };
    }
  };
  return MultiChannelAssociationCCGet2 = _classThis;
})();
let MultiChannelAssociationCCSupportedGroupingsReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelAssociationCommand.SupportedGroupingsReport), (0, import_CommandClassDecorators.ccValueProperty)("groupCount", import_CCValues_generated.MultiChannelAssociationCCValues.groupCount)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelAssociationCC;
  var MultiChannelAssociationCCSupportedGroupingsReport2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelAssociationCCSupportedGroupingsReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelAssociationCCSupportedGroupingsReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.groupCount = options.groupCount;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const groupCount = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        groupCount
      });
    }
    groupCount;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.groupCount]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "group count": this.groupCount }
      };
    }
  };
  return MultiChannelAssociationCCSupportedGroupingsReport2 = _classThis;
})();
let MultiChannelAssociationCCSupportedGroupingsGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelAssociationCommand.SupportedGroupingsGet), (0, import_CommandClassDecorators.expectedCCResponse)(MultiChannelAssociationCCSupportedGroupingsReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelAssociationCC;
  var MultiChannelAssociationCCSupportedGroupingsGet2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelAssociationCCSupportedGroupingsGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelAssociationCCSupportedGroupingsGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return MultiChannelAssociationCCSupportedGroupingsGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MultiChannelAssociationCC,
  MultiChannelAssociationCCAPI,
  MultiChannelAssociationCCGet,
  MultiChannelAssociationCCRemove,
  MultiChannelAssociationCCReport,
  MultiChannelAssociationCCSet,
  MultiChannelAssociationCCSupportedGroupingsGet,
  MultiChannelAssociationCCSupportedGroupingsReport,
  MultiChannelAssociationCCValues
});
//# sourceMappingURL=MultiChannelAssociationCC.js.map
