"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultiCommandCC_exports = {};
__export(MultiCommandCC_exports, {
  MultiCommandCC: () => MultiCommandCC,
  MultiCommandCCAPI: () => MultiCommandCCAPI,
  MultiCommandCCCommandEncapsulation: () => MultiCommandCCCommandEncapsulation
});
module.exports = __toCommonJS(MultiCommandCC_exports);
var __validateArgs = __toESM(require("./MultiCommandCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_MultiCommandCCAPI_send } = __validateArgs;
let MultiCommandCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Multi Command"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _send_decorators;
  var MultiCommandCCAPI2 = class extends _classSuper {
    static {
      __name(this, "MultiCommandCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _send_decorators = [validateArgs_MultiCommandCCAPI_send()];
      __esDecorate(this, null, _send_decorators, { kind: "method", name: "send", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "send" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.send, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiCommandCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(_cmd) {
      return true;
    }
    async send(commands) {
      this.assertSupportsCommand(import_Types.MultiCommandCommand, import_Types.MultiCommandCommand.CommandEncapsulation);
      const cc = new MultiCommandCCCommandEncapsulation({
        nodeId: this.endpoint.nodeId,
        encapsulated: commands
      });
      cc.endpointIndex = this.endpoint.index;
      await this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return MultiCommandCCAPI2 = _classThis;
})();
let MultiCommandCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Multi Command"]), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var MultiCommandCC2 = class extends _classSuper {
    static {
      __name(this, "MultiCommandCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiCommandCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    /** Tests if a command targets a specific endpoint and thus requires encapsulation */
    static requiresEncapsulation(cc) {
      return cc.endpointIndex !== 0 && !(cc instanceof MultiCommandCCCommandEncapsulation);
    }
    static encapsulate(CCs) {
      const ret = new MultiCommandCCCommandEncapsulation({
        nodeId: CCs[0].nodeId,
        encapsulated: CCs
      });
      for (const flag of [
        import_core.EncapsulationFlags.Supervision,
        import_core.EncapsulationFlags.Security,
        import_core.EncapsulationFlags.CRC16
      ]) {
        ret.toggleEncapsulationFlag(flag, CCs.some((cc) => cc.encapsulationFlags & flag));
      }
      return ret;
    }
  };
  return MultiCommandCC2 = _classThis;
})();
let MultiCommandCCCommandEncapsulation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiCommandCommand.CommandEncapsulation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiCommandCC;
  var MultiCommandCCCommandEncapsulation2 = class extends _classSuper {
    static {
      __name(this, "MultiCommandCCCommandEncapsulation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiCommandCCCommandEncapsulation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.encapsulated = options.encapsulated;
      for (const cc of options.encapsulated) {
        cc.encapsulatingCC = this;
        cc.endpointIndex = this.endpointIndex;
      }
    }
    static async from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const numCommands = raw.payload[0];
      const encapsulated = [];
      let offset = 1;
      for (let i = 0; i < numCommands; i++) {
        (0, import_core.validatePayload)(raw.payload.length >= offset + 1);
        const cmdLength = raw.payload[offset];
        (0, import_core.validatePayload)(raw.payload.length >= offset + 1 + cmdLength);
        encapsulated.push(await import_CommandClass.CommandClass.parse(raw.payload.subarray(offset + 1, offset + 1 + cmdLength), ctx));
        offset += 1 + cmdLength;
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        encapsulated
      });
    }
    encapsulated;
    async serialize(ctx) {
      const buffers = [];
      buffers.push(import_shared.Bytes.from([this.encapsulated.length]));
      for (const cmd of this.encapsulated) {
        const cmdBuffer = await cmd.serialize(ctx);
        buffers.push(import_shared.Bytes.from([cmdBuffer.length]));
        buffers.push(cmdBuffer);
      }
      this.payload = import_shared.Bytes.concat(buffers);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        // Hide the default payload line
        message: void 0
      };
    }
  };
  return MultiCommandCCCommandEncapsulation2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MultiCommandCC,
  MultiCommandCCAPI,
  MultiCommandCCCommandEncapsulation
});
//# sourceMappingURL=MultiCommandCC.js.map
