"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultilevelSensorCC_exports = {};
__export(MultilevelSensorCC_exports, {
  MultilevelSensorCC: () => MultilevelSensorCC,
  MultilevelSensorCCAPI: () => MultilevelSensorCCAPI,
  MultilevelSensorCCGet: () => MultilevelSensorCCGet,
  MultilevelSensorCCGetSupportedScale: () => MultilevelSensorCCGetSupportedScale,
  MultilevelSensorCCGetSupportedSensor: () => MultilevelSensorCCGetSupportedSensor,
  MultilevelSensorCCReport: () => MultilevelSensorCCReport,
  MultilevelSensorCCSupportedScaleReport: () => MultilevelSensorCCSupportedScaleReport,
  MultilevelSensorCCSupportedSensorReport: () => MultilevelSensorCCSupportedSensorReport,
  MultilevelSensorCCValues: () => import_CCValues_generated.MultilevelSensorCCValues
});
module.exports = __toCommonJS(MultilevelSensorCC_exports);
var __validateArgs = __toESM(require("./MultilevelSensorCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_MultilevelSensorCCAPI_get, validateArgs_MultilevelSensorCCAPI_getSupportedScales, validateArgs_MultilevelSensorCCAPI_sendReport } = __validateArgs;
function getPreferredSensorScale(ctx, nodeId, endpointIndex, sensorType, supportedScales) {
  const preferences = ctx.getUserPreferences();
  const sensor = (0, import_core.getSensor)(sensorType);
  if (!sensor) {
    const preferred2 = preferences?.scales[sensorType];
    if (typeof preferred2 !== "number")
      return 0;
    return preferred2;
  }
  let preferred;
  preferred = preferences?.scales[sensorType];
  const scaleGroupName = sensor.scaleGroupName;
  if (preferred == void 0 && scaleGroupName) {
    preferred = preferences?.scales[scaleGroupName];
  }
  if (preferred == void 0) {
    const sensorName = (0, import_core.getSensorName)(sensorType);
    const sensorValue = import_CCValues_generated.MultilevelSensorCCValues.value(sensorName);
    const metadata = ctx.tryGetValueDB(nodeId)?.getMetadata(sensorValue.endpoint(endpointIndex));
    const scale = metadata?.ccSpecific?.scale;
    if (typeof scale === "number" && supportedScales.includes(scale)) {
      preferred = scale;
      ctx.logNode(nodeId, {
        endpoint: endpointIndex,
        message: `No scale preference for sensor type ${sensorType}, using the last-used scale ${preferred}`
      });
    }
  }
  if (preferred == void 0) {
    preferred = supportedScales[0] ?? 0;
    ctx.logNode(nodeId, {
      endpoint: endpointIndex,
      message: `No scale preference for sensor type ${sensorType}, using the first supported scale ${preferred}`
    });
    return preferred;
  }
  if (typeof preferred === "string") {
    for (const [key, scale] of Object.entries(sensor.scales)) {
      if (scale.label === preferred || scale.unit === preferred) {
        preferred = parseInt(key, 10);
        break;
      }
    }
  }
  if (typeof preferred === "string") {
    ctx.logNode(nodeId, {
      endpoint: endpointIndex,
      message: `Preferred scale "${preferred}" for sensor type ${sensorType} not found, using the first supported scale ${supportedScales[0] ?? 0}`
    });
    return supportedScales[0] ?? 0;
  }
  if (!supportedScales.length) {
    return preferred;
  } else if (!supportedScales.includes(preferred)) {
    ctx.logNode(nodeId, {
      endpoint: endpointIndex,
      message: `Preferred scale ${preferred} not supported for sensor type ${sensorType}, using the first supported scale`
    });
    return supportedScales[0];
  } else {
    return preferred;
  }
}
__name(getPreferredSensorScale, "getPreferredSensorScale");
let MultilevelSensorCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Multilevel Sensor"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  let _getSupportedScales_decorators;
  let _sendReport_decorators;
  var MultilevelSensorCCAPI2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSensorCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_MultilevelSensorCCAPI_get()];
      _getSupportedScales_decorators = [validateArgs_MultilevelSensorCCAPI_getSupportedScales()];
      _sendReport_decorators = [validateArgs_MultilevelSensorCCAPI_sendReport()];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getSupportedScales_decorators, { kind: "method", name: "getSupportedScales", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getSupportedScales" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getSupportedScales, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _sendReport_decorators, { kind: "method", name: "sendReport", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendReport" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendReport, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSensorCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.MultilevelSensorCommand.Get:
        case import_Types.MultilevelSensorCommand.Report:
          return true;
        // This is mandatory
        case import_Types.MultilevelSensorCommand.GetSupportedSensor:
        case import_Types.MultilevelSensorCommand.GetSupportedScale:
          return this.version >= 5;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        const valueId = {
          commandClass: import_core.CommandClasses["Multilevel Sensor"],
          endpoint: this.endpoint.index,
          property
        };
        const ccSpecific = this.tryGetValueDB()?.getMetadata(valueId)?.ccSpecific;
        if (!ccSpecific) {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        const { sensorType, scale } = ccSpecific;
        return this.get(sensorType, scale);
      };
    }
    async get(sensorType, scale) {
      this.assertSupportsCommand(import_Types.MultilevelSensorCommand, import_Types.MultilevelSensorCommand.Get);
      let preferredScale;
      if (sensorType != void 0 && scale == void 0) {
        const supportedScales = this.tryGetValueDB()?.getValue({
          commandClass: this.ccId,
          endpoint: this.endpoint.index,
          property: "supportedScales",
          propertyKey: sensorType
        }) ?? [];
        preferredScale = getPreferredSensorScale(this.host, this.endpoint.nodeId, this.endpoint.index, sensorType, supportedScales);
      }
      const cc = new MultilevelSensorCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        sensorType,
        scale: scale ?? preferredScale
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (!response)
        return;
      const responseScale = (0, import_core.getSensorScale)(response.type, response.scale);
      if (sensorType == void 0) {
        return {
          type: response.type,
          value: response.value,
          scale: responseScale
        };
      } else if (scale == void 0) {
        return {
          value: response.value,
          scale: responseScale
        };
      } else {
        return response.value;
      }
    }
    async getSupportedSensorTypes() {
      this.assertSupportsCommand(import_Types.MultilevelSensorCommand, import_Types.MultilevelSensorCommand.GetSupportedSensor);
      const cc = new MultilevelSensorCCGetSupportedSensor({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedSensorTypes;
    }
    async getSupportedScales(sensorType) {
      this.assertSupportsCommand(import_Types.MultilevelSensorCommand, import_Types.MultilevelSensorCommand.GetSupportedScale);
      const cc = new MultilevelSensorCCGetSupportedScale({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        sensorType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedScales;
    }
    async sendReport(sensorType, scale, value) {
      this.assertSupportsCommand(import_Types.MultilevelSensorCommand, import_Types.MultilevelSensorCommand.Report);
      const cc = new MultilevelSensorCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        type: sensorType,
        scale,
        value
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return MultilevelSensorCCAPI2 = _classThis;
})();
let MultilevelSensorCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Multilevel Sensor"]), (0, import_CommandClassDecorators.implementedVersion)(11), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.MultilevelSensorCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var MultilevelSensorCC2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSensorCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSensorCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Multilevel Sensor"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      if (api.version >= 5) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "retrieving supported sensor types...",
          direction: "outbound"
        });
        const sensorTypes = await api.getSupportedSensorTypes();
        if (sensorTypes) {
          const logMessage = "received supported sensor types:\n" + sensorTypes.map((t) => (0, import_core.getSensorName)(t)).map((name) => `\xB7 ${name}`).join("\n");
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        } else {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "Querying supported sensor types timed out, skipping interview...",
            level: "warn"
          });
          return;
        }
        for (const type of sensorTypes) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `querying supported scales for ${(0, import_core.getSensorName)(type)} sensor`,
            direction: "outbound"
          });
          const sensorScales = await api.getSupportedScales(type);
          if (sensorScales) {
            const logMessage = "received supported scales:\n" + sensorScales.map((s) => ((0, import_core.getSensorScale)(type, s) ?? (0, import_core.getUnknownScale)(s)).label).map((name) => `\xB7 ${name}`).join("\n");
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: logMessage,
              direction: "inbound"
            });
          } else {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: "Querying supported scales timed out, skipping interview...",
              level: "warn"
            });
            return;
          }
        }
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Multilevel Sensor"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const valueDB = this.getValueDB(ctx);
      if (api.version <= 4) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "querying current sensor reading...",
          direction: "outbound"
        });
        const mlsResponse = await api.get();
        if (mlsResponse) {
          const sensorScale = (0, import_core.getSensorScale)(mlsResponse.type, mlsResponse.scale.key);
          const logMessage = `received current sensor reading:
sensor type: ${(0, import_core.getSensorName)(mlsResponse.type)}
value:       ${mlsResponse.value}${sensorScale?.unit ? ` ${sensorScale.unit}` : ""}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      } else {
        const sensorTypes = valueDB.getValue({
          commandClass: this.ccId,
          property: "supportedSensorTypes",
          endpoint: this.endpointIndex
        }) || [];
        for (const type of sensorTypes) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `querying ${(0, import_core.getSensorName)(type)} sensor reading...`,
            direction: "outbound"
          });
          const value = await api.get(type);
          if (value) {
            const logMessage = `received current ${(0, import_core.getSensorName)(type)} sensor reading: ${value.value} ${value.scale.unit || ""}`;
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: logMessage,
              direction: "inbound"
            });
          }
        }
      }
    }
    shouldRefreshValues(ctx) {
      const valueDB = ctx.tryGetValueDB(this.nodeId);
      if (!valueDB)
        return true;
      const values = this.getDefinedValueIDs(ctx).filter((v) => import_CCValues_generated.MultilevelSensorCCValues.value.is(v));
      return values.every((v) => {
        const lastUpdated = valueDB.getTimestamp(v);
        return lastUpdated == void 0 || Date.now() - lastUpdated > import_core.timespan.hours(6);
      });
    }
    /**
     * Returns which sensor types are supported.
     * This only works AFTER the interview process
     */
    static getSupportedSensorTypesCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.MultilevelSensorCCValues.supportedSensorTypes.endpoint(endpoint.index));
    }
    /**
     * Returns which scales are supported for a given sensor type.
     * This only works AFTER the interview process
     */
    static getSupportedScalesCached(ctx, endpoint, sensorType) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.MultilevelSensorCCValues.supportedScales(sensorType).endpoint(endpoint.index));
    }
    translatePropertyKey(ctx, property, propertyKey) {
      if (property === "values" && typeof propertyKey === "number") {
        const sensor = (0, import_core.getSensor)(propertyKey);
        if (sensor)
          return sensor.label;
      }
      return super.translatePropertyKey(ctx, property, propertyKey);
    }
  };
  return MultilevelSensorCC2 = _classThis;
})();
let MultilevelSensorCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSensorCommand.Report), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSensorCC;
  var MultilevelSensorCCReport2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSensorCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSensorCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.type = options.type;
      this.value = options.value;
      this.scale = typeof options.scale === "number" ? options.scale : options.scale.key;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const type = raw.payload[0];
      const { value, scale } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1));
      return new this({
        nodeId: ctx.sourceNodeId,
        type,
        value,
        scale
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const sensor = (0, import_core.getSensor)(this.type);
      const scale = (0, import_core.getSensorScale)(this.type, this.scale) ?? (0, import_core.getUnknownScale)(this.scale);
      const measurementValidation = !ctx.getDeviceConfig?.(this.nodeId)?.compat?.disableStrictMeasurementValidation;
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (measurementValidation) {
        if (ccVersion >= 5) {
          const supportedSensorTypes = this.getValue(ctx, import_CCValues_generated.MultilevelSensorCCValues.supportedSensorTypes);
          if (supportedSensorTypes?.length) {
            import_core.validatePayload.withReason(`Unsupported sensor type ${(0, import_core.getSensorName)(this.type)} or corrupted data`)(supportedSensorTypes.includes(this.type));
          }
          const supportedScales = this.getValue(ctx, import_CCValues_generated.MultilevelSensorCCValues.supportedScales(this.type));
          if (supportedScales?.length) {
            import_core.validatePayload.withReason(`Unsupported scale ${scale.label} or corrupted data`)(supportedScales.includes(scale.key));
          }
        } else {
          import_core.validatePayload.withReason(`Unknown sensor type ${(0, import_shared.num2hex)(this.type)} or corrupted data`)(!!sensor);
          import_core.validatePayload.withReason(`Unknown scale ${(0, import_shared.num2hex)(this.scale)} or corrupted data`)(scale.label !== (0, import_core.getUnknownScale)(this.scale).label);
        }
      }
      const sensorName = (0, import_core.getSensorName)(this.type);
      const sensorValue = import_CCValues_generated.MultilevelSensorCCValues.value(sensorName);
      this.setMetadata(ctx, sensorValue, {
        ...sensorValue.meta,
        unit: scale.unit,
        ccSpecific: {
          sensorType: this.type,
          scale: scale.key
        }
      });
      this.setValue(ctx, sensorValue, this.value);
      return true;
    }
    type;
    scale;
    value;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.type]),
        (0, import_core.encodeFloatWithScale)(this.value, this.scale)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "sensor type": (0, import_core.getSensorName)(this.type),
          scale: ((0, import_core.getSensorScale)(this.type, this.scale) ?? (0, import_core.getUnknownScale)(this.scale)).label,
          value: this.value
        }
      };
    }
  };
  return MultilevelSensorCCReport2 = _classThis;
})();
const testResponseForMultilevelSensorGet = /* @__PURE__ */ __name((sent, received) => {
  return sent.sensorType == void 0 || received.type === sent.sensorType;
}, "testResponseForMultilevelSensorGet");
let MultilevelSensorCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSensorCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(MultilevelSensorCCReport, testResponseForMultilevelSensorGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSensorCC;
  var MultilevelSensorCCGet2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSensorCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSensorCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ("sensorType" in options) {
        this.sensorType = options.sensorType;
        this.scale = options.scale;
      }
    }
    static from(raw, ctx) {
      if (raw.payload.length >= 2) {
        const sensorType = raw.payload[0];
        const scale = raw.payload[1] >> 3 & 3;
        return new this({
          nodeId: ctx.sourceNodeId,
          sensorType,
          scale
        });
      } else {
        return new this({
          nodeId: ctx.sourceNodeId
        });
      }
    }
    sensorType;
    scale;
    serialize(ctx) {
      if (this.sensorType != void 0 && this.scale != void 0) {
        this.payload = import_shared.Bytes.from([
          this.sensorType,
          (this.scale & 3) << 3
        ]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      let message = {};
      if (this.sensorType != void 0 && this.scale != void 0) {
        message = {
          "sensor type": (0, import_core.getSensorName)(this.sensorType),
          scale: ((0, import_core.getSensorScale)(this.sensorType, this.scale) ?? (0, import_core.getUnknownScale)(this.scale)).label
        };
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return MultilevelSensorCCGet2 = _classThis;
})();
let MultilevelSensorCCSupportedSensorReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSensorCommand.SupportedSensorReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedSensorTypes", import_CCValues_generated.MultilevelSensorCCValues.supportedSensorTypes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSensorCC;
  var MultilevelSensorCCSupportedSensorReport2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSensorCCSupportedSensorReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSensorCCSupportedSensorReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedSensorTypes = options.supportedSensorTypes;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const supportedSensorTypes = (0, import_core.parseBitMask)(raw.payload);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedSensorTypes
      });
    }
    // TODO: Use this during interview to precreate values
    supportedSensorTypes;
    serialize(ctx) {
      this.payload = (0, import_core.encodeBitMask)(this.supportedSensorTypes);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported sensor types": this.supportedSensorTypes.map((t) => `
\xB7 ${(0, import_core.getSensorName)(t)}`).join("")
        }
      };
    }
  };
  return MultilevelSensorCCSupportedSensorReport2 = _classThis;
})();
let MultilevelSensorCCGetSupportedSensor = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSensorCommand.GetSupportedSensor), (0, import_CommandClassDecorators.expectedCCResponse)(MultilevelSensorCCSupportedSensorReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSensorCC;
  var MultilevelSensorCCGetSupportedSensor2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSensorCCGetSupportedSensor");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSensorCCGetSupportedSensor2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return MultilevelSensorCCGetSupportedSensor2 = _classThis;
})();
let MultilevelSensorCCSupportedScaleReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSensorCommand.SupportedScaleReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedScales", import_CCValues_generated.MultilevelSensorCCValues.supportedScales, (self) => [self.sensorType])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSensorCC;
  var MultilevelSensorCCSupportedScaleReport2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSensorCCSupportedScaleReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSensorCCSupportedScaleReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sensorType = options.sensorType;
      this.supportedScales = options.supportedScales;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const sensorType = raw.payload[0];
      const supportedScales = (0, import_core.parseBitMask)(import_shared.Bytes.from([raw.payload[1] & 15]), 0);
      return new this({
        nodeId: ctx.sourceNodeId,
        sensorType,
        supportedScales
      });
    }
    sensorType;
    supportedScales;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.sensorType]),
        (0, import_core.encodeBitMask)(this.supportedScales, 4, 0)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "sensor type": (0, import_core.getSensorName)(this.sensorType),
          "supported scales": this.supportedScales.map((s) => `
\xB7 ${((0, import_core.getSensorScale)(this.sensorType, s) ?? (0, import_core.getUnknownScale)(s)).label}`).join("")
        }
      };
    }
  };
  return MultilevelSensorCCSupportedScaleReport2 = _classThis;
})();
let MultilevelSensorCCGetSupportedScale = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSensorCommand.GetSupportedScale), (0, import_CommandClassDecorators.expectedCCResponse)(MultilevelSensorCCSupportedScaleReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSensorCC;
  var MultilevelSensorCCGetSupportedScale2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSensorCCGetSupportedScale");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSensorCCGetSupportedScale2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sensorType = options.sensorType;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const sensorType = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        sensorType
      });
    }
    sensorType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.sensorType]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "sensor type": (0, import_core.getSensorName)(this.sensorType)
        }
      };
    }
  };
  return MultilevelSensorCCGetSupportedScale2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MultilevelSensorCC,
  MultilevelSensorCCAPI,
  MultilevelSensorCCGet,
  MultilevelSensorCCGetSupportedScale,
  MultilevelSensorCCGetSupportedSensor,
  MultilevelSensorCCReport,
  MultilevelSensorCCSupportedScaleReport,
  MultilevelSensorCCSupportedSensorReport,
  MultilevelSensorCCValues
});
//# sourceMappingURL=MultilevelSensorCC.js.map
