"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ThermostatFanModeCC_exports = {};
__export(ThermostatFanModeCC_exports, {
  ThermostatFanModeCC: () => ThermostatFanModeCC,
  ThermostatFanModeCCAPI: () => ThermostatFanModeCCAPI,
  ThermostatFanModeCCGet: () => ThermostatFanModeCCGet,
  ThermostatFanModeCCReport: () => ThermostatFanModeCCReport,
  ThermostatFanModeCCSet: () => ThermostatFanModeCCSet,
  ThermostatFanModeCCSupportedGet: () => ThermostatFanModeCCSupportedGet,
  ThermostatFanModeCCSupportedReport: () => ThermostatFanModeCCSupportedReport,
  ThermostatFanModeCCValues: () => import_CCValues_generated.ThermostatFanModeCCValues
});
module.exports = __toCommonJS(ThermostatFanModeCC_exports);
var __validateArgs = __toESM(require("./ThermostatFanModeCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ThermostatFanModeCCAPI_set } = __validateArgs;
let ThermostatFanModeCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Thermostat Fan Mode"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  var ThermostatFanModeCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ThermostatFanModeCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_ThermostatFanModeCCAPI_set({ strictEnums: true })];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatFanModeCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ThermostatFanModeCommand.Get:
        case import_Types.ThermostatFanModeCommand.SupportedGet:
          return this.isSinglecast();
        case import_Types.ThermostatFanModeCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        const valueDB = this.getValueDB();
        let result;
        if (property === "mode") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          const off = valueDB.getValue(import_CCValues_generated.ThermostatFanModeCCValues.turnedOff.endpoint(this.endpoint.index));
          result = await this.set(value, off);
        } else if (property === "off") {
          if (typeof value !== "boolean") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "boolean", typeof value);
          }
          const mode = valueDB.getValue(import_CCValues_generated.ThermostatFanModeCCValues.fanMode.endpoint(this.endpoint.index));
          if (mode == void 0) {
            throw new import_core.ZWaveError(`The "off" property cannot be changed before the fan mode is known!`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
          result = await this.set(mode, value);
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
          this.schedulePoll({ property }, value);
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "mode":
          case "off":
            return (await this.get())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.ThermostatFanModeCommand, import_Types.ThermostatFanModeCommand.Get);
      const cc = new ThermostatFanModeCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["mode", "off"]);
      }
    }
    async set(mode, off) {
      this.assertSupportsCommand(import_Types.ThermostatFanModeCommand, import_Types.ThermostatFanModeCommand.Set);
      const cc = new ThermostatFanModeCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        mode,
        off
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getSupportedModes() {
      this.assertSupportsCommand(import_Types.ThermostatFanModeCommand, import_Types.ThermostatFanModeCommand.SupportedGet);
      const cc = new ThermostatFanModeCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedModes;
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ThermostatFanModeCCAPI2 = _classThis;
})();
let ThermostatFanModeCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Thermostat Fan Mode"]), (0, import_CommandClassDecorators.implementedVersion)(5), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ThermostatFanModeCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ThermostatFanModeCC2 = class extends _classSuper {
    static {
      __name(this, "ThermostatFanModeCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatFanModeCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Thermostat Fan Mode"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying supported thermostat fan modes...",
        direction: "outbound"
      });
      const supportedModes = await api.getSupportedModes();
      if (supportedModes) {
        const logMessage = `received supported thermostat fan modes:${supportedModes.map((mode) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.ThermostatFanMode, mode)}`).join("")}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying supported thermostat fan modes timed out, skipping interview..."
        });
        return;
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Thermostat Fan Mode"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying current thermostat fan mode...",
        direction: "outbound"
      });
      const currentStatus = await api.get();
      if (currentStatus) {
        let logMessage = `received current thermostat fan mode: ${(0, import_shared.getEnumMemberName)(import_Types.ThermostatFanMode, currentStatus.mode)}`;
        if (currentStatus.off != void 0) {
          logMessage += ` (turned off)`;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
    }
  };
  return ThermostatFanModeCC2 = _classThis;
})();
let ThermostatFanModeCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatFanModeCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatFanModeCC;
  var ThermostatFanModeCCSet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatFanModeCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatFanModeCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.mode = options.mode;
      this.off = options.off;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    mode;
    off;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        (this.off ? 128 : 0) | this.mode & 15
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        mode: (0, import_shared.getEnumMemberName)(import_Types.ThermostatFanMode, this.mode)
      };
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ThermostatFanModeCCSet2 = _classThis;
})();
let ThermostatFanModeCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatFanModeCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("mode", import_CCValues_generated.ThermostatFanModeCCValues.fanMode), (0, import_CommandClassDecorators.ccValueProperty)("off", import_CCValues_generated.ThermostatFanModeCCValues.turnedOff)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatFanModeCC;
  var ThermostatFanModeCCReport2 = class extends _classSuper {
    static {
      __name(this, "ThermostatFanModeCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatFanModeCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.mode = options.mode;
      this.off = options.off;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const mode = raw.payload[0] & 15;
      const off = !!(raw.payload[0] & 128);
      return new this({
        nodeId: ctx.sourceNodeId,
        mode,
        off
      });
    }
    mode;
    off;
    toLogEntry(ctx) {
      const message = {
        mode: (0, import_shared.getEnumMemberName)(import_Types.ThermostatFanMode, this.mode)
      };
      if (this.off != void 0) {
        message.off = this.off;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ThermostatFanModeCCReport2 = _classThis;
})();
let ThermostatFanModeCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatFanModeCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ThermostatFanModeCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatFanModeCC;
  var ThermostatFanModeCCGet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatFanModeCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatFanModeCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ThermostatFanModeCCGet2 = _classThis;
})();
let ThermostatFanModeCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatFanModeCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedModes", import_CCValues_generated.ThermostatFanModeCCValues.supportedFanModes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatFanModeCC;
  var ThermostatFanModeCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "ThermostatFanModeCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatFanModeCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedModes = options.supportedModes;
    }
    static from(raw, ctx) {
      const supportedModes = (0, import_core.parseBitMask)(raw.payload, import_Types.ThermostatFanMode["Auto low"]);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedModes
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const fanModeValue = import_CCValues_generated.ThermostatFanModeCCValues.fanMode;
      this.setMetadata(ctx, fanModeValue, {
        ...fanModeValue.meta,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.ThermostatFanMode, this.supportedModes)
      });
      return true;
    }
    supportedModes;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported modes": this.supportedModes.map((mode) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.ThermostatFanMode, mode)}`).join("")
        }
      };
    }
  };
  return ThermostatFanModeCCSupportedReport2 = _classThis;
})();
let ThermostatFanModeCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatFanModeCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(ThermostatFanModeCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatFanModeCC;
  var ThermostatFanModeCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatFanModeCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatFanModeCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ThermostatFanModeCCSupportedGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ThermostatFanModeCC,
  ThermostatFanModeCCAPI,
  ThermostatFanModeCCGet,
  ThermostatFanModeCCReport,
  ThermostatFanModeCCSet,
  ThermostatFanModeCCSupportedGet,
  ThermostatFanModeCCSupportedReport,
  ThermostatFanModeCCValues
});
//# sourceMappingURL=ThermostatFanModeCC.js.map
