"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TransportServiceCC_exports = {};
__export(TransportServiceCC_exports, {
  MAX_SEGMENT_SIZE: () => MAX_SEGMENT_SIZE,
  RELAXED_TIMING_THRESHOLD: () => RELAXED_TIMING_THRESHOLD,
  TransportServiceCC: () => TransportServiceCC,
  TransportServiceCCFirstSegment: () => TransportServiceCCFirstSegment,
  TransportServiceCCSegmentComplete: () => TransportServiceCCSegmentComplete,
  TransportServiceCCSegmentRequest: () => TransportServiceCCSegmentRequest,
  TransportServiceCCSegmentWait: () => TransportServiceCCSegmentWait,
  TransportServiceCCSubsequentSegment: () => TransportServiceCCSubsequentSegment,
  TransportServiceTimeouts: () => TransportServiceTimeouts,
  isTransportServiceEncapsulation: () => isTransportServiceEncapsulation
});
module.exports = __toCommonJS(TransportServiceCC_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const MAX_SEGMENT_SIZE = 39;
const RELAXED_TIMING_THRESHOLD = 2;
const TransportServiceTimeouts = {
  /** Waiting time before requesting a missing segment at data rate R2 */
  requestMissingSegmentR2: 800,
  /** Waiting time before requesting a missing segment at data rate R3 */
  requestMissingSegmentR3: 400,
  /** Waiting time before sending another datagram at data rate R2 */
  segmentCompleteR2: 1e3,
  /** Waiting time before sending another datagram at data rate R3 */
  segmentCompleteR3: 500,
  /** Waiting time between segments when sending more than {@link RELAXED_TIMING_THRESHOLD} segments at data rate R2 */
  relaxedTimingDelayR2: 35,
  /** Waiting time between segments when sending more than {@link RELAXED_TIMING_THRESHOLD} segments at data rate R3 */
  relaxedTimingDelayR3: 15
};
let TransportServiceCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Transport Service"]), (0, import_CommandClassDecorators.implementedVersion)(2)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var TransportServiceCC2 = class extends _classSuper {
    static {
      __name(this, "TransportServiceCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TransportServiceCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return TransportServiceCC2 = _classThis;
})();
function isTransportServiceEncapsulation(command) {
  return command.ccId === import_core.CommandClasses["Transport Service"] && (command.ccCommand === import_Types.TransportServiceCommand.FirstSegment || command.ccCommand === import_Types.TransportServiceCommand.SubsequentSegment);
}
__name(isTransportServiceEncapsulation, "isTransportServiceEncapsulation");
let TransportServiceCCFirstSegment = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TransportServiceCommand.FirstSegment)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TransportServiceCC;
  var TransportServiceCCFirstSegment2 = class extends _classSuper {
    static {
      __name(this, "TransportServiceCCFirstSegment");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TransportServiceCCFirstSegment2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.datagramSize = options.datagramSize;
      this.sessionId = options.sessionId;
      this.headerExtension = options.headerExtension;
      this.partialDatagram = options.partialDatagram;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 6);
      const headerBuffer = import_shared.Bytes.from([
        import_core.CommandClasses["Transport Service"],
        import_Types.TransportServiceCommand.FirstSegment | raw.payload[0]
      ]);
      const ccBuffer = raw.payload.subarray(1, -2);
      let expectedCRC = (0, import_core.CRC16_CCITT)(headerBuffer);
      expectedCRC = (0, import_core.CRC16_CCITT)(ccBuffer, expectedCRC);
      const actualCRC = raw.payload.readUInt16BE(raw.payload.length - 2);
      (0, import_core.validatePayload)(expectedCRC === actualCRC);
      const datagramSize = raw.payload.readUInt16BE(0);
      const sessionId = raw.payload[2] >>> 4;
      let payloadOffset = 3;
      const hasHeaderExtension = !!(raw.payload[2] & 8);
      let headerExtension;
      if (hasHeaderExtension) {
        const extLength = raw.payload[3];
        headerExtension = raw.payload.subarray(4, 4 + extLength);
        payloadOffset += 1 + extLength;
      }
      const partialDatagram = raw.payload.subarray(payloadOffset, -2);
      (0, import_core.validatePayload)(partialDatagram.length <= MAX_SEGMENT_SIZE);
      return new this({
        nodeId: ctx.sourceNodeId,
        datagramSize,
        sessionId,
        headerExtension,
        partialDatagram
      });
    }
    datagramSize;
    sessionId;
    headerExtension;
    partialDatagram;
    encapsulated;
    serialize(ctx) {
      this.ccCommand = this.ccCommand & 248 | this.datagramSize >>> 8 & 7;
      const ext = !!this.headerExtension && this.headerExtension.length >= 1;
      this.payload = import_shared.Bytes.from([
        this.datagramSize & 255,
        (this.sessionId & 15) << 4 | (ext ? 8 : 0)
      ]);
      if (ext) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          import_shared.Bytes.from([this.headerExtension.length]),
          this.headerExtension
        ]);
      }
      this.payload = import_shared.Bytes.concat([
        this.payload,
        this.partialDatagram,
        import_shared.Bytes.alloc(2, 0)
        // checksum
      ]);
      const headerBuffer = import_shared.Bytes.from([this.ccId, this.ccCommand]);
      let crc = (0, import_core.CRC16_CCITT)(headerBuffer);
      crc = (0, import_core.CRC16_CCITT)(this.payload.subarray(0, -2), crc);
      this.payload.writeUInt16BE(crc, this.payload.length - 2);
      return super.serialize(ctx);
    }
    expectMoreMessages() {
      return true;
    }
    getPartialCCSessionId() {
      return { ccCommand: void 0, sessionId: this.sessionId };
    }
    computeEncapsulationOverhead() {
      return super.computeEncapsulationOverhead() + 4 + (this.headerExtension?.length ? 1 + this.headerExtension.length : 0);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "session ID": this.sessionId,
          "datagram size": this.datagramSize,
          "byte range": `0...${this.partialDatagram.length - 1}`,
          payload: (0, import_shared.buffer2hex)(this.partialDatagram)
        }
      };
    }
  };
  return TransportServiceCCFirstSegment2 = _classThis;
})();
let TransportServiceCCSubsequentSegment = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TransportServiceCommand.SubsequentSegment)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TransportServiceCC;
  var TransportServiceCCSubsequentSegment2 = class extends _classSuper {
    static {
      __name(this, "TransportServiceCCSubsequentSegment");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TransportServiceCCSubsequentSegment2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.datagramSize = options.datagramSize;
      this.datagramOffset = options.datagramOffset;
      this.sessionId = options.sessionId;
      this.headerExtension = options.headerExtension;
      this.partialDatagram = options.partialDatagram;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 7);
      const headerBuffer = import_shared.Bytes.from([
        import_core.CommandClasses["Transport Service"],
        import_Types.TransportServiceCommand.SubsequentSegment | raw.payload[0]
      ]);
      const ccBuffer = raw.payload.subarray(1, -2);
      let expectedCRC = (0, import_core.CRC16_CCITT)(headerBuffer);
      expectedCRC = (0, import_core.CRC16_CCITT)(ccBuffer, expectedCRC);
      const actualCRC = raw.payload.readUInt16BE(raw.payload.length - 2);
      (0, import_core.validatePayload)(expectedCRC === actualCRC);
      const datagramSize = raw.payload.readUInt16BE(0);
      const sessionId = raw.payload[2] >>> 4;
      const datagramOffset = ((raw.payload[2] & 7) << 8) + raw.payload[3];
      let payloadOffset = 4;
      const hasHeaderExtension = !!(raw.payload[2] & 8);
      let headerExtension;
      if (hasHeaderExtension) {
        const extLength = raw.payload[4];
        headerExtension = raw.payload.subarray(5, 5 + extLength);
        payloadOffset += 1 + extLength;
      }
      const partialDatagram = raw.payload.subarray(payloadOffset, -2);
      (0, import_core.validatePayload)(partialDatagram.length <= MAX_SEGMENT_SIZE);
      return new this({
        nodeId: ctx.sourceNodeId,
        datagramSize,
        sessionId,
        datagramOffset,
        headerExtension,
        partialDatagram
      });
    }
    datagramSize;
    datagramOffset;
    sessionId;
    headerExtension;
    partialDatagram;
    // This can only be received
    _encapsulated;
    get encapsulated() {
      return this._encapsulated;
    }
    expectMoreMessages(session) {
      if (!(session[0] instanceof TransportServiceCCFirstSegment)) {
        return true;
      }
      const datagramSize = session[0].datagramSize;
      const receivedBytes = new Array(datagramSize).fill(false);
      for (const segment of [...session, this]) {
        const offset = segment instanceof TransportServiceCCFirstSegment ? 0 : segment.datagramOffset;
        for (let i = offset; i <= offset + segment.partialDatagram.length; i++) {
          receivedBytes[i] = true;
        }
      }
      return receivedBytes.includes(false);
    }
    getPartialCCSessionId() {
      return { ccCommand: void 0, sessionId: this.sessionId };
    }
    async mergePartialCCs(partials, ctx) {
      const datagram = new import_shared.Bytes(this.datagramSize);
      for (const partial of [...partials, this]) {
        const offset = partial instanceof TransportServiceCCFirstSegment ? 0 : partial.datagramOffset;
        if (offset + partial.partialDatagram.length > datagram.length) {
          throw new import_core.ZWaveError(`The partial datagram offset and length in a segment are not compatible to the communicated datagram length`, import_core.ZWaveErrorCodes.PacketFormat_InvalidPayload);
        }
        datagram.set(partial.partialDatagram, offset);
      }
      this._encapsulated = await import_CommandClass.CommandClass.parse(datagram, ctx);
      this._encapsulated.encapsulatingCC = this;
    }
    serialize(ctx) {
      this.ccCommand = this.ccCommand & 248 | this.datagramSize >>> 8 & 7;
      const ext = !!this.headerExtension && this.headerExtension.length >= 1;
      this.payload = import_shared.Bytes.from([
        this.datagramSize & 255,
        (this.sessionId & 15) << 4 | (ext ? 8 : 0) | this.datagramOffset >>> 8 & 7,
        this.datagramOffset & 255
      ]);
      if (ext) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          import_shared.Bytes.from([this.headerExtension.length]),
          this.headerExtension
        ]);
      }
      this.payload = import_shared.Bytes.concat([
        this.payload,
        this.partialDatagram,
        import_shared.Bytes.alloc(2, 0)
        // checksum
      ]);
      const headerBuffer = import_shared.Bytes.from([this.ccId, this.ccCommand]);
      let crc = (0, import_core.CRC16_CCITT)(headerBuffer);
      crc = (0, import_core.CRC16_CCITT)(this.payload.subarray(0, -2), crc);
      this.payload.writeUInt16BE(crc, this.payload.length - 2);
      return super.serialize(ctx);
    }
    computeEncapsulationOverhead() {
      return super.computeEncapsulationOverhead() + 5 + (this.headerExtension?.length ? 1 + this.headerExtension.length : 0);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "session ID": this.sessionId,
          "datagram size": this.datagramSize,
          "byte range": `${this.datagramOffset}...${this.datagramOffset + this.partialDatagram.length - 1}`,
          payload: (0, import_shared.buffer2hex)(this.partialDatagram)
        }
      };
    }
  };
  return TransportServiceCCSubsequentSegment2 = _classThis;
})();
let TransportServiceCCSegmentRequest = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TransportServiceCommand.SegmentRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TransportServiceCC;
  var TransportServiceCCSegmentRequest2 = class extends _classSuper {
    static {
      __name(this, "TransportServiceCCSegmentRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TransportServiceCCSegmentRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sessionId = options.sessionId;
      this.datagramOffset = options.datagramOffset;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const sessionId = raw.payload[1] >>> 4;
      const datagramOffset = ((raw.payload[1] & 7) << 8) + raw.payload[2];
      return new this({
        nodeId: ctx.sourceNodeId,
        sessionId,
        datagramOffset
      });
    }
    sessionId;
    datagramOffset;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        (this.sessionId & 15) << 4 | this.datagramOffset >>> 8 & 7,
        this.datagramOffset & 255
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "session ID": this.sessionId,
          offset: this.datagramOffset
        }
      };
    }
  };
  return TransportServiceCCSegmentRequest2 = _classThis;
})();
let TransportServiceCCSegmentComplete = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TransportServiceCommand.SegmentComplete)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TransportServiceCC;
  var TransportServiceCCSegmentComplete2 = class extends _classSuper {
    static {
      __name(this, "TransportServiceCCSegmentComplete");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TransportServiceCCSegmentComplete2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sessionId = options.sessionId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const sessionId = raw.payload[1] >>> 4;
      return new this({
        nodeId: ctx.sourceNodeId,
        sessionId
      });
    }
    sessionId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([(this.sessionId & 15) << 4]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "session ID": this.sessionId }
      };
    }
  };
  return TransportServiceCCSegmentComplete2 = _classThis;
})();
let TransportServiceCCSegmentWait = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TransportServiceCommand.SegmentWait)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TransportServiceCC;
  var TransportServiceCCSegmentWait2 = class extends _classSuper {
    static {
      __name(this, "TransportServiceCCSegmentWait");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TransportServiceCCSegmentWait2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.pendingSegments = options.pendingSegments;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const pendingSegments = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        pendingSegments
      });
    }
    pendingSegments;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.pendingSegments]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "pending segments": this.pendingSegments }
      };
    }
  };
  return TransportServiceCCSegmentWait2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MAX_SEGMENT_SIZE,
  RELAXED_TIMING_THRESHOLD,
  TransportServiceCC,
  TransportServiceCCFirstSegment,
  TransportServiceCCSegmentComplete,
  TransportServiceCCSegmentRequest,
  TransportServiceCCSegmentWait,
  TransportServiceCCSubsequentSegment,
  TransportServiceTimeouts,
  isTransportServiceEncapsulation
});
//# sourceMappingURL=TransportServiceCC.js.map
