"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var UserCodeCC_exports = {};
__export(UserCodeCC_exports, {
  UserCodeCC: () => UserCodeCC,
  UserCodeCCAPI: () => UserCodeCCAPI,
  UserCodeCCAdminCodeGet: () => UserCodeCCAdminCodeGet,
  UserCodeCCAdminCodeReport: () => UserCodeCCAdminCodeReport,
  UserCodeCCAdminCodeSet: () => UserCodeCCAdminCodeSet,
  UserCodeCCCapabilitiesGet: () => UserCodeCCCapabilitiesGet,
  UserCodeCCCapabilitiesReport: () => UserCodeCCCapabilitiesReport,
  UserCodeCCExtendedUserCodeGet: () => UserCodeCCExtendedUserCodeGet,
  UserCodeCCExtendedUserCodeReport: () => UserCodeCCExtendedUserCodeReport,
  UserCodeCCExtendedUserCodeSet: () => UserCodeCCExtendedUserCodeSet,
  UserCodeCCGet: () => UserCodeCCGet,
  UserCodeCCKeypadModeGet: () => UserCodeCCKeypadModeGet,
  UserCodeCCKeypadModeReport: () => UserCodeCCKeypadModeReport,
  UserCodeCCKeypadModeSet: () => UserCodeCCKeypadModeSet,
  UserCodeCCReport: () => UserCodeCCReport,
  UserCodeCCSet: () => UserCodeCCSet,
  UserCodeCCUserCodeChecksumGet: () => UserCodeCCUserCodeChecksumGet,
  UserCodeCCUserCodeChecksumReport: () => UserCodeCCUserCodeChecksumReport,
  UserCodeCCUsersNumberGet: () => UserCodeCCUsersNumberGet,
  UserCodeCCUsersNumberReport: () => UserCodeCCUsersNumberReport,
  UserCodeCCValues: () => import_CCValues_generated.UserCodeCCValues,
  userCodeToLogString: () => userCodeToLogString
});
module.exports = __toCommonJS(UserCodeCC_exports);
var __validateArgs = __toESM(require("./UserCodeCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_UserCodeCCAPI_get, validateArgs_UserCodeCCAPI_set, validateArgs_UserCodeCCAPI_setMany, validateArgs_UserCodeCCAPI_clear, validateArgs_UserCodeCCAPI_setKeypadMode, validateArgs_UserCodeCCAPI_setAdminCode } = __validateArgs;
function parseExtendedUserCode(payload) {
  (0, import_core.validatePayload)(payload.length >= 4);
  const userId = payload.readUInt16BE(0);
  const status = payload[2];
  const codeLength = payload[3] & 15;
  (0, import_core.validatePayload)(payload.length >= 4 + codeLength);
  const code = payload.subarray(4, 4 + codeLength).toString("ascii");
  return {
    code: {
      userId,
      userIdStatus: status,
      userCode: code
    },
    bytesRead: 4 + codeLength
  };
}
__name(parseExtendedUserCode, "parseExtendedUserCode");
function validateCode(code, supportedChars) {
  if (code.length < 4 || code.length > 10)
    return false;
  return [...code].every((char) => supportedChars.includes(char));
}
__name(validateCode, "validateCode");
function setUserCodeMetadata(ctx, userId, userCode) {
  const statusValue = import_CCValues_generated.UserCodeCCValues.userIdStatus(userId);
  const codeValue = import_CCValues_generated.UserCodeCCValues.userCode(userId);
  const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
  const supportedUserIDStatuses = this.getValue(ctx, import_CCValues_generated.UserCodeCCValues.supportedUserIDStatuses) ?? (ccVersion === 1 ? [
    import_Types.UserIDStatus.Available,
    import_Types.UserIDStatus.Enabled,
    import_Types.UserIDStatus.Disabled
  ] : [
    import_Types.UserIDStatus.Available,
    import_Types.UserIDStatus.Enabled,
    import_Types.UserIDStatus.Disabled,
    import_Types.UserIDStatus.Messaging,
    import_Types.UserIDStatus.PassageMode
  ]);
  this.ensureMetadata(ctx, statusValue, {
    ...statusValue.meta,
    states: (0, import_core.enumValuesToMetadataStates)(import_Types.UserIDStatus, supportedUserIDStatuses)
  });
  const codeMetadata = {
    ...(0, import_shared.isUint8Array)(userCode) ? import_core.ValueMetadata.Buffer : import_core.ValueMetadata.String,
    minLength: 4,
    maxLength: 10,
    label: `User Code (${userId})`
  };
  if (this.getMetadata(ctx, codeValue)?.type !== codeMetadata.type) {
    this.setMetadata(ctx, codeValue, codeMetadata);
  }
}
__name(setUserCodeMetadata, "setUserCodeMetadata");
function persistUserCode(ctx, userId, userIdStatus, userCode) {
  const statusValue = import_CCValues_generated.UserCodeCCValues.userIdStatus(userId);
  const codeValue = import_CCValues_generated.UserCodeCCValues.userCode(userId);
  if (userIdStatus === import_Types.UserIDStatus.StatusNotAvailable) {
    this.removeValue(ctx, statusValue);
    this.removeValue(ctx, codeValue);
    this.removeMetadata(ctx, statusValue);
    this.removeMetadata(ctx, codeValue);
  } else {
    setUserCodeMetadata.call(this, ctx, userId, userCode);
    this.setValue(ctx, statusValue, userIdStatus);
    this.setValue(ctx, codeValue, userCode);
  }
  return true;
}
__name(persistUserCode, "persistUserCode");
function userCodeToLogString(userCode) {
  if (userCode.length === 0)
    return "(empty)";
  return "*".repeat(userCode.length);
}
__name(userCodeToLogString, "userCodeToLogString");
let UserCodeCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["User Code"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  let _set_decorators;
  let _setMany_decorators;
  let _clear_decorators;
  let _setKeypadMode_decorators;
  let _setAdminCode_decorators;
  var UserCodeCCAPI2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_UserCodeCCAPI_get()];
      _set_decorators = [validateArgs_UserCodeCCAPI_set()];
      _setMany_decorators = [validateArgs_UserCodeCCAPI_setMany()];
      _clear_decorators = [validateArgs_UserCodeCCAPI_clear()];
      _setKeypadMode_decorators = [validateArgs_UserCodeCCAPI_setKeypadMode({ strictEnums: true })];
      _setAdminCode_decorators = [validateArgs_UserCodeCCAPI_setAdminCode()];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setMany_decorators, { kind: "method", name: "setMany", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setMany" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setMany, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _clear_decorators, { kind: "method", name: "clear", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "clear" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.clear, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setKeypadMode_decorators, { kind: "method", name: "setKeypadMode", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setKeypadMode" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setKeypadMode, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setAdminCode_decorators, { kind: "method", name: "setAdminCode", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setAdminCode" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setAdminCode, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.UserCodeCommand.Get:
        case import_Types.UserCodeCommand.Set:
        case import_Types.UserCodeCommand.UsersNumberGet:
          return true;
        // This is mandatory
        case import_Types.UserCodeCommand.CapabilitiesGet:
        case import_Types.UserCodeCommand.KeypadModeSet:
        case import_Types.UserCodeCommand.KeypadModeGet:
        case import_Types.UserCodeCommand.ExtendedUserCodeSet:
        case import_Types.UserCodeCommand.ExtendedUserCodeGet:
          return this.version >= 2;
        case import_Types.UserCodeCommand.AdminCodeSet:
        case import_Types.UserCodeCommand.AdminCodeGet: {
          if (this.version < 2)
            return false;
          return this.tryGetValueDB()?.getValue(import_CCValues_generated.UserCodeCCValues.supportsAdminCode.endpoint(this.endpoint.index));
        }
        case import_Types.UserCodeCommand.UserCodeChecksumGet: {
          if (this.version < 2)
            return false;
          return this.tryGetValueDB()?.getValue(import_CCValues_generated.UserCodeCCValues.supportsUserCodeChecksum.endpoint(this.endpoint.index));
        }
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property, propertyKey }, value) {
        let result;
        if (property === "keypadMode") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          result = await this.setKeypadMode(value);
        } else if (property === "adminCode" || property === "masterCode") {
          if (typeof value !== "string") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "string", typeof value);
          }
          result = await this.setAdminCode(value);
        } else if (property === "userIdStatus") {
          if (propertyKey == void 0) {
            (0, import_API.throwMissingPropertyKey)(this.ccId, property);
          } else if (typeof propertyKey !== "number") {
            (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
          }
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          if (value === import_Types.UserIDStatus.Available) {
            result = await this.clear(propertyKey);
          } else {
            const userCode = this.getValueDB().getValue(import_CCValues_generated.UserCodeCCValues.userCode(propertyKey).endpoint(this.endpoint.index));
            result = await this.set(propertyKey, value, userCode);
          }
        } else if (property === "userCode") {
          if (propertyKey == void 0) {
            (0, import_API.throwMissingPropertyKey)(this.ccId, property);
          } else if (typeof propertyKey !== "number") {
            (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
          }
          if (typeof value !== "string" && !(0, import_shared.isUint8Array)(value)) {
            (0, import_API.throwWrongValueType)(this.ccId, property, "string or Buffer", typeof value);
          }
          let userIdStatus = this.getValueDB().getValue(import_CCValues_generated.UserCodeCCValues.userIdStatus(propertyKey).endpoint(this.endpoint.index));
          if (userIdStatus === import_Types.UserIDStatus.Available || userIdStatus == void 0) {
            userIdStatus = import_Types.UserIDStatus.Enabled;
          }
          result = await this.set(propertyKey, userIdStatus, value);
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
          this.schedulePoll({ property, propertyKey }, value, {
            transition: "fast"
          });
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        switch (property) {
          case "keypadMode":
            return this.getKeypadMode();
          case "adminCode":
            return this.getAdminCode();
          case "userIdStatus":
          case "userCode": {
            if (propertyKey == void 0) {
              (0, import_API.throwMissingPropertyKey)(this.ccId, property);
            } else if (typeof propertyKey !== "number") {
              (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
            }
            return (await this.get(propertyKey))?.[property];
          }
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async getUsersCount() {
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.UsersNumberGet);
      const cc = new UserCodeCCUsersNumberGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedUsers;
    }
    async get(userId, multiple = false) {
      if (userId > 255 || multiple) {
        this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.ExtendedUserCodeGet);
        const cc = new UserCodeCCExtendedUserCodeGet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          userId,
          reportMore: multiple
        });
        const response = await this.host.sendCommand(cc, this.commandOptions);
        if (!response) {
          return;
        } else if (multiple) {
          return (0, import_shared.pick)(response, ["userCodes", "nextUserId"]);
        } else {
          return (0, import_shared.pick)(response.userCodes[0], [
            "userIdStatus",
            "userCode"
          ]);
        }
      } else {
        this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.Get);
        const cc = new UserCodeCCGet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          userId
        });
        const response = await this.host.sendCommand(cc, this.commandOptions);
        if (response)
          return (0, import_shared.pick)(response, ["userIdStatus", "userCode"]);
      }
    }
    /** Configures a single user code */
    async set(userId, userIdStatus, userCode) {
      if (userId > 255) {
        return this.setMany([{ userId, userIdStatus, userCode }]);
      }
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.Set);
      const numUsers = UserCodeCC.getSupportedUsersCached(this.host, this.endpoint);
      if (numUsers != void 0 && userId > numUsers) {
        throw new import_core.ZWaveError(`The user ID must be between 0 and the number of supported users ${numUsers}.`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const cc = new UserCodeCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        userId,
        userIdStatus,
        userCode
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /** Configures multiple user codes */
    async setMany(codes) {
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.ExtendedUserCodeSet);
      const numUsers = UserCodeCC.getSupportedUsersCached(this.host, this.endpoint);
      const supportedStatuses = UserCodeCC.getSupportedUserIDStatusesCached(this.host, this.endpoint);
      const supportedASCIIChars = UserCodeCC.getSupportedASCIICharsCached(this.host, this.endpoint);
      const supportsMultipleUserCodeSet = UserCodeCC.supportsMultipleUserCodeSetCached(this.host, this.endpoint) ?? false;
      if (numUsers != void 0) {
        if (codes.some((code) => code.userId < 0 || code.userId > numUsers)) {
          throw new import_core.ZWaveError(`All User IDs must be between 0 and the number of supported users ${numUsers}.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      } else {
        if (codes.some((code) => code.userId < 0)) {
          throw new import_core.ZWaveError(`All User IDs must be greater than 0.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      }
      if (codes.some((code) => code.userId === 0) && codes.length > 1) {
        throw new import_core.ZWaveError(`If user ID 0 is used, only one code may be set`, import_core.ZWaveErrorCodes.Argument_Invalid);
      } else if (codes.some((code) => code.userId === 0 && code.userIdStatus !== import_Types.UserIDStatus.Available)) {
        throw new import_core.ZWaveError(`User ID 0 may only be used to clear all user codes`, import_core.ZWaveErrorCodes.Argument_Invalid);
      } else if (codes.length > 1 && !supportsMultipleUserCodeSet) {
        throw new import_core.ZWaveError(`The node does not support setting multiple user codes at once`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      for (const code of codes) {
        if (supportedStatuses != void 0 && !supportedStatuses.includes(code.userIdStatus)) {
          throw new import_core.ZWaveError(`The user ID status ${(0, import_shared.getEnumMemberName)(import_Types.UserIDStatus, code.userIdStatus)} is not supported by the node`, import_core.ZWaveErrorCodes.Argument_Invalid);
        } else if (code.userIdStatus === import_Types.UserIDStatus.Available) {
          code.userCode = void 0;
        } else if (supportedASCIIChars) {
          const userCodeString = typeof code.userCode === "string" ? code.userCode : (0, import_shared.uint8ArrayToString)(code.userCode);
          if (!validateCode(userCodeString, supportedASCIIChars)) {
            throw new import_core.ZWaveError(`The user code must consist of 4 to 10 of the following characters: ${supportedASCIIChars}`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
        }
      }
      const cc = new UserCodeCCExtendedUserCodeSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        userCodes: codes
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Clears one or all user code
     * @param userId The user code to clear. If none or 0 is given, all codes are cleared
     */
    async clear(userId = 0) {
      if (this.version > 1 || userId > 255) {
        return this.setMany([
          { userId, userIdStatus: import_Types.UserIDStatus.Available }
        ]);
      } else {
        this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.Set);
        const numUsers = UserCodeCC.getSupportedUsersCached(this.host, this.endpoint);
        if (numUsers != void 0 && userId > numUsers) {
          throw new import_core.ZWaveError(`The user ID must be between 0 and the number of supported users ${numUsers}.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        const cc = new UserCodeCCSet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          userId,
          userIdStatus: import_Types.UserIDStatus.Available
        });
        return this.host.sendCommand(cc, this.commandOptions);
      }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getCapabilities() {
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.CapabilitiesGet);
      const cc = new UserCodeCCCapabilitiesGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "supportsAdminCode",
          "supportsAdminCodeDeactivation",
          "supportsUserCodeChecksum",
          "supportsMultipleUserCodeReport",
          "supportsMultipleUserCodeSet",
          "supportedUserIDStatuses",
          "supportedKeypadModes",
          "supportedASCIIChars"
        ]);
      }
    }
    async getKeypadMode() {
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.KeypadModeGet);
      const cc = new UserCodeCCKeypadModeGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.keypadMode;
    }
    async setKeypadMode(keypadMode) {
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.KeypadModeSet);
      const supportedModes = UserCodeCC.getSupportedKeypadModesCached(this.host, this.endpoint);
      if (!supportedModes) {
        throw new import_core.ZWaveError(`The keypad mode can only be set after the interview is complete!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      } else if (!supportedModes.includes(keypadMode)) {
        throw new import_core.ZWaveError(`The keypad mode ${(0, import_shared.getEnumMemberName)(import_Types.KeypadMode, keypadMode)} is not supported by the node!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const cc = new UserCodeCCKeypadModeSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        keypadMode
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getAdminCode() {
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.AdminCodeGet);
      const cc = new UserCodeCCAdminCodeGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.adminCode;
    }
    async setAdminCode(adminCode) {
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.AdminCodeSet);
      const supportedASCIIChars = UserCodeCC.getSupportedASCIICharsCached(this.host, this.endpoint);
      if (!supportedASCIIChars) {
        throw new import_core.ZWaveError(`The admin code can only be set after the interview is complete!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      if (!adminCode) {
        const supportsDeactivation = UserCodeCC.supportsAdminCodeDeactivationCached(this.host, this.endpoint);
        if (!supportsDeactivation) {
          throw new import_core.ZWaveError(`The node does not support deactivating the admin code!`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      } else if (!validateCode(adminCode, supportedASCIIChars)) {
        throw new import_core.ZWaveError(`The admin code must consist of 4 to 10 of the following characters: ${supportedASCIIChars}`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const cc = new UserCodeCCAdminCodeSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        adminCode
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getUserCodeChecksum() {
      this.assertSupportsCommand(import_Types.UserCodeCommand, import_Types.UserCodeCommand.UserCodeChecksumGet);
      const cc = new UserCodeCCUserCodeChecksumGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.userCodeChecksum;
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return UserCodeCCAPI2 = _classThis;
})();
let UserCodeCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["User Code"]), (0, import_CommandClassDecorators.implementedVersion)(2), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.UserCodeCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var UserCodeCC2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["User Code"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      if (api.version >= 2) {
        ctx.logNode(node.id, {
          message: "querying capabilities...",
          direction: "outbound"
        });
        const caps = await api.getCapabilities();
        if (!caps) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "User Code capabilities query timed out, skipping interview...",
            level: "warn"
          });
          return;
        }
      }
      ctx.logNode(node.id, {
        message: "querying number of user codes...",
        direction: "outbound"
      });
      const supportedUsers = await api.getUsersCount();
      if (supportedUsers == void 0) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying number of user codes timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      for (let userId = 1; userId <= supportedUsers; userId++) {
        setUserCodeMetadata.call(this, ctx, userId);
      }
      if (ctx.getInterviewOptions()?.queryAllUserCodes) {
        await this.refreshValues(ctx);
      }
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["User Code"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const supportsAdminCode = UserCodeCC2.supportsAdminCodeCached(ctx, endpoint);
      const supportsUserCodeChecksum = this.getValue(ctx, import_CCValues_generated.UserCodeCCValues.supportsUserCodeChecksum) ?? false;
      const supportedKeypadModes = this.getValue(ctx, import_CCValues_generated.UserCodeCCValues.supportedKeypadModes) ?? [];
      const supportedUsers = this.getValue(ctx, import_CCValues_generated.UserCodeCCValues.supportedUsers) ?? 0;
      const supportsMultipleUserCodeReport = !!this.getValue(ctx, import_CCValues_generated.UserCodeCCValues.supportsMultipleUserCodeReport);
      if (api.version >= 2) {
        if (supportsAdminCode) {
          ctx.logNode(node.id, {
            message: "querying admin code...",
            direction: "outbound"
          });
          await api.getAdminCode();
        }
        if (supportedKeypadModes.length > 1) {
          ctx.logNode(node.id, {
            message: "querying active keypad mode...",
            direction: "outbound"
          });
          await api.getKeypadMode();
        }
        const storedUserCodeChecksum = this.getValue(ctx, import_CCValues_generated.UserCodeCCValues.userCodeChecksum) ?? 0;
        let currentUserCodeChecksum = 0;
        if (supportsUserCodeChecksum) {
          ctx.logNode(node.id, {
            message: "retrieving current user code checksum...",
            direction: "outbound"
          });
          currentUserCodeChecksum = await api.getUserCodeChecksum();
        }
        if (!supportsUserCodeChecksum || currentUserCodeChecksum !== storedUserCodeChecksum) {
          ctx.logNode(node.id, {
            message: "checksum changed or is not supported, querying all user codes...",
            direction: "outbound"
          });
          if (supportsMultipleUserCodeReport) {
            let nextUserId = 1;
            while (nextUserId > 0 && nextUserId <= supportedUsers) {
              const response = await api.get(nextUserId, true);
              if (response) {
                nextUserId = response.nextUserId;
              } else {
                ctx.logNode(node.id, {
                  endpoint: this.endpointIndex,
                  message: `Querying user code #${nextUserId} timed out, skipping the remaining interview...`,
                  level: "warn"
                });
                break;
              }
            }
          } else {
            for (let userId = 1; userId <= supportedUsers; userId++) {
              await api.get(userId);
            }
          }
        }
      } else {
        ctx.logNode(node.id, {
          message: "querying all user codes...",
          direction: "outbound"
        });
        for (let userId = 1; userId <= supportedUsers; userId++) {
          await api.get(userId);
        }
      }
    }
    /**
     * Returns the number of supported users.
     * This only works AFTER the interview process
     */
    static getSupportedUsersCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.UserCodeCCValues.supportedUsers.endpoint(endpoint.index));
    }
    /**
     * Returns the supported keypad modes.
     * This only works AFTER the interview process
     */
    static getSupportedKeypadModesCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.UserCodeCCValues.supportedKeypadModes.endpoint(endpoint.index));
    }
    /**
     * Returns the supported user ID statuses.
     * This only works AFTER the interview process
     */
    static getSupportedUserIDStatusesCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.UserCodeCCValues.supportedUserIDStatuses.endpoint(endpoint.index));
    }
    /**
     * Returns the supported ASCII characters.
     * This only works AFTER the interview process
     */
    static getSupportedASCIICharsCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.UserCodeCCValues.supportedASCIIChars.endpoint(endpoint.index));
    }
    /**
     * Returns whether the admin code functionality is supported.
     * This only works AFTER the interview process
     */
    static supportsAdminCodeCached(ctx, endpoint) {
      const valueDB = ctx.getValueDB(endpoint.nodeId);
      return valueDB.getValue(import_CCValues_generated.UserCodeCCValues.supportsAdminCode.endpoint(endpoint.index)) ?? valueDB.getValue(import_CCValues_generated.UserCodeCCValues._deprecated_supportsMasterCode.endpoint(endpoint.index)) ?? false;
    }
    /**
     * Returns whether deactivating the admin code is supported.
     * This only works AFTER the interview process
     */
    static supportsAdminCodeDeactivationCached(ctx, endpoint) {
      const valueDB = ctx.getValueDB(endpoint.nodeId);
      return valueDB.getValue(import_CCValues_generated.UserCodeCCValues.supportsAdminCodeDeactivation.endpoint(endpoint.index)) ?? valueDB.getValue(import_CCValues_generated.UserCodeCCValues._deprecated_supportsMasterCodeDeactivation.endpoint(endpoint.index)) ?? false;
    }
    /**
     * Returns whether setting multiple user codes at once is supported.
     * This only works AFTER the interview process
     */
    static supportsMultipleUserCodeSetCached(ctx, endpoint) {
      return !!ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.UserCodeCCValues.supportsMultipleUserCodeSet.endpoint(endpoint.index));
    }
    /**
     * Returns the current status of a user ID.
     * This only works AFTER the user IDs have been queried.
     */
    static getUserIdStatusCached(ctx, endpoint, userId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.UserCodeCCValues.userIdStatus(userId).endpoint(endpoint.index));
    }
    /**
     * Returns the current code belonging to a user ID.
     * This only works AFTER the user IDs have been queried.
     */
    static getUserCodeCached(ctx, endpoint, userId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.UserCodeCCValues.userCode(userId).endpoint(endpoint.index));
    }
  };
  return UserCodeCC2 = _classThis;
})();
let UserCodeCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCSet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.userIdStatus = options.userIdStatus;
      if (this.userId < 0) {
        throw new import_core.ZWaveError(`${this.constructor.name}: The user ID must be between greater than 0.`, import_core.ZWaveErrorCodes.Argument_Invalid);
      } else if (this.userId === 0 && this.userIdStatus !== import_Types.UserIDStatus.Available) {
        throw new import_core.ZWaveError(`${this.constructor.name}: User ID 0 may only be used to clear all user codes`, import_core.ZWaveErrorCodes.Argument_Invalid);
      } else if (this.userIdStatus === import_Types.UserIDStatus.Available) {
        this.userCode = "\0".repeat(4);
      } else {
        this.userCode = options.userCode;
        if (this.userCode.length < 4 || this.userCode.length > 10) {
          throw new import_core.ZWaveError(`${this.constructor.name}: The user code must have a length of 4 to 10 ${typeof this.userCode === "string" ? "characters" : "bytes"}`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const userIdStatus = raw.payload[1];
      if (userIdStatus === import_Types.UserIDStatus.StatusNotAvailable) {
        import_core.validatePayload.fail("Invalid user ID status");
      }
      if (userIdStatus === import_Types.UserIDStatus.Available) {
        return new this({
          nodeId: ctx.sourceNodeId,
          userId,
          userIdStatus
        });
      }
      const userCode = raw.payload.subarray(2);
      return new this({
        nodeId: ctx.sourceNodeId,
        userId,
        userIdStatus,
        userCode
      });
    }
    userId;
    userIdStatus;
    userCode;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.userId, this.userIdStatus]),
        typeof this.userCode === "string" ? import_shared.Bytes.from(this.userCode, "ascii") : this.userCode
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "user id": this.userId,
          "id status": (0, import_shared.getEnumMemberName)(import_Types.UserIDStatus, this.userIdStatus),
          "user code": userCodeToLogString(this.userCode)
        }
      };
    }
  };
  return UserCodeCCSet2 = _classThis;
})();
let UserCodeCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCReport2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.userIdStatus = options.userIdStatus;
      this.userCode = options.userCode ?? "";
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const userIdStatus = raw.payload[1];
      let userCode;
      if (raw.payload.length === 2 && (userIdStatus === import_Types.UserIDStatus.Available || userIdStatus === import_Types.UserIDStatus.StatusNotAvailable)) {
        userCode = "";
      } else {
        (0, import_core.validatePayload)(raw.payload.length >= 6);
        let userCodeBuffer = raw.payload.subarray(2);
        while (userCodeBuffer.at(-1) === 0) {
          userCodeBuffer = userCodeBuffer.subarray(0, -1);
        }
        const userCodeString = userCodeBuffer.toString("utf8");
        if ((0, import_shared.isPrintableASCII)(userCodeString)) {
          userCode = userCodeString;
        } else if ((0, import_shared.isPrintableASCIIWithWhitespace)(userCodeString)) {
          userCode = userCodeString.trim();
        } else {
          userCode = userCodeBuffer;
        }
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        userId,
        userIdStatus,
        userCode
      });
    }
    userId;
    userIdStatus;
    userCode;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      persistUserCode.call(this, ctx, this.userId, this.userIdStatus, this.userCode);
      return true;
    }
    serialize(ctx) {
      let userCodeBuffer;
      if (typeof this.userCode === "string") {
        userCodeBuffer = import_shared.Bytes.from(this.userCode, "ascii");
      } else {
        userCodeBuffer = this.userCode;
      }
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.userId, this.userIdStatus]),
        userCodeBuffer
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "user id": this.userId,
          "id status": (0, import_shared.getEnumMemberName)(import_Types.UserIDStatus, this.userIdStatus),
          "user code": userCodeToLogString(this.userCode)
        }
      };
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toNotificationEventParameters() {
      return { userId: this.userId };
    }
  };
  return UserCodeCCReport2 = _classThis;
})();
let UserCodeCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(UserCodeCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCGet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const userId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        userId
      });
    }
    userId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.userId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "user id": this.userId }
      };
    }
  };
  return UserCodeCCGet2 = _classThis;
})();
let UserCodeCCUsersNumberReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.UsersNumberReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedUsers", import_CCValues_generated.UserCodeCCValues.supportedUsers)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCUsersNumberReport2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCUsersNumberReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCUsersNumberReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedUsers = options.supportedUsers;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      let supportedUsers;
      if (raw.payload.length >= 3) {
        supportedUsers = raw.payload.readUInt16BE(1);
      } else {
        supportedUsers = raw.payload[0];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedUsers
      });
    }
    supportedUsers;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(3);
      this.payload[0] = Math.min(255, this.supportedUsers);
      this.payload.writeUInt16BE(this.supportedUsers, 1);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "supported users": this.supportedUsers }
      };
    }
  };
  return UserCodeCCUsersNumberReport2 = _classThis;
})();
let UserCodeCCUsersNumberGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.UsersNumberGet), (0, import_CommandClassDecorators.expectedCCResponse)(UserCodeCCUsersNumberReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCUsersNumberGet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCUsersNumberGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCUsersNumberGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return UserCodeCCUsersNumberGet2 = _classThis;
})();
let UserCodeCCCapabilitiesReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.CapabilitiesReport), (0, import_CommandClassDecorators.ccValueProperty)("supportsAdminCode", import_CCValues_generated.UserCodeCCValues.supportsAdminCode), (0, import_CommandClassDecorators.ccValueProperty)("supportsAdminCodeDeactivation", import_CCValues_generated.UserCodeCCValues.supportsAdminCodeDeactivation), (0, import_CommandClassDecorators.ccValueProperty)("supportsUserCodeChecksum", import_CCValues_generated.UserCodeCCValues.supportsUserCodeChecksum), (0, import_CommandClassDecorators.ccValueProperty)("supportsMultipleUserCodeReport", import_CCValues_generated.UserCodeCCValues.supportsMultipleUserCodeReport), (0, import_CommandClassDecorators.ccValueProperty)("supportsMultipleUserCodeSet", import_CCValues_generated.UserCodeCCValues.supportsMultipleUserCodeSet), (0, import_CommandClassDecorators.ccValueProperty)("supportedUserIDStatuses", import_CCValues_generated.UserCodeCCValues.supportedUserIDStatuses), (0, import_CommandClassDecorators.ccValueProperty)("supportedKeypadModes", import_CCValues_generated.UserCodeCCValues.supportedKeypadModes), (0, import_CommandClassDecorators.ccValueProperty)("supportedASCIIChars", import_CCValues_generated.UserCodeCCValues.supportedASCIIChars)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCCapabilitiesReport2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCCapabilitiesReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCCapabilitiesReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportsAdminCode = options.supportsAdminCode;
      this.supportsAdminCodeDeactivation = options.supportsAdminCodeDeactivation;
      this.supportsUserCodeChecksum = options.supportsUserCodeChecksum;
      this.supportsMultipleUserCodeReport = options.supportsMultipleUserCodeReport;
      this.supportsMultipleUserCodeSet = options.supportsMultipleUserCodeSet;
      this.supportedUserIDStatuses = options.supportedUserIDStatuses;
      this.supportedKeypadModes = options.supportedKeypadModes;
      this.supportedASCIIChars = options.supportedASCIIChars;
    }
    static from(raw, ctx) {
      let offset = 0;
      (0, import_core.validatePayload)(raw.payload.length >= offset + 1);
      const supportsAdminCode = !!(raw.payload[offset] & 128);
      const supportsAdminCodeDeactivation = !!(raw.payload[offset] & 64);
      const statusBitMaskLength = raw.payload[offset] & 31;
      offset += 1;
      (0, import_core.validatePayload)(raw.payload.length >= offset + statusBitMaskLength + 1);
      const supportedUserIDStatuses = (0, import_core.parseBitMask)(raw.payload.subarray(offset, offset + statusBitMaskLength), import_Types.UserIDStatus.Available);
      offset += statusBitMaskLength;
      const supportsUserCodeChecksum = !!(raw.payload[offset] & 128);
      const supportsMultipleUserCodeReport = !!(raw.payload[offset] & 64);
      const supportsMultipleUserCodeSet = !!(raw.payload[offset] & 32);
      const keypadModesBitMaskLength = raw.payload[offset] & 31;
      offset += 1;
      (0, import_core.validatePayload)(raw.payload.length >= offset + keypadModesBitMaskLength + 1);
      const supportedKeypadModes = (0, import_core.parseBitMask)(raw.payload.subarray(offset, offset + keypadModesBitMaskLength), import_Types.KeypadMode.Normal);
      offset += keypadModesBitMaskLength;
      const keysBitMaskLength = raw.payload[offset] & 31;
      offset += 1;
      (0, import_core.validatePayload)(raw.payload.length >= offset + keysBitMaskLength);
      const supportedASCIIChars = import_shared.Bytes.from((0, import_core.parseBitMask)(raw.payload.subarray(offset, offset + keysBitMaskLength), 0)).toString("ascii");
      return new this({
        nodeId: ctx.sourceNodeId,
        supportsAdminCode,
        supportsAdminCodeDeactivation,
        supportedUserIDStatuses,
        supportsUserCodeChecksum,
        supportsMultipleUserCodeReport,
        supportsMultipleUserCodeSet,
        supportedKeypadModes,
        supportedASCIIChars
      });
    }
    supportsAdminCode;
    supportsAdminCodeDeactivation;
    supportsUserCodeChecksum;
    supportsMultipleUserCodeReport;
    supportsMultipleUserCodeSet;
    supportedUserIDStatuses;
    supportedKeypadModes;
    supportedASCIIChars;
    serialize(ctx) {
      const supportedStatusesBitmask = (0, import_core.encodeBitMask)(this.supportedUserIDStatuses, void 0, import_Types.UserIDStatus.Available);
      const controlByte1 = (this.supportsAdminCode ? 128 : 0) | (this.supportsAdminCodeDeactivation ? 64 : 0) | supportedStatusesBitmask.length & 31;
      const supportedKeypadModesBitmask = (0, import_core.encodeBitMask)(this.supportedKeypadModes, void 0, import_Types.KeypadMode.Normal);
      const controlByte2 = (this.supportsUserCodeChecksum ? 128 : 0) | (this.supportsMultipleUserCodeReport ? 64 : 0) | (this.supportsMultipleUserCodeSet ? 32 : 0) | supportedKeypadModesBitmask.length & 31;
      const keysAsNumbers = [...this.supportedASCIIChars].map((char) => char.charCodeAt(0));
      const supportedKeysBitmask = (0, import_core.encodeBitMask)(keysAsNumbers, void 0, 0);
      const controlByte3 = supportedKeysBitmask.length & 31;
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([controlByte1]),
        supportedStatusesBitmask,
        import_shared.Bytes.from([controlByte2]),
        supportedKeypadModesBitmask,
        import_shared.Bytes.from([controlByte3]),
        supportedKeysBitmask
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supports admin code": this.supportsAdminCode,
          "supports admin code deactivation": this.supportsAdminCodeDeactivation,
          "supports user code checksum": this.supportsUserCodeChecksum,
          "supports multiple codes in report": this.supportsMultipleUserCodeReport,
          "supports multiple codes in set": this.supportsMultipleUserCodeSet,
          "supported user id statuses": this.supportedUserIDStatuses.map((status) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.UserIDStatus, status)}`).join(""),
          "supported keypad modes": this.supportedKeypadModes.map((mode) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.KeypadMode, mode)}`).join(""),
          "supported ASCII chars": this.supportedASCIIChars
        }
      };
    }
  };
  return UserCodeCCCapabilitiesReport2 = _classThis;
})();
let UserCodeCCCapabilitiesGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.CapabilitiesGet), (0, import_CommandClassDecorators.expectedCCResponse)(UserCodeCCCapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCCapabilitiesGet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCCapabilitiesGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCCapabilitiesGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return UserCodeCCCapabilitiesGet2 = _classThis;
})();
let UserCodeCCKeypadModeSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.KeypadModeSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCKeypadModeSet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCKeypadModeSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCKeypadModeSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.keypadMode = options.keypadMode;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const keypadMode = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        keypadMode
      });
    }
    keypadMode;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.keypadMode]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { mode: (0, import_shared.getEnumMemberName)(import_Types.KeypadMode, this.keypadMode) }
      };
    }
  };
  return UserCodeCCKeypadModeSet2 = _classThis;
})();
let UserCodeCCKeypadModeReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.KeypadModeReport), (0, import_CommandClassDecorators.ccValueProperty)("keypadMode", import_CCValues_generated.UserCodeCCValues.keypadMode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCKeypadModeReport2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCKeypadModeReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCKeypadModeReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.keypadMode = options.keypadMode;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const keypadMode = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        keypadMode
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const supportedKeypadModes = this.getValue(ctx, import_CCValues_generated.UserCodeCCValues.supportedKeypadModes) ?? [this.keypadMode];
      const keypadModeValue = import_CCValues_generated.UserCodeCCValues.keypadMode;
      this.setMetadata(ctx, keypadModeValue, {
        ...keypadModeValue.meta,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.KeypadMode, supportedKeypadModes)
      });
      return true;
    }
    keypadMode;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.keypadMode]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          keypadMode: (0, import_shared.getEnumMemberName)(import_Types.KeypadMode, this.keypadMode)
        }
      };
    }
  };
  return UserCodeCCKeypadModeReport2 = _classThis;
})();
let UserCodeCCKeypadModeGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.KeypadModeGet), (0, import_CommandClassDecorators.expectedCCResponse)(UserCodeCCKeypadModeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCKeypadModeGet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCKeypadModeGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCKeypadModeGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return UserCodeCCKeypadModeGet2 = _classThis;
})();
let UserCodeCCAdminCodeSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.AdminCodeSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCAdminCodeSet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCAdminCodeSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCAdminCodeSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.adminCode = options.adminCode;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const codeLength = raw.payload[0] & 15;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + codeLength);
      const adminCode = raw.payload.subarray(1, 1 + codeLength).toString("ascii");
      return new this({
        nodeId: ctx.sourceNodeId,
        adminCode
      });
    }
    adminCode;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.adminCode.length & 15]),
        import_shared.Bytes.from(this.adminCode, "ascii")
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "admin code": userCodeToLogString(this.adminCode) }
      };
    }
  };
  return UserCodeCCAdminCodeSet2 = _classThis;
})();
let UserCodeCCAdminCodeReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.AdminCodeReport), (0, import_CommandClassDecorators.ccValueProperty)("adminCode", import_CCValues_generated.UserCodeCCValues.adminCode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCAdminCodeReport2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCAdminCodeReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCAdminCodeReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.adminCode = options.adminCode;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const codeLength = raw.payload[0] & 15;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + codeLength);
      const adminCode = raw.payload.subarray(1, 1 + codeLength).toString("ascii");
      return new this({
        nodeId: ctx.sourceNodeId,
        adminCode
      });
    }
    adminCode;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.adminCode.length & 15]),
        import_shared.Bytes.from(this.adminCode, "ascii")
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "admin code": userCodeToLogString(this.adminCode) }
      };
    }
  };
  return UserCodeCCAdminCodeReport2 = _classThis;
})();
let UserCodeCCAdminCodeGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.AdminCodeGet), (0, import_CommandClassDecorators.expectedCCResponse)(UserCodeCCAdminCodeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCAdminCodeGet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCAdminCodeGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCAdminCodeGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return UserCodeCCAdminCodeGet2 = _classThis;
})();
let UserCodeCCUserCodeChecksumReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.UserCodeChecksumReport), (0, import_CommandClassDecorators.ccValueProperty)("userCodeChecksum", import_CCValues_generated.UserCodeCCValues.userCodeChecksum)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCUserCodeChecksumReport2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCUserCodeChecksumReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCUserCodeChecksumReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userCodeChecksum = options.userCodeChecksum;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userCodeChecksum = raw.payload.readUInt16BE(0);
      return new this({
        nodeId: ctx.sourceNodeId,
        userCodeChecksum
      });
    }
    userCodeChecksum;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(2);
      this.payload.writeUInt16BE(this.userCodeChecksum, 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "user code checksum": (0, import_shared.num2hex)(this.userCodeChecksum) }
      };
    }
  };
  return UserCodeCCUserCodeChecksumReport2 = _classThis;
})();
let UserCodeCCUserCodeChecksumGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.UserCodeChecksumGet), (0, import_CommandClassDecorators.expectedCCResponse)(UserCodeCCUserCodeChecksumReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCUserCodeChecksumGet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCUserCodeChecksumGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCUserCodeChecksumGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return UserCodeCCUserCodeChecksumGet2 = _classThis;
})();
let UserCodeCCExtendedUserCodeSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.ExtendedUserCodeSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCExtendedUserCodeSet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCExtendedUserCodeSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCExtendedUserCodeSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userCodes = options.userCodes;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    userCodes;
    serialize(ctx) {
      const userCodeBuffers = this.userCodes.map((code) => {
        const ret = import_shared.Bytes.concat([
          import_shared.Bytes.from([
            0,
            0,
            code.userIdStatus,
            code.userCode?.length ?? 0
          ]),
          (0, import_shared.isUint8Array)(code.userCode) ? code.userCode : import_shared.Bytes.from(code.userCode ?? "", "ascii")
        ]);
        ret.writeUInt16BE(code.userId, 0);
        return ret;
      });
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.userCodes.length]),
        ...userCodeBuffers
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {};
      for (const { userId, userIdStatus, userCode } of this.userCodes) {
        message[`code #${userId}`] = `${userCodeToLogString(userCode ?? "")} (status: ${(0, import_shared.getEnumMemberName)(import_Types.UserIDStatus, userIdStatus)})`;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return UserCodeCCExtendedUserCodeSet2 = _classThis;
})();
let UserCodeCCExtendedUserCodeReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.ExtendedUserCodeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCExtendedUserCodeReport2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCExtendedUserCodeReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCExtendedUserCodeReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userCodes = options.userCodes;
      this.nextUserId = options.nextUserId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const numCodes = raw.payload[0];
      let offset = 1;
      const userCodes = [];
      for (let i = 0; i < numCodes; i++) {
        const { code, bytesRead } = parseExtendedUserCode(raw.payload.subarray(offset));
        userCodes.push(code);
        offset += bytesRead;
      }
      (0, import_core.validatePayload)(raw.payload.length >= offset + 2);
      const nextUserId = raw.payload.readUInt16BE(offset);
      return new this({
        nodeId: ctx.sourceNodeId,
        userCodes,
        nextUserId
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      for (const { userId, userIdStatus, userCode } of this.userCodes) {
        persistUserCode.call(this, ctx, userId, userIdStatus, userCode);
      }
      return true;
    }
    userCodes;
    nextUserId;
    toLogEntry(ctx) {
      const message = {};
      for (const { userId, userIdStatus, userCode } of this.userCodes) {
        message[`code #${userId}`] = `${userCodeToLogString(userCode)} (status: ${(0, import_shared.getEnumMemberName)(import_Types.UserIDStatus, userIdStatus)})`;
      }
      message["next user id"] = this.nextUserId;
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return UserCodeCCExtendedUserCodeReport2 = _classThis;
})();
let UserCodeCCExtendedUserCodeGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.UserCodeCommand.ExtendedUserCodeGet), (0, import_CommandClassDecorators.expectedCCResponse)(UserCodeCCExtendedUserCodeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = UserCodeCC;
  var UserCodeCCExtendedUserCodeGet2 = class extends _classSuper {
    static {
      __name(this, "UserCodeCCExtendedUserCodeGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      UserCodeCCExtendedUserCodeGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.reportMore = !!options.reportMore;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    userId;
    reportMore;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([0, 0, this.reportMore ? 1 : 0]);
      this.payload.writeUInt16BE(this.userId, 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "user id": this.userId,
          "report more": this.reportMore
        }
      };
    }
  };
  return UserCodeCCExtendedUserCodeGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  UserCodeCC,
  UserCodeCCAPI,
  UserCodeCCAdminCodeGet,
  UserCodeCCAdminCodeReport,
  UserCodeCCAdminCodeSet,
  UserCodeCCCapabilitiesGet,
  UserCodeCCCapabilitiesReport,
  UserCodeCCExtendedUserCodeGet,
  UserCodeCCExtendedUserCodeReport,
  UserCodeCCExtendedUserCodeSet,
  UserCodeCCGet,
  UserCodeCCKeypadModeGet,
  UserCodeCCKeypadModeReport,
  UserCodeCCKeypadModeSet,
  UserCodeCCReport,
  UserCodeCCSet,
  UserCodeCCUserCodeChecksumGet,
  UserCodeCCUserCodeChecksumReport,
  UserCodeCCUsersNumberGet,
  UserCodeCCUsersNumberReport,
  UserCodeCCValues,
  userCodeToLogString
});
//# sourceMappingURL=UserCodeCC.js.map
