"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Types_exports = {};
__export(Types_exports, {
  AlarmSensorCommand: () => AlarmSensorCommand,
  AlarmSensorType: () => AlarmSensorType,
  AssociationCheckResult: () => AssociationCheckResult,
  AssociationCommand: () => AssociationCommand,
  AssociationGroupInfoCommand: () => AssociationGroupInfoCommand,
  AssociationGroupInfoProfile: () => AssociationGroupInfoProfile,
  BarrierOperatorCommand: () => BarrierOperatorCommand,
  BarrierState: () => BarrierState,
  BasicCommand: () => BasicCommand,
  BasicWindowCoveringCommand: () => BasicWindowCoveringCommand,
  BatteryChargingStatus: () => BatteryChargingStatus,
  BatteryCommand: () => BatteryCommand,
  BatteryReplacementStatus: () => BatteryReplacementStatus,
  BinarySensorCommand: () => BinarySensorCommand,
  BinarySensorType: () => BinarySensorType,
  BinarySwitchCommand: () => BinarySwitchCommand,
  CRC16Command: () => CRC16Command,
  CentralSceneCommand: () => CentralSceneCommand,
  CentralSceneKeys: () => CentralSceneKeys,
  ClimateControlScheduleCommand: () => ClimateControlScheduleCommand,
  ClockCommand: () => ClockCommand,
  ColorComponent: () => ColorComponent,
  ColorComponentMap: () => ColorComponentMap,
  ColorSwitchCommand: () => ColorSwitchCommand,
  ConfigurationCommand: () => ConfigurationCommand,
  DeviceIdType: () => DeviceIdType,
  DeviceResetLocallyCommand: () => DeviceResetLocallyCommand,
  DoorLockCommand: () => DoorLockCommand,
  DoorLockLoggingCommand: () => DoorLockLoggingCommand,
  DoorLockLoggingEventType: () => DoorLockLoggingEventType,
  DoorLockLoggingRecordStatus: () => DoorLockLoggingRecordStatus,
  DoorLockMode: () => DoorLockMode,
  DoorLockOperationType: () => DoorLockOperationType,
  EnergyProductionCommand: () => EnergyProductionCommand,
  EnergyProductionParameter: () => EnergyProductionParameter,
  EntryControlCommand: () => EntryControlCommand,
  EntryControlDataTypes: () => EntryControlDataTypes,
  EntryControlEventTypes: () => EntryControlEventTypes,
  FLiRS2WakeUpTime: () => FLiRS2WakeUpTime,
  FirmwareDownloadStatus: () => FirmwareDownloadStatus,
  FirmwareUpdateActivationStatus: () => FirmwareUpdateActivationStatus,
  FirmwareUpdateMetaDataCommand: () => FirmwareUpdateMetaDataCommand,
  FirmwareUpdateRequestStatus: () => FirmwareUpdateRequestStatus,
  FirmwareUpdateStatus: () => FirmwareUpdateStatus,
  HailCommand: () => HailCommand,
  HumidityControlMode: () => HumidityControlMode,
  HumidityControlModeCommand: () => HumidityControlModeCommand,
  HumidityControlOperatingState: () => HumidityControlOperatingState,
  HumidityControlOperatingStateCommand: () => HumidityControlOperatingStateCommand,
  HumidityControlSetpointCommand: () => HumidityControlSetpointCommand,
  HumidityControlSetpointType: () => HumidityControlSetpointType,
  InclusionControllerCommand: () => InclusionControllerCommand,
  InclusionControllerStatus: () => InclusionControllerStatus,
  InclusionControllerStep: () => InclusionControllerStep,
  IndicatorCommand: () => IndicatorCommand,
  IrrigationCommand: () => IrrigationCommand,
  IrrigationSensorPolarity: () => IrrigationSensorPolarity,
  KeypadMode: () => KeypadMode,
  LanguageCommand: () => LanguageCommand,
  LevelChangeDirection: () => LevelChangeDirection,
  LocalProtectionState: () => LocalProtectionState,
  LockCommand: () => LockCommand,
  ManufacturerSpecificCommand: () => ManufacturerSpecificCommand,
  MeterCommand: () => MeterCommand,
  MultiChannelAssociationCommand: () => MultiChannelAssociationCommand,
  MultiChannelCommand: () => MultiChannelCommand,
  MultiCommandCommand: () => MultiCommandCommand,
  MultilevelSensorCommand: () => MultilevelSensorCommand,
  MultilevelSwitchCommand: () => MultilevelSwitchCommand,
  NetworkTransferStatus: () => NetworkTransferStatus,
  NodeNamingAndLocationCommand: () => NodeNamingAndLocationCommand,
  NotificationCommand: () => NotificationCommand,
  Powerlevel: () => Powerlevel,
  PowerlevelCommand: () => PowerlevelCommand,
  PowerlevelTestStatus: () => PowerlevelTestStatus,
  ProtectionCommand: () => ProtectionCommand,
  RFProtectionState: () => RFProtectionState,
  RateType: () => RateType,
  SceneActivationCommand: () => SceneActivationCommand,
  SceneActuatorConfigurationCommand: () => SceneActuatorConfigurationCommand,
  SceneControllerConfigurationCommand: () => SceneControllerConfigurationCommand,
  ScheduleEntryLockCommand: () => ScheduleEntryLockCommand,
  ScheduleEntryLockScheduleKind: () => ScheduleEntryLockScheduleKind,
  ScheduleEntryLockSetAction: () => ScheduleEntryLockSetAction,
  ScheduleEntryLockWeekday: () => ScheduleEntryLockWeekday,
  ScheduleOverrideType: () => ScheduleOverrideType,
  Security2Command: () => Security2Command,
  SecurityCommand: () => SecurityCommand,
  SetbackType: () => SetbackType,
  SoundSwitchCommand: () => SoundSwitchCommand,
  SubsystemState: () => SubsystemState,
  SubsystemType: () => SubsystemType,
  SupervisionCommand: () => SupervisionCommand,
  SwitchType: () => SwitchType,
  ThermostatFanMode: () => ThermostatFanMode,
  ThermostatFanModeCommand: () => ThermostatFanModeCommand,
  ThermostatFanState: () => ThermostatFanState,
  ThermostatFanStateCommand: () => ThermostatFanStateCommand,
  ThermostatMode: () => ThermostatMode,
  ThermostatModeCommand: () => ThermostatModeCommand,
  ThermostatOperatingState: () => ThermostatOperatingState,
  ThermostatOperatingStateCommand: () => ThermostatOperatingStateCommand,
  ThermostatSetbackCommand: () => ThermostatSetbackCommand,
  ThermostatSetpointCommand: () => ThermostatSetpointCommand,
  ThermostatSetpointType: () => ThermostatSetpointType,
  TimeCommand: () => TimeCommand,
  TimeParametersCommand: () => TimeParametersCommand,
  ToneId: () => ToneId,
  TransportServiceCommand: () => TransportServiceCommand,
  UserCodeCommand: () => UserCodeCommand,
  UserIDStatus: () => UserIDStatus,
  ValveType: () => ValveType,
  VersionCommand: () => VersionCommand,
  WakeUpCommand: () => WakeUpCommand,
  WakeUpTime: () => WakeUpTime,
  Weekday: () => Weekday,
  WindowCoveringCommand: () => WindowCoveringCommand,
  WindowCoveringParameter: () => WindowCoveringParameter,
  ZWaveDataRate2DataRate: () => ZWaveDataRate2DataRate,
  ZWavePlusCommand: () => ZWavePlusCommand,
  ZWavePlusNodeType: () => ZWavePlusNodeType,
  ZWavePlusRoleType: () => ZWavePlusRoleType,
  ZWaveProtocolCommand: () => ZWaveProtocolCommand,
  dataRate2ZWaveDataRate: () => dataRate2ZWaveDataRate,
  entryControlEventTypeLabels: () => entryControlEventTypeLabels,
  getEnergyProductionScale: () => getEnergyProductionScale,
  parseWakeUpTime: () => parseWakeUpTime,
  wakeUpTime2FLiRS: () => wakeUpTime2FLiRS
});
module.exports = __toCommonJS(Types_exports);
var import_core = require("@zwave-js/core");
var AlarmSensorCommand;
(function(AlarmSensorCommand2) {
  AlarmSensorCommand2[AlarmSensorCommand2["Get"] = 1] = "Get";
  AlarmSensorCommand2[AlarmSensorCommand2["Report"] = 2] = "Report";
  AlarmSensorCommand2[AlarmSensorCommand2["SupportedGet"] = 3] = "SupportedGet";
  AlarmSensorCommand2[AlarmSensorCommand2["SupportedReport"] = 4] = "SupportedReport";
})(AlarmSensorCommand || (AlarmSensorCommand = {}));
var AlarmSensorType;
(function(AlarmSensorType2) {
  AlarmSensorType2[AlarmSensorType2["General Purpose"] = 0] = "General Purpose";
  AlarmSensorType2[AlarmSensorType2["Smoke"] = 1] = "Smoke";
  AlarmSensorType2[AlarmSensorType2["CO"] = 2] = "CO";
  AlarmSensorType2[AlarmSensorType2["CO2"] = 3] = "CO2";
  AlarmSensorType2[AlarmSensorType2["Heat"] = 4] = "Heat";
  AlarmSensorType2[AlarmSensorType2["Water Leak"] = 5] = "Water Leak";
  AlarmSensorType2[AlarmSensorType2["Any"] = 255] = "Any";
})(AlarmSensorType || (AlarmSensorType = {}));
var AssociationCommand;
(function(AssociationCommand2) {
  AssociationCommand2[AssociationCommand2["Set"] = 1] = "Set";
  AssociationCommand2[AssociationCommand2["Get"] = 2] = "Get";
  AssociationCommand2[AssociationCommand2["Report"] = 3] = "Report";
  AssociationCommand2[AssociationCommand2["Remove"] = 4] = "Remove";
  AssociationCommand2[AssociationCommand2["SupportedGroupingsGet"] = 5] = "SupportedGroupingsGet";
  AssociationCommand2[AssociationCommand2["SupportedGroupingsReport"] = 6] = "SupportedGroupingsReport";
  AssociationCommand2[AssociationCommand2["SpecificGroupGet"] = 11] = "SpecificGroupGet";
  AssociationCommand2[AssociationCommand2["SpecificGroupReport"] = 12] = "SpecificGroupReport";
})(AssociationCommand || (AssociationCommand = {}));
var AssociationCheckResult;
(function(AssociationCheckResult2) {
  AssociationCheckResult2[AssociationCheckResult2["OK"] = 1] = "OK";
  AssociationCheckResult2[AssociationCheckResult2["Forbidden_DestinationIsLongRange"] = 2] = "Forbidden_DestinationIsLongRange";
  AssociationCheckResult2[AssociationCheckResult2["Forbidden_SourceIsLongRange"] = 3] = "Forbidden_SourceIsLongRange";
  AssociationCheckResult2[AssociationCheckResult2["Forbidden_SelfAssociation"] = 4] = "Forbidden_SelfAssociation";
  AssociationCheckResult2[AssociationCheckResult2["Forbidden_SecurityClassMismatch"] = 5] = "Forbidden_SecurityClassMismatch";
  AssociationCheckResult2[AssociationCheckResult2["Forbidden_DestinationSecurityClassNotGranted"] = 6] = "Forbidden_DestinationSecurityClassNotGranted";
  AssociationCheckResult2[AssociationCheckResult2["Forbidden_NoSupportedCCs"] = 7] = "Forbidden_NoSupportedCCs";
})(AssociationCheckResult || (AssociationCheckResult = {}));
var AssociationGroupInfoCommand;
(function(AssociationGroupInfoCommand2) {
  AssociationGroupInfoCommand2[AssociationGroupInfoCommand2["NameGet"] = 1] = "NameGet";
  AssociationGroupInfoCommand2[AssociationGroupInfoCommand2["NameReport"] = 2] = "NameReport";
  AssociationGroupInfoCommand2[AssociationGroupInfoCommand2["InfoGet"] = 3] = "InfoGet";
  AssociationGroupInfoCommand2[AssociationGroupInfoCommand2["InfoReport"] = 4] = "InfoReport";
  AssociationGroupInfoCommand2[AssociationGroupInfoCommand2["CommandListGet"] = 5] = "CommandListGet";
  AssociationGroupInfoCommand2[AssociationGroupInfoCommand2["CommandListReport"] = 6] = "CommandListReport";
})(AssociationGroupInfoCommand || (AssociationGroupInfoCommand = {}));
var AssociationGroupInfoProfile;
(function(AssociationGroupInfoProfile2) {
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["General: N/A"] = 0] = "General: N/A";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["General: Lifeline"] = 1] = "General: Lifeline";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 01"] = 8193] = "Control: Key 01";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 02"] = 8194] = "Control: Key 02";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 03"] = 8195] = "Control: Key 03";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 04"] = 8196] = "Control: Key 04";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 05"] = 8197] = "Control: Key 05";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 06"] = 8198] = "Control: Key 06";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 07"] = 8199] = "Control: Key 07";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 08"] = 8200] = "Control: Key 08";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 09"] = 8201] = "Control: Key 09";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 10"] = 8202] = "Control: Key 10";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 11"] = 8203] = "Control: Key 11";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 12"] = 8204] = "Control: Key 12";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 13"] = 8205] = "Control: Key 13";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 14"] = 8206] = "Control: Key 14";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 15"] = 8207] = "Control: Key 15";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 16"] = 8208] = "Control: Key 16";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 17"] = 8209] = "Control: Key 17";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 18"] = 8210] = "Control: Key 18";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 19"] = 8211] = "Control: Key 19";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 20"] = 8212] = "Control: Key 20";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 21"] = 8213] = "Control: Key 21";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 22"] = 8214] = "Control: Key 22";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 23"] = 8215] = "Control: Key 23";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 24"] = 8216] = "Control: Key 24";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 25"] = 8217] = "Control: Key 25";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 26"] = 8218] = "Control: Key 26";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 27"] = 8219] = "Control: Key 27";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 28"] = 8220] = "Control: Key 28";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 29"] = 8221] = "Control: Key 29";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 30"] = 8222] = "Control: Key 30";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 31"] = 8223] = "Control: Key 31";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Control: Key 32"] = 8224] = "Control: Key 32";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Air temperature"] = 12545] = "Sensor: Air temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: General purpose"] = 12546] = "Sensor: General purpose";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Illuminance"] = 12547] = "Sensor: Illuminance";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Power"] = 12548] = "Sensor: Power";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Humidity"] = 12549] = "Sensor: Humidity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Velocity"] = 12550] = "Sensor: Velocity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Direction"] = 12551] = "Sensor: Direction";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Atmospheric pressure"] = 12552] = "Sensor: Atmospheric pressure";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Barometric pressure"] = 12553] = "Sensor: Barometric pressure";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Solar radiation"] = 12554] = "Sensor: Solar radiation";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Dew point"] = 12555] = "Sensor: Dew point";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Rain rate"] = 12556] = "Sensor: Rain rate";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Tide level"] = 12557] = "Sensor: Tide level";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Weight"] = 12558] = "Sensor: Weight";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Voltage"] = 12559] = "Sensor: Voltage";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Current"] = 12560] = "Sensor: Current";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Carbon dioxide (CO2) level"] = 12561] = "Sensor: Carbon dioxide (CO2) level";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Air flow"] = 12562] = "Sensor: Air flow";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Tank capacity"] = 12563] = "Sensor: Tank capacity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Distance"] = 12564] = "Sensor: Distance";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Angle position"] = 12565] = "Sensor: Angle position";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Rotation"] = 12566] = "Sensor: Rotation";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Water temperature"] = 12567] = "Sensor: Water temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Soil temperature"] = 12568] = "Sensor: Soil temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Seismic Intensity"] = 12569] = "Sensor: Seismic Intensity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Seismic magnitude"] = 12570] = "Sensor: Seismic magnitude";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Ultraviolet"] = 12571] = "Sensor: Ultraviolet";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Electrical resistivity"] = 12572] = "Sensor: Electrical resistivity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Electrical conductivity"] = 12573] = "Sensor: Electrical conductivity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Loudness"] = 12574] = "Sensor: Loudness";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Moisture"] = 12575] = "Sensor: Moisture";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Frequency"] = 12576] = "Sensor: Frequency";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Time"] = 12577] = "Sensor: Time";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Target temperature"] = 12578] = "Sensor: Target temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Particulate Matter 2.5"] = 12579] = "Sensor: Particulate Matter 2.5";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Formaldehyde (CH2O) level"] = 12580] = "Sensor: Formaldehyde (CH2O) level";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Radon concentration"] = 12581] = "Sensor: Radon concentration";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Methane (CH4) density"] = 12582] = "Sensor: Methane (CH4) density";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Volatile Organic Compound level"] = 12583] = "Sensor: Volatile Organic Compound level";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Carbon monoxide (CO) level"] = 12584] = "Sensor: Carbon monoxide (CO) level";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Soil humidity"] = 12585] = "Sensor: Soil humidity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Soil reactivity"] = 12586] = "Sensor: Soil reactivity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Soil salinity"] = 12587] = "Sensor: Soil salinity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Heart rate"] = 12588] = "Sensor: Heart rate";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Blood pressure"] = 12589] = "Sensor: Blood pressure";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Muscle mass"] = 12590] = "Sensor: Muscle mass";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Fat mass"] = 12591] = "Sensor: Fat mass";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Bone mass"] = 12592] = "Sensor: Bone mass";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Total body water (TBW)"] = 12593] = "Sensor: Total body water (TBW)";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Basis metabolic rate (BMR)"] = 12594] = "Sensor: Basis metabolic rate (BMR)";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Body Mass Index (BMI)"] = 12595] = "Sensor: Body Mass Index (BMI)";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Acceleration X-axis"] = 12596] = "Sensor: Acceleration X-axis";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Acceleration Y-axis"] = 12597] = "Sensor: Acceleration Y-axis";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Acceleration Z-axis"] = 12598] = "Sensor: Acceleration Z-axis";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Smoke density"] = 12599] = "Sensor: Smoke density";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Water flow"] = 12600] = "Sensor: Water flow";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Water pressure"] = 12601] = "Sensor: Water pressure";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: RF signal strength"] = 12602] = "Sensor: RF signal strength";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Particulate Matter 10"] = 12603] = "Sensor: Particulate Matter 10";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Respiratory rate"] = 12604] = "Sensor: Respiratory rate";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Relative Modulation level"] = 12605] = "Sensor: Relative Modulation level";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Boiler water temperature"] = 12606] = "Sensor: Boiler water temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Domestic Hot Water (DHW) temperature"] = 12607] = "Sensor: Domestic Hot Water (DHW) temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Outside temperature"] = 12608] = "Sensor: Outside temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Exhaust temperature"] = 12609] = "Sensor: Exhaust temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Water Chlorine level"] = 12610] = "Sensor: Water Chlorine level";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Water acidity"] = 12611] = "Sensor: Water acidity";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Water Oxidation reduction potential"] = 12612] = "Sensor: Water Oxidation reduction potential";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Heart Rate LF/HF ratio"] = 12613] = "Sensor: Heart Rate LF/HF ratio";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Motion Direction"] = 12614] = "Sensor: Motion Direction";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Applied force on the sensor"] = 12615] = "Sensor: Applied force on the sensor";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Return Air temperature"] = 12616] = "Sensor: Return Air temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Supply Air temperature"] = 12617] = "Sensor: Supply Air temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Condenser Coil temperature"] = 12618] = "Sensor: Condenser Coil temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Evaporator Coil temperature"] = 12619] = "Sensor: Evaporator Coil temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Liquid Line temperature"] = 12620] = "Sensor: Liquid Line temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Discharge Line temperature"] = 12621] = "Sensor: Discharge Line temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Suction Pressure"] = 12622] = "Sensor: Suction Pressure";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Discharge Pressure"] = 12623] = "Sensor: Discharge Pressure";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Sensor: Defrost temperature"] = 12624] = "Sensor: Defrost temperature";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Smoke Alarm"] = 28929] = "Notification: Smoke Alarm";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: CO Alarm"] = 28930] = "Notification: CO Alarm";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: CO2 Alarm"] = 28931] = "Notification: CO2 Alarm";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Heat Alarm"] = 28932] = "Notification: Heat Alarm";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Water Alarm"] = 28933] = "Notification: Water Alarm";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Access Control"] = 28934] = "Notification: Access Control";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Home Security"] = 28935] = "Notification: Home Security";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Power Management"] = 28936] = "Notification: Power Management";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: System"] = 28937] = "Notification: System";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Emergency Alarm"] = 28938] = "Notification: Emergency Alarm";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Clock"] = 28939] = "Notification: Clock";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Appliance"] = 28940] = "Notification: Appliance";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Home Health"] = 28941] = "Notification: Home Health";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Siren"] = 28942] = "Notification: Siren";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Water Valve"] = 28943] = "Notification: Water Valve";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Weather Alarm"] = 28944] = "Notification: Weather Alarm";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Irrigation"] = 28945] = "Notification: Irrigation";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Gas alarm"] = 28946] = "Notification: Gas alarm";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Pest Control"] = 28947] = "Notification: Pest Control";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Light sensor"] = 28948] = "Notification: Light sensor";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Water Quality Monitoring"] = 28949] = "Notification: Water Quality Monitoring";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Notification: Home monitoring"] = 28950] = "Notification: Home monitoring";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Meter: Electric"] = 12801] = "Meter: Electric";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Meter: Gas"] = 12802] = "Meter: Gas";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Meter: Water"] = 12803] = "Meter: Water";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Meter: Heating"] = 12804] = "Meter: Heating";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Meter: Cooling"] = 12805] = "Meter: Cooling";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 01"] = 27393] = "Irrigation: Channel 01";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 02"] = 27394] = "Irrigation: Channel 02";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 03"] = 27395] = "Irrigation: Channel 03";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 04"] = 27396] = "Irrigation: Channel 04";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 05"] = 27397] = "Irrigation: Channel 05";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 06"] = 27398] = "Irrigation: Channel 06";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 07"] = 27399] = "Irrigation: Channel 07";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 08"] = 27400] = "Irrigation: Channel 08";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 09"] = 27401] = "Irrigation: Channel 09";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 10"] = 27402] = "Irrigation: Channel 10";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 11"] = 27403] = "Irrigation: Channel 11";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 12"] = 27404] = "Irrigation: Channel 12";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 13"] = 27405] = "Irrigation: Channel 13";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 14"] = 27406] = "Irrigation: Channel 14";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 15"] = 27407] = "Irrigation: Channel 15";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 16"] = 27408] = "Irrigation: Channel 16";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 17"] = 27409] = "Irrigation: Channel 17";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 18"] = 27410] = "Irrigation: Channel 18";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 19"] = 27411] = "Irrigation: Channel 19";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 20"] = 27412] = "Irrigation: Channel 20";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 21"] = 27413] = "Irrigation: Channel 21";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 22"] = 27414] = "Irrigation: Channel 22";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 23"] = 27415] = "Irrigation: Channel 23";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 24"] = 27416] = "Irrigation: Channel 24";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 25"] = 27417] = "Irrigation: Channel 25";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 26"] = 27418] = "Irrigation: Channel 26";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 27"] = 27419] = "Irrigation: Channel 27";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 28"] = 27420] = "Irrigation: Channel 28";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 29"] = 27421] = "Irrigation: Channel 29";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 30"] = 27422] = "Irrigation: Channel 30";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 31"] = 27423] = "Irrigation: Channel 31";
  AssociationGroupInfoProfile2[AssociationGroupInfoProfile2["Irrigation: Channel 32"] = 27424] = "Irrigation: Channel 32";
})(AssociationGroupInfoProfile || (AssociationGroupInfoProfile = {}));
var BarrierOperatorCommand;
(function(BarrierOperatorCommand2) {
  BarrierOperatorCommand2[BarrierOperatorCommand2["Set"] = 1] = "Set";
  BarrierOperatorCommand2[BarrierOperatorCommand2["Get"] = 2] = "Get";
  BarrierOperatorCommand2[BarrierOperatorCommand2["Report"] = 3] = "Report";
  BarrierOperatorCommand2[BarrierOperatorCommand2["SignalingCapabilitiesGet"] = 4] = "SignalingCapabilitiesGet";
  BarrierOperatorCommand2[BarrierOperatorCommand2["SignalingCapabilitiesReport"] = 5] = "SignalingCapabilitiesReport";
  BarrierOperatorCommand2[BarrierOperatorCommand2["EventSignalingSet"] = 6] = "EventSignalingSet";
  BarrierOperatorCommand2[BarrierOperatorCommand2["EventSignalingGet"] = 7] = "EventSignalingGet";
  BarrierOperatorCommand2[BarrierOperatorCommand2["EventSignalingReport"] = 8] = "EventSignalingReport";
})(BarrierOperatorCommand || (BarrierOperatorCommand = {}));
var BarrierState;
(function(BarrierState2) {
  BarrierState2[BarrierState2["Closed"] = 0] = "Closed";
  BarrierState2[BarrierState2["Closing"] = 252] = "Closing";
  BarrierState2[BarrierState2["Stopped"] = 253] = "Stopped";
  BarrierState2[BarrierState2["Opening"] = 254] = "Opening";
  BarrierState2[BarrierState2["Open"] = 255] = "Open";
})(BarrierState || (BarrierState = {}));
var SubsystemType;
(function(SubsystemType2) {
  SubsystemType2[SubsystemType2["Audible"] = 1] = "Audible";
  SubsystemType2[SubsystemType2["Visual"] = 2] = "Visual";
})(SubsystemType || (SubsystemType = {}));
var SubsystemState;
(function(SubsystemState2) {
  SubsystemState2[SubsystemState2["Off"] = 0] = "Off";
  SubsystemState2[SubsystemState2["On"] = 255] = "On";
})(SubsystemState || (SubsystemState = {}));
var BasicCommand;
(function(BasicCommand2) {
  BasicCommand2[BasicCommand2["Set"] = 1] = "Set";
  BasicCommand2[BasicCommand2["Get"] = 2] = "Get";
  BasicCommand2[BasicCommand2["Report"] = 3] = "Report";
})(BasicCommand || (BasicCommand = {}));
var BasicWindowCoveringCommand;
(function(BasicWindowCoveringCommand2) {
  BasicWindowCoveringCommand2[BasicWindowCoveringCommand2["StartLevelChange"] = 1] = "StartLevelChange";
  BasicWindowCoveringCommand2[BasicWindowCoveringCommand2["StopLevelChange"] = 2] = "StopLevelChange";
})(BasicWindowCoveringCommand || (BasicWindowCoveringCommand = {}));
var BatteryChargingStatus;
(function(BatteryChargingStatus2) {
  BatteryChargingStatus2[BatteryChargingStatus2["Discharging"] = 0] = "Discharging";
  BatteryChargingStatus2[BatteryChargingStatus2["Charging"] = 1] = "Charging";
  BatteryChargingStatus2[BatteryChargingStatus2["Maintaining"] = 2] = "Maintaining";
})(BatteryChargingStatus || (BatteryChargingStatus = {}));
var BatteryReplacementStatus;
(function(BatteryReplacementStatus2) {
  BatteryReplacementStatus2[BatteryReplacementStatus2["No"] = 0] = "No";
  BatteryReplacementStatus2[BatteryReplacementStatus2["Soon"] = 1] = "Soon";
  BatteryReplacementStatus2[BatteryReplacementStatus2["Now"] = 2] = "Now";
})(BatteryReplacementStatus || (BatteryReplacementStatus = {}));
var BatteryCommand;
(function(BatteryCommand2) {
  BatteryCommand2[BatteryCommand2["Get"] = 2] = "Get";
  BatteryCommand2[BatteryCommand2["Report"] = 3] = "Report";
  BatteryCommand2[BatteryCommand2["HealthGet"] = 4] = "HealthGet";
  BatteryCommand2[BatteryCommand2["HealthReport"] = 5] = "HealthReport";
})(BatteryCommand || (BatteryCommand = {}));
var BinarySensorCommand;
(function(BinarySensorCommand2) {
  BinarySensorCommand2[BinarySensorCommand2["Get"] = 2] = "Get";
  BinarySensorCommand2[BinarySensorCommand2["Report"] = 3] = "Report";
  BinarySensorCommand2[BinarySensorCommand2["SupportedGet"] = 1] = "SupportedGet";
  BinarySensorCommand2[BinarySensorCommand2["SupportedReport"] = 4] = "SupportedReport";
})(BinarySensorCommand || (BinarySensorCommand = {}));
var BinarySensorType;
(function(BinarySensorType2) {
  BinarySensorType2[BinarySensorType2["General Purpose"] = 1] = "General Purpose";
  BinarySensorType2[BinarySensorType2["Smoke"] = 2] = "Smoke";
  BinarySensorType2[BinarySensorType2["CO"] = 3] = "CO";
  BinarySensorType2[BinarySensorType2["CO2"] = 4] = "CO2";
  BinarySensorType2[BinarySensorType2["Heat"] = 5] = "Heat";
  BinarySensorType2[BinarySensorType2["Water"] = 6] = "Water";
  BinarySensorType2[BinarySensorType2["Freeze"] = 7] = "Freeze";
  BinarySensorType2[BinarySensorType2["Tamper"] = 8] = "Tamper";
  BinarySensorType2[BinarySensorType2["Aux"] = 9] = "Aux";
  BinarySensorType2[BinarySensorType2["Door/Window"] = 10] = "Door/Window";
  BinarySensorType2[BinarySensorType2["Tilt"] = 11] = "Tilt";
  BinarySensorType2[BinarySensorType2["Motion"] = 12] = "Motion";
  BinarySensorType2[BinarySensorType2["Glass Break"] = 13] = "Glass Break";
  BinarySensorType2[BinarySensorType2["Any"] = 255] = "Any";
})(BinarySensorType || (BinarySensorType = {}));
var BinarySwitchCommand;
(function(BinarySwitchCommand2) {
  BinarySwitchCommand2[BinarySwitchCommand2["Set"] = 1] = "Set";
  BinarySwitchCommand2[BinarySwitchCommand2["Get"] = 2] = "Get";
  BinarySwitchCommand2[BinarySwitchCommand2["Report"] = 3] = "Report";
})(BinarySwitchCommand || (BinarySwitchCommand = {}));
var CentralSceneCommand;
(function(CentralSceneCommand2) {
  CentralSceneCommand2[CentralSceneCommand2["SupportedGet"] = 1] = "SupportedGet";
  CentralSceneCommand2[CentralSceneCommand2["SupportedReport"] = 2] = "SupportedReport";
  CentralSceneCommand2[CentralSceneCommand2["Notification"] = 3] = "Notification";
  CentralSceneCommand2[CentralSceneCommand2["ConfigurationSet"] = 4] = "ConfigurationSet";
  CentralSceneCommand2[CentralSceneCommand2["ConfigurationGet"] = 5] = "ConfigurationGet";
  CentralSceneCommand2[CentralSceneCommand2["ConfigurationReport"] = 6] = "ConfigurationReport";
})(CentralSceneCommand || (CentralSceneCommand = {}));
var CentralSceneKeys;
(function(CentralSceneKeys2) {
  CentralSceneKeys2[CentralSceneKeys2["KeyPressed"] = 0] = "KeyPressed";
  CentralSceneKeys2[CentralSceneKeys2["KeyReleased"] = 1] = "KeyReleased";
  CentralSceneKeys2[CentralSceneKeys2["KeyHeldDown"] = 2] = "KeyHeldDown";
  CentralSceneKeys2[CentralSceneKeys2["KeyPressed2x"] = 3] = "KeyPressed2x";
  CentralSceneKeys2[CentralSceneKeys2["KeyPressed3x"] = 4] = "KeyPressed3x";
  CentralSceneKeys2[CentralSceneKeys2["KeyPressed4x"] = 5] = "KeyPressed4x";
  CentralSceneKeys2[CentralSceneKeys2["KeyPressed5x"] = 6] = "KeyPressed5x";
})(CentralSceneKeys || (CentralSceneKeys = {}));
var ClimateControlScheduleCommand;
(function(ClimateControlScheduleCommand2) {
  ClimateControlScheduleCommand2[ClimateControlScheduleCommand2["Set"] = 1] = "Set";
  ClimateControlScheduleCommand2[ClimateControlScheduleCommand2["Get"] = 2] = "Get";
  ClimateControlScheduleCommand2[ClimateControlScheduleCommand2["Report"] = 3] = "Report";
  ClimateControlScheduleCommand2[ClimateControlScheduleCommand2["ChangedGet"] = 4] = "ChangedGet";
  ClimateControlScheduleCommand2[ClimateControlScheduleCommand2["ChangedReport"] = 5] = "ChangedReport";
  ClimateControlScheduleCommand2[ClimateControlScheduleCommand2["OverrideSet"] = 6] = "OverrideSet";
  ClimateControlScheduleCommand2[ClimateControlScheduleCommand2["OverrideGet"] = 7] = "OverrideGet";
  ClimateControlScheduleCommand2[ClimateControlScheduleCommand2["OverrideReport"] = 8] = "OverrideReport";
})(ClimateControlScheduleCommand || (ClimateControlScheduleCommand = {}));
var ScheduleOverrideType;
(function(ScheduleOverrideType2) {
  ScheduleOverrideType2[ScheduleOverrideType2["None"] = 0] = "None";
  ScheduleOverrideType2[ScheduleOverrideType2["Temporary"] = 1] = "Temporary";
  ScheduleOverrideType2[ScheduleOverrideType2["Permanent"] = 2] = "Permanent";
})(ScheduleOverrideType || (ScheduleOverrideType = {}));
var ClockCommand;
(function(ClockCommand2) {
  ClockCommand2[ClockCommand2["Set"] = 4] = "Set";
  ClockCommand2[ClockCommand2["Get"] = 5] = "Get";
  ClockCommand2[ClockCommand2["Report"] = 6] = "Report";
})(ClockCommand || (ClockCommand = {}));
var Weekday;
(function(Weekday2) {
  Weekday2[Weekday2["Unknown"] = 0] = "Unknown";
  Weekday2[Weekday2["Monday"] = 1] = "Monday";
  Weekday2[Weekday2["Tuesday"] = 2] = "Tuesday";
  Weekday2[Weekday2["Wednesday"] = 3] = "Wednesday";
  Weekday2[Weekday2["Thursday"] = 4] = "Thursday";
  Weekday2[Weekday2["Friday"] = 5] = "Friday";
  Weekday2[Weekday2["Saturday"] = 6] = "Saturday";
  Weekday2[Weekday2["Sunday"] = 7] = "Sunday";
})(Weekday || (Weekday = {}));
var ColorSwitchCommand;
(function(ColorSwitchCommand2) {
  ColorSwitchCommand2[ColorSwitchCommand2["SupportedGet"] = 1] = "SupportedGet";
  ColorSwitchCommand2[ColorSwitchCommand2["SupportedReport"] = 2] = "SupportedReport";
  ColorSwitchCommand2[ColorSwitchCommand2["Get"] = 3] = "Get";
  ColorSwitchCommand2[ColorSwitchCommand2["Report"] = 4] = "Report";
  ColorSwitchCommand2[ColorSwitchCommand2["Set"] = 5] = "Set";
  ColorSwitchCommand2[ColorSwitchCommand2["StartLevelChange"] = 6] = "StartLevelChange";
  ColorSwitchCommand2[ColorSwitchCommand2["StopLevelChange"] = 7] = "StopLevelChange";
})(ColorSwitchCommand || (ColorSwitchCommand = {}));
var ColorComponent;
(function(ColorComponent2) {
  ColorComponent2[ColorComponent2["Warm White"] = 0] = "Warm White";
  ColorComponent2[ColorComponent2["Cold White"] = 1] = "Cold White";
  ColorComponent2[ColorComponent2["Red"] = 2] = "Red";
  ColorComponent2[ColorComponent2["Green"] = 3] = "Green";
  ColorComponent2[ColorComponent2["Blue"] = 4] = "Blue";
  ColorComponent2[ColorComponent2["Amber"] = 5] = "Amber";
  ColorComponent2[ColorComponent2["Cyan"] = 6] = "Cyan";
  ColorComponent2[ColorComponent2["Purple"] = 7] = "Purple";
  ColorComponent2[ColorComponent2["Index"] = 8] = "Index";
})(ColorComponent || (ColorComponent = {}));
const ColorComponentMap = {
  warmWhite: ColorComponent["Warm White"],
  coldWhite: ColorComponent["Cold White"],
  red: ColorComponent.Red,
  green: ColorComponent.Green,
  blue: ColorComponent.Blue,
  amber: ColorComponent.Amber,
  cyan: ColorComponent.Cyan,
  purple: ColorComponent.Purple,
  index: ColorComponent.Index
};
var ConfigurationCommand;
(function(ConfigurationCommand2) {
  ConfigurationCommand2[ConfigurationCommand2["Set"] = 4] = "Set";
  ConfigurationCommand2[ConfigurationCommand2["Get"] = 5] = "Get";
  ConfigurationCommand2[ConfigurationCommand2["Report"] = 6] = "Report";
  ConfigurationCommand2[ConfigurationCommand2["BulkSet"] = 7] = "BulkSet";
  ConfigurationCommand2[ConfigurationCommand2["BulkGet"] = 8] = "BulkGet";
  ConfigurationCommand2[ConfigurationCommand2["BulkReport"] = 9] = "BulkReport";
  ConfigurationCommand2[ConfigurationCommand2["NameGet"] = 10] = "NameGet";
  ConfigurationCommand2[ConfigurationCommand2["NameReport"] = 11] = "NameReport";
  ConfigurationCommand2[ConfigurationCommand2["InfoGet"] = 12] = "InfoGet";
  ConfigurationCommand2[ConfigurationCommand2["InfoReport"] = 13] = "InfoReport";
  ConfigurationCommand2[ConfigurationCommand2["PropertiesGet"] = 14] = "PropertiesGet";
  ConfigurationCommand2[ConfigurationCommand2["PropertiesReport"] = 15] = "PropertiesReport";
  ConfigurationCommand2[ConfigurationCommand2["DefaultReset"] = 1] = "DefaultReset";
})(ConfigurationCommand || (ConfigurationCommand = {}));
var CRC16Command;
(function(CRC16Command2) {
  CRC16Command2[CRC16Command2["CommandEncapsulation"] = 1] = "CommandEncapsulation";
})(CRC16Command || (CRC16Command = {}));
var DeviceResetLocallyCommand;
(function(DeviceResetLocallyCommand2) {
  DeviceResetLocallyCommand2[DeviceResetLocallyCommand2["Notification"] = 1] = "Notification";
})(DeviceResetLocallyCommand || (DeviceResetLocallyCommand = {}));
var DoorLockCommand;
(function(DoorLockCommand2) {
  DoorLockCommand2[DoorLockCommand2["OperationSet"] = 1] = "OperationSet";
  DoorLockCommand2[DoorLockCommand2["OperationGet"] = 2] = "OperationGet";
  DoorLockCommand2[DoorLockCommand2["OperationReport"] = 3] = "OperationReport";
  DoorLockCommand2[DoorLockCommand2["ConfigurationSet"] = 4] = "ConfigurationSet";
  DoorLockCommand2[DoorLockCommand2["ConfigurationGet"] = 5] = "ConfigurationGet";
  DoorLockCommand2[DoorLockCommand2["ConfigurationReport"] = 6] = "ConfigurationReport";
  DoorLockCommand2[DoorLockCommand2["CapabilitiesGet"] = 7] = "CapabilitiesGet";
  DoorLockCommand2[DoorLockCommand2["CapabilitiesReport"] = 8] = "CapabilitiesReport";
})(DoorLockCommand || (DoorLockCommand = {}));
var DoorLockMode;
(function(DoorLockMode2) {
  DoorLockMode2[DoorLockMode2["Unsecured"] = 0] = "Unsecured";
  DoorLockMode2[DoorLockMode2["UnsecuredWithTimeout"] = 1] = "UnsecuredWithTimeout";
  DoorLockMode2[DoorLockMode2["InsideUnsecured"] = 16] = "InsideUnsecured";
  DoorLockMode2[DoorLockMode2["InsideUnsecuredWithTimeout"] = 17] = "InsideUnsecuredWithTimeout";
  DoorLockMode2[DoorLockMode2["OutsideUnsecured"] = 32] = "OutsideUnsecured";
  DoorLockMode2[DoorLockMode2["OutsideUnsecuredWithTimeout"] = 33] = "OutsideUnsecuredWithTimeout";
  DoorLockMode2[DoorLockMode2["Unknown"] = 254] = "Unknown";
  DoorLockMode2[DoorLockMode2["Secured"] = 255] = "Secured";
})(DoorLockMode || (DoorLockMode = {}));
var DoorLockOperationType;
(function(DoorLockOperationType2) {
  DoorLockOperationType2[DoorLockOperationType2["Constant"] = 1] = "Constant";
  DoorLockOperationType2[DoorLockOperationType2["Timed"] = 2] = "Timed";
})(DoorLockOperationType || (DoorLockOperationType = {}));
var EnergyProductionCommand;
(function(EnergyProductionCommand2) {
  EnergyProductionCommand2[EnergyProductionCommand2["Get"] = 2] = "Get";
  EnergyProductionCommand2[EnergyProductionCommand2["Report"] = 3] = "Report";
})(EnergyProductionCommand || (EnergyProductionCommand = {}));
var EnergyProductionParameter;
(function(EnergyProductionParameter2) {
  EnergyProductionParameter2[EnergyProductionParameter2["Power"] = 0] = "Power";
  EnergyProductionParameter2[EnergyProductionParameter2["Production Total"] = 1] = "Production Total";
  EnergyProductionParameter2[EnergyProductionParameter2["Production Today"] = 2] = "Production Today";
  EnergyProductionParameter2[EnergyProductionParameter2["Total Time"] = 3] = "Total Time";
})(EnergyProductionParameter || (EnergyProductionParameter = {}));
function getEnergyProductionScale(parameter, key) {
  if (parameter === EnergyProductionParameter.Power && key === 0) {
    return {
      key,
      unit: "W"
    };
  } else if (parameter === EnergyProductionParameter["Production Total"] && key === 0) {
    return {
      key,
      unit: "Wh"
    };
  } else if (parameter === EnergyProductionParameter["Production Today"] && key === 0) {
    return {
      key,
      unit: "Wh"
    };
  } else if (parameter === EnergyProductionParameter["Total Time"]) {
    if (key === 0) {
      return {
        key,
        unit: "seconds"
      };
    } else if (key === 1) {
      return {
        key,
        unit: "hours"
      };
    }
  }
  return {
    key,
    unit: "unknown"
  };
}
__name(getEnergyProductionScale, "getEnergyProductionScale");
var EntryControlEventTypes;
(function(EntryControlEventTypes2) {
  EntryControlEventTypes2[EntryControlEventTypes2["Caching"] = 0] = "Caching";
  EntryControlEventTypes2[EntryControlEventTypes2["CachedKeys"] = 1] = "CachedKeys";
  EntryControlEventTypes2[EntryControlEventTypes2["Enter"] = 2] = "Enter";
  EntryControlEventTypes2[EntryControlEventTypes2["DisarmAll"] = 3] = "DisarmAll";
  EntryControlEventTypes2[EntryControlEventTypes2["ArmAll"] = 4] = "ArmAll";
  EntryControlEventTypes2[EntryControlEventTypes2["ArmAway"] = 5] = "ArmAway";
  EntryControlEventTypes2[EntryControlEventTypes2["ArmHome"] = 6] = "ArmHome";
  EntryControlEventTypes2[EntryControlEventTypes2["ExitDelay"] = 7] = "ExitDelay";
  EntryControlEventTypes2[EntryControlEventTypes2["Arm1"] = 8] = "Arm1";
  EntryControlEventTypes2[EntryControlEventTypes2["Arm2"] = 9] = "Arm2";
  EntryControlEventTypes2[EntryControlEventTypes2["Arm3"] = 10] = "Arm3";
  EntryControlEventTypes2[EntryControlEventTypes2["Arm4"] = 11] = "Arm4";
  EntryControlEventTypes2[EntryControlEventTypes2["Arm5"] = 12] = "Arm5";
  EntryControlEventTypes2[EntryControlEventTypes2["Arm6"] = 13] = "Arm6";
  EntryControlEventTypes2[EntryControlEventTypes2["Rfid"] = 14] = "Rfid";
  EntryControlEventTypes2[EntryControlEventTypes2["Bell"] = 15] = "Bell";
  EntryControlEventTypes2[EntryControlEventTypes2["Fire"] = 16] = "Fire";
  EntryControlEventTypes2[EntryControlEventTypes2["Police"] = 17] = "Police";
  EntryControlEventTypes2[EntryControlEventTypes2["AlertPanic"] = 18] = "AlertPanic";
  EntryControlEventTypes2[EntryControlEventTypes2["AlertMedical"] = 19] = "AlertMedical";
  EntryControlEventTypes2[EntryControlEventTypes2["GateOpen"] = 20] = "GateOpen";
  EntryControlEventTypes2[EntryControlEventTypes2["GateClose"] = 21] = "GateClose";
  EntryControlEventTypes2[EntryControlEventTypes2["Lock"] = 22] = "Lock";
  EntryControlEventTypes2[EntryControlEventTypes2["Unlock"] = 23] = "Unlock";
  EntryControlEventTypes2[EntryControlEventTypes2["Test"] = 24] = "Test";
  EntryControlEventTypes2[EntryControlEventTypes2["Cancel"] = 25] = "Cancel";
})(EntryControlEventTypes || (EntryControlEventTypes = {}));
const entryControlEventTypeLabels = {
  [EntryControlEventTypes.Caching]: "Caching",
  [EntryControlEventTypes.CachedKeys]: "Cached keys",
  [EntryControlEventTypes.Enter]: "Enter",
  [EntryControlEventTypes.DisarmAll]: "Disarm all",
  [EntryControlEventTypes.ArmAll]: "Arm all",
  [EntryControlEventTypes.ArmAway]: "Away",
  [EntryControlEventTypes.ArmHome]: "Home",
  [EntryControlEventTypes.ExitDelay]: "Arm delay",
  [EntryControlEventTypes.Arm1]: "Arm zone 1",
  [EntryControlEventTypes.Arm2]: "Arm zone 2",
  [EntryControlEventTypes.Arm3]: "Arm zone 3",
  [EntryControlEventTypes.Arm4]: "Arm zone 4",
  [EntryControlEventTypes.Arm5]: "Arm zone 5",
  [EntryControlEventTypes.Arm6]: "Arm zone 6",
  [EntryControlEventTypes.Rfid]: "RFID",
  [EntryControlEventTypes.Bell]: "Bell",
  [EntryControlEventTypes.Fire]: "Fire",
  [EntryControlEventTypes.Police]: "Police",
  [EntryControlEventTypes.AlertPanic]: "Panic alert",
  [EntryControlEventTypes.AlertMedical]: "Medical alert",
  [EntryControlEventTypes.GateOpen]: "Open gate",
  [EntryControlEventTypes.GateClose]: "Close gate",
  [EntryControlEventTypes.Lock]: "Lock",
  [EntryControlEventTypes.Unlock]: "Unlock",
  [EntryControlEventTypes.Test]: "Test",
  [EntryControlEventTypes.Cancel]: "Cancel"
};
var DoorLockLoggingCommand;
(function(DoorLockLoggingCommand2) {
  DoorLockLoggingCommand2[DoorLockLoggingCommand2["RecordsSupportedGet"] = 1] = "RecordsSupportedGet";
  DoorLockLoggingCommand2[DoorLockLoggingCommand2["RecordsSupportedReport"] = 2] = "RecordsSupportedReport";
  DoorLockLoggingCommand2[DoorLockLoggingCommand2["RecordGet"] = 3] = "RecordGet";
  DoorLockLoggingCommand2[DoorLockLoggingCommand2["RecordReport"] = 4] = "RecordReport";
})(DoorLockLoggingCommand || (DoorLockLoggingCommand = {}));
var DoorLockLoggingEventType;
(function(DoorLockLoggingEventType2) {
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockCode"] = 1] = "LockCode";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockCode"] = 2] = "UnlockCode";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockButton"] = 3] = "LockButton";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockButton"] = 4] = "UnlockButton";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockCodeOutOfSchedule"] = 5] = "LockCodeOutOfSchedule";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockCodeOutOfSchedule"] = 6] = "UnlockCodeOutOfSchedule";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["IllegalCode"] = 7] = "IllegalCode";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockManual"] = 8] = "LockManual";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockManual"] = 9] = "UnlockManual";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockAuto"] = 10] = "LockAuto";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockAuto"] = 11] = "UnlockAuto";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockRemoteCode"] = 12] = "LockRemoteCode";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockRemoteCode"] = 13] = "UnlockRemoteCode";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockRemote"] = 14] = "LockRemote";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockRemote"] = 15] = "UnlockRemote";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockRemoteCodeOutOfSchedule"] = 16] = "LockRemoteCodeOutOfSchedule";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockRemoteCodeOutOfSchedule"] = 17] = "UnlockRemoteCodeOutOfSchedule";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["RemoteIllegalCode"] = 18] = "RemoteIllegalCode";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockManual2"] = 19] = "LockManual2";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UnlockManual2"] = 20] = "UnlockManual2";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockSecured"] = 21] = "LockSecured";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockUnsecured"] = 22] = "LockUnsecured";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UserCodeAdded"] = 23] = "UserCodeAdded";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UserCodeDeleted"] = 24] = "UserCodeDeleted";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["AllUserCodesDeleted"] = 25] = "AllUserCodesDeleted";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["AdminCodeChanged"] = 26] = "AdminCodeChanged";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["UserCodeChanged"] = 27] = "UserCodeChanged";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LockReset"] = 28] = "LockReset";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["ConfigurationChanged"] = 29] = "ConfigurationChanged";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["LowBattery"] = 30] = "LowBattery";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["NewBattery"] = 31] = "NewBattery";
  DoorLockLoggingEventType2[DoorLockLoggingEventType2["Unknown"] = 32] = "Unknown";
})(DoorLockLoggingEventType || (DoorLockLoggingEventType = {}));
var DoorLockLoggingRecordStatus;
(function(DoorLockLoggingRecordStatus2) {
  DoorLockLoggingRecordStatus2[DoorLockLoggingRecordStatus2["Empty"] = 0] = "Empty";
  DoorLockLoggingRecordStatus2[DoorLockLoggingRecordStatus2["HoldsLegalData"] = 1] = "HoldsLegalData";
})(DoorLockLoggingRecordStatus || (DoorLockLoggingRecordStatus = {}));
var EntryControlCommand;
(function(EntryControlCommand2) {
  EntryControlCommand2[EntryControlCommand2["Notification"] = 1] = "Notification";
  EntryControlCommand2[EntryControlCommand2["KeySupportedGet"] = 2] = "KeySupportedGet";
  EntryControlCommand2[EntryControlCommand2["KeySupportedReport"] = 3] = "KeySupportedReport";
  EntryControlCommand2[EntryControlCommand2["EventSupportedGet"] = 4] = "EventSupportedGet";
  EntryControlCommand2[EntryControlCommand2["EventSupportedReport"] = 5] = "EventSupportedReport";
  EntryControlCommand2[EntryControlCommand2["ConfigurationSet"] = 6] = "ConfigurationSet";
  EntryControlCommand2[EntryControlCommand2["ConfigurationGet"] = 7] = "ConfigurationGet";
  EntryControlCommand2[EntryControlCommand2["ConfigurationReport"] = 8] = "ConfigurationReport";
})(EntryControlCommand || (EntryControlCommand = {}));
var EntryControlDataTypes;
(function(EntryControlDataTypes2) {
  EntryControlDataTypes2[EntryControlDataTypes2["None"] = 0] = "None";
  EntryControlDataTypes2[EntryControlDataTypes2["Raw"] = 1] = "Raw";
  EntryControlDataTypes2[EntryControlDataTypes2["ASCII"] = 2] = "ASCII";
  EntryControlDataTypes2[EntryControlDataTypes2["MD5"] = 3] = "MD5";
})(EntryControlDataTypes || (EntryControlDataTypes = {}));
var FirmwareUpdateMetaDataCommand;
(function(FirmwareUpdateMetaDataCommand2) {
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["MetaDataGet"] = 1] = "MetaDataGet";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["MetaDataReport"] = 2] = "MetaDataReport";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["RequestGet"] = 3] = "RequestGet";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["RequestReport"] = 4] = "RequestReport";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["Get"] = 5] = "Get";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["Report"] = 6] = "Report";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["StatusReport"] = 7] = "StatusReport";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["ActivationSet"] = 8] = "ActivationSet";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["ActivationReport"] = 9] = "ActivationReport";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["PrepareGet"] = 10] = "PrepareGet";
  FirmwareUpdateMetaDataCommand2[FirmwareUpdateMetaDataCommand2["PrepareReport"] = 11] = "PrepareReport";
})(FirmwareUpdateMetaDataCommand || (FirmwareUpdateMetaDataCommand = {}));
var FirmwareUpdateRequestStatus;
(function(FirmwareUpdateRequestStatus2) {
  FirmwareUpdateRequestStatus2[FirmwareUpdateRequestStatus2["Error_InvalidManufacturerOrFirmwareID"] = 0] = "Error_InvalidManufacturerOrFirmwareID";
  FirmwareUpdateRequestStatus2[FirmwareUpdateRequestStatus2["Error_AuthenticationExpected"] = 1] = "Error_AuthenticationExpected";
  FirmwareUpdateRequestStatus2[FirmwareUpdateRequestStatus2["Error_FragmentSizeTooLarge"] = 2] = "Error_FragmentSizeTooLarge";
  FirmwareUpdateRequestStatus2[FirmwareUpdateRequestStatus2["Error_NotUpgradable"] = 3] = "Error_NotUpgradable";
  FirmwareUpdateRequestStatus2[FirmwareUpdateRequestStatus2["Error_InvalidHardwareVersion"] = 4] = "Error_InvalidHardwareVersion";
  FirmwareUpdateRequestStatus2[FirmwareUpdateRequestStatus2["Error_FirmwareUpgradeInProgress"] = 5] = "Error_FirmwareUpgradeInProgress";
  FirmwareUpdateRequestStatus2[FirmwareUpdateRequestStatus2["Error_BatteryLow"] = 6] = "Error_BatteryLow";
  FirmwareUpdateRequestStatus2[FirmwareUpdateRequestStatus2["OK"] = 255] = "OK";
})(FirmwareUpdateRequestStatus || (FirmwareUpdateRequestStatus = {}));
var FirmwareUpdateStatus;
(function(FirmwareUpdateStatus2) {
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_Timeout"] = -1] = "Error_Timeout";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_Checksum"] = 0] = "Error_Checksum";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_TransmissionFailed"] = 1] = "Error_TransmissionFailed";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_InvalidManufacturerID"] = 2] = "Error_InvalidManufacturerID";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_InvalidFirmwareID"] = 3] = "Error_InvalidFirmwareID";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_InvalidFirmwareTarget"] = 4] = "Error_InvalidFirmwareTarget";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_InvalidHeaderInformation"] = 5] = "Error_InvalidHeaderInformation";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_InvalidHeaderFormat"] = 6] = "Error_InvalidHeaderFormat";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_InsufficientMemory"] = 7] = "Error_InsufficientMemory";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["Error_InvalidHardwareVersion"] = 8] = "Error_InvalidHardwareVersion";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["OK_WaitingForActivation"] = 253] = "OK_WaitingForActivation";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["OK_NoRestart"] = 254] = "OK_NoRestart";
  FirmwareUpdateStatus2[FirmwareUpdateStatus2["OK_RestartPending"] = 255] = "OK_RestartPending";
})(FirmwareUpdateStatus || (FirmwareUpdateStatus = {}));
var FirmwareUpdateActivationStatus;
(function(FirmwareUpdateActivationStatus2) {
  FirmwareUpdateActivationStatus2[FirmwareUpdateActivationStatus2["Error_InvalidFirmware"] = 0] = "Error_InvalidFirmware";
  FirmwareUpdateActivationStatus2[FirmwareUpdateActivationStatus2["Error_ActivationFailed"] = 1] = "Error_ActivationFailed";
  FirmwareUpdateActivationStatus2[FirmwareUpdateActivationStatus2["OK"] = 255] = "OK";
})(FirmwareUpdateActivationStatus || (FirmwareUpdateActivationStatus = {}));
var FirmwareDownloadStatus;
(function(FirmwareDownloadStatus2) {
  FirmwareDownloadStatus2[FirmwareDownloadStatus2["Error_InvalidManufacturerOrFirmwareID"] = 0] = "Error_InvalidManufacturerOrFirmwareID";
  FirmwareDownloadStatus2[FirmwareDownloadStatus2["Error_AuthenticationExpected"] = 1] = "Error_AuthenticationExpected";
  FirmwareDownloadStatus2[FirmwareDownloadStatus2["Error_FragmentSizeTooLarge"] = 2] = "Error_FragmentSizeTooLarge";
  FirmwareDownloadStatus2[FirmwareDownloadStatus2["Error_NotDownloadable"] = 3] = "Error_NotDownloadable";
  FirmwareDownloadStatus2[FirmwareDownloadStatus2["Error_InvalidHardwareVersion"] = 4] = "Error_InvalidHardwareVersion";
  FirmwareDownloadStatus2[FirmwareDownloadStatus2["OK"] = 255] = "OK";
})(FirmwareDownloadStatus || (FirmwareDownloadStatus = {}));
var HailCommand;
(function(HailCommand2) {
  HailCommand2[HailCommand2["Hail"] = 1] = "Hail";
})(HailCommand || (HailCommand = {}));
var HumidityControlModeCommand;
(function(HumidityControlModeCommand2) {
  HumidityControlModeCommand2[HumidityControlModeCommand2["Set"] = 1] = "Set";
  HumidityControlModeCommand2[HumidityControlModeCommand2["Get"] = 2] = "Get";
  HumidityControlModeCommand2[HumidityControlModeCommand2["Report"] = 3] = "Report";
  HumidityControlModeCommand2[HumidityControlModeCommand2["SupportedGet"] = 4] = "SupportedGet";
  HumidityControlModeCommand2[HumidityControlModeCommand2["SupportedReport"] = 5] = "SupportedReport";
})(HumidityControlModeCommand || (HumidityControlModeCommand = {}));
var HumidityControlMode;
(function(HumidityControlMode2) {
  HumidityControlMode2[HumidityControlMode2["Off"] = 0] = "Off";
  HumidityControlMode2[HumidityControlMode2["Humidify"] = 1] = "Humidify";
  HumidityControlMode2[HumidityControlMode2["De-humidify"] = 2] = "De-humidify";
  HumidityControlMode2[HumidityControlMode2["Auto"] = 3] = "Auto";
})(HumidityControlMode || (HumidityControlMode = {}));
var HumidityControlOperatingStateCommand;
(function(HumidityControlOperatingStateCommand2) {
  HumidityControlOperatingStateCommand2[HumidityControlOperatingStateCommand2["Get"] = 1] = "Get";
  HumidityControlOperatingStateCommand2[HumidityControlOperatingStateCommand2["Report"] = 2] = "Report";
})(HumidityControlOperatingStateCommand || (HumidityControlOperatingStateCommand = {}));
var HumidityControlOperatingState;
(function(HumidityControlOperatingState2) {
  HumidityControlOperatingState2[HumidityControlOperatingState2["Idle"] = 0] = "Idle";
  HumidityControlOperatingState2[HumidityControlOperatingState2["Humidifying"] = 1] = "Humidifying";
  HumidityControlOperatingState2[HumidityControlOperatingState2["De-humidifying"] = 2] = "De-humidifying";
})(HumidityControlOperatingState || (HumidityControlOperatingState = {}));
var HumidityControlSetpointCommand;
(function(HumidityControlSetpointCommand2) {
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["Set"] = 1] = "Set";
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["Get"] = 2] = "Get";
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["Report"] = 3] = "Report";
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["SupportedGet"] = 4] = "SupportedGet";
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["SupportedReport"] = 5] = "SupportedReport";
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["ScaleSupportedGet"] = 6] = "ScaleSupportedGet";
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["ScaleSupportedReport"] = 7] = "ScaleSupportedReport";
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["CapabilitiesGet"] = 8] = "CapabilitiesGet";
  HumidityControlSetpointCommand2[HumidityControlSetpointCommand2["CapabilitiesReport"] = 9] = "CapabilitiesReport";
})(HumidityControlSetpointCommand || (HumidityControlSetpointCommand = {}));
var HumidityControlSetpointType;
(function(HumidityControlSetpointType2) {
  HumidityControlSetpointType2[HumidityControlSetpointType2["N/A"] = 0] = "N/A";
  HumidityControlSetpointType2[HumidityControlSetpointType2["Humidifier"] = 1] = "Humidifier";
  HumidityControlSetpointType2[HumidityControlSetpointType2["De-humidifier"] = 2] = "De-humidifier";
  HumidityControlSetpointType2[HumidityControlSetpointType2["Auto"] = 3] = "Auto";
})(HumidityControlSetpointType || (HumidityControlSetpointType = {}));
var InclusionControllerCommand;
(function(InclusionControllerCommand2) {
  InclusionControllerCommand2[InclusionControllerCommand2["Initiate"] = 1] = "Initiate";
  InclusionControllerCommand2[InclusionControllerCommand2["Complete"] = 2] = "Complete";
})(InclusionControllerCommand || (InclusionControllerCommand = {}));
var InclusionControllerStep;
(function(InclusionControllerStep2) {
  InclusionControllerStep2[InclusionControllerStep2["ProxyInclusion"] = 1] = "ProxyInclusion";
  InclusionControllerStep2[InclusionControllerStep2["S0Inclusion"] = 2] = "S0Inclusion";
  InclusionControllerStep2[InclusionControllerStep2["ProxyInclusionReplace"] = 3] = "ProxyInclusionReplace";
})(InclusionControllerStep || (InclusionControllerStep = {}));
var InclusionControllerStatus;
(function(InclusionControllerStatus2) {
  InclusionControllerStatus2[InclusionControllerStatus2["OK"] = 1] = "OK";
  InclusionControllerStatus2[InclusionControllerStatus2["UserRejected"] = 2] = "UserRejected";
  InclusionControllerStatus2[InclusionControllerStatus2["Failed"] = 3] = "Failed";
  InclusionControllerStatus2[InclusionControllerStatus2["NotSupported"] = 4] = "NotSupported";
})(InclusionControllerStatus || (InclusionControllerStatus = {}));
var IndicatorCommand;
(function(IndicatorCommand2) {
  IndicatorCommand2[IndicatorCommand2["Set"] = 1] = "Set";
  IndicatorCommand2[IndicatorCommand2["Get"] = 2] = "Get";
  IndicatorCommand2[IndicatorCommand2["Report"] = 3] = "Report";
  IndicatorCommand2[IndicatorCommand2["SupportedGet"] = 4] = "SupportedGet";
  IndicatorCommand2[IndicatorCommand2["SupportedReport"] = 5] = "SupportedReport";
  IndicatorCommand2[IndicatorCommand2["DescriptionGet"] = 6] = "DescriptionGet";
  IndicatorCommand2[IndicatorCommand2["DescriptionReport"] = 7] = "DescriptionReport";
})(IndicatorCommand || (IndicatorCommand = {}));
var IrrigationCommand;
(function(IrrigationCommand2) {
  IrrigationCommand2[IrrigationCommand2["SystemInfoGet"] = 1] = "SystemInfoGet";
  IrrigationCommand2[IrrigationCommand2["SystemInfoReport"] = 2] = "SystemInfoReport";
  IrrigationCommand2[IrrigationCommand2["SystemStatusGet"] = 3] = "SystemStatusGet";
  IrrigationCommand2[IrrigationCommand2["SystemStatusReport"] = 4] = "SystemStatusReport";
  IrrigationCommand2[IrrigationCommand2["SystemConfigSet"] = 5] = "SystemConfigSet";
  IrrigationCommand2[IrrigationCommand2["SystemConfigGet"] = 6] = "SystemConfigGet";
  IrrigationCommand2[IrrigationCommand2["SystemConfigReport"] = 7] = "SystemConfigReport";
  IrrigationCommand2[IrrigationCommand2["ValveInfoGet"] = 8] = "ValveInfoGet";
  IrrigationCommand2[IrrigationCommand2["ValveInfoReport"] = 9] = "ValveInfoReport";
  IrrigationCommand2[IrrigationCommand2["ValveConfigSet"] = 10] = "ValveConfigSet";
  IrrigationCommand2[IrrigationCommand2["ValveConfigGet"] = 11] = "ValveConfigGet";
  IrrigationCommand2[IrrigationCommand2["ValveConfigReport"] = 12] = "ValveConfigReport";
  IrrigationCommand2[IrrigationCommand2["ValveRun"] = 13] = "ValveRun";
  IrrigationCommand2[IrrigationCommand2["ValveTableSet"] = 14] = "ValveTableSet";
  IrrigationCommand2[IrrigationCommand2["ValveTableGet"] = 15] = "ValveTableGet";
  IrrigationCommand2[IrrigationCommand2["ValveTableReport"] = 16] = "ValveTableReport";
  IrrigationCommand2[IrrigationCommand2["ValveTableRun"] = 17] = "ValveTableRun";
  IrrigationCommand2[IrrigationCommand2["SystemShutoff"] = 18] = "SystemShutoff";
})(IrrigationCommand || (IrrigationCommand = {}));
var IrrigationSensorPolarity;
(function(IrrigationSensorPolarity2) {
  IrrigationSensorPolarity2[IrrigationSensorPolarity2["Low"] = 0] = "Low";
  IrrigationSensorPolarity2[IrrigationSensorPolarity2["High"] = 1] = "High";
})(IrrigationSensorPolarity || (IrrigationSensorPolarity = {}));
var ValveType;
(function(ValveType2) {
  ValveType2[ValveType2["ZoneValve"] = 0] = "ZoneValve";
  ValveType2[ValveType2["MasterValve"] = 1] = "MasterValve";
})(ValveType || (ValveType = {}));
var LanguageCommand;
(function(LanguageCommand2) {
  LanguageCommand2[LanguageCommand2["Set"] = 1] = "Set";
  LanguageCommand2[LanguageCommand2["Get"] = 2] = "Get";
  LanguageCommand2[LanguageCommand2["Report"] = 3] = "Report";
})(LanguageCommand || (LanguageCommand = {}));
var LockCommand;
(function(LockCommand2) {
  LockCommand2[LockCommand2["Set"] = 1] = "Set";
  LockCommand2[LockCommand2["Get"] = 2] = "Get";
  LockCommand2[LockCommand2["Report"] = 3] = "Report";
})(LockCommand || (LockCommand = {}));
var ManufacturerSpecificCommand;
(function(ManufacturerSpecificCommand2) {
  ManufacturerSpecificCommand2[ManufacturerSpecificCommand2["Get"] = 4] = "Get";
  ManufacturerSpecificCommand2[ManufacturerSpecificCommand2["Report"] = 5] = "Report";
  ManufacturerSpecificCommand2[ManufacturerSpecificCommand2["DeviceSpecificGet"] = 6] = "DeviceSpecificGet";
  ManufacturerSpecificCommand2[ManufacturerSpecificCommand2["DeviceSpecificReport"] = 7] = "DeviceSpecificReport";
})(ManufacturerSpecificCommand || (ManufacturerSpecificCommand = {}));
var DeviceIdType;
(function(DeviceIdType2) {
  DeviceIdType2[DeviceIdType2["FactoryDefault"] = 0] = "FactoryDefault";
  DeviceIdType2[DeviceIdType2["SerialNumber"] = 1] = "SerialNumber";
  DeviceIdType2[DeviceIdType2["PseudoRandom"] = 2] = "PseudoRandom";
})(DeviceIdType || (DeviceIdType = {}));
var MeterCommand;
(function(MeterCommand2) {
  MeterCommand2[MeterCommand2["Get"] = 1] = "Get";
  MeterCommand2[MeterCommand2["Report"] = 2] = "Report";
  MeterCommand2[MeterCommand2["SupportedGet"] = 3] = "SupportedGet";
  MeterCommand2[MeterCommand2["SupportedReport"] = 4] = "SupportedReport";
  MeterCommand2[MeterCommand2["Reset"] = 5] = "Reset";
})(MeterCommand || (MeterCommand = {}));
var RateType;
(function(RateType2) {
  RateType2[RateType2["Unspecified"] = 0] = "Unspecified";
  RateType2[RateType2["Consumed"] = 1] = "Consumed";
  RateType2[RateType2["Produced"] = 2] = "Produced";
})(RateType || (RateType = {}));
var MultiChannelAssociationCommand;
(function(MultiChannelAssociationCommand2) {
  MultiChannelAssociationCommand2[MultiChannelAssociationCommand2["Set"] = 1] = "Set";
  MultiChannelAssociationCommand2[MultiChannelAssociationCommand2["Get"] = 2] = "Get";
  MultiChannelAssociationCommand2[MultiChannelAssociationCommand2["Report"] = 3] = "Report";
  MultiChannelAssociationCommand2[MultiChannelAssociationCommand2["Remove"] = 4] = "Remove";
  MultiChannelAssociationCommand2[MultiChannelAssociationCommand2["SupportedGroupingsGet"] = 5] = "SupportedGroupingsGet";
  MultiChannelAssociationCommand2[MultiChannelAssociationCommand2["SupportedGroupingsReport"] = 6] = "SupportedGroupingsReport";
})(MultiChannelAssociationCommand || (MultiChannelAssociationCommand = {}));
var MultiChannelCommand;
(function(MultiChannelCommand2) {
  MultiChannelCommand2[MultiChannelCommand2["GetV1"] = 4] = "GetV1";
  MultiChannelCommand2[MultiChannelCommand2["ReportV1"] = 5] = "ReportV1";
  MultiChannelCommand2[MultiChannelCommand2["CommandEncapsulationV1"] = 6] = "CommandEncapsulationV1";
  MultiChannelCommand2[MultiChannelCommand2["EndPointGet"] = 7] = "EndPointGet";
  MultiChannelCommand2[MultiChannelCommand2["EndPointReport"] = 8] = "EndPointReport";
  MultiChannelCommand2[MultiChannelCommand2["CapabilityGet"] = 9] = "CapabilityGet";
  MultiChannelCommand2[MultiChannelCommand2["CapabilityReport"] = 10] = "CapabilityReport";
  MultiChannelCommand2[MultiChannelCommand2["EndPointFind"] = 11] = "EndPointFind";
  MultiChannelCommand2[MultiChannelCommand2["EndPointFindReport"] = 12] = "EndPointFindReport";
  MultiChannelCommand2[MultiChannelCommand2["CommandEncapsulation"] = 13] = "CommandEncapsulation";
  MultiChannelCommand2[MultiChannelCommand2["AggregatedMembersGet"] = 14] = "AggregatedMembersGet";
  MultiChannelCommand2[MultiChannelCommand2["AggregatedMembersReport"] = 15] = "AggregatedMembersReport";
})(MultiChannelCommand || (MultiChannelCommand = {}));
var MultiCommandCommand;
(function(MultiCommandCommand2) {
  MultiCommandCommand2[MultiCommandCommand2["CommandEncapsulation"] = 1] = "CommandEncapsulation";
})(MultiCommandCommand || (MultiCommandCommand = {}));
var MultilevelSensorCommand;
(function(MultilevelSensorCommand2) {
  MultilevelSensorCommand2[MultilevelSensorCommand2["GetSupportedSensor"] = 1] = "GetSupportedSensor";
  MultilevelSensorCommand2[MultilevelSensorCommand2["SupportedSensorReport"] = 2] = "SupportedSensorReport";
  MultilevelSensorCommand2[MultilevelSensorCommand2["GetSupportedScale"] = 3] = "GetSupportedScale";
  MultilevelSensorCommand2[MultilevelSensorCommand2["Get"] = 4] = "Get";
  MultilevelSensorCommand2[MultilevelSensorCommand2["Report"] = 5] = "Report";
  MultilevelSensorCommand2[MultilevelSensorCommand2["SupportedScaleReport"] = 6] = "SupportedScaleReport";
})(MultilevelSensorCommand || (MultilevelSensorCommand = {}));
var MultilevelSwitchCommand;
(function(MultilevelSwitchCommand2) {
  MultilevelSwitchCommand2[MultilevelSwitchCommand2["Set"] = 1] = "Set";
  MultilevelSwitchCommand2[MultilevelSwitchCommand2["Get"] = 2] = "Get";
  MultilevelSwitchCommand2[MultilevelSwitchCommand2["Report"] = 3] = "Report";
  MultilevelSwitchCommand2[MultilevelSwitchCommand2["StartLevelChange"] = 4] = "StartLevelChange";
  MultilevelSwitchCommand2[MultilevelSwitchCommand2["StopLevelChange"] = 5] = "StopLevelChange";
  MultilevelSwitchCommand2[MultilevelSwitchCommand2["SupportedGet"] = 6] = "SupportedGet";
  MultilevelSwitchCommand2[MultilevelSwitchCommand2["SupportedReport"] = 7] = "SupportedReport";
})(MultilevelSwitchCommand || (MultilevelSwitchCommand = {}));
var LevelChangeDirection;
(function(LevelChangeDirection2) {
  LevelChangeDirection2[LevelChangeDirection2["up"] = 0] = "up";
  LevelChangeDirection2[LevelChangeDirection2["down"] = 1] = "down";
})(LevelChangeDirection || (LevelChangeDirection = {}));
var SwitchType;
(function(SwitchType2) {
  SwitchType2[SwitchType2["not supported"] = 0] = "not supported";
  SwitchType2[SwitchType2["Off/On"] = 1] = "Off/On";
  SwitchType2[SwitchType2["Down/Up"] = 2] = "Down/Up";
  SwitchType2[SwitchType2["Close/Open"] = 3] = "Close/Open";
  SwitchType2[SwitchType2["CCW/CW"] = 4] = "CCW/CW";
  SwitchType2[SwitchType2["Left/Right"] = 5] = "Left/Right";
  SwitchType2[SwitchType2["Reverse/Forward"] = 6] = "Reverse/Forward";
  SwitchType2[SwitchType2["Pull/Push"] = 7] = "Pull/Push";
})(SwitchType || (SwitchType = {}));
var NodeNamingAndLocationCommand;
(function(NodeNamingAndLocationCommand2) {
  NodeNamingAndLocationCommand2[NodeNamingAndLocationCommand2["NameSet"] = 1] = "NameSet";
  NodeNamingAndLocationCommand2[NodeNamingAndLocationCommand2["NameGet"] = 2] = "NameGet";
  NodeNamingAndLocationCommand2[NodeNamingAndLocationCommand2["NameReport"] = 3] = "NameReport";
  NodeNamingAndLocationCommand2[NodeNamingAndLocationCommand2["LocationSet"] = 4] = "LocationSet";
  NodeNamingAndLocationCommand2[NodeNamingAndLocationCommand2["LocationGet"] = 5] = "LocationGet";
  NodeNamingAndLocationCommand2[NodeNamingAndLocationCommand2["LocationReport"] = 6] = "LocationReport";
})(NodeNamingAndLocationCommand || (NodeNamingAndLocationCommand = {}));
var NotificationCommand;
(function(NotificationCommand2) {
  NotificationCommand2[NotificationCommand2["EventSupportedGet"] = 1] = "EventSupportedGet";
  NotificationCommand2[NotificationCommand2["EventSupportedReport"] = 2] = "EventSupportedReport";
  NotificationCommand2[NotificationCommand2["Get"] = 4] = "Get";
  NotificationCommand2[NotificationCommand2["Report"] = 5] = "Report";
  NotificationCommand2[NotificationCommand2["Set"] = 6] = "Set";
  NotificationCommand2[NotificationCommand2["SupportedGet"] = 7] = "SupportedGet";
  NotificationCommand2[NotificationCommand2["SupportedReport"] = 8] = "SupportedReport";
})(NotificationCommand || (NotificationCommand = {}));
var PowerlevelCommand;
(function(PowerlevelCommand2) {
  PowerlevelCommand2[PowerlevelCommand2["Set"] = 1] = "Set";
  PowerlevelCommand2[PowerlevelCommand2["Get"] = 2] = "Get";
  PowerlevelCommand2[PowerlevelCommand2["Report"] = 3] = "Report";
  PowerlevelCommand2[PowerlevelCommand2["TestNodeSet"] = 4] = "TestNodeSet";
  PowerlevelCommand2[PowerlevelCommand2["TestNodeGet"] = 5] = "TestNodeGet";
  PowerlevelCommand2[PowerlevelCommand2["TestNodeReport"] = 6] = "TestNodeReport";
})(PowerlevelCommand || (PowerlevelCommand = {}));
var Powerlevel;
(function(Powerlevel2) {
  Powerlevel2[Powerlevel2["Normal Power"] = 0] = "Normal Power";
  Powerlevel2[Powerlevel2["-1 dBm"] = 1] = "-1 dBm";
  Powerlevel2[Powerlevel2["-2 dBm"] = 2] = "-2 dBm";
  Powerlevel2[Powerlevel2["-3 dBm"] = 3] = "-3 dBm";
  Powerlevel2[Powerlevel2["-4 dBm"] = 4] = "-4 dBm";
  Powerlevel2[Powerlevel2["-5 dBm"] = 5] = "-5 dBm";
  Powerlevel2[Powerlevel2["-6 dBm"] = 6] = "-6 dBm";
  Powerlevel2[Powerlevel2["-7 dBm"] = 7] = "-7 dBm";
  Powerlevel2[Powerlevel2["-8 dBm"] = 8] = "-8 dBm";
  Powerlevel2[Powerlevel2["-9 dBm"] = 9] = "-9 dBm";
})(Powerlevel || (Powerlevel = {}));
var PowerlevelTestStatus;
(function(PowerlevelTestStatus2) {
  PowerlevelTestStatus2[PowerlevelTestStatus2["Failed"] = 0] = "Failed";
  PowerlevelTestStatus2[PowerlevelTestStatus2["Success"] = 1] = "Success";
  PowerlevelTestStatus2[PowerlevelTestStatus2["In Progress"] = 2] = "In Progress";
})(PowerlevelTestStatus || (PowerlevelTestStatus = {}));
var ProtectionCommand;
(function(ProtectionCommand2) {
  ProtectionCommand2[ProtectionCommand2["Set"] = 1] = "Set";
  ProtectionCommand2[ProtectionCommand2["Get"] = 2] = "Get";
  ProtectionCommand2[ProtectionCommand2["Report"] = 3] = "Report";
  ProtectionCommand2[ProtectionCommand2["SupportedGet"] = 4] = "SupportedGet";
  ProtectionCommand2[ProtectionCommand2["SupportedReport"] = 5] = "SupportedReport";
  ProtectionCommand2[ProtectionCommand2["ExclusiveControlSet"] = 6] = "ExclusiveControlSet";
  ProtectionCommand2[ProtectionCommand2["ExclusiveControlGet"] = 7] = "ExclusiveControlGet";
  ProtectionCommand2[ProtectionCommand2["ExclusiveControlReport"] = 8] = "ExclusiveControlReport";
  ProtectionCommand2[ProtectionCommand2["TimeoutSet"] = 9] = "TimeoutSet";
  ProtectionCommand2[ProtectionCommand2["TimeoutGet"] = 10] = "TimeoutGet";
  ProtectionCommand2[ProtectionCommand2["TimeoutReport"] = 11] = "TimeoutReport";
})(ProtectionCommand || (ProtectionCommand = {}));
var LocalProtectionState;
(function(LocalProtectionState2) {
  LocalProtectionState2[LocalProtectionState2["Unprotected"] = 0] = "Unprotected";
  LocalProtectionState2[LocalProtectionState2["ProtectedBySequence"] = 1] = "ProtectedBySequence";
  LocalProtectionState2[LocalProtectionState2["NoOperationPossible"] = 2] = "NoOperationPossible";
})(LocalProtectionState || (LocalProtectionState = {}));
var RFProtectionState;
(function(RFProtectionState2) {
  RFProtectionState2[RFProtectionState2["Unprotected"] = 0] = "Unprotected";
  RFProtectionState2[RFProtectionState2["NoControl"] = 1] = "NoControl";
  RFProtectionState2[RFProtectionState2["NoResponse"] = 2] = "NoResponse";
})(RFProtectionState || (RFProtectionState = {}));
var SceneActivationCommand;
(function(SceneActivationCommand2) {
  SceneActivationCommand2[SceneActivationCommand2["Set"] = 1] = "Set";
})(SceneActivationCommand || (SceneActivationCommand = {}));
var SceneActuatorConfigurationCommand;
(function(SceneActuatorConfigurationCommand2) {
  SceneActuatorConfigurationCommand2[SceneActuatorConfigurationCommand2["Set"] = 1] = "Set";
  SceneActuatorConfigurationCommand2[SceneActuatorConfigurationCommand2["Get"] = 2] = "Get";
  SceneActuatorConfigurationCommand2[SceneActuatorConfigurationCommand2["Report"] = 3] = "Report";
})(SceneActuatorConfigurationCommand || (SceneActuatorConfigurationCommand = {}));
var SceneControllerConfigurationCommand;
(function(SceneControllerConfigurationCommand2) {
  SceneControllerConfigurationCommand2[SceneControllerConfigurationCommand2["Set"] = 1] = "Set";
  SceneControllerConfigurationCommand2[SceneControllerConfigurationCommand2["Get"] = 2] = "Get";
  SceneControllerConfigurationCommand2[SceneControllerConfigurationCommand2["Report"] = 3] = "Report";
})(SceneControllerConfigurationCommand || (SceneControllerConfigurationCommand = {}));
var ScheduleEntryLockCommand;
(function(ScheduleEntryLockCommand2) {
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["EnableSet"] = 1] = "EnableSet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["EnableAllSet"] = 2] = "EnableAllSet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["WeekDayScheduleSet"] = 3] = "WeekDayScheduleSet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["WeekDayScheduleGet"] = 4] = "WeekDayScheduleGet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["WeekDayScheduleReport"] = 5] = "WeekDayScheduleReport";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["YearDayScheduleSet"] = 6] = "YearDayScheduleSet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["YearDayScheduleGet"] = 7] = "YearDayScheduleGet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["YearDayScheduleReport"] = 8] = "YearDayScheduleReport";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["SupportedGet"] = 9] = "SupportedGet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["SupportedReport"] = 10] = "SupportedReport";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["TimeOffsetGet"] = 11] = "TimeOffsetGet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["TimeOffsetReport"] = 12] = "TimeOffsetReport";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["TimeOffsetSet"] = 13] = "TimeOffsetSet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["DailyRepeatingScheduleGet"] = 14] = "DailyRepeatingScheduleGet";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["DailyRepeatingScheduleReport"] = 15] = "DailyRepeatingScheduleReport";
  ScheduleEntryLockCommand2[ScheduleEntryLockCommand2["DailyRepeatingScheduleSet"] = 16] = "DailyRepeatingScheduleSet";
})(ScheduleEntryLockCommand || (ScheduleEntryLockCommand = {}));
var ScheduleEntryLockSetAction;
(function(ScheduleEntryLockSetAction2) {
  ScheduleEntryLockSetAction2[ScheduleEntryLockSetAction2["Erase"] = 0] = "Erase";
  ScheduleEntryLockSetAction2[ScheduleEntryLockSetAction2["Set"] = 1] = "Set";
})(ScheduleEntryLockSetAction || (ScheduleEntryLockSetAction = {}));
var ScheduleEntryLockWeekday;
(function(ScheduleEntryLockWeekday2) {
  ScheduleEntryLockWeekday2[ScheduleEntryLockWeekday2["Sunday"] = 0] = "Sunday";
  ScheduleEntryLockWeekday2[ScheduleEntryLockWeekday2["Monday"] = 1] = "Monday";
  ScheduleEntryLockWeekday2[ScheduleEntryLockWeekday2["Tuesday"] = 2] = "Tuesday";
  ScheduleEntryLockWeekday2[ScheduleEntryLockWeekday2["Wednesday"] = 3] = "Wednesday";
  ScheduleEntryLockWeekday2[ScheduleEntryLockWeekday2["Thursday"] = 4] = "Thursday";
  ScheduleEntryLockWeekday2[ScheduleEntryLockWeekday2["Friday"] = 5] = "Friday";
  ScheduleEntryLockWeekday2[ScheduleEntryLockWeekday2["Saturday"] = 6] = "Saturday";
})(ScheduleEntryLockWeekday || (ScheduleEntryLockWeekday = {}));
var ScheduleEntryLockScheduleKind;
(function(ScheduleEntryLockScheduleKind2) {
  ScheduleEntryLockScheduleKind2[ScheduleEntryLockScheduleKind2["WeekDay"] = 0] = "WeekDay";
  ScheduleEntryLockScheduleKind2[ScheduleEntryLockScheduleKind2["YearDay"] = 1] = "YearDay";
  ScheduleEntryLockScheduleKind2[ScheduleEntryLockScheduleKind2["DailyRepeating"] = 2] = "DailyRepeating";
})(ScheduleEntryLockScheduleKind || (ScheduleEntryLockScheduleKind = {}));
var Security2Command;
(function(Security2Command2) {
  Security2Command2[Security2Command2["NonceGet"] = 1] = "NonceGet";
  Security2Command2[Security2Command2["NonceReport"] = 2] = "NonceReport";
  Security2Command2[Security2Command2["MessageEncapsulation"] = 3] = "MessageEncapsulation";
  Security2Command2[Security2Command2["KEXGet"] = 4] = "KEXGet";
  Security2Command2[Security2Command2["KEXReport"] = 5] = "KEXReport";
  Security2Command2[Security2Command2["KEXSet"] = 6] = "KEXSet";
  Security2Command2[Security2Command2["KEXFail"] = 7] = "KEXFail";
  Security2Command2[Security2Command2["PublicKeyReport"] = 8] = "PublicKeyReport";
  Security2Command2[Security2Command2["NetworkKeyGet"] = 9] = "NetworkKeyGet";
  Security2Command2[Security2Command2["NetworkKeyReport"] = 10] = "NetworkKeyReport";
  Security2Command2[Security2Command2["NetworkKeyVerify"] = 11] = "NetworkKeyVerify";
  Security2Command2[Security2Command2["TransferEnd"] = 12] = "TransferEnd";
  Security2Command2[Security2Command2["CommandsSupportedGet"] = 13] = "CommandsSupportedGet";
  Security2Command2[Security2Command2["CommandsSupportedReport"] = 14] = "CommandsSupportedReport";
})(Security2Command || (Security2Command = {}));
var SecurityCommand;
(function(SecurityCommand2) {
  SecurityCommand2[SecurityCommand2["CommandsSupportedGet"] = 2] = "CommandsSupportedGet";
  SecurityCommand2[SecurityCommand2["CommandsSupportedReport"] = 3] = "CommandsSupportedReport";
  SecurityCommand2[SecurityCommand2["SchemeGet"] = 4] = "SchemeGet";
  SecurityCommand2[SecurityCommand2["SchemeReport"] = 5] = "SchemeReport";
  SecurityCommand2[SecurityCommand2["SchemeInherit"] = 8] = "SchemeInherit";
  SecurityCommand2[SecurityCommand2["NetworkKeySet"] = 6] = "NetworkKeySet";
  SecurityCommand2[SecurityCommand2["NetworkKeyVerify"] = 7] = "NetworkKeyVerify";
  SecurityCommand2[SecurityCommand2["NonceGet"] = 64] = "NonceGet";
  SecurityCommand2[SecurityCommand2["NonceReport"] = 128] = "NonceReport";
  SecurityCommand2[SecurityCommand2["CommandEncapsulation"] = 129] = "CommandEncapsulation";
  SecurityCommand2[SecurityCommand2["CommandEncapsulationNonceGet"] = 193] = "CommandEncapsulationNonceGet";
})(SecurityCommand || (SecurityCommand = {}));
var SoundSwitchCommand;
(function(SoundSwitchCommand2) {
  SoundSwitchCommand2[SoundSwitchCommand2["TonesNumberGet"] = 1] = "TonesNumberGet";
  SoundSwitchCommand2[SoundSwitchCommand2["TonesNumberReport"] = 2] = "TonesNumberReport";
  SoundSwitchCommand2[SoundSwitchCommand2["ToneInfoGet"] = 3] = "ToneInfoGet";
  SoundSwitchCommand2[SoundSwitchCommand2["ToneInfoReport"] = 4] = "ToneInfoReport";
  SoundSwitchCommand2[SoundSwitchCommand2["ConfigurationSet"] = 5] = "ConfigurationSet";
  SoundSwitchCommand2[SoundSwitchCommand2["ConfigurationGet"] = 6] = "ConfigurationGet";
  SoundSwitchCommand2[SoundSwitchCommand2["ConfigurationReport"] = 7] = "ConfigurationReport";
  SoundSwitchCommand2[SoundSwitchCommand2["TonePlaySet"] = 8] = "TonePlaySet";
  SoundSwitchCommand2[SoundSwitchCommand2["TonePlayGet"] = 9] = "TonePlayGet";
  SoundSwitchCommand2[SoundSwitchCommand2["TonePlayReport"] = 10] = "TonePlayReport";
})(SoundSwitchCommand || (SoundSwitchCommand = {}));
var ToneId;
(function(ToneId2) {
  ToneId2[ToneId2["Off"] = 0] = "Off";
  ToneId2[ToneId2["Default"] = 255] = "Default";
})(ToneId || (ToneId = {}));
var SupervisionCommand;
(function(SupervisionCommand2) {
  SupervisionCommand2[SupervisionCommand2["Get"] = 1] = "Get";
  SupervisionCommand2[SupervisionCommand2["Report"] = 2] = "Report";
})(SupervisionCommand || (SupervisionCommand = {}));
var ThermostatFanModeCommand;
(function(ThermostatFanModeCommand2) {
  ThermostatFanModeCommand2[ThermostatFanModeCommand2["Set"] = 1] = "Set";
  ThermostatFanModeCommand2[ThermostatFanModeCommand2["Get"] = 2] = "Get";
  ThermostatFanModeCommand2[ThermostatFanModeCommand2["Report"] = 3] = "Report";
  ThermostatFanModeCommand2[ThermostatFanModeCommand2["SupportedGet"] = 4] = "SupportedGet";
  ThermostatFanModeCommand2[ThermostatFanModeCommand2["SupportedReport"] = 5] = "SupportedReport";
})(ThermostatFanModeCommand || (ThermostatFanModeCommand = {}));
var ThermostatFanMode;
(function(ThermostatFanMode2) {
  ThermostatFanMode2[ThermostatFanMode2["Auto low"] = 0] = "Auto low";
  ThermostatFanMode2[ThermostatFanMode2["Low"] = 1] = "Low";
  ThermostatFanMode2[ThermostatFanMode2["Auto high"] = 2] = "Auto high";
  ThermostatFanMode2[ThermostatFanMode2["High"] = 3] = "High";
  ThermostatFanMode2[ThermostatFanMode2["Auto medium"] = 4] = "Auto medium";
  ThermostatFanMode2[ThermostatFanMode2["Medium"] = 5] = "Medium";
  ThermostatFanMode2[ThermostatFanMode2["Circulation"] = 6] = "Circulation";
  ThermostatFanMode2[ThermostatFanMode2["Humidity circulation"] = 7] = "Humidity circulation";
  ThermostatFanMode2[ThermostatFanMode2["Left and right"] = 8] = "Left and right";
  ThermostatFanMode2[ThermostatFanMode2["Up and down"] = 9] = "Up and down";
  ThermostatFanMode2[ThermostatFanMode2["Quiet"] = 10] = "Quiet";
  ThermostatFanMode2[ThermostatFanMode2["External circulation"] = 11] = "External circulation";
})(ThermostatFanMode || (ThermostatFanMode = {}));
var ThermostatFanStateCommand;
(function(ThermostatFanStateCommand2) {
  ThermostatFanStateCommand2[ThermostatFanStateCommand2["Get"] = 2] = "Get";
  ThermostatFanStateCommand2[ThermostatFanStateCommand2["Report"] = 3] = "Report";
})(ThermostatFanStateCommand || (ThermostatFanStateCommand = {}));
var ThermostatFanState;
(function(ThermostatFanState2) {
  ThermostatFanState2[ThermostatFanState2["Idle / off"] = 0] = "Idle / off";
  ThermostatFanState2[ThermostatFanState2["Running / running low"] = 1] = "Running / running low";
  ThermostatFanState2[ThermostatFanState2["Running high"] = 2] = "Running high";
  ThermostatFanState2[ThermostatFanState2["Running medium"] = 3] = "Running medium";
  ThermostatFanState2[ThermostatFanState2["Circulation mode"] = 4] = "Circulation mode";
  ThermostatFanState2[ThermostatFanState2["Humidity circulation mode"] = 5] = "Humidity circulation mode";
  ThermostatFanState2[ThermostatFanState2["Right - left circulation mode"] = 6] = "Right - left circulation mode";
  ThermostatFanState2[ThermostatFanState2["Up - down circulation mode"] = 7] = "Up - down circulation mode";
  ThermostatFanState2[ThermostatFanState2["Quiet circulation mode"] = 8] = "Quiet circulation mode";
})(ThermostatFanState || (ThermostatFanState = {}));
var ThermostatModeCommand;
(function(ThermostatModeCommand2) {
  ThermostatModeCommand2[ThermostatModeCommand2["Set"] = 1] = "Set";
  ThermostatModeCommand2[ThermostatModeCommand2["Get"] = 2] = "Get";
  ThermostatModeCommand2[ThermostatModeCommand2["Report"] = 3] = "Report";
  ThermostatModeCommand2[ThermostatModeCommand2["SupportedGet"] = 4] = "SupportedGet";
  ThermostatModeCommand2[ThermostatModeCommand2["SupportedReport"] = 5] = "SupportedReport";
})(ThermostatModeCommand || (ThermostatModeCommand = {}));
var ThermostatMode;
(function(ThermostatMode2) {
  ThermostatMode2[ThermostatMode2["Off"] = 0] = "Off";
  ThermostatMode2[ThermostatMode2["Heat"] = 1] = "Heat";
  ThermostatMode2[ThermostatMode2["Cool"] = 2] = "Cool";
  ThermostatMode2[ThermostatMode2["Auto"] = 3] = "Auto";
  ThermostatMode2[ThermostatMode2["Auxiliary"] = 4] = "Auxiliary";
  ThermostatMode2[ThermostatMode2["Resume (on)"] = 5] = "Resume (on)";
  ThermostatMode2[ThermostatMode2["Fan"] = 6] = "Fan";
  ThermostatMode2[ThermostatMode2["Furnace"] = 7] = "Furnace";
  ThermostatMode2[ThermostatMode2["Dry"] = 8] = "Dry";
  ThermostatMode2[ThermostatMode2["Moist"] = 9] = "Moist";
  ThermostatMode2[ThermostatMode2["Auto changeover"] = 10] = "Auto changeover";
  ThermostatMode2[ThermostatMode2["Energy heat"] = 11] = "Energy heat";
  ThermostatMode2[ThermostatMode2["Energy cool"] = 12] = "Energy cool";
  ThermostatMode2[ThermostatMode2["Away"] = 13] = "Away";
  ThermostatMode2[ThermostatMode2["Full power"] = 15] = "Full power";
  ThermostatMode2[ThermostatMode2["Manufacturer specific"] = 31] = "Manufacturer specific";
})(ThermostatMode || (ThermostatMode = {}));
var ThermostatOperatingStateCommand;
(function(ThermostatOperatingStateCommand2) {
  ThermostatOperatingStateCommand2[ThermostatOperatingStateCommand2["Get"] = 2] = "Get";
  ThermostatOperatingStateCommand2[ThermostatOperatingStateCommand2["Report"] = 3] = "Report";
})(ThermostatOperatingStateCommand || (ThermostatOperatingStateCommand = {}));
var ThermostatOperatingState;
(function(ThermostatOperatingState2) {
  ThermostatOperatingState2[ThermostatOperatingState2["Idle"] = 0] = "Idle";
  ThermostatOperatingState2[ThermostatOperatingState2["Heating"] = 1] = "Heating";
  ThermostatOperatingState2[ThermostatOperatingState2["Cooling"] = 2] = "Cooling";
  ThermostatOperatingState2[ThermostatOperatingState2["Fan Only"] = 3] = "Fan Only";
  ThermostatOperatingState2[ThermostatOperatingState2["Pending Heat"] = 4] = "Pending Heat";
  ThermostatOperatingState2[ThermostatOperatingState2["Pending Cool"] = 5] = "Pending Cool";
  ThermostatOperatingState2[ThermostatOperatingState2["Vent/Economizer"] = 6] = "Vent/Economizer";
  ThermostatOperatingState2[ThermostatOperatingState2["Aux Heating"] = 7] = "Aux Heating";
  ThermostatOperatingState2[ThermostatOperatingState2["2nd Stage Heating"] = 8] = "2nd Stage Heating";
  ThermostatOperatingState2[ThermostatOperatingState2["2nd Stage Cooling"] = 9] = "2nd Stage Cooling";
  ThermostatOperatingState2[ThermostatOperatingState2["2nd Stage Aux Heat"] = 10] = "2nd Stage Aux Heat";
  ThermostatOperatingState2[ThermostatOperatingState2["3rd Stage Aux Heat"] = 11] = "3rd Stage Aux Heat";
})(ThermostatOperatingState || (ThermostatOperatingState = {}));
var ThermostatSetbackCommand;
(function(ThermostatSetbackCommand2) {
  ThermostatSetbackCommand2[ThermostatSetbackCommand2["Set"] = 1] = "Set";
  ThermostatSetbackCommand2[ThermostatSetbackCommand2["Get"] = 2] = "Get";
  ThermostatSetbackCommand2[ThermostatSetbackCommand2["Report"] = 3] = "Report";
})(ThermostatSetbackCommand || (ThermostatSetbackCommand = {}));
var SetbackType;
(function(SetbackType2) {
  SetbackType2[SetbackType2["None"] = 0] = "None";
  SetbackType2[SetbackType2["Temporary"] = 1] = "Temporary";
  SetbackType2[SetbackType2["Permanent"] = 2] = "Permanent";
})(SetbackType || (SetbackType = {}));
var ThermostatSetpointCommand;
(function(ThermostatSetpointCommand2) {
  ThermostatSetpointCommand2[ThermostatSetpointCommand2["Set"] = 1] = "Set";
  ThermostatSetpointCommand2[ThermostatSetpointCommand2["Get"] = 2] = "Get";
  ThermostatSetpointCommand2[ThermostatSetpointCommand2["Report"] = 3] = "Report";
  ThermostatSetpointCommand2[ThermostatSetpointCommand2["SupportedGet"] = 4] = "SupportedGet";
  ThermostatSetpointCommand2[ThermostatSetpointCommand2["SupportedReport"] = 5] = "SupportedReport";
  ThermostatSetpointCommand2[ThermostatSetpointCommand2["CapabilitiesGet"] = 9] = "CapabilitiesGet";
  ThermostatSetpointCommand2[ThermostatSetpointCommand2["CapabilitiesReport"] = 10] = "CapabilitiesReport";
})(ThermostatSetpointCommand || (ThermostatSetpointCommand = {}));
var ThermostatSetpointType;
(function(ThermostatSetpointType2) {
  ThermostatSetpointType2[ThermostatSetpointType2["N/A"] = 0] = "N/A";
  ThermostatSetpointType2[ThermostatSetpointType2["Heating"] = 1] = "Heating";
  ThermostatSetpointType2[ThermostatSetpointType2["Cooling"] = 2] = "Cooling";
  ThermostatSetpointType2[ThermostatSetpointType2["Furnace"] = 7] = "Furnace";
  ThermostatSetpointType2[ThermostatSetpointType2["Dry Air"] = 8] = "Dry Air";
  ThermostatSetpointType2[ThermostatSetpointType2["Moist Air"] = 9] = "Moist Air";
  ThermostatSetpointType2[ThermostatSetpointType2["Auto Changeover"] = 10] = "Auto Changeover";
  ThermostatSetpointType2[ThermostatSetpointType2["Energy Save Heating"] = 11] = "Energy Save Heating";
  ThermostatSetpointType2[ThermostatSetpointType2["Energy Save Cooling"] = 12] = "Energy Save Cooling";
  ThermostatSetpointType2[ThermostatSetpointType2["Away Heating"] = 13] = "Away Heating";
  ThermostatSetpointType2[ThermostatSetpointType2["Away Cooling"] = 14] = "Away Cooling";
  ThermostatSetpointType2[ThermostatSetpointType2["Full Power"] = 15] = "Full Power";
})(ThermostatSetpointType || (ThermostatSetpointType = {}));
var TimeCommand;
(function(TimeCommand2) {
  TimeCommand2[TimeCommand2["TimeGet"] = 1] = "TimeGet";
  TimeCommand2[TimeCommand2["TimeReport"] = 2] = "TimeReport";
  TimeCommand2[TimeCommand2["DateGet"] = 3] = "DateGet";
  TimeCommand2[TimeCommand2["DateReport"] = 4] = "DateReport";
  TimeCommand2[TimeCommand2["TimeOffsetSet"] = 5] = "TimeOffsetSet";
  TimeCommand2[TimeCommand2["TimeOffsetGet"] = 6] = "TimeOffsetGet";
  TimeCommand2[TimeCommand2["TimeOffsetReport"] = 7] = "TimeOffsetReport";
})(TimeCommand || (TimeCommand = {}));
var TimeParametersCommand;
(function(TimeParametersCommand2) {
  TimeParametersCommand2[TimeParametersCommand2["Set"] = 1] = "Set";
  TimeParametersCommand2[TimeParametersCommand2["Get"] = 2] = "Get";
  TimeParametersCommand2[TimeParametersCommand2["Report"] = 3] = "Report";
})(TimeParametersCommand || (TimeParametersCommand = {}));
var TransportServiceCommand;
(function(TransportServiceCommand2) {
  TransportServiceCommand2[TransportServiceCommand2["FirstSegment"] = 192] = "FirstSegment";
  TransportServiceCommand2[TransportServiceCommand2["SegmentComplete"] = 232] = "SegmentComplete";
  TransportServiceCommand2[TransportServiceCommand2["SegmentRequest"] = 200] = "SegmentRequest";
  TransportServiceCommand2[TransportServiceCommand2["SegmentWait"] = 240] = "SegmentWait";
  TransportServiceCommand2[TransportServiceCommand2["SubsequentSegment"] = 224] = "SubsequentSegment";
})(TransportServiceCommand || (TransportServiceCommand = {}));
var UserCodeCommand;
(function(UserCodeCommand2) {
  UserCodeCommand2[UserCodeCommand2["Set"] = 1] = "Set";
  UserCodeCommand2[UserCodeCommand2["Get"] = 2] = "Get";
  UserCodeCommand2[UserCodeCommand2["Report"] = 3] = "Report";
  UserCodeCommand2[UserCodeCommand2["UsersNumberGet"] = 4] = "UsersNumberGet";
  UserCodeCommand2[UserCodeCommand2["UsersNumberReport"] = 5] = "UsersNumberReport";
  UserCodeCommand2[UserCodeCommand2["CapabilitiesGet"] = 6] = "CapabilitiesGet";
  UserCodeCommand2[UserCodeCommand2["CapabilitiesReport"] = 7] = "CapabilitiesReport";
  UserCodeCommand2[UserCodeCommand2["KeypadModeSet"] = 8] = "KeypadModeSet";
  UserCodeCommand2[UserCodeCommand2["KeypadModeGet"] = 9] = "KeypadModeGet";
  UserCodeCommand2[UserCodeCommand2["KeypadModeReport"] = 10] = "KeypadModeReport";
  UserCodeCommand2[UserCodeCommand2["ExtendedUserCodeSet"] = 11] = "ExtendedUserCodeSet";
  UserCodeCommand2[UserCodeCommand2["ExtendedUserCodeGet"] = 12] = "ExtendedUserCodeGet";
  UserCodeCommand2[UserCodeCommand2["ExtendedUserCodeReport"] = 13] = "ExtendedUserCodeReport";
  UserCodeCommand2[UserCodeCommand2["AdminCodeSet"] = 14] = "AdminCodeSet";
  UserCodeCommand2[UserCodeCommand2["AdminCodeGet"] = 15] = "AdminCodeGet";
  UserCodeCommand2[UserCodeCommand2["AdminCodeReport"] = 16] = "AdminCodeReport";
  UserCodeCommand2[UserCodeCommand2["UserCodeChecksumGet"] = 17] = "UserCodeChecksumGet";
  UserCodeCommand2[UserCodeCommand2["UserCodeChecksumReport"] = 18] = "UserCodeChecksumReport";
})(UserCodeCommand || (UserCodeCommand = {}));
var UserIDStatus;
(function(UserIDStatus2) {
  UserIDStatus2[UserIDStatus2["Available"] = 0] = "Available";
  UserIDStatus2[UserIDStatus2["Enabled"] = 1] = "Enabled";
  UserIDStatus2[UserIDStatus2["Disabled"] = 2] = "Disabled";
  UserIDStatus2[UserIDStatus2["Messaging"] = 3] = "Messaging";
  UserIDStatus2[UserIDStatus2["PassageMode"] = 4] = "PassageMode";
  UserIDStatus2[UserIDStatus2["StatusNotAvailable"] = 254] = "StatusNotAvailable";
})(UserIDStatus || (UserIDStatus = {}));
var KeypadMode;
(function(KeypadMode2) {
  KeypadMode2[KeypadMode2["Normal"] = 0] = "Normal";
  KeypadMode2[KeypadMode2["Vacation"] = 1] = "Vacation";
  KeypadMode2[KeypadMode2["Privacy"] = 2] = "Privacy";
  KeypadMode2[KeypadMode2["LockedOut"] = 3] = "LockedOut";
})(KeypadMode || (KeypadMode = {}));
var VersionCommand;
(function(VersionCommand2) {
  VersionCommand2[VersionCommand2["Get"] = 17] = "Get";
  VersionCommand2[VersionCommand2["Report"] = 18] = "Report";
  VersionCommand2[VersionCommand2["CommandClassGet"] = 19] = "CommandClassGet";
  VersionCommand2[VersionCommand2["CommandClassReport"] = 20] = "CommandClassReport";
  VersionCommand2[VersionCommand2["CapabilitiesGet"] = 21] = "CapabilitiesGet";
  VersionCommand2[VersionCommand2["CapabilitiesReport"] = 22] = "CapabilitiesReport";
  VersionCommand2[VersionCommand2["ZWaveSoftwareGet"] = 23] = "ZWaveSoftwareGet";
  VersionCommand2[VersionCommand2["ZWaveSoftwareReport"] = 24] = "ZWaveSoftwareReport";
})(VersionCommand || (VersionCommand = {}));
var WakeUpCommand;
(function(WakeUpCommand2) {
  WakeUpCommand2[WakeUpCommand2["IntervalSet"] = 4] = "IntervalSet";
  WakeUpCommand2[WakeUpCommand2["IntervalGet"] = 5] = "IntervalGet";
  WakeUpCommand2[WakeUpCommand2["IntervalReport"] = 6] = "IntervalReport";
  WakeUpCommand2[WakeUpCommand2["WakeUpNotification"] = 7] = "WakeUpNotification";
  WakeUpCommand2[WakeUpCommand2["NoMoreInformation"] = 8] = "NoMoreInformation";
  WakeUpCommand2[WakeUpCommand2["IntervalCapabilitiesGet"] = 9] = "IntervalCapabilitiesGet";
  WakeUpCommand2[WakeUpCommand2["IntervalCapabilitiesReport"] = 10] = "IntervalCapabilitiesReport";
})(WakeUpCommand || (WakeUpCommand = {}));
var WindowCoveringCommand;
(function(WindowCoveringCommand2) {
  WindowCoveringCommand2[WindowCoveringCommand2["SupportedGet"] = 1] = "SupportedGet";
  WindowCoveringCommand2[WindowCoveringCommand2["SupportedReport"] = 2] = "SupportedReport";
  WindowCoveringCommand2[WindowCoveringCommand2["Get"] = 3] = "Get";
  WindowCoveringCommand2[WindowCoveringCommand2["Report"] = 4] = "Report";
  WindowCoveringCommand2[WindowCoveringCommand2["Set"] = 5] = "Set";
  WindowCoveringCommand2[WindowCoveringCommand2["StartLevelChange"] = 6] = "StartLevelChange";
  WindowCoveringCommand2[WindowCoveringCommand2["StopLevelChange"] = 7] = "StopLevelChange";
})(WindowCoveringCommand || (WindowCoveringCommand = {}));
var WindowCoveringParameter;
(function(WindowCoveringParameter2) {
  WindowCoveringParameter2[WindowCoveringParameter2["Outbound Left (no position)"] = 0] = "Outbound Left (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Outbound Left"] = 1] = "Outbound Left";
  WindowCoveringParameter2[WindowCoveringParameter2["Outbound Right (no position)"] = 2] = "Outbound Right (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Outbound Right"] = 3] = "Outbound Right";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Left (no position)"] = 4] = "Inbound Left (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Left"] = 5] = "Inbound Left";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Right (no position)"] = 6] = "Inbound Right (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Right"] = 7] = "Inbound Right";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Left/Right (no position)"] = 8] = "Inbound Left/Right (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Left/Right"] = 9] = "Inbound Left/Right";
  WindowCoveringParameter2[WindowCoveringParameter2["Vertical Slats Angle (no position)"] = 10] = "Vertical Slats Angle (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Vertical Slats Angle"] = 11] = "Vertical Slats Angle";
  WindowCoveringParameter2[WindowCoveringParameter2["Outbound Bottom (no position)"] = 12] = "Outbound Bottom (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Outbound Bottom"] = 13] = "Outbound Bottom";
  WindowCoveringParameter2[WindowCoveringParameter2["Outbound Top (no position)"] = 14] = "Outbound Top (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Outbound Top"] = 15] = "Outbound Top";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Bottom (no position)"] = 16] = "Inbound Bottom (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Bottom"] = 17] = "Inbound Bottom";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Top (no position)"] = 18] = "Inbound Top (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Top"] = 19] = "Inbound Top";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Top/Bottom (no position)"] = 20] = "Inbound Top/Bottom (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Inbound Top/Bottom"] = 21] = "Inbound Top/Bottom";
  WindowCoveringParameter2[WindowCoveringParameter2["Horizontal Slats Angle (no position)"] = 22] = "Horizontal Slats Angle (no position)";
  WindowCoveringParameter2[WindowCoveringParameter2["Horizontal Slats Angle"] = 23] = "Horizontal Slats Angle";
})(WindowCoveringParameter || (WindowCoveringParameter = {}));
var ZWavePlusCommand;
(function(ZWavePlusCommand2) {
  ZWavePlusCommand2[ZWavePlusCommand2["Get"] = 1] = "Get";
  ZWavePlusCommand2[ZWavePlusCommand2["Report"] = 2] = "Report";
})(ZWavePlusCommand || (ZWavePlusCommand = {}));
var ZWavePlusRoleType;
(function(ZWavePlusRoleType2) {
  ZWavePlusRoleType2[ZWavePlusRoleType2["CentralStaticController"] = 0] = "CentralStaticController";
  ZWavePlusRoleType2[ZWavePlusRoleType2["SubStaticController"] = 1] = "SubStaticController";
  ZWavePlusRoleType2[ZWavePlusRoleType2["PortableController"] = 2] = "PortableController";
  ZWavePlusRoleType2[ZWavePlusRoleType2["PortableReportingController"] = 3] = "PortableReportingController";
  ZWavePlusRoleType2[ZWavePlusRoleType2["PortableSlave"] = 4] = "PortableSlave";
  ZWavePlusRoleType2[ZWavePlusRoleType2["AlwaysOnSlave"] = 5] = "AlwaysOnSlave";
  ZWavePlusRoleType2[ZWavePlusRoleType2["SleepingReportingSlave"] = 6] = "SleepingReportingSlave";
  ZWavePlusRoleType2[ZWavePlusRoleType2["SleepingListeningSlave"] = 7] = "SleepingListeningSlave";
  ZWavePlusRoleType2[ZWavePlusRoleType2["NetworkAwareSlave"] = 8] = "NetworkAwareSlave";
})(ZWavePlusRoleType || (ZWavePlusRoleType = {}));
var ZWavePlusNodeType;
(function(ZWavePlusNodeType2) {
  ZWavePlusNodeType2[ZWavePlusNodeType2["Node"] = 0] = "Node";
  ZWavePlusNodeType2[ZWavePlusNodeType2["IPGateway"] = 2] = "IPGateway";
})(ZWavePlusNodeType || (ZWavePlusNodeType = {}));
var ZWaveProtocolCommand;
(function(ZWaveProtocolCommand2) {
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["NodeInformationFrame"] = 1] = "NodeInformationFrame";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["RequestNodeInformationFrame"] = 2] = "RequestNodeInformationFrame";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["AssignIDs"] = 3] = "AssignIDs";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["FindNodesInRange"] = 4] = "FindNodesInRange";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["GetNodesInRange"] = 5] = "GetNodesInRange";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["RangeInfo"] = 6] = "RangeInfo";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["CommandComplete"] = 7] = "CommandComplete";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["TransferPresentation"] = 8] = "TransferPresentation";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["TransferNodeInformation"] = 9] = "TransferNodeInformation";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["TransferRangeInformation"] = 10] = "TransferRangeInformation";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["TransferEnd"] = 11] = "TransferEnd";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["AssignReturnRoute"] = 12] = "AssignReturnRoute";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["NewNodeRegistered"] = 13] = "NewNodeRegistered";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["NewRangeRegistered"] = 14] = "NewRangeRegistered";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["TransferNewPrimaryControllerComplete"] = 15] = "TransferNewPrimaryControllerComplete";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["AutomaticControllerUpdateStart"] = 16] = "AutomaticControllerUpdateStart";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["SUCNodeID"] = 17] = "SUCNodeID";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["SetSUC"] = 18] = "SetSUC";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["SetSUCAck"] = 19] = "SetSUCAck";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["AssignSUCReturnRoute"] = 20] = "AssignSUCReturnRoute";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["StaticRouteRequest"] = 21] = "StaticRouteRequest";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["Lost"] = 22] = "Lost";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["AcceptLost"] = 23] = "AcceptLost";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["NOPPower"] = 24] = "NOPPower";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["ReserveNodeIDs"] = 25] = "ReserveNodeIDs";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["ReservedIDs"] = 26] = "ReservedIDs";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["NodesExist"] = 31] = "NodesExist";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["NodesExistReply"] = 32] = "NodesExistReply";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["SetNWIMode"] = 34] = "SetNWIMode";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["ExcludeRequest"] = 35] = "ExcludeRequest";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["AssignReturnRoutePriority"] = 36] = "AssignReturnRoutePriority";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["AssignSUCReturnRoutePriority"] = 37] = "AssignSUCReturnRoutePriority";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["SmartStartIncludedNodeInformation"] = 38] = "SmartStartIncludedNodeInformation";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["SmartStartPrime"] = 39] = "SmartStartPrime";
  ZWaveProtocolCommand2[ZWaveProtocolCommand2["SmartStartInclusionRequest"] = 40] = "SmartStartInclusionRequest";
})(ZWaveProtocolCommand || (ZWaveProtocolCommand = {}));
var WakeUpTime;
(function(WakeUpTime2) {
  WakeUpTime2[WakeUpTime2["None"] = 0] = "None";
  WakeUpTime2[WakeUpTime2["1000ms"] = 1] = "1000ms";
  WakeUpTime2[WakeUpTime2["250ms"] = 2] = "250ms";
})(WakeUpTime || (WakeUpTime = {}));
function FLiRS2WakeUpTime(value) {
  return value === "1000ms" ? 1 : value === "250ms" ? 2 : 0;
}
__name(FLiRS2WakeUpTime, "FLiRS2WakeUpTime");
function wakeUpTime2FLiRS(value) {
  return value === 1 ? "1000ms" : value === 2 ? "250ms" : false;
}
__name(wakeUpTime2FLiRS, "wakeUpTime2FLiRS");
function dataRate2ZWaveDataRate(dataRate) {
  return dataRate === 1e5 ? import_core.ZWaveDataRate["100k"] : dataRate === 4e4 ? import_core.ZWaveDataRate["40k"] : import_core.ZWaveDataRate["9k6"];
}
__name(dataRate2ZWaveDataRate, "dataRate2ZWaveDataRate");
function ZWaveDataRate2DataRate(zdr) {
  return zdr === import_core.ZWaveDataRate["100k"] ? 1e5 : zdr === import_core.ZWaveDataRate["40k"] ? 4e4 : 9600;
}
__name(ZWaveDataRate2DataRate, "ZWaveDataRate2DataRate");
function parseWakeUpTime(value) {
  return value <= WakeUpTime["250ms"] ? value : 0;
}
__name(parseWakeUpTime, "parseWakeUpTime");
var NetworkTransferStatus;
(function(NetworkTransferStatus2) {
  NetworkTransferStatus2[NetworkTransferStatus2["Failed"] = 0] = "Failed";
  NetworkTransferStatus2[NetworkTransferStatus2["Success"] = 1] = "Success";
  NetworkTransferStatus2[NetworkTransferStatus2["UpdateDone"] = 2] = "UpdateDone";
  NetworkTransferStatus2[NetworkTransferStatus2["UpdateAborted"] = 3] = "UpdateAborted";
  NetworkTransferStatus2[NetworkTransferStatus2["UpdateWait"] = 4] = "UpdateWait";
  NetworkTransferStatus2[NetworkTransferStatus2["UpdateDisabled"] = 5] = "UpdateDisabled";
  NetworkTransferStatus2[NetworkTransferStatus2["UpdateOverflow"] = 6] = "UpdateOverflow";
})(NetworkTransferStatus || (NetworkTransferStatus = {}));
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AlarmSensorCommand,
  AlarmSensorType,
  AssociationCheckResult,
  AssociationCommand,
  AssociationGroupInfoCommand,
  AssociationGroupInfoProfile,
  BarrierOperatorCommand,
  BarrierState,
  BasicCommand,
  BasicWindowCoveringCommand,
  BatteryChargingStatus,
  BatteryCommand,
  BatteryReplacementStatus,
  BinarySensorCommand,
  BinarySensorType,
  BinarySwitchCommand,
  CRC16Command,
  CentralSceneCommand,
  CentralSceneKeys,
  ClimateControlScheduleCommand,
  ClockCommand,
  ColorComponent,
  ColorComponentMap,
  ColorSwitchCommand,
  ConfigurationCommand,
  DeviceIdType,
  DeviceResetLocallyCommand,
  DoorLockCommand,
  DoorLockLoggingCommand,
  DoorLockLoggingEventType,
  DoorLockLoggingRecordStatus,
  DoorLockMode,
  DoorLockOperationType,
  EnergyProductionCommand,
  EnergyProductionParameter,
  EntryControlCommand,
  EntryControlDataTypes,
  EntryControlEventTypes,
  FLiRS2WakeUpTime,
  FirmwareDownloadStatus,
  FirmwareUpdateActivationStatus,
  FirmwareUpdateMetaDataCommand,
  FirmwareUpdateRequestStatus,
  FirmwareUpdateStatus,
  HailCommand,
  HumidityControlMode,
  HumidityControlModeCommand,
  HumidityControlOperatingState,
  HumidityControlOperatingStateCommand,
  HumidityControlSetpointCommand,
  HumidityControlSetpointType,
  InclusionControllerCommand,
  InclusionControllerStatus,
  InclusionControllerStep,
  IndicatorCommand,
  IrrigationCommand,
  IrrigationSensorPolarity,
  KeypadMode,
  LanguageCommand,
  LevelChangeDirection,
  LocalProtectionState,
  LockCommand,
  ManufacturerSpecificCommand,
  MeterCommand,
  MultiChannelAssociationCommand,
  MultiChannelCommand,
  MultiCommandCommand,
  MultilevelSensorCommand,
  MultilevelSwitchCommand,
  NetworkTransferStatus,
  NodeNamingAndLocationCommand,
  NotificationCommand,
  Powerlevel,
  PowerlevelCommand,
  PowerlevelTestStatus,
  ProtectionCommand,
  RFProtectionState,
  RateType,
  SceneActivationCommand,
  SceneActuatorConfigurationCommand,
  SceneControllerConfigurationCommand,
  ScheduleEntryLockCommand,
  ScheduleEntryLockScheduleKind,
  ScheduleEntryLockSetAction,
  ScheduleEntryLockWeekday,
  ScheduleOverrideType,
  Security2Command,
  SecurityCommand,
  SetbackType,
  SoundSwitchCommand,
  SubsystemState,
  SubsystemType,
  SupervisionCommand,
  SwitchType,
  ThermostatFanMode,
  ThermostatFanModeCommand,
  ThermostatFanState,
  ThermostatFanStateCommand,
  ThermostatMode,
  ThermostatModeCommand,
  ThermostatOperatingState,
  ThermostatOperatingStateCommand,
  ThermostatSetbackCommand,
  ThermostatSetpointCommand,
  ThermostatSetpointType,
  TimeCommand,
  TimeParametersCommand,
  ToneId,
  TransportServiceCommand,
  UserCodeCommand,
  UserIDStatus,
  ValveType,
  VersionCommand,
  WakeUpCommand,
  WakeUpTime,
  Weekday,
  WindowCoveringCommand,
  WindowCoveringParameter,
  ZWaveDataRate2DataRate,
  ZWavePlusCommand,
  ZWavePlusNodeType,
  ZWavePlusRoleType,
  ZWaveProtocolCommand,
  dataRate2ZWaveDataRate,
  entryControlEventTypeLabels,
  getEnergyProductionScale,
  parseWakeUpTime,
  wakeUpTime2FLiRS
});
//# sourceMappingURL=_Types.js.map
