import * as v from "@zwave-js/core/validation";
export function validateArgs_MultiChannelAssociationCCAPI_reportGroupCount() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportGroupCount(groupCount) {
                v.assert(v.primitive({ kind: "parameter", name: "groupCount" }, "number")(groupCount));
                return __decoratedMethod.call(this, groupCount);
            };
        }
    };
}
export function validateArgs_MultiChannelAssociationCCAPI_getGroup() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getGroup(groupId) {
                v.assert(v.primitive({ kind: "parameter", name: "groupId" }, "number")(groupId));
                return __decoratedMethod.call(this, groupId);
            };
        }
    };
}
export function validateArgs_MultiChannelAssociationCCAPI_sendReport() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function sendReport(options) {
                v.assert(v.object({ kind: "parameter", name: "options" }, 'MultiChannelAssociationCCReportOptions', { "groupId": v.primitive({ kind: "property", name: "groupId" }, "number"), "maxNodes": v.primitive({ kind: "property", name: "maxNodes" }, "number"), "nodeIds": v.array({ kind: "property", name: "nodeIds" }, 'number', v.primitive({ kind: "item", name: "nodeIds" }, "number")), "endpoints": v.array({ kind: "property", name: "endpoints" }, 'EndpointAddress', v.object({ kind: "item", name: "endpoints" }, 'EndpointAddress', { "nodeId": v.primitive({ kind: "property", name: "nodeId" }, "number"), "endpoint": v.oneOf({ kind: "property", name: "endpoint" }, undefined, v.primitive({ kind: "property", name: "endpoint" }, "number"), v.array({ kind: "property", name: "endpoint" }, 'number', v.primitive({ kind: "item", name: "endpoint" }, "number"))) })), "reportsToFollow": v.primitive({ kind: "property", name: "reportsToFollow" }, "number") })(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_MultiChannelAssociationCCAPI_addDestinations() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function addDestinations(options) {
                v.assert(v.oneOf({ kind: "parameter", name: "options" }, "MultiChannelAssociationCCSetOptions", v.allOf({ kind: "parameter", name: "options" }, undefined, v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "groupId": v.primitive({ kind: "property", name: "groupId" }, "number") }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "nodeIds": v.array({ kind: "property", name: "nodeIds" }, 'number', v.primitive({ kind: "item", name: "nodeIds" }, "number")) })), v.allOf({ kind: "parameter", name: "options" }, undefined, v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "groupId": v.primitive({ kind: "property", name: "groupId" }, "number") }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "endpoints": v.array({ kind: "property", name: "endpoints" }, 'EndpointAddress', v.object({ kind: "item", name: "endpoints" }, 'EndpointAddress', { "nodeId": v.primitive({ kind: "property", name: "nodeId" }, "number"), "endpoint": v.oneOf({ kind: "property", name: "endpoint" }, undefined, v.primitive({ kind: "property", name: "endpoint" }, "number"), v.array({ kind: "property", name: "endpoint" }, 'number', v.primitive({ kind: "item", name: "endpoint" }, "number"))) })) })), v.allOf({ kind: "parameter", name: "options" }, undefined, v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "groupId": v.primitive({ kind: "property", name: "groupId" }, "number") }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "nodeIds": v.array({ kind: "property", name: "nodeIds" }, 'number', v.primitive({ kind: "item", name: "nodeIds" }, "number")), "endpoints": v.array({ kind: "property", name: "endpoints" }, 'EndpointAddress', v.object({ kind: "item", name: "endpoints" }, 'EndpointAddress', { "nodeId": v.primitive({ kind: "property", name: "nodeId" }, "number"), "endpoint": v.oneOf({ kind: "property", name: "endpoint" }, undefined, v.primitive({ kind: "property", name: "endpoint" }, "number"), v.array({ kind: "property", name: "endpoint" }, 'number', v.primitive({ kind: "item", name: "endpoint" }, "number"))) })) })))(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_MultiChannelAssociationCCAPI_removeDestinations() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function removeDestinations(options) {
                v.assert(v.object({ kind: "parameter", name: "options" }, 'MultiChannelAssociationCCRemoveOptions', { "groupId": v.optional({ kind: "property", name: "groupId" }, v.primitive({ kind: "property", name: "groupId" }, "number")), "nodeIds": v.optional({ kind: "property", name: "nodeIds" }, v.array({ kind: "property", name: "nodeIds" }, 'number', v.primitive({ kind: "item", name: "nodeIds" }, "number"))), "endpoints": v.optional({ kind: "property", name: "endpoints" }, v.array({ kind: "property", name: "endpoints" }, 'EndpointAddress', v.object({ kind: "item", name: "endpoints" }, 'EndpointAddress', { "nodeId": v.primitive({ kind: "property", name: "nodeId" }, "number"), "endpoint": v.oneOf({ kind: "property", name: "endpoint" }, undefined, v.primitive({ kind: "property", name: "endpoint" }, "number"), v.array({ kind: "property", name: "endpoint" }, 'number', v.primitive({ kind: "item", name: "endpoint" }, "number"))) }))) })(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
//# sourceMappingURL=MultiChannelAssociationCC._validateArgs.js.map