import * as v from "@zwave-js/core/validation";
export function validateArgs_PowerlevelCCAPI_setCustomPowerlevel() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function setCustomPowerlevel(powerlevel, timeout) {
                v.assert(v.enum({ kind: "parameter", name: "powerlevel" }, "Powerlevel", [0, 1, 2, 3, 4, 5, 6, 7, 8, 9])(powerlevel), v.primitive({ kind: "parameter", name: "timeout" }, "number")(timeout));
                return __decoratedMethod.call(this, powerlevel, timeout);
            };
        }
    };
}
export function validateArgs_PowerlevelCCAPI_reportPowerlevel() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportPowerlevel(options) {
                v.assert(v.oneOf({ kind: "parameter", name: "options" }, "PowerlevelCCReportOptions", v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "powerlevel": v.literal({ kind: "property", name: "powerlevel" }, 0), "timeout": v.undefined({ kind: "property", name: "timeout" }) }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "powerlevel": v.oneOf({ kind: "property", name: "powerlevel" }, undefined, v.literal({ kind: "property", name: "powerlevel" }, 1), v.literal({ kind: "property", name: "powerlevel" }, 2), v.literal({ kind: "property", name: "powerlevel" }, 3), v.literal({ kind: "property", name: "powerlevel" }, 4), v.literal({ kind: "property", name: "powerlevel" }, 5), v.literal({ kind: "property", name: "powerlevel" }, 6), v.literal({ kind: "property", name: "powerlevel" }, 7), v.literal({ kind: "property", name: "powerlevel" }, 8), v.literal({ kind: "property", name: "powerlevel" }, 9)), "timeout": v.primitive({ kind: "property", name: "timeout" }, "number") }))(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_PowerlevelCCAPI_startNodeTest() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function startNodeTest(testNodeId, powerlevel, testFrameCount) {
                v.assert(v.primitive({ kind: "parameter", name: "testNodeId" }, "number")(testNodeId), v.enum({ kind: "parameter", name: "powerlevel" }, "Powerlevel", [0, 1, 2, 3, 4, 5, 6, 7, 8, 9])(powerlevel), v.primitive({ kind: "parameter", name: "testFrameCount" }, "number")(testFrameCount));
                return __decoratedMethod.call(this, testNodeId, powerlevel, testFrameCount);
            };
        }
    };
}
export function validateArgs_PowerlevelCCAPI_sendNodeTestReport() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function sendNodeTestReport(options) {
                v.assert(v.object({ kind: "parameter", name: "options" }, 'PowerlevelCCTestNodeReportOptions', { "testNodeId": v.primitive({ kind: "property", name: "testNodeId" }, "number"), "status": v.enum({ kind: "property", name: "status" }, "PowerlevelTestStatus"), "acknowledgedFrames": v.primitive({ kind: "property", name: "acknowledgedFrames" }, "number") })(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
//# sourceMappingURL=PowerlevelCC._validateArgs.js.map