import * as v from "@zwave-js/core/validation";
export function validateArgs_TimeCCAPI_reportTime() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportTime(hour, minute, second) {
                v.assert(v.primitive({ kind: "parameter", name: "hour" }, "number")(hour), v.primitive({ kind: "parameter", name: "minute" }, "number")(minute), v.primitive({ kind: "parameter", name: "second" }, "number")(second));
                return __decoratedMethod.call(this, hour, minute, second);
            };
        }
    };
}
export function validateArgs_TimeCCAPI_reportDate() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportDate(year, month, day) {
                v.assert(v.primitive({ kind: "parameter", name: "year" }, "number")(year), v.primitive({ kind: "parameter", name: "month" }, "number")(month), v.primitive({ kind: "parameter", name: "day" }, "number")(day));
                return __decoratedMethod.call(this, year, month, day);
            };
        }
    };
}
export function validateArgs_TimeCCAPI_setTimezone() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function setTimezone(timezone) {
                v.assert(v.object({ kind: "parameter", name: "timezone" }, 'DSTInfo', { "startDate": v.date({ kind: "property", name: "startDate" }), "endDate": v.date({ kind: "property", name: "endDate" }), "standardOffset": v.primitive({ kind: "property", name: "standardOffset" }, "number"), "dstOffset": v.primitive({ kind: "property", name: "dstOffset" }, "number") })(timezone));
                return __decoratedMethod.call(this, timezone);
            };
        }
    };
}
export function validateArgs_TimeCCAPI_reportTimezone() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportTimezone(timezone) {
                v.assert(v.object({ kind: "parameter", name: "timezone" }, 'DSTInfo', { "startDate": v.date({ kind: "property", name: "startDate" }), "endDate": v.date({ kind: "property", name: "endDate" }), "standardOffset": v.primitive({ kind: "property", name: "standardOffset" }, "number"), "dstOffset": v.primitive({ kind: "property", name: "dstOffset" }, "number") })(timezone));
                return __decoratedMethod.call(this, timezone);
            };
        }
    };
}
//# sourceMappingURL=TimeCC._validateArgs.js.map