"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ConfigManager_exports = {};
__export(ConfigManager_exports, {
  ConfigManager: () => ConfigManager
});
module.exports = __toCommonJS(ConfigManager_exports);
var import_config_dir = require("#config_dir");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_pathe = __toESM(require("pathe"), 1);
var import_Logger = require("./Logger.js");
var import_Manufacturers = require("./Manufacturers.js");
var import_version = require("./_version.js");
var import_DeviceConfig = require("./devices/DeviceConfig.js");
var import_utils = require("./utils.js");
class ConfigManager {
  static {
    __name(this, "ConfigManager");
  }
  constructor(options = {}) {
    this._fs = options.bindings;
    this._logContainer = options.logContainer;
    this.deviceConfigPriorityDir = options.deviceConfigPriorityDir;
    this.deviceConfigExternalDir = options.deviceConfigExternalDir;
    this._configVersion = import_version.PACKAGE_VERSION;
  }
  _fs;
  async getFS() {
    this._fs ??= (await import("#default_bindings/fs")).fs;
    return this._fs;
  }
  _configVersion;
  get configVersion() {
    return this._configVersion;
  }
  _logContainer;
  _logger;
  async getLogger() {
    if (!this._logContainer) {
      this._logContainer = // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore - For some reason, VSCode does not like this import, although tsc is fine with it
      (await import("#default_bindings/log")).log({
        enabled: false
      });
    }
    if (!this._logger) {
      this._logger = new import_Logger.ConfigLogger(this._logContainer);
    }
    return this._logger;
  }
  _manufacturers;
  get manufacturers() {
    if (!this._manufacturers) {
      throw new import_core.ZWaveError("The config has not been loaded yet!", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    return this._manufacturers;
  }
  deviceConfigPriorityDir;
  deviceConfigExternalDir;
  get externalConfigDir() {
    return this.deviceConfigExternalDir ?? (0, import_utils.getExternalConfigDirEnvVariable)();
  }
  index;
  fulltextIndex;
  _useExternalConfig = false;
  get useExternalConfig() {
    return this._useExternalConfig;
  }
  async loadAll() {
    const logger = await this.getLogger();
    let syncResult;
    const externalConfigDir = this.externalConfigDir;
    if (externalConfigDir) {
      syncResult = await (0, import_utils.syncExternalConfigDir)(await this.getFS(), externalConfigDir, logger);
    }
    if (syncResult?.success) {
      this._useExternalConfig = true;
      logger.print(`Using external configuration dir ${externalConfigDir}`);
      this._configVersion = syncResult.version;
    } else {
      this._useExternalConfig = false;
      this._configVersion = import_version.PACKAGE_VERSION;
    }
    logger.print(`version ${this._configVersion}`, "info");
    await this.loadManufacturers();
    await this.loadDeviceIndex();
  }
  async loadManufacturers() {
    try {
      this._manufacturers = await (0, import_Manufacturers.loadManufacturersInternal)(await this.getFS(), this._useExternalConfig && this.externalConfigDir || void 0);
    } catch (e) {
      if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Config_Invalid) {
        if (process.env.NODE_ENV !== "test") {
          (await this.getLogger()).print(`Could not load manufacturers config: ${e.message}`, "error");
        }
        if (!this._manufacturers)
          this._manufacturers = /* @__PURE__ */ new Map();
      } else {
        throw e;
      }
    }
  }
  async saveManufacturers() {
    if (!this._manufacturers) {
      throw new import_core.ZWaveError("The config has not been loaded yet!", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    await (0, import_Manufacturers.saveManufacturersInternal)(await this.getFS(), this._manufacturers);
  }
  /**
   * Looks up the name of the manufacturer with the given ID in the configuration DB
   * @param manufacturerId The manufacturer id to look up
   */
  lookupManufacturer(manufacturerId) {
    if (!this._manufacturers) {
      throw new import_core.ZWaveError("The config has not been loaded yet!", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    return this._manufacturers.get(manufacturerId);
  }
  /**
   * Add new manufacturers to configuration DB
   * @param manufacturerId The manufacturer id to look up
   * @param manufacturerName The manufacturer name
   */
  setManufacturer(manufacturerId, manufacturerName) {
    if (!this._manufacturers) {
      throw new import_core.ZWaveError("The config has not been loaded yet!", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    this._manufacturers.set(manufacturerId, manufacturerName);
  }
  async loadDeviceIndex() {
    const fs = await this.getFS();
    const logger = await this.getLogger();
    try {
      const embeddedIndex = await (0, import_DeviceConfig.loadDeviceIndexInternal)(fs, logger, this._useExternalConfig && this.externalConfigDir || void 0);
      const priorityIndex = [];
      if (this.deviceConfigPriorityDir) {
        if (await (0, import_shared.pathExists)(fs, this.deviceConfigPriorityDir)) {
          priorityIndex.push(...await (0, import_DeviceConfig.generatePriorityDeviceIndex)(fs, this.deviceConfigPriorityDir, logger));
        } else {
          logger.print(`Priority device configuration directory ${this.deviceConfigPriorityDir} not found`, "warn");
        }
      }
      this.index = [...priorityIndex, ...embeddedIndex];
    } catch (e) {
      if (!(0, import_core.isZWaveError)(e) && e instanceof Error || (0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Config_Invalid) {
        if (!this.index)
          this.index = [];
        if (process.env.NODE_ENV !== "test") {
          logger.print(`Could not load or regenerate device config index: ${e.message}`, "error");
          return;
        }
        throw e;
      }
    }
  }
  getIndex() {
    return this.index;
  }
  async loadFulltextDeviceIndex() {
    this.fulltextIndex = await (0, import_DeviceConfig.loadFulltextDeviceIndexInternal)(await this.getFS(), await this.getLogger());
  }
  getFulltextIndex() {
    return this.fulltextIndex;
  }
  /**
   * Looks up the definition of a given device in the configuration DB, but does not evaluate conditional settings.
   * @param manufacturerId The manufacturer id of the device
   * @param productType The product type of the device
   * @param productId The product id of the device
   * @param firmwareVersion If known, configuration for a specific firmware version can be loaded.
   * If this is `undefined` or not given, the first matching file with a defined firmware range will be returned.
   */
  async lookupDevicePreserveConditions(manufacturerId, productType, productId, firmwareVersion) {
    if (!this.index)
      await this.loadDeviceIndex();
    const fs = await this.getFS();
    const indexEntries = this.index.filter((0, import_utils.getDeviceEntryPredicate)(manufacturerId, productType, productId, firmwareVersion));
    const indexEntry = indexEntries.find((e) => !!e.preferred) ?? indexEntries[0];
    if (indexEntry) {
      const devicesDir = (0, import_DeviceConfig.getDevicesPaths)(this._useExternalConfig && this.externalConfigDir || import_config_dir.configDir).devicesDir;
      const filePath = import_pathe.default.isAbsolute(indexEntry.filename) ? indexEntry.filename : import_pathe.default.join(devicesDir, indexEntry.filename);
      if (!await (0, import_shared.pathExists)(fs, filePath))
        return;
      const isEmbedded = !import_pathe.default.relative(devicesDir, filePath).startsWith("..");
      const rootDir = indexEntry.rootDir ?? devicesDir;
      const fallbackDirs = rootDir === devicesDir ? void 0 : [devicesDir];
      try {
        return await import_DeviceConfig.ConditionalDeviceConfig.from(fs, filePath, isEmbedded, { rootDir, fallbackDirs });
      } catch (e) {
        if (process.env.NODE_ENV !== "test") {
          (await this.getLogger()).print(`Error loading device config ${filePath}: ${(0, import_shared.getErrorMessage)(e, true)}`, "error");
        }
      }
    }
  }
  /**
   * Looks up the definition of a given device in the configuration DB
   * @param manufacturerId The manufacturer id of the device
   * @param productType The product type of the device
   * @param productId The product id of the device
   * @param firmwareVersion If known, configuration for a specific firmware version can be loaded.
   * If this is `undefined` or not given, the first matching file with a defined firmware range will be returned.
   */
  async lookupDevice(manufacturerId, productType, productId, firmwareVersion) {
    const ret = await this.lookupDevicePreserveConditions(manufacturerId, productType, productId, firmwareVersion);
    return ret?.evaluate({
      manufacturerId,
      productType,
      productId,
      firmwareVersion
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfigManager
});
//# sourceMappingURL=ConfigManager.js.map
