"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Manufacturers_exports = {};
__export(Manufacturers_exports, {
  loadManufacturersInternal: () => loadManufacturersInternal,
  saveManufacturersInternal: () => saveManufacturersInternal
});
module.exports = __toCommonJS(Manufacturers_exports);
var import_config_dir = require("#config_dir");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_json5 = __toESM(require("json5"), 1);
var import_pathe = __toESM(require("pathe"), 1);
var import_utils_safe = require("./utils_safe.js");
async function loadManufacturersInternal(fs, externalConfigDir) {
  const configPath = import_pathe.default.join(externalConfigDir || import_config_dir.configDir, "manufacturers.json");
  if (!await (0, import_shared.pathExists)(fs, configPath)) {
    throw new import_core.ZWaveError("The manufacturer config file does not exist!", import_core.ZWaveErrorCodes.Config_Invalid);
  }
  try {
    const fileContents = await (0, import_shared.readTextFile)(fs, configPath, "utf8");
    const definition = import_json5.default.parse(fileContents);
    if (!(0, import_typeguards.isObject)(definition)) {
      (0, import_utils_safe.throwInvalidConfig)("manufacturers", `the database is not an object!`);
    }
    const manufacturers = /* @__PURE__ */ new Map();
    for (const [id, name] of Object.entries(definition)) {
      if (!import_utils_safe.hexKeyRegex4Digits.test(id)) {
        (0, import_utils_safe.throwInvalidConfig)("manufacturers", `found invalid key ${id} at the root level. Manufacturer IDs must be hexadecimal lowercase.`);
      }
      if (typeof name !== "string") {
        (0, import_utils_safe.throwInvalidConfig)("manufacturers", `Key ${id} has a non-string manufacturer name`);
      }
      const idNum = parseInt(id.slice(2), 16);
      manufacturers.set(idNum, name);
    }
    return manufacturers;
  } catch (e) {
    if ((0, import_core.isZWaveError)(e) || e.code === "ENOENT") {
      throw e;
    } else {
      (0, import_utils_safe.throwInvalidConfig)("manufacturers");
    }
  }
}
__name(loadManufacturersInternal, "loadManufacturersInternal");
async function saveManufacturersInternal(fs, manufacturers) {
  const data = {};
  const orderedMap = new Map([...manufacturers].sort((a, b) => a[0] > b[0] ? 1 : -1));
  for (const [id, name] of orderedMap) {
    data[(0, import_shared.formatId)(id)] = name;
  }
  const configPath = import_pathe.default.join(import_config_dir.configDir, "manufacturers.json");
  await (0, import_shared.writeTextFile)(fs, configPath, (0, import_shared.stringify)(data, "	") + "\n");
}
__name(saveManufacturersInternal, "saveManufacturersInternal");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  loadManufacturersInternal,
  saveManufacturersInternal
});
//# sourceMappingURL=Manufacturers.js.map
