"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ConditionalItem_exports = {};
__export(ConditionalItem_exports, {
  conditionApplies: () => conditionApplies,
  evaluateDeep: () => evaluateDeep,
  isConditionalItem: () => isConditionalItem,
  validateCondition: () => validateCondition
});
module.exports = __toCommonJS(ConditionalItem_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_Logic = require("../Logic.js");
var import_utils_safe = require("../utils_safe.js");
function isConditionalItem(val) {
  if (typeof val !== "object" || val == void 0)
    return false;
  if (typeof val.condition !== "string" && typeof val.condition !== "undefined") {
    return false;
  }
  if (typeof val.evaluateCondition !== "function")
    return false;
  return true;
}
__name(isConditionalItem, "isConditionalItem");
function conditionApplies(self, deviceId) {
  if (!self.condition)
    return true;
  if (!deviceId)
    return true;
  try {
    return !!(0, import_Logic.evaluate)(self.condition, deviceId);
  } catch {
    throw new import_core.ZWaveError(`Invalid condition "${self.condition}"!`, import_core.ZWaveErrorCodes.Config_Invalid);
  }
}
__name(conditionApplies, "conditionApplies");
function validateCondition(filename, definition, errorPrefix) {
  if (definition.$if != void 0 && typeof definition.$if !== "string") {
    (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
${errorPrefix} invalid $if condition`);
  }
}
__name(validateCondition, "validateCondition");
function evaluateDeep(obj, deviceId, preserveArray = false) {
  if (obj == void 0) {
    return obj;
  } else if ((0, import_typeguards.isArray)(obj)) {
    if (preserveArray) {
      return obj.map((item) => evaluateDeep(item, deviceId, true)).filter((o) => o != void 0);
    } else {
      for (const item of obj) {
        const evaluated = evaluateDeep(item, deviceId, false);
        if (evaluated != void 0)
          return evaluated;
      }
    }
  } else if (obj instanceof Map) {
    const ret = /* @__PURE__ */ new Map();
    for (const [key, val] of obj) {
      const evaluated = evaluateDeep(val, deviceId, false);
      if (evaluated != void 0) {
        ret.set(key, evaluated);
        continue;
      }
    }
    if (ret.size > 0)
      return ret;
  } else if (obj instanceof import_shared.ObjectKeyMap) {
    const ret = new import_shared.ObjectKeyMap();
    for (const [key, val] of obj) {
      const evaluated = evaluateDeep(val, deviceId, false);
      if (evaluated != void 0) {
        ret.set(key, evaluated);
        continue;
      }
    }
    if (ret.size > 0)
      return ret;
  } else if (isConditionalItem(obj)) {
    return obj.evaluateCondition(deviceId);
  } else {
    return obj;
  }
}
__name(evaluateDeep, "evaluateDeep");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  conditionApplies,
  evaluateDeep,
  isConditionalItem,
  validateCondition
});
//# sourceMappingURL=ConditionalItem.js.map
