"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SceneConfig_exports = {};
__export(SceneConfig_exports, {
  ConditionalSceneConfig: () => ConditionalSceneConfig
});
module.exports = __toCommonJS(SceneConfig_exports);
var import_shared = require("@zwave-js/shared");
var import_utils_safe = require("../utils_safe.js");
var import_ConditionalItem = require("./ConditionalItem.js");
class ConditionalSceneConfig {
  static {
    __name(this, "ConditionalSceneConfig");
  }
  constructor(filename, sceneId, definition) {
    this.sceneId = sceneId;
    (0, import_ConditionalItem.validateCondition)(filename, definition, `Scene ${sceneId} contains an`);
    this.condition = definition.$if;
    if (typeof definition.label !== "string") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
Scene ${sceneId} has a non-string label`);
    }
    this.label = definition.label;
    if (definition.description != void 0 && typeof definition.description !== "string") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
Scene ${sceneId} has a non-string description`);
    }
    this.description = definition.description;
  }
  condition;
  sceneId;
  label;
  description;
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    return (0, import_shared.pick)(this, [
      "sceneId",
      "label",
      "description"
    ]);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConditionalSceneConfig
});
//# sourceMappingURL=SceneConfig.js.map
