"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_exports = {};
__export(utils_exports, {
  getDeviceEntryPredicate: () => getDeviceEntryPredicate,
  getExternalConfigDirEnvVariable: () => getExternalConfigDirEnvVariable,
  syncExternalConfigDir: () => syncExternalConfigDir,
  versionInRange: () => versionInRange
});
module.exports = __toCommonJS(utils_exports);
var import_config_dir = require("#config_dir");
var import_shared = require("@zwave-js/shared");
var import_pathe = __toESM(require("pathe"), 1);
var import_gte = __toESM(require("semver/functions/gte.js"), 1);
var import_inc = __toESM(require("semver/functions/inc.js"), 1);
var import_lte = __toESM(require("semver/functions/lte.js"), 1);
var import_satisfies = __toESM(require("semver/functions/satisfies.js"), 1);
var import_valid = __toESM(require("semver/functions/valid.js"), 1);
var import_version = require("./_version.js");
function getExternalConfigDirEnvVariable() {
  return (0, import_shared.getenv)("ZWAVEJS_EXTERNAL_CONFIG");
}
__name(getExternalConfigDirEnvVariable, "getExternalConfigDirEnvVariable");
function getDeviceEntryPredicate(manufacturerId, productType, productId, firmwareVersion) {
  return (entry) => {
    if (entry.manufacturerId !== (0, import_shared.formatId)(manufacturerId))
      return false;
    if (entry.productType !== (0, import_shared.formatId)(productType))
      return false;
    if (entry.productId !== (0, import_shared.formatId)(productId))
      return false;
    if (firmwareVersion != void 0) {
      return (0, import_lte.default)((0, import_shared.padVersion)(entry.firmwareVersion.min), (0, import_shared.padVersion)(firmwareVersion)) && (0, import_gte.default)((0, import_shared.padVersion)(entry.firmwareVersion.max), (0, import_shared.padVersion)(firmwareVersion));
    }
    return true;
  };
}
__name(getDeviceEntryPredicate, "getDeviceEntryPredicate");
async function syncExternalConfigDir(fs, extConfigDir, logger) {
  if (!extConfigDir)
    return { success: false };
  try {
    await fs.ensureDir(extConfigDir);
  } catch {
    logger.print(`Synchronizing external config dir failed - directory could not be created`, "error");
    return { success: false };
  }
  const externalVersionFilename = import_pathe.default.join(extConfigDir, "version");
  const currentVersion = import_version.PACKAGE_VERSION;
  const supportedRange = `>=${currentVersion} <${(0, import_inc.default)(currentVersion, "patch")}`;
  let wipe = false;
  let externalVersion;
  try {
    externalVersion = await (0, import_shared.readTextFile)(fs, externalVersionFilename, "utf8");
    if (!(0, import_valid.default)(externalVersion)) {
      wipe = true;
    } else if (!(0, import_satisfies.default)(externalVersion, supportedRange, {
      includePrerelease: true
    })) {
      wipe = true;
    }
  } catch {
    wipe = true;
  }
  if (!wipe)
    return { success: true, version: externalVersion };
  try {
    logger.print(`Synchronizing external config dir ${extConfigDir}...`);
    await fs.deleteDir(extConfigDir);
    await fs.ensureDir(extConfigDir);
    await (0, import_shared.copyFilesRecursive)(fs, import_config_dir.configDir, extConfigDir, (src) => src.endsWith(".json"));
    await (0, import_shared.writeTextFile)(fs, externalVersionFilename, currentVersion, "utf8");
    externalVersion = currentVersion;
  } catch {
    logger.print(`Synchronizing external config dir failed - using embedded config`, "error");
    return { success: false };
  }
  return { success: true, version: externalVersion };
}
__name(syncExternalConfigDir, "syncExternalConfigDir");
function versionInRange(version, min, max) {
  return (0, import_gte.default)((0, import_shared.padVersion)(version), (0, import_shared.padVersion)(min)) && (0, import_lte.default)((0, import_shared.padVersion)(version), (0, import_shared.padVersion)(max));
}
__name(versionInRange, "versionInRange");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getDeviceEntryPredicate,
  getExternalConfigDirEnvVariable,
  syncExternalConfigDir,
  versionInRange
});
//# sourceMappingURL=utils.js.map
