"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_safe_exports = {};
__export(utils_safe_exports, {
  hexKeyRegex2Digits: () => hexKeyRegex2Digits,
  hexKeyRegex4Digits: () => hexKeyRegex4Digits,
  hexKeyRegexNDigits: () => hexKeyRegexNDigits,
  throwInvalidConfig: () => throwInvalidConfig,
  tryParseCCId: () => tryParseCCId
});
module.exports = __toCommonJS(utils_safe_exports);
var import_core = require("@zwave-js/core");
const hexKeyRegexNDigits = /^0x[a-f0-9]+$/;
const hexKeyRegex4Digits = /^0x[a-f0-9]{4}$/;
const hexKeyRegex2Digits = /^0x[a-f0-9]{2}$/;
function throwInvalidConfig(which, reason) {
  throw new import_core.ZWaveError(`The ${which ? which + " " : ""}config file is malformed!` + (reason ? `
${reason}` : ""), import_core.ZWaveErrorCodes.Config_Invalid);
}
__name(throwInvalidConfig, "throwInvalidConfig");
function tryParseCCId(from) {
  let ccId;
  if (/^\d+$/.test(from)) {
    ccId = parseInt(from, 10);
  } else if (hexKeyRegexNDigits.test(from)) {
    ccId = parseInt(from.slice(2), 16);
  } else if (from in import_core.CommandClasses) {
    return import_core.CommandClasses[from];
  }
  if (ccId != void 0 && ccId in import_core.CommandClasses) {
    return ccId;
  }
}
__name(tryParseCCId, "tryParseCCId");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  hexKeyRegex2Digits,
  hexKeyRegex4Digits,
  hexKeyRegexNDigits,
  throwInvalidConfig,
  tryParseCCId
});
//# sourceMappingURL=utils_safe.js.map
