import { isArray, isObject } from "alcalzone-shared/typeguards";
import { throwInvalidConfig } from "../utils_safe.js";
import { conditionApplies } from "./ConditionalItem.js";
export function parseConditionalPrimitive(filename, valueType, propertyName, definition, errorMessagePrefix = "") {
    if (isArray(definition)
        && definition.every((i, index, dfn) => 
        // In arrays, only the last item may be non-conditional
        (isObject(i) && typeof i.value === valueType)
            || (index === dfn.length - 1 && typeof i === valueType))) {
        return definition.map((d) => typeof d === valueType
            ? new ConditionalPrimitiveVariant(d)
            : new ConditionalPrimitiveVariant(d.value, typeof d.$if === "string" ? d.$if : undefined));
    }
    else if (typeof definition === valueType) {
        return definition;
    }
    else {
        throwInvalidConfig(`device`, `packages/config/config/devices/${filename}:
${errorMessagePrefix}${propertyName} must be a ${valueType} or an array of conditional ${valueType} entries`);
    }
}
export class ConditionalPrimitiveVariant {
    value;
    condition;
    constructor(value, condition) {
        this.value = value;
        this.condition = condition;
    }
    evaluateCondition(deviceId) {
        if (!conditionApplies(this, deviceId))
            return;
        return this.value;
    }
}
//# sourceMappingURL=ConditionalPrimitive.js.map