import { pick } from "@zwave-js/shared";
import { throwInvalidConfig } from "../utils_safe.js";
import { conditionApplies, validateCondition, } from "./ConditionalItem.js";
export class ConditionalSceneConfig {
    constructor(filename, sceneId, definition) {
        this.sceneId = sceneId;
        validateCondition(filename, definition, `Scene ${sceneId} contains an`);
        this.condition = definition.$if;
        if (typeof definition.label !== "string") {
            throwInvalidConfig("devices", `packages/config/config/devices/${filename}:
Scene ${sceneId} has a non-string label`);
        }
        this.label = definition.label;
        if (definition.description != undefined
            && typeof definition.description !== "string") {
            throwInvalidConfig("devices", `packages/config/config/devices/${filename}:
Scene ${sceneId} has a non-string description`);
        }
        this.description = definition.description;
    }
    condition;
    sceneId;
    label;
    description;
    evaluateCondition(deviceId) {
        if (!conditionApplies(this, deviceId))
            return;
        return pick(this, [
            "sceneId",
            "label",
            "description",
        ]);
    }
}
//# sourceMappingURL=SceneConfig.js.map