import type { CopyFile, ManageDirectory, ReadFile, ReadFileSystemInfo, WriteFile } from "@zwave-js/shared/bindings";
import type { ConfigLogger } from "./Logger.js";
import type { DeviceConfigIndexEntry } from "./devices/DeviceConfig.js";
/** The (optional) absolute path of an external configuration directory */
export declare function getExternalConfigDirEnvVariable(): string | undefined;
export declare function getDeviceEntryPredicate(manufacturerId: number, productType: number, productId: number, firmwareVersion?: string): (entry: DeviceConfigIndexEntry) => boolean;
export type SyncExternalConfigDirResult = {
    success: false;
} | {
    success: true;
    version: string;
};
/**
 * Synchronizes or updates the external config directory and returns whether the directory is in a state that can be used
 */
export declare function syncExternalConfigDir(fs: ManageDirectory & ReadFileSystemInfo & ReadFile & CopyFile & WriteFile, extConfigDir: string, logger: ConfigLogger): Promise<SyncExternalConfigDirResult>;
export declare function versionInRange(version: string, min: string, max: string): boolean;
//# sourceMappingURL=utils.d.ts.map