"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var node_exports = {};
__export(node_exports, {
  NodeFileHandle: () => NodeFileHandle,
  fs: () => fs
});
module.exports = __toCommonJS(node_exports);
var import_shared = require("@zwave-js/shared");
var import_promises = __toESM(require("node:fs/promises"), 1);
var import_node_os = __toESM(require("node:os"), 1);
var import_node_path = __toESM(require("node:path"), 1);
const fs = {
  readDir(path2) {
    return import_promises.default.readdir(path2);
  },
  readFile(path2) {
    return import_promises.default.readFile(path2);
  },
  writeFile(path2, data) {
    return import_promises.default.writeFile(path2, data);
  },
  copyFile(source, dest) {
    return import_promises.default.copyFile(source, dest);
  },
  async ensureDir(path2) {
    await import_promises.default.mkdir(path2, { recursive: true });
  },
  deleteDir(path2) {
    return import_promises.default.rm(path2, { recursive: true, force: true });
  },
  stat(path2) {
    return import_promises.default.stat(path2);
  },
  async open(path2, flags) {
    let mode = "";
    if (!flags.truncate && !flags.read) {
      throw new Error("Cannot open a file writeonly without truncating it");
    }
    if (!flags.write && flags.create) {
      throw new Error("Cannot open a file readonly with create flag");
    }
    if (flags.read && !flags.write) {
      mode = "r";
    } else if (flags.read && flags.write && !flags.create) {
      mode = "r+";
    } else if (flags.write && flags.create && flags.truncate) {
      mode = flags.read ? "w+" : "w";
    }
    return new NodeFileHandle(await import_promises.default.open(path2, mode), {
      read: flags.read,
      write: flags.write
    });
  },
  async makeTempDir(prefix) {
    return import_promises.default.mkdtemp(import_node_path.default.join(import_node_os.default.tmpdir(), prefix));
  }
};
class NodeFileHandle {
  static {
    __name(this, "NodeFileHandle");
  }
  constructor(handle, flags) {
    this.open = true;
    this.handle = handle;
    this.flags = flags;
  }
  open;
  handle;
  flags;
  _readable;
  _writable;
  get readable() {
    if (!this.flags.read) {
      throw new Error("File is not readable");
    }
    if (!this._readable) {
      this._readable = (0, import_shared.fileHandleToReadableStream)(this);
    }
    return this._readable;
  }
  get writable() {
    if (!this.flags.write) {
      throw new Error("File is not writable");
    }
    if (!this._writable) {
      this._writable = (0, import_shared.fileHandleToWritableStream)(this);
    }
    return this._writable;
  }
  async close() {
    if (!this.open)
      return;
    this.open = false;
    await this.handle.close();
  }
  async read(position, length) {
    if (!this.open)
      throw new Error("File is not open");
    const ret = await this.handle.read({
      position,
      length
    });
    return {
      data: ret.buffer.subarray(0, ret.bytesRead),
      bytesRead: ret.bytesRead
    };
  }
  async write(data, position) {
    if (!this.open)
      throw new Error("File is not open");
    const ret = await this.handle.write(data, null, null, position);
    return {
      bytesWritten: ret.bytesWritten
    };
  }
  stat() {
    if (!this.open)
      throw new Error("File is not open");
    return this.handle.stat();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeFileHandle,
  fs
});
//# sourceMappingURL=node.js.map
