"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Protocol_exports = {};
__export(Protocol_exports, {
  LongRangeChannel: () => LongRangeChannel,
  ProtocolDataRate: () => ProtocolDataRate,
  ProtocolType: () => ProtocolType,
  ProtocolVersion: () => ProtocolVersion,
  Protocols: () => Protocols,
  RouteProtocolDataRate: () => RouteProtocolDataRate,
  ZWaveDataRate: () => ZWaveDataRate,
  ZnifferProtocolDataRate: () => ZnifferProtocolDataRate,
  isLongRangeNodeId: () => isLongRangeNodeId,
  protocolDataRateMask: () => protocolDataRateMask,
  protocolDataRateToString: () => protocolDataRateToString,
  znifferProtocolDataRateToString: () => znifferProtocolDataRateToString,
  zwaveDataRateToString: () => zwaveDataRateToString
});
module.exports = __toCommonJS(Protocol_exports);
var import_shared = require("@zwave-js/shared");
var Protocols;
(function(Protocols2) {
  Protocols2[Protocols2["ZWave"] = 0] = "ZWave";
  Protocols2[Protocols2["ZWaveLongRange"] = 1] = "ZWaveLongRange";
})(Protocols || (Protocols = {}));
var ZWaveDataRate;
(function(ZWaveDataRate2) {
  ZWaveDataRate2[ZWaveDataRate2["9k6"] = 1] = "9k6";
  ZWaveDataRate2[ZWaveDataRate2["40k"] = 2] = "40k";
  ZWaveDataRate2[ZWaveDataRate2["100k"] = 3] = "100k";
})(ZWaveDataRate || (ZWaveDataRate = {}));
function zwaveDataRateToString(rate) {
  switch (rate) {
    case ZWaveDataRate["9k6"]:
      return "9.6 kbit/s";
    case ZWaveDataRate["40k"]:
      return "40 kbit/s";
    case ZWaveDataRate["100k"]:
      return "100 kbit/s";
  }
  return `Unknown (${(0, import_shared.num2hex)(rate)})`;
}
__name(zwaveDataRateToString, "zwaveDataRateToString");
var ProtocolDataRate;
(function(ProtocolDataRate2) {
  ProtocolDataRate2[ProtocolDataRate2["ZWave_9k6"] = 1] = "ZWave_9k6";
  ProtocolDataRate2[ProtocolDataRate2["ZWave_40k"] = 2] = "ZWave_40k";
  ProtocolDataRate2[ProtocolDataRate2["ZWave_100k"] = 3] = "ZWave_100k";
  ProtocolDataRate2[ProtocolDataRate2["LongRange_100k"] = 4] = "LongRange_100k";
})(ProtocolDataRate || (ProtocolDataRate = {}));
function protocolDataRateToString(rate) {
  switch (rate) {
    case ProtocolDataRate.ZWave_9k6:
      return "Z-Wave, 9.6 kbit/s";
    case ProtocolDataRate.ZWave_40k:
      return "Z-Wave, 40 kbit/s";
    case ProtocolDataRate.ZWave_100k:
      return "Z-Wave, 100 kbit/s";
    case ProtocolDataRate.LongRange_100k:
      return "Z-Wave Long Range, 100 kbit/s";
  }
  return `Unknown (${(0, import_shared.num2hex)(rate)})`;
}
__name(protocolDataRateToString, "protocolDataRateToString");
var RouteProtocolDataRate;
(function(RouteProtocolDataRate2) {
  RouteProtocolDataRate2[RouteProtocolDataRate2["Unspecified"] = 0] = "Unspecified";
  RouteProtocolDataRate2[RouteProtocolDataRate2["ZWave_9k6"] = 1] = "ZWave_9k6";
  RouteProtocolDataRate2[RouteProtocolDataRate2["ZWave_40k"] = 2] = "ZWave_40k";
  RouteProtocolDataRate2[RouteProtocolDataRate2["ZWave_100k"] = 3] = "ZWave_100k";
  RouteProtocolDataRate2[RouteProtocolDataRate2["LongRange_100k"] = 4] = "LongRange_100k";
})(RouteProtocolDataRate || (RouteProtocolDataRate = {}));
var ZnifferProtocolDataRate;
(function(ZnifferProtocolDataRate2) {
  ZnifferProtocolDataRate2[ZnifferProtocolDataRate2["ZWave_9k6"] = 0] = "ZWave_9k6";
  ZnifferProtocolDataRate2[ZnifferProtocolDataRate2["ZWave_40k"] = 1] = "ZWave_40k";
  ZnifferProtocolDataRate2[ZnifferProtocolDataRate2["ZWave_100k"] = 2] = "ZWave_100k";
  ZnifferProtocolDataRate2[ZnifferProtocolDataRate2["LongRange_100k"] = 3] = "LongRange_100k";
})(ZnifferProtocolDataRate || (ZnifferProtocolDataRate = {}));
function znifferProtocolDataRateToString(rate, includeProtocol = true) {
  if (includeProtocol) {
    switch (rate) {
      case ZnifferProtocolDataRate.ZWave_9k6:
        return "Z-Wave, 9.6 kbit/s";
      case ZnifferProtocolDataRate.ZWave_40k:
        return "Z-Wave, 40 kbit/s";
      case ZnifferProtocolDataRate.ZWave_100k:
        return "Z-Wave, 100 kbit/s";
      case ZnifferProtocolDataRate.LongRange_100k:
        return "Z-Wave Long Range, 100 kbit/s";
    }
  } else {
    switch (rate) {
      case ZnifferProtocolDataRate.ZWave_9k6:
        return "9.6 kbit/s";
      case ZnifferProtocolDataRate.ZWave_40k:
        return "40 kbit/s";
      case ZnifferProtocolDataRate.ZWave_100k:
      case ZnifferProtocolDataRate.LongRange_100k:
        return "100 kbit/s";
    }
  }
  return `Unknown (${(0, import_shared.num2hex)(rate)})`;
}
__name(znifferProtocolDataRateToString, "znifferProtocolDataRateToString");
const protocolDataRateMask = 7;
var ProtocolType;
(function(ProtocolType2) {
  ProtocolType2[ProtocolType2["Z-Wave"] = 0] = "Z-Wave";
  ProtocolType2[ProtocolType2["Z-Wave AV"] = 1] = "Z-Wave AV";
  ProtocolType2[ProtocolType2["Z-Wave for IP"] = 2] = "Z-Wave for IP";
})(ProtocolType || (ProtocolType = {}));
var LongRangeChannel;
(function(LongRangeChannel2) {
  LongRangeChannel2[LongRangeChannel2["Unsupported"] = 0] = "Unsupported";
  LongRangeChannel2[LongRangeChannel2["A"] = 1] = "A";
  LongRangeChannel2[LongRangeChannel2["B"] = 2] = "B";
  LongRangeChannel2[LongRangeChannel2["Auto"] = 255] = "Auto";
})(LongRangeChannel || (LongRangeChannel = {}));
function isLongRangeNodeId(nodeId) {
  return nodeId > 255;
}
__name(isLongRangeNodeId, "isLongRangeNodeId");
var ProtocolVersion;
(function(ProtocolVersion2) {
  ProtocolVersion2[ProtocolVersion2["unknown"] = 0] = "unknown";
  ProtocolVersion2[ProtocolVersion2["2.0"] = 1] = "2.0";
  ProtocolVersion2[ProtocolVersion2["4.2x / 5.0x"] = 2] = "4.2x / 5.0x";
  ProtocolVersion2[ProtocolVersion2["4.5x / 6.0x"] = 3] = "4.5x / 6.0x";
})(ProtocolVersion || (ProtocolVersion = {}));
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  LongRangeChannel,
  ProtocolDataRate,
  ProtocolType,
  ProtocolVersion,
  Protocols,
  RouteProtocolDataRate,
  ZWaveDataRate,
  ZnifferProtocolDataRate,
  isLongRangeNodeId,
  protocolDataRateMask,
  protocolDataRateToString,
  znifferProtocolDataRateToString,
  zwaveDataRateToString
});
//# sourceMappingURL=Protocol.js.map
