"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var parse_exports = {};
__export(parse_exports, {
  parseQRCodeString: () => parseQRCodeString
});
module.exports = __toCommonJS(parse_exports);
var import_shared = require("@zwave-js/shared");
var import_crypto = require("../crypto/index.js");
var import_SecurityClass = require("../definitions/SecurityClass.js");
var import_dsk = require("../dsk/index.js");
var import_Primitive = require("../values/Primitive.js");
var import_definitions = require("./definitions.js");
var import_utils = require("./utils.js");
async function parseQRCodeString(qr) {
  qr = qr.trim();
  if (!qr.startsWith("90"))
    (0, import_utils.fail)("must start with 90");
  if (qr.length < import_definitions.minQRCodeLength)
    (0, import_utils.fail)("too short");
  if (!import_definitions.onlyDigitsRegex.test(qr))
    (0, import_utils.fail)("contains invalid characters");
  const version = (0, import_utils.readLevel)(qr, 2);
  if (version > import_definitions.QRCodeVersion.SmartStart)
    (0, import_utils.fail)("invalid version");
  const checksum = (0, import_utils.readUInt16)(qr, 4);
  const checksumInput = new TextEncoder().encode(qr.slice(9));
  const hashResult = await (0, import_crypto.digest)("sha-1", checksumInput);
  const expectedChecksum = import_shared.Bytes.view(hashResult).readUInt16BE(0);
  if (checksum !== expectedChecksum)
    (0, import_utils.fail)("invalid checksum");
  const requestedKeysBitmask = (0, import_utils.readUInt8)(qr, 9);
  const requestedSecurityClasses = (0, import_Primitive.parseBitMask)([requestedKeysBitmask], import_SecurityClass.SecurityClass.S2_Unauthenticated);
  if (!requestedSecurityClasses.every((k) => k in import_SecurityClass.SecurityClass)) {
    (0, import_utils.fail)("invalid security class requested");
  }
  let offset = 12;
  const dsk = new import_shared.Bytes(16);
  for (let dskBlock = 0; dskBlock < 8; dskBlock++) {
    const block = (0, import_utils.readUInt16)(qr, offset);
    dsk.writeUInt16BE(block, dskBlock * 2);
    offset += 5;
  }
  const ret = {
    version,
    // This seems like a duplication, but it's more convenient for applications to not have to copy this field over
    requestedSecurityClasses,
    securityClasses: [...requestedSecurityClasses],
    dsk: (0, import_dsk.dskToString)(dsk)
  };
  let hasProductID = false;
  let hasProductType = false;
  while (offset < qr.length) {
    const { entry: { type, ...data }, charsRead } = (0, import_utils.parseTLV)(qr.slice(offset));
    offset += charsRead;
    if (type === import_definitions.ProvisioningInformationType.ProductId) {
      hasProductID = true;
    } else if (type === import_definitions.ProvisioningInformationType.ProductType) {
      hasProductType = true;
    }
    Object.assign(ret, data);
  }
  if (!hasProductID || !hasProductType) {
    (0, import_utils.fail)("missing required fields");
  }
  return ret;
}
__name(parseQRCodeString, "parseQRCodeString");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  parseQRCodeString
});
//# sourceMappingURL=parse.js.map
