"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Sensors_exports = {};
__export(Sensors_exports, {
  getAllSensorScales: () => getAllSensorScales,
  getAllSensors: () => getAllSensors,
  getSensor: () => getSensor,
  getSensorName: () => getSensorName,
  getSensorScale: () => getSensorScale
});
module.exports = __toCommonJS(Sensors_exports);
var import_shared = require("@zwave-js/shared");
var import_Scales = require("./Scales.js");
function useNamedScales(name) {
  return { scaleGroupName: name, scales: (0, import_Scales.getNamedScaleGroup)(name) };
}
__name(useNamedScales, "useNamedScales");
const sensors = Object.freeze({
  [1]: {
    label: "Air temperature",
    ...useNamedScales("temperature")
  },
  [2]: {
    label: "General purpose",
    scales: {
      [0]: {
        label: "Percentage value",
        unit: "%"
      },
      [1]: {
        label: "Dimensionless value"
      }
    }
  },
  [3]: {
    label: "Illuminance",
    scales: {
      [0]: {
        label: "Percentage value",
        unit: "%"
      },
      [1]: {
        label: "Lux",
        unit: "Lux"
      }
    }
  },
  [4]: {
    label: "Power",
    scales: {
      [0]: {
        label: "Watt",
        unit: "W"
      },
      [1]: {
        label: "Btu/h",
        unit: "Btu/h"
      }
    }
  },
  [5]: {
    label: "Humidity",
    ...useNamedScales("humidity")
  },
  [6]: {
    label: "Velocity",
    scales: {
      [0]: {
        label: "m/s",
        unit: "m/s"
      },
      [1]: {
        label: "Mph",
        unit: "Mph"
      }
    }
  },
  [7]: {
    label: "Direction",
    ...useNamedScales("direction")
  },
  [8]: {
    label: "Atmospheric pressure",
    ...useNamedScales("airPressure")
  },
  [9]: {
    label: "Barometric pressure",
    ...useNamedScales("airPressure")
  },
  [10]: {
    label: "Solar radiation",
    scales: {
      [0]: {
        label: "Watt per square meter",
        unit: "W/m\xB2"
      }
    }
  },
  [11]: {
    label: "Dew point",
    ...useNamedScales("temperature")
  },
  [12]: {
    label: "Rain rate",
    scales: {
      [0]: {
        label: "Millimeter/hour",
        unit: "mm/h"
      },
      [1]: {
        label: "Inches per hour",
        unit: "in/h"
      }
    }
  },
  [13]: {
    label: "Tide level",
    scales: {
      [0]: {
        label: "Meter",
        unit: "m"
      },
      [1]: {
        label: "Feet",
        unit: "ft"
      }
    }
  },
  [14]: {
    label: "Weight",
    scales: {
      [0]: {
        label: "Kilogram",
        unit: "kg"
      },
      [1]: {
        label: "Pounds",
        unit: "lb"
      }
    }
  },
  [15]: {
    label: "Voltage",
    scales: {
      [0]: {
        label: "Volt",
        unit: "V"
      },
      [1]: {
        label: "Millivolt",
        unit: "mV"
      }
    }
  },
  [16]: {
    label: "Current",
    scales: {
      [0]: {
        label: "Ampere",
        unit: "A"
      },
      [1]: {
        label: "Milliampere",
        unit: "mA"
      }
    }
  },
  [17]: {
    label: "Carbon dioxide (CO\u2082) level",
    scales: {
      [0]: {
        label: "Parts/million",
        unit: "ppm"
      }
    }
  },
  [18]: {
    label: "Air flow",
    scales: {
      [0]: {
        label: "Cubic meter per hour",
        unit: "m\xB3/h"
      },
      [1]: {
        label: "Cubic feet per minute",
        unit: "cfm"
      }
    }
  },
  [19]: {
    label: "Tank capacity",
    scales: {
      [0]: {
        label: "Liter",
        unit: "l"
      },
      [1]: {
        label: "Cubic meter",
        unit: "m\xB3"
      },
      [2]: {
        label: "Gallons",
        unit: "gallon"
      }
    }
  },
  [20]: {
    label: "Distance",
    scales: {
      [0]: {
        label: "Meter",
        unit: "m"
      },
      [1]: {
        label: "Centimeter",
        unit: "cm"
      },
      [2]: {
        label: "Feet",
        unit: "ft"
      }
    }
  },
  [21]: {
    label: "Angle position",
    scales: {
      [0]: {
        label: "Percentage value",
        unit: "%"
      },
      [1]: {
        label: "Degrees relative to north pole of standing eye view",
        unit: "\xB0N"
      },
      [2]: {
        label: "Degrees relative to south pole of standing eye view",
        unit: "\xB0S"
      }
    }
  },
  [22]: {
    label: "Rotation",
    scales: {
      [0]: {
        label: "Revolutions per minute",
        unit: "rpm"
      },
      [1]: {
        label: "Hertz",
        unit: "Hz"
      }
    }
  },
  [23]: {
    label: "Water temperature",
    ...useNamedScales("temperature")
  },
  [24]: {
    label: "Soil temperature",
    ...useNamedScales("temperature")
  },
  [25]: {
    label: "Seismic Intensity",
    scales: {
      [0]: {
        label: "Mercalli"
      },
      [1]: {
        label: "European Macroseismic"
      },
      [2]: {
        label: "Liedu"
      },
      [3]: {
        label: "Shindo"
      }
    }
  },
  [26]: {
    label: "Seismic magnitude",
    scales: {
      [0]: {
        label: "Local"
      },
      [1]: {
        label: "Moment"
      },
      [2]: {
        label: "Surface wave"
      },
      [3]: {
        label: "Body wave"
      }
    }
  },
  [27]: {
    label: "Ultraviolet",
    scales: {
      [0]: {
        label: "UV index"
      }
    }
  },
  [28]: {
    label: "Electrical resistivity",
    scales: {
      [0]: {
        label: "Ohm meter",
        unit: "\u03A9m"
      }
    }
  },
  [29]: {
    label: "Electrical conductivity",
    scales: {
      [0]: {
        label: "Siemens per meter",
        unit: "S/m"
      }
    }
  },
  [30]: {
    label: "Loudness",
    scales: {
      [0]: {
        label: "Decibel",
        unit: "dB"
      },
      [1]: {
        label: "A-weighted decibels",
        unit: "dBA"
      }
    }
  },
  [31]: {
    label: "Moisture",
    scales: {
      [0]: {
        label: "Percentage value",
        unit: "%"
      },
      [1]: {
        label: "Volume water content",
        unit: "m\xB3/m\xB3"
      },
      [2]: {
        label: "Impedance",
        unit: "k\u03A9"
      },
      [3]: {
        label: "Water activity",
        unit: "aw"
      }
    }
  },
  [32]: {
    label: "Frequency",
    scales: {
      [0]: {
        label: "Hertz",
        unit: "Hz",
        description: "MUST be used until 2.147483647 GHz"
      },
      [1]: {
        label: "Kilohertz",
        unit: "kHz",
        description: "MUST be used after 2.147483647 GHz"
      }
    }
  },
  [33]: {
    label: "Time",
    scales: {
      [0]: {
        label: "Second",
        unit: "s"
      }
    }
  },
  [34]: {
    label: "Target temperature",
    ...useNamedScales("temperature")
  },
  [35]: {
    label: "Particulate Matter 2.5",
    scales: {
      [0]: {
        label: "Mole per cubic meter",
        unit: "mol/m\xB3"
      },
      [1]: {
        label: "Microgram per cubic meter",
        unit: "\xB5g/m\xB3"
      }
    }
  },
  [36]: {
    label: "Formaldehyde (CH\u2082O) level",
    scales: {
      [0]: {
        label: "Mole per cubic meter",
        unit: "mol/m\xB3"
      }
    }
  },
  [37]: {
    label: "Radon concentration",
    scales: {
      [0]: {
        label: "Becquerel per cubic meter",
        unit: "bq/m\xB3"
      },
      [1]: {
        label: "Picocuries per liter",
        unit: "pCi/l"
      }
    }
  },
  [38]: {
    label: "Methane (CH\u2084) density",
    scales: {
      [0]: {
        label: "Mole per cubic meter",
        unit: "mol/m\xB3"
      }
    }
  },
  [39]: {
    label: "Volatile Organic Compound level",
    scales: {
      [0]: {
        label: "Mole per cubic meter",
        unit: "mol/m\xB3"
      },
      [1]: {
        label: "Parts/million",
        unit: "ppm"
      }
    }
  },
  [40]: {
    label: "Carbon monoxide (CO) level",
    scales: {
      [0]: {
        label: "Mole per cubic meter",
        unit: "mol/m\xB3"
      },
      [1]: {
        label: "Parts/million",
        unit: "ppm"
      }
    }
  },
  [41]: {
    label: "Soil humidity",
    ...useNamedScales("percentage")
  },
  [42]: {
    label: "Soil reactivity",
    ...useNamedScales("acidity")
  },
  [43]: {
    label: "Soil salinity",
    scales: {
      [0]: {
        label: "Mole per cubic meter",
        unit: "mol/m\xB3"
      }
    }
  },
  [44]: {
    label: "Heart rate",
    scales: {
      [0]: {
        label: "Beats per minute",
        unit: "bpm"
      }
    }
  },
  [45]: {
    label: "Blood pressure",
    scales: {
      [0]: {
        label: "Systolic",
        unit: "mmHg"
      },
      [1]: {
        label: "Diastolic",
        unit: "mmHg"
      }
    }
  },
  [46]: {
    label: "Muscle mass",
    ...useNamedScales("mass")
  },
  [47]: {
    label: "Fat mass",
    ...useNamedScales("mass")
  },
  [48]: {
    label: "Bone mass",
    ...useNamedScales("mass")
  },
  [49]: {
    label: "Total body water (TBW)",
    ...useNamedScales("mass")
  },
  [50]: {
    label: "Basis metabolic rate (BMR)",
    scales: {
      [0]: {
        label: "Joule",
        unit: "J"
      }
    }
  },
  [51]: {
    label: "Body Mass Index (BMI)",
    scales: {
      [0]: {
        label: "Body Mass Index"
      }
    }
  },
  [52]: {
    label: "Acceleration X-axis",
    ...useNamedScales("acceleration")
  },
  [53]: {
    label: "Acceleration Y-axis",
    ...useNamedScales("acceleration")
  },
  [54]: {
    label: "Acceleration Z-axis",
    ...useNamedScales("acceleration")
  },
  [55]: {
    label: "Smoke density",
    ...useNamedScales("percentage")
  },
  [56]: {
    label: "Water flow",
    scales: {
      [0]: {
        label: "Liter per hour",
        unit: "l/h"
      }
    }
  },
  [57]: {
    label: "Water pressure",
    scales: {
      [0]: {
        label: "Kilopascal",
        unit: "kPa"
      }
    }
  },
  [58]: {
    label: "RF signal strength",
    scales: {
      [0]: {
        label: "RSSI",
        unit: "%"
      },
      [1]: {
        label: "Power Level",
        unit: "dBm"
      }
    }
  },
  [59]: {
    label: "Particulate Matter 10",
    scales: {
      [0]: {
        label: "Mole per cubic meter",
        unit: "mol/m\xB3"
      },
      [1]: {
        label: "Microgram per cubic meter",
        unit: "\xB5g/m\xB3"
      }
    }
  },
  [60]: {
    label: "Respiratory rate",
    scales: {
      [0]: {
        label: "Breaths per minute",
        unit: "bpm"
      }
    }
  },
  [61]: {
    label: "Relative Modulation level",
    ...useNamedScales("percentage")
  },
  [62]: {
    label: "Boiler water temperature",
    ...useNamedScales("temperature")
  },
  [63]: {
    label: "Domestic Hot Water (DHW) temperature",
    ...useNamedScales("temperature")
  },
  [64]: {
    label: "Outside temperature",
    ...useNamedScales("temperature")
  },
  [65]: {
    label: "Exhaust temperature",
    ...useNamedScales("temperature")
  },
  [66]: {
    label: "Water Chlorine level",
    scales: {
      [0]: {
        label: "Milligram per liter",
        unit: "mg/l"
      }
    }
  },
  [67]: {
    label: "Water acidity",
    ...useNamedScales("acidity")
  },
  [68]: {
    label: "Water Oxidation reduction potential",
    scales: {
      [0]: {
        label: "Millivolt",
        unit: "mV"
      }
    }
  },
  [69]: {
    label: "Heart Rate LF/HF ratio",
    ...useNamedScales("unitless")
  },
  [70]: {
    label: "Motion Direction",
    ...useNamedScales("direction")
  },
  [71]: {
    label: "Applied force on the sensor",
    scales: {
      [0]: {
        label: "Newton",
        unit: "N"
      }
    }
  },
  [72]: {
    label: "Return Air temperature",
    ...useNamedScales("temperature")
  },
  [73]: {
    label: "Supply Air temperature",
    ...useNamedScales("temperature")
  },
  [74]: {
    label: "Condenser Coil temperature",
    ...useNamedScales("temperature")
  },
  [75]: {
    label: "Evaporator Coil temperature",
    ...useNamedScales("temperature")
  },
  [76]: {
    label: "Liquid Line temperature",
    ...useNamedScales("temperature")
  },
  [77]: {
    label: "Discharge Line temperature",
    ...useNamedScales("temperature")
  },
  [78]: {
    label: "Suction Pressure",
    ...useNamedScales("pressure")
  },
  [79]: {
    label: "Discharge Pressure",
    ...useNamedScales("pressure")
  },
  [80]: {
    label: "Defrost temperature",
    ...useNamedScales("temperature")
  },
  [81]: {
    label: "Ozone",
    ...useNamedScales("density")
  },
  [82]: {
    label: "Sulfur dioxide",
    ...useNamedScales("density")
  },
  [83]: {
    label: "Nitrogen dioxide",
    ...useNamedScales("density")
  },
  [84]: {
    label: "Ammonia",
    ...useNamedScales("density")
  },
  [85]: {
    label: "Lead",
    ...useNamedScales("density")
  },
  [86]: {
    label: "Particulate Matter 1",
    ...useNamedScales("density")
  },
  [87]: {
    label: "Person counter (entering)",
    ...useNamedScales("unitless")
  },
  [88]: {
    label: "Person counter (exiting)",
    ...useNamedScales("unitless")
  }
});
function getSensor(type) {
  const sensor = sensors[type];
  if (!sensor)
    return;
  return {
    key: type,
    ...sensor
  };
}
__name(getSensor, "getSensor");
function getSensorName(sensorType) {
  return getSensor(sensorType)?.label ?? `UNKNOWN (${(0, import_shared.num2hex)(sensorType)})`;
}
__name(getSensorName, "getSensorName");
function getAllSensors() {
  return Object.entries(sensors).map(([key, value]) => ({ key: parseInt(key, 10), ...value }));
}
__name(getAllSensors, "getAllSensors");
function getSensorScale(type, scale) {
  const sensor = getSensor(type);
  if (!sensor)
    return;
  const scaleDef = (sensor?.scales)[scale];
  if (!scaleDef)
    return;
  return {
    key: scale,
    ...scaleDef
  };
}
__name(getSensorScale, "getSensorScale");
function getAllSensorScales(sensorType) {
  const sensor = getSensor(sensorType);
  if (!sensor)
    return;
  return Object.entries(sensor.scales).map(([key, scale]) => ({ key: parseInt(key, 10), ...scale }));
}
__name(getAllSensorScales, "getAllSensorScales");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getAllSensorScales,
  getAllSensors,
  getSensor,
  getSensorName,
  getSensorScale
});
//# sourceMappingURL=Sensors.js.map
