/** Management class and utils for Security S0 */
import { type BytesView } from "@zwave-js/shared";
export declare function generateAuthKey(networkKey: BytesView): Promise<BytesView>;
export declare function generateEncryptionKey(networkKey: BytesView): Promise<BytesView>;
interface NonceKey {
    /** The node that has created this nonce */
    issuer: number;
    nonceId: number;
}
interface NonceEntry {
    nonce: BytesView;
    /** The node this nonce was created for */
    receiver: number;
}
export interface SecurityManagerOptions {
    networkKey: BytesView;
    ownNodeId: number;
    nonceTimeout: number;
}
export interface SetNonceOptions {
    free?: boolean;
}
export declare class SecurityManager {
    constructor(options: SecurityManagerOptions);
    private ownNodeId;
    private nonceTimeout;
    private _networkKey;
    get networkKey(): BytesView;
    set networkKey(v: BytesView);
    private _authKey;
    getAuthKey(): Promise<BytesView>;
    private _encryptionKey;
    getEncryptionKey(): Promise<BytesView>;
    private _nonceStore;
    private _freeNonceIDs;
    private _nonceTimers;
    private normalizeId;
    /** Generates a nonce for the current node */
    generateNonce(receiver: number, length: number): BytesView;
    getNonceId(nonce: BytesView): number;
    setNonce(id: number | NonceKey, entry: NonceEntry, { free }?: SetNonceOptions): void;
    /** Deletes ALL nonces that were issued for a given node */
    deleteAllNoncesForReceiver(receiver: number): void;
    deleteNonce(id: number | NonceKey): void;
    private deleteNonceInternal;
    private expireNonce;
    getNonce(id: number | NonceKey): BytesView | undefined;
    hasNonce(id: number | NonceKey): boolean;
    getFreeNonce(nodeId: number): BytesView | undefined;
}
export {};
//# sourceMappingURL=Manager.d.ts.map