import type { BytesView } from "@zwave-js/shared";
import type { S2SecurityClass, SecurityClass } from "../definitions/SecurityClass.js";
import type { CtrDRBG } from "./ctr_drbg.js";
export interface NetworkKeys {
    pnk: BytesView;
    keyCCM: BytesView;
    keyMPAN: BytesView;
    personalizationString: BytesView;
}
export interface TempNetworkKeys {
    keyCCM: BytesView;
    personalizationString: BytesView;
}
export declare enum SPANState {
    /** No entry exists */
    None = 0,
    RemoteEI = 1,
    LocalEI = 2,
    SPAN = 3
}
export declare enum MPANState {
    /** No entry exists */
    None = 0,
    /** The group is in use, but no MPAN was received yet, or it is out of sync */
    OutOfSync = 1,
    /** An MPAN has been established */
    MPAN = 2
}
export type SPANTableEntry = {
    type: SPANState.RemoteEI;
    receiverEI: BytesView;
} | {
    type: SPANState.LocalEI;
    receiverEI: BytesView;
} | {
    type: SPANState.SPAN;
    securityClass: SecurityClass;
    rng: CtrDRBG;
    /** The most recent generated SPAN */
    currentSPAN?: {
        nonce: BytesView;
        expires: number;
    };
};
export type MPANTableEntry = {
    type: MPANState.OutOfSync;
} | {
    type: MPANState.MPAN;
    currentMPAN: BytesView;
};
export interface MulticastGroup {
    nodeIDs: readonly number[];
    securityClass: S2SecurityClass;
    sequenceNumber: number;
}
//# sourceMappingURL=Manager2Types.d.ts.map