"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var sucUpdateEntry_exports = {};
__export(sucUpdateEntry_exports, {
  encodeSUCUpdateEntry: () => encodeSUCUpdateEntry,
  parseSUCUpdateEntry: () => parseSUCUpdateEntry
});
module.exports = __toCommonJS(sucUpdateEntry_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_consts = require("../../consts.js");
function parseSUCUpdateEntry(buffer, offset) {
  const slice = buffer.subarray(offset, offset + import_consts.SUC_UPDATE_ENTRY_SIZE);
  if (slice.every((b) => b === 0 || b === 255)) {
    return;
  }
  const nodeId = slice[0];
  const changeType = slice[1];
  const { supportedCCs, controlledCCs } = (0, import_core.parseCCList)(slice.subarray(2, import_consts.SUC_UPDATE_ENTRY_SIZE));
  return {
    nodeId,
    changeType,
    supportedCCs: supportedCCs.filter((cc) => cc > 0),
    controlledCCs: controlledCCs.filter((cc) => cc > 0)
  };
}
__name(parseSUCUpdateEntry, "parseSUCUpdateEntry");
function encodeSUCUpdateEntry(entry) {
  const ret = new import_shared.Bytes(import_consts.SUC_UPDATE_ENTRY_SIZE).fill(0);
  if (entry) {
    ret[0] = entry.nodeId;
    ret[1] = entry.changeType;
    const ccList = (0, import_core.encodeCCList)(entry.supportedCCs, entry.controlledCCs);
    if (ccList.length > import_consts.SUC_UPDATE_NODEPARM_MAX) {
      throw new import_core.ZWaveError("Cannot encode SUC update entry, too many CCs", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    ret.set(ccList, 2);
  }
  return ret;
}
__name(encodeSUCUpdateEntry, "encodeSUCUpdateEntry");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  encodeSUCUpdateEntry,
  parseSUCUpdateEntry
});
//# sourceMappingURL=sucUpdateEntry.js.map
