"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NVMMemoryIO_exports = {};
__export(NVMMemoryIO_exports, {
  NVMMemoryIO: () => NVMMemoryIO
});
module.exports = __toCommonJS(NVMMemoryIO_exports);
var import_core = require("@zwave-js/core");
var import_definitions = require("../common/definitions.js");
class NVMMemoryIO {
  static {
    __name(this, "NVMMemoryIO");
  }
  constructor(buffer) {
    this._buffer = buffer;
  }
  _buffer;
  open(_access) {
    return Promise.resolve(import_definitions.NVMAccess.ReadWrite);
  }
  get size() {
    return this._buffer.length;
  }
  get accessMode() {
    return import_definitions.NVMAccess.ReadWrite;
  }
  determineChunkSize() {
    return Promise.resolve(this._buffer.length);
  }
  read(offset, length) {
    return Promise.resolve({
      buffer: this._buffer.subarray(offset, offset + length),
      endOfFile: offset + length >= this._buffer.length
    });
  }
  write(offset, data) {
    if (offset + data.length > this.size) {
      throw new import_core.ZWaveError("Write would exceed the NVM size", import_core.ZWaveErrorCodes.NVM_NoSpace);
    }
    this._buffer.set(data, offset);
    return Promise.resolve({
      bytesWritten: data.length,
      endOfFile: offset + data.length >= this._buffer.length
    });
  }
  close() {
    return Promise.resolve();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NVMMemoryIO
});
//# sourceMappingURL=NVMMemoryIO.js.map
