import type { NVM3 } from "../NVM3.js";
import type { NVMAdapter, NVMProperty, NVMPropertyToDataType } from "../common/definitions.js";
import { NVMFile } from "./files/index.js";
export declare class NVM3Adapter implements NVMAdapter {
    constructor(nvm: NVM3);
    private _nvm;
    private _initialized;
    private _protocolInfo;
    private _applicationInfo;
    /** A list of pending changes that haven't been written to the NVM yet. `null` indicates a deleted entry. */
    private _pendingChanges;
    private getFileVersion;
    private init;
    /** Adds a complete file to the list of pending changes */
    setFile(file: NVMFile): void;
    hasFile(fileId: number): Promise<boolean>;
    private _getFile;
    private _expectFile;
    getFile<T extends NVMFile = NVMFile>(fileId: number, required: true): Promise<T>;
    getFile<T extends NVMFile = NVMFile>(fileId: number, required?: false): Promise<T | undefined>;
    get<T extends NVMProperty, R extends boolean = boolean>(property: T, required?: R): Promise<R extends true ? NVMPropertyToDataType<T> : (NVMPropertyToDataType<T> | undefined)>;
    private getControllerNVMProperty;
    private getNodeNVMProperty;
    private getLRNodeNVMProperty;
    set<T extends NVMProperty>(property: T, value: NVMPropertyToDataType<T>): Promise<void>;
    private setControllerNVMProperty;
    private setLRNodeNVMProperty;
    private setNodeNVMProperty;
    delete(property: NVMProperty): Promise<void>;
    hasPendingChanges(): boolean;
    commit(): Promise<void>;
}
//# sourceMappingURL=adapter.d.ts.map