"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ControllerInfoFile_exports = {};
__export(ControllerInfoFile_exports, {
  ControllerInfoFile: () => ControllerInfoFile,
  ControllerInfoFileID: () => ControllerInfoFileID
});
module.exports = __toCommonJS(ControllerInfoFile_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_NVMFile = require("./NVMFile.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const ControllerInfoFileID = 327684;
let ControllerInfoFile = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)(ControllerInfoFileID), (0, import_NVMFile.nvmSection)("protocol")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var ControllerInfoFile2 = class extends _classSuper {
    static {
      __name(this, "ControllerInfoFile");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ControllerInfoFile2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        this.homeId = this.payload.subarray(0, 4);
        if (this.payload.length === 13) {
          this.nodeId = this.payload[4];
          this.lastNodeId = this.payload[5];
          this.staticControllerNodeId = this.payload[6];
          this.sucLastIndex = this.payload[7];
          this.controllerConfiguration = this.payload[8];
          this.sucAwarenessPushNeeded = this.payload[9];
          this.maxNodeId = this.payload[10];
          this.reservedId = this.payload[11];
          this.systemState = this.payload[12];
        } else if (this.payload.length === 22) {
          this.nodeId = this.payload.readUInt16LE(4);
          this.staticControllerNodeId = this.payload.readUInt16LE(6);
          this.lastNodeIdLR = this.payload.readUInt16LE(8);
          this.lastNodeId = this.payload[10];
          this.sucLastIndex = this.payload[11];
          this.maxNodeIdLR = this.payload.readUInt16LE(12);
          this.maxNodeId = this.payload[14];
          this.controllerConfiguration = this.payload[15];
          this.reservedIdLR = this.payload.readUInt16LE(16);
          this.reservedId = this.payload[18];
          this.systemState = this.payload[19];
          this.primaryLongRangeChannelId = this.payload[20];
          this.dcdcConfig = this.payload[21];
        } else {
          throw new import_core.ZWaveError(`Unsupported payload length`, import_core.ZWaveErrorCodes.NVM_InvalidFormat);
        }
      } else {
        this.homeId = import_shared.Bytes.view(options.homeId);
        this.nodeId = options.nodeId;
        this.lastNodeId = options.lastNodeId;
        this.staticControllerNodeId = options.staticControllerNodeId;
        this.sucLastIndex = options.sucLastIndex;
        this.controllerConfiguration = options.controllerConfiguration;
        this.maxNodeId = options.maxNodeId;
        this.reservedId = options.reservedId;
        this.systemState = options.systemState;
        if ("lastNodeIdLR" in options) {
          this.lastNodeIdLR = options.lastNodeIdLR;
          this.maxNodeIdLR = options.maxNodeIdLR;
          this.reservedIdLR = options.reservedIdLR;
          this.primaryLongRangeChannelId = options.primaryLongRangeChannelId;
          this.dcdcConfig = options.dcdcConfig;
        } else {
          this.sucAwarenessPushNeeded = options.sucAwarenessPushNeeded;
        }
      }
    }
    homeId;
    nodeId;
    lastNodeId;
    staticControllerNodeId;
    sucLastIndex;
    controllerConfiguration;
    // TODO: Figure out what this is
    sucAwarenessPushNeeded;
    maxNodeId;
    reservedId;
    systemState;
    lastNodeIdLR;
    maxNodeIdLR;
    reservedIdLR;
    primaryLongRangeChannelId;
    dcdcConfig;
    serialize() {
      if (this.lastNodeIdLR != void 0) {
        this.payload = new import_shared.Bytes(22);
        this.payload.set(this.homeId, 0);
        this.payload.writeUInt16LE(this.nodeId, 4);
        this.payload.writeUInt16LE(this.staticControllerNodeId, 6);
        this.payload.writeUInt16LE(this.lastNodeIdLR, 8);
        this.payload[10] = this.lastNodeId;
        this.payload[11] = this.sucLastIndex;
        this.payload.writeUInt16LE(this.maxNodeIdLR, 12);
        this.payload[14] = this.maxNodeId;
        this.payload[15] = this.controllerConfiguration;
        this.payload.writeUInt16LE(this.reservedIdLR, 16);
        this.payload[18] = this.reservedId;
        this.payload[19] = this.systemState;
        this.payload[20] = this.primaryLongRangeChannelId;
        this.payload[21] = this.dcdcConfig;
      } else {
        this.payload = import_shared.Bytes.concat([
          this.homeId,
          import_shared.Bytes.from([
            this.nodeId,
            this.lastNodeId,
            this.staticControllerNodeId,
            this.sucLastIndex,
            this.controllerConfiguration,
            this.sucAwarenessPushNeeded ?? 0,
            this.maxNodeId,
            this.reservedId,
            this.systemState
          ])
        ]);
      }
      return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
      return (0, import_core.stripUndefined)({
        ...super.toJSON(),
        homeId: (0, import_shared.buffer2hex)(this.homeId),
        nodeId: this.nodeId,
        lastNodeId: this.lastNodeId,
        staticControllerNodeId: this.staticControllerNodeId,
        sucLastIndex: this.sucLastIndex,
        controllerConfiguration: this.controllerConfiguration,
        sucAwarenessPushNeeded: this.sucAwarenessPushNeeded,
        maxNodeId: this.maxNodeId,
        reservedId: this.reservedId,
        systemState: this.systemState,
        lastNodeIdLR: this.lastNodeIdLR,
        maxNodeIdLR: this.maxNodeIdLR,
        reservedIdLR: this.reservedIdLR,
        primaryLongRangeChannelId: this.primaryLongRangeChannelId,
        dcdcConfig: this.dcdcConfig
      });
    }
  };
  return ControllerInfoFile2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ControllerInfoFile,
  ControllerInfoFileID
});
//# sourceMappingURL=ControllerInfoFile.js.map
