"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var shared_exports = {};
__export(shared_exports, {
  APPL_NODEPARM_MAX: () => APPL_NODEPARM_MAX,
  CONFIGURATION_VALID_0: () => CONFIGURATION_VALID_0,
  CONFIGURATION_VALID_1: () => CONFIGURATION_VALID_1,
  MAGIC_VALUE: () => MAGIC_VALUE,
  MAX_REPEATERS: () => MAX_REPEATERS,
  NVMEntrySizes: () => NVMEntrySizes,
  NVMEntryType: () => NVMEntryType,
  NVMModuleType: () => NVMModuleType,
  NVM_SERIALAPI_HOST_SIZE: () => NVM_SERIALAPI_HOST_SIZE,
  POWERLEVEL_CHANNELS: () => POWERLEVEL_CHANNELS,
  ROUTECACHE_VALID: () => ROUTECACHE_VALID,
  RTC_TIMER_SIZE: () => RTC_TIMER_SIZE,
  SUC_CONTROLLER_LIST_SIZE: () => SUC_CONTROLLER_LIST_SIZE,
  TOTAL_RTC_TIMER_MAX: () => TOTAL_RTC_TIMER_MAX,
  resolveLayout: () => resolveLayout
});
module.exports = __toCommonJS(shared_exports);
var import_core = require("@zwave-js/core");
var import_consts = require("../../consts.js");
var NVMEntryType;
(function(NVMEntryType2) {
  NVMEntryType2[NVMEntryType2["NVMModuleSize"] = 0] = "NVMModuleSize";
  NVMEntryType2[NVMEntryType2["Byte"] = 1] = "Byte";
  NVMEntryType2[NVMEntryType2["Word"] = 2] = "Word";
  NVMEntryType2[NVMEntryType2["DWord"] = 3] = "DWord";
  NVMEntryType2[NVMEntryType2["Buffer"] = 4] = "Buffer";
  NVMEntryType2[NVMEntryType2["NodeInfo"] = 5] = "NodeInfo";
  NVMEntryType2[NVMEntryType2["NodeMask"] = 6] = "NodeMask";
  NVMEntryType2[NVMEntryType2["SUCUpdateEntry"] = 7] = "SUCUpdateEntry";
  NVMEntryType2[NVMEntryType2["Route"] = 8] = "Route";
  NVMEntryType2[NVMEntryType2["NVMModuleDescriptor"] = 9] = "NVMModuleDescriptor";
  NVMEntryType2[NVMEntryType2["NVMDescriptor"] = 10] = "NVMDescriptor";
})(NVMEntryType || (NVMEntryType = {}));
const NVMEntrySizes = {
  [NVMEntryType.NVMModuleSize]: 2,
  // Marks the start of an NVM module
  [NVMEntryType.Byte]: 1,
  [NVMEntryType.Word]: 2,
  [NVMEntryType.DWord]: 4,
  [NVMEntryType.Buffer]: 1,
  // The size must be specified
  [NVMEntryType.NodeInfo]: 5,
  // 3 bytes NodeProtocolInfo + generic + specific device class
  [NVMEntryType.NodeMask]: import_core.NUM_NODEMASK_BYTES,
  // Nodes bitmask
  [NVMEntryType.SUCUpdateEntry]: import_consts.SUC_UPDATE_ENTRY_SIZE,
  [NVMEntryType.Route]: 5,
  // a Route
  [NVMEntryType.NVMModuleDescriptor]: 5,
  // 2 bytes module size, 1 byte module type, 2 bytes module version
  [NVMEntryType.NVMDescriptor]: 12
};
var NVMModuleType;
(function(NVMModuleType2) {
  NVMModuleType2[NVMModuleType2["UNDEFINED"] = 0] = "UNDEFINED";
  NVMModuleType2[NVMModuleType2["ZW_PHY_LIBRARY"] = 1] = "ZW_PHY_LIBRARY";
  NVMModuleType2[NVMModuleType2["ZW_LIBRARY"] = 2] = "ZW_LIBRARY";
  NVMModuleType2[NVMModuleType2["ZW_FRAMEWORK"] = 3] = "ZW_FRAMEWORK";
  NVMModuleType2[NVMModuleType2["APPLICATION"] = 4] = "APPLICATION";
  NVMModuleType2[NVMModuleType2["HOST_APPLICATION"] = 5] = "HOST_APPLICATION";
  NVMModuleType2[NVMModuleType2["SECURITY_2"] = 6] = "SECURITY_2";
  NVMModuleType2[NVMModuleType2["NVM_DESCRIPTOR"] = 255] = "NVM_DESCRIPTOR";
})(NVMModuleType || (NVMModuleType = {}));
const SUC_CONTROLLER_LIST_SIZE = 232;
const MAX_REPEATERS = 4;
const NVM_SERIALAPI_HOST_SIZE = 2048;
const POWERLEVEL_CHANNELS = 3;
const APPL_NODEPARM_MAX = 35;
const RTC_TIMER_SIZE = 16;
const TOTAL_RTC_TIMER_MAX = 8 + 2;
const CONFIGURATION_VALID_0 = 84;
const CONFIGURATION_VALID_1 = 165;
const ROUTECACHE_VALID = 74;
const MAGIC_VALUE = 66;
function resolveLayout(layout) {
  const ret = /* @__PURE__ */ new Map();
  let offset = 0;
  for (const entry of layout) {
    const size = entry.size ?? NVMEntrySizes[entry.type];
    const resolvedEntry = {
      ...entry,
      size,
      offset: entry.offset ?? offset
    };
    ret.set(resolvedEntry.name, resolvedEntry);
    offset += size * entry.count;
  }
  const endMarker = ret.get("nvmModuleSizeEndMarker");
  const nvmSize = endMarker.offset + endMarker.size;
  return { layout: ret, nvmSize };
}
__name(resolveLayout, "resolveLayout");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  APPL_NODEPARM_MAX,
  CONFIGURATION_VALID_0,
  CONFIGURATION_VALID_1,
  MAGIC_VALUE,
  MAX_REPEATERS,
  NVMEntrySizes,
  NVMEntryType,
  NVMModuleType,
  NVM_SERIALAPI_HOST_SIZE,
  POWERLEVEL_CHANNELS,
  ROUTECACHE_VALID,
  RTC_TIMER_SIZE,
  SUC_CONTROLLER_LIST_SIZE,
  TOTAL_RTC_TIMER_MAX,
  resolveLayout
});
//# sourceMappingURL=shared.js.map
