import { type NVM, type NVMIO } from "./common/definitions.js";
import { type NVMDescriptor, type NVMModuleDescriptor } from "./nvm500/EntryParsers.js";
import { type NVM500Impl, type NVMData, type NVMEntryName, type ResolvedNVMLayout } from "./nvm500/shared.js";
export interface NVM500Info {
    layout: ResolvedNVMLayout;
    library: NVM500Impl["library"];
    moduleDescriptors: Map<NVMEntryName, NVMModuleDescriptor>;
    nvmDescriptor: NVMDescriptor;
}
export type NVM500EraseOptions = {
    layout: ResolvedNVMLayout;
    nvmSize: number;
    library: NVM500Impl["library"];
    nvmDescriptor: NVMDescriptor;
};
export declare class NVM500 implements NVM<NVMEntryName, NVMData[]> {
    constructor(io: NVMIO);
    private _io;
    private _access;
    private _info;
    get info(): NVM500Info | undefined;
    private ensureReadable;
    private ensureWritable;
    init(): Promise<NVM500Info>;
    private resolveLayout;
    private isLayoutValid;
    has(property: NVMEntryName): Promise<boolean>;
    private readSingleRawEntry;
    private readRawEntry;
    private parseEntry;
    private readEntry;
    private readSingleEntry;
    get(property: NVMEntryName): Promise<NVMData[] | undefined>;
    getSingle(property: NVMEntryName, index: number): Promise<NVMData | undefined>;
    private encodeEntry;
    private writeSingleRawEntry;
    private writeRawEntry;
    private writeEntry;
    private writeSingleEntry;
    set(property: NVMEntryName, value: NVMData[]): Promise<void>;
    setSingle(property: NVMEntryName, index: number, value: NVMData): Promise<void>;
    private fill;
    delete(_property: NVMEntryName): Promise<void>;
    erase(options: NVM500EraseOptions): Promise<void>;
}
//# sourceMappingURL=NVM500.d.ts.map