import type { NVM500 } from "../NVM500.js";
import type { NVMAdapter, NVMProperty, NVMPropertyToDataType } from "../common/definitions.js";
export declare class NVM500Adapter implements NVMAdapter {
    constructor(nvm: NVM500);
    private _nvm;
    get<T extends NVMProperty, R extends boolean = boolean>(property: T, required?: R): Promise<R extends true ? NonNullable<NVMPropertyToDataType<T>> : (NVMPropertyToDataType<T> | undefined)>;
    private getOnly;
    private getSingle;
    private getAll;
    private getControllerNVMProperty;
    private getNodeNVMProperty;
    private setOnly;
    private setSingle;
    private setAll;
    set<T extends NVMProperty>(property: T, value: NVMPropertyToDataType<T>): Promise<void>;
    private setControllerNVMProperty;
    private setNodeNVMProperty;
    delete(_property: NVMProperty): Promise<void>;
    hasPendingChanges(): boolean;
    commit(): Promise<void>;
}
//# sourceMappingURL=adapter.d.ts.map