"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Logger_exports = {};
__export(Logger_exports, {
  SerialLogger: () => SerialLogger
});
module.exports = __toCommonJS(Logger_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_MessageHeaders = require("../message/MessageHeaders.js");
var import_Logger_safe = require("./Logger_safe.js");
class SerialLogger extends import_core.ZWaveLoggerBase {
  static {
    __name(this, "SerialLogger");
  }
  constructor(loggers) {
    super(loggers, import_Logger_safe.SERIAL_LABEL);
  }
  isVisible() {
    return this.container.isLoglevelVisible(import_Logger_safe.SERIAL_LOGLEVEL);
  }
  /**
   * Logs transmission or receipt of an ACK frame
   * @param direction The direction this ACK was sent
   */
  ACK(direction) {
    if (this.isVisible()) {
      this.logMessageHeader(direction, import_MessageHeaders.MessageHeaders.ACK);
    }
  }
  /**
   * Logs transmission or receipt of an NAK frame
   * @param direction The direction this NAK was sent
   */
  NAK(direction) {
    if (this.isVisible()) {
      this.logMessageHeader(direction, import_MessageHeaders.MessageHeaders.NAK);
    }
  }
  /**
   * Logs transmission or receipt of an CAN frame
   * @param direction The direction this CAN was sent
   */
  CAN(direction) {
    if (this.isVisible()) {
      this.logMessageHeader(direction, import_MessageHeaders.MessageHeaders.CAN);
    }
  }
  /**
   * Logs receipt of unexpected data while waiting for an ACK, NAK, CAN, or data frame
   */
  discarded(data) {
    if (this.isVisible()) {
      const direction = "inbound";
      this.logger.log({
        level: "warn",
        primaryTags: "[DISCARDED]",
        message: `invalid data ${(0, import_shared.buffer2hex)(data)}`,
        secondaryTags: `(${data.length} bytes)`,
        direction: (0, import_core.getDirectionPrefix)(direction),
        context: {
          source: "serial",
          direction
        }
      });
    }
  }
  logMessageHeader(direction, header) {
    this.logger.log({
      level: import_Logger_safe.SERIAL_LOGLEVEL,
      primaryTags: `[${import_MessageHeaders.MessageHeaders[header]}]`,
      message: "",
      secondaryTags: `(${(0, import_shared.num2hex)(header)})`,
      direction: (0, import_core.getDirectionPrefix)(direction),
      context: {
        source: "serial",
        header: (0, import_shared.getEnumMemberName)(import_MessageHeaders.MessageHeaders, header),
        direction
      }
    });
  }
  /**
   * Logs transmission or receipt of a data chunk
   * @param direction The direction the data was sent
   * @param data The data that was transmitted or received
   */
  data(direction, data) {
    if (this.isVisible()) {
      this.logger.log({
        level: import_Logger_safe.SERIAL_LOGLEVEL,
        message: (0, import_shared.buffer2hex)(data),
        secondaryTags: `(${data.length} bytes)`,
        direction: (0, import_core.getDirectionPrefix)(direction),
        context: {
          source: "serial",
          direction
        }
      });
    }
  }
  // /**
  //  * Logs the current content of the receive buffer
  //  * @param data The data that is currently in the receive buffer
  //  */
  // export function receiveBuffer(data: Buffer, isComplete: boolean): void {
  // 	if (isVisible()) {
  // 		getLogger().log({
  // 			level: isComplete ? SERIAL_LOGLEVEL : "silly",
  // 			primaryTags: isComplete ? undefined : "[incomplete]",
  // 			message: `Buffer := 0x${data.toString("hex")}`,
  // 			secondaryTags: `(${data.length} bytes)`,
  // 			direction: getDirectionPrefix("none"),
  // 		});
  // 	}
  // }
  /**
   * Logs a message
   * @param message The message to output
   */
  message(message, direction = "none") {
    if (this.isVisible()) {
      this.logger.log({
        level: import_Logger_safe.SERIAL_LOGLEVEL,
        message,
        direction: (0, import_core.getDirectionPrefix)(direction),
        context: {
          source: "serial",
          direction: "none"
        }
      });
    }
  }
  /**
   * Prints output from the bootloader
   * @param screen The "screen" to output
   */
  bootloaderScreen(screen) {
    if (this.isVisible()) {
      this.logger.log({
        level: "silly",
        message: screen,
        direction: (0, import_core.getDirectionPrefix)("inbound"),
        context: {
          source: "serial",
          direction: "inbound"
        }
      });
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SerialLogger
});
//# sourceMappingURL=Logger.js.map
