"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Merge_exports = {};
__export(Merge_exports, {
  mergeReadableStreams: () => mergeReadableStreams
});
module.exports = __toCommonJS(Merge_exports);
var import_shared = require("@zwave-js/shared");
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
function mergeReadableStreams(...streams) {
  const resolvePromises = streams.map(() => (0, import_deferred_promise.createDeferredPromise)());
  return new ReadableStream({
    start(controller) {
      void Promise.all(resolvePromises).then(() => controller.close()).catch(import_shared.noop);
      try {
        for (const [key, stream] of Object.entries(streams)) {
          void (async () => {
            try {
              for await (const data of stream) {
                controller.enqueue(data);
              }
            } catch (e) {
              if (!(0, import_shared.isAbortError)(e)) {
                try {
                  controller.error(e);
                } catch {
                }
              }
            }
            resolvePromises[+key].resolve();
          })();
        }
      } catch (e) {
        controller.error(e);
      }
    }
  });
}
__name(mergeReadableStreams, "mergeReadableStreams");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  mergeReadableStreams
});
//# sourceMappingURL=Merge.js.map
