"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SerialModeSwitch_exports = {};
__export(SerialModeSwitch_exports, {
  SerialModeSwitch: () => SerialModeSwitch
});
module.exports = __toCommonJS(SerialModeSwitch_exports);
var import_shared = require("@zwave-js/shared");
var import_BootloaderParsers = require("../parsers/BootloaderParsers.js");
var import_definitions = require("../serialport/definitions.js");
const IS_TEST = process.env.NODE_ENV === "test" || !!(0, import_shared.getenv)("CI");
class SerialModeSwitch extends WritableStream {
  static {
    __name(this, "SerialModeSwitch");
  }
  possiblyCLI = false;
  #mode;
  get mode() {
    return this.#mode;
  }
  set mode(mode) {
    this.#mode = mode;
    this.possiblyCLI = false;
  }
  // The output sides of the stream
  #serialAPIWriter;
  toSerialAPI;
  #bootloaderWriter;
  toBootloader;
  #cliWriter;
  toCLI;
  constructor() {
    super({
      write: /* @__PURE__ */ __name(async (chunk) => {
        if (this.mode == void 0) {
          if (chunk.length === 1 && chunk[0] === 21) {
            this.possiblyCLI = true;
          } else {
            const buffer = import_shared.Bytes.view(chunk);
            const str = buffer.toString("ascii").replaceAll(/^[\s\0]+|[\s\0]+$/g, "");
            if (str.startsWith(import_BootloaderParsers.bootloaderMenuPreamble)) {
              this.mode = import_definitions.ZWaveSerialMode.Bootloader;
            } else if (str.split("\n").some((line) => line === ">" || line.startsWith("> "))) {
              this.mode = import_definitions.ZWaveSerialMode.CLI;
            } else if (buffer.every((b) => b === 0 || b === 10 || b === 13 || b >= 32 && b <= 126) && buffer.some((b) => b >= 32 && b <= 126)) {
              if (this.possiblyCLI) {
                this.mode = import_definitions.ZWaveSerialMode.CLI;
              } else {
                this.mode = import_definitions.ZWaveSerialMode.Bootloader;
              }
            } else {
              this.mode = import_definitions.ZWaveSerialMode.SerialAPI;
            }
          }
        }
        const write = /* @__PURE__ */ __name(async () => {
          if (this.mode === import_definitions.ZWaveSerialMode.Bootloader) {
            await this.#bootloaderWriter.write(chunk);
            await this.#bootloaderWriter.ready;
          } else if (this.mode === import_definitions.ZWaveSerialMode.CLI) {
            await this.#cliWriter.write(chunk);
            await this.#cliWriter.ready;
          } else {
            await this.#serialAPIWriter.write(chunk);
            await this.#serialAPIWriter.ready;
          }
        }, "write");
        if (IS_TEST) {
          await write();
        } else {
          setImmediate(write);
        }
      }, "write"),
      abort: /* @__PURE__ */ __name(async (reason) => {
        try {
          await this.#bootloaderWriter.abort(reason);
        } catch {
        }
        try {
          await this.#serialAPIWriter.abort(reason);
        } catch {
        }
        try {
          await this.#cliWriter.abort(reason);
        } catch {
        }
      }, "abort")
    });
    const { readable: toSerialAPI, writable: outputSerialAPI } = new TransformStream();
    const { readable: toBootloader, writable: outputBootloader } = new TransformStream();
    const { readable: toCLI, writable: outputCLI } = new TransformStream();
    this.toSerialAPI = toSerialAPI;
    this.#serialAPIWriter = outputSerialAPI.getWriter();
    this.toBootloader = toBootloader;
    this.#bootloaderWriter = outputBootloader.getWriter();
    this.toCLI = toCLI;
    this.#cliWriter = outputCLI.getWriter();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SerialModeSwitch
});
//# sourceMappingURL=SerialModeSwitch.js.map
